/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.diagnostic.execution;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import oracle.kv.impl.diagnostic.LogFileInfo;
import oracle.kv.impl.diagnostic.LogInfo;
import oracle.kv.impl.diagnostic.execution.LogExtractor;

public class SecurityEventExtractor
extends LogExtractor {
    private String TEMP_FILE_SUFFIX = "_securityevent.tmp";
    private String SECURITY_EVENT_PATTERN = "KVAuditInfo";
    private String prefixName;
    private File resultFile = null;

    public SecurityEventExtractor(String prefixName) {
        super(LogFileInfo.LogFileType.ALL);
        this.prefixName = prefixName;
    }

    public File getResultFile() {
        return this.resultFile;
    }

    @Override
    protected void extract(Map<String, List<LogFileInfo>> logFileInfoMap) throws Exception {
        if (logFileInfoMap.isEmpty()) {
            this.resultFile = null;
            return;
        }
        ArrayList<LogInfo> securityEventList = new ArrayList<LogInfo>();
        for (Map.Entry<String, List<LogFileInfo>> entry : logFileInfoMap.entrySet()) {
            List<LogFileInfo> logFileInfoList = entry.getValue();
            if (logFileInfoList.isEmpty()) continue;
            for (LogFileInfo logFileInfo : logFileInfoList) {
                this.getSecurityEvent(new File(logFileInfo.getFilePath()), securityEventList);
            }
        }
        BufferedWriter bw = null;
        try {
            this.resultFile = new File(this.prefixName + this.TEMP_FILE_SUFFIX);
            bw = new BufferedWriter(new FileWriter(this.resultFile));
            Collections.sort(securityEventList, new LogInfo.LogInfoComparator());
            LogInfo currentLog = null;
            for (LogInfo log : securityEventList) {
                if (currentLog != null && currentLog.equals(log)) continue;
                currentLog = log;
                bw.write(log.toString());
                bw.newLine();
            }
        }
        catch (Exception ex) {
            this.resultFile = null;
            throw ex;
        }
        finally {
            if (bw != null) {
                bw.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getSecurityEvent(File file, List<LogInfo> list) {
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new FileReader(file));
            while ((line = br.readLine()) != null) {
                if (!line.contains(this.SECURITY_EVENT_PATTERN)) continue;
                list.add(new LogInfo(line));
            }
        }
        catch (Exception ex) {
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (Exception ex) {}
        }
    }
}

