/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.diagnostic;

import java.net.InetAddress;

public class SNAInfo {
    private String storeName;
    private String storageNodeName;
    private String host;
    private String user;
    private String rootdir;
    private InetAddress IP;
    private String remoteRootdir;
    private String LOCALHOST_NAME = "localhost";
    private String LOCALHOST_IP = "127.0.0.1";

    public SNAInfo(String storeName, String storageNodeName, String host, String user, String rootdir) {
        this.storeName = storeName;
        this.storageNodeName = storageNodeName;
        this.host = host;
        this.user = user;
        this.rootdir = rootdir;
        this.convertToIP();
    }

    public SNAInfo(String storeName, String storageNodeName, String host, String rootdir) {
        this.storeName = storeName;
        this.storageNodeName = storageNodeName;
        this.host = host;
        this.rootdir = rootdir;
        this.convertToIP();
    }

    public SNAInfo(String snaInfoString) throws Exception {
        this.parse(snaInfoString);
        this.convertToIP();
    }

    private void parse(String snaInfoString) throws Exception {
        try {
            String[] snaInfoStrs = snaInfoString.split("\\|");
            this.storeName = snaInfoStrs[0];
            this.storageNodeName = snaInfoStrs[1];
            int index = snaInfoStrs[2].indexOf("@");
            if (index > -1) {
                this.user = snaInfoStrs[2].substring(0, index);
                this.host = snaInfoStrs[2].substring(index + 1);
            } else {
                this.host = snaInfoStrs[2];
            }
            this.rootdir = snaInfoStrs[3];
        }
        catch (Exception ex) {
            throw new Exception("Problem parsing " + snaInfoString + ": " + ex);
        }
    }

    public String getSNAInfo() {
        return "Store: " + this.storeName + ", SN: " + this.storageNodeName + ", Host: " + this.host;
    }

    public String toString() {
        if (this.user == null || this.user.equals("")) {
            return this.storeName + "|" + this.storageNodeName + "|" + this.host + "|" + this.rootdir;
        }
        return this.storeName + "|" + this.storageNodeName + "|" + this.user + "@" + this.host + "|" + this.rootdir;
    }

    public String getStoreName() {
        return this.storeName;
    }

    public String getStorageNodeName() {
        return this.storageNodeName;
    }

    public String getHost() {
        return this.host;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getRootdir() {
        return this.rootdir;
    }

    public InetAddress getIP() {
        return this.IP;
    }

    public String getRemoteRootdir() {
        return this.remoteRootdir;
    }

    public void setRemoteRootdir(String remoteRootdir) {
        this.remoteRootdir = remoteRootdir;
    }

    private InetAddress convertToIP() {
        try {
            this.IP = this.host.equals(this.LOCALHOST_NAME) || this.host.equals(this.LOCALHOST_IP) ? InetAddress.getLocalHost() : InetAddress.getByName(this.host);
            return this.IP;
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean equals(Object obj) {
        SNAInfo comparedSNAInfo = null;
        if (!(obj instanceof SNAInfo)) {
            return false;
        }
        comparedSNAInfo = (SNAInfo)obj;
        if (this.storeName == null || this.storageNodeName == null || this.IP == null || comparedSNAInfo.storeName == null || comparedSNAInfo.storageNodeName == null || comparedSNAInfo.IP == null) {
            return false;
        }
        return this.storeName.equals(comparedSNAInfo.storeName) && this.storageNodeName.equals(comparedSNAInfo.storageNodeName) && this.IP.equals(comparedSNAInfo.IP);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.storeName == null ? 0 : this.storeName.hashCode());
        result = 31 * result + (this.storageNodeName == null ? 0 : this.storageNodeName.hashCode());
        result = 31 * result + (this.IP == null ? 0 : this.IP.hashCode());
        return result;
    }
}

