/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.diagnostic;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import oracle.kv.KVVersion;
import oracle.kv.impl.admin.param.BootstrapParams;
import oracle.kv.impl.admin.param.SecurityParams;
import oracle.kv.impl.diagnostic.DiagnosticConfigFile;
import oracle.kv.impl.diagnostic.DiagnosticSSHRunnable;
import oracle.kv.impl.diagnostic.DiagnosticSSHTask;
import oracle.kv.impl.diagnostic.DiagnosticTask;
import oracle.kv.impl.diagnostic.DiagnosticTaskManager;
import oracle.kv.impl.diagnostic.EnvParams;
import oracle.kv.impl.diagnostic.JavaVersionVerifier;
import oracle.kv.impl.diagnostic.ParametersValidator;
import oracle.kv.impl.diagnostic.PortConflictValidator;
import oracle.kv.impl.diagnostic.RemoteFile;
import oracle.kv.impl.diagnostic.SNAInfo;
import oracle.kv.impl.diagnostic.ssh.SSHClient;
import oracle.kv.impl.diagnostic.util.TopologyDetector;
import oracle.kv.impl.param.LoadParameters;
import oracle.kv.impl.security.ssl.KeyStorePasswordSource;
import oracle.kv.impl.topo.StorageNode;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.ConfigUtils;
import oracle.kv.util.shell.CommandWithSubs;
import oracle.kv.util.shell.Shell;
import oracle.kv.util.shell.ShellException;
import oracle.kv.util.shell.ShellUsageException;

public class DiagnosticVerifyCommand
extends CommandWithSubs {
    private static final String DEFAULT_WORK_DIR = System.getProperty("user.dir");
    private static final String COMMAND_NAME = "verify";
    private static final String CHECK_CONFIG_SUBCOMMAND_NAME = "-checkLocal";
    private static final String CHECK_SNS_SUBCOMMAND_NAME = "-checkMulti";
    private static final String NEW_LINE_TAB = "\n\t";
    private static final String HOST_FLAG = "-host";
    private static final String PORT_FLAG = "-port";
    private static final String SSH_USER_FLAG = "-sshusername";
    private static final String USER_FLAG = "-username";
    private static final String SECURITY_FLAG = "-security";
    private static final String CONFIG_DIRECTORY_FLAG = "-configdir";
    private static final Set<RemoteFile> remoteFileSet = new CopyOnWriteArraySet<RemoteFile>();
    private static final Map<InetAddress, List<RemoteFile>> IPRemoteMap = new ConcurrentHashMap<InetAddress, List<RemoteFile>>();
    private static final List<? extends CommandWithSubs.SubCommand> subs = Arrays.asList(new DiagnosticVerifySNAsSub(), new DiagnosticVerifyConfigSub());
    private static String snHostname = null;
    private static int snPort = -1;
    private static String sshUser = null;
    private static String user = null;
    private static String securityFile = null;
    private static String configdir = null;

    public DiagnosticVerifyCommand() {
        super(subs, COMMAND_NAME, 4, 0);
    }

    @Override
    protected String getCommandOverview() {
        return "The verify command checks that each SN's configuration has valid values and is consistent with other nodes in the cluster.";
    }

    private static void setUserByHistory(SNAInfo snaInfo, List<SNAInfo> list) {
        for (SNAInfo si : list) {
            if (!si.getIP().equals(snaInfo.getIP())) continue;
            snaInfo.setUser(si.getUser());
        }
    }

    private static void updateSNTargetFile(Shell shell) throws Exception {
        TopologyDetector detector = new TopologyDetector(snHostname, snPort, user, securityFile);
        Topology topo = detector.getTopology();
        List<StorageNode> list = topo.getSortedStorageNodes();
        DiagnosticConfigFile configFile = new DiagnosticConfigFile(configdir);
        List<SNAInfo> historyList = configFile.getAllSNAInfo();
        configFile.clear();
        for (StorageNode sn : list) {
            StorageNodeId snId = sn.getStorageNodeId();
            String rootDir = detector.getRootDirPath(sn);
            if (rootDir != null) {
                SNAInfo snaInfo = new SNAInfo(topo.getKVStoreName(), snId.getFullName(), sn.getHostname(), rootDir);
                DiagnosticVerifyCommand.setUserByHistory(snaInfo, historyList);
                if (sshUser != null) {
                    snaInfo.setUser(sshUser);
                }
                configFile.add(snaInfo);
                continue;
            }
            shell.getOutput().println("Cannot get root directory path for " + snId.getFullName() + " on host " + sn.getHostname());
        }
    }

    public static void deleteEntireDirectory(File toDeletedFile) {
        File[] files;
        if (!toDeletedFile.exists()) {
            return;
        }
        if (toDeletedFile.isFile()) {
            toDeletedFile.delete();
            return;
        }
        for (File f : files = toDeletedFile.listFiles()) {
            if (f.isFile()) {
                f.delete();
                continue;
            }
            if (!f.isDirectory()) continue;
            DiagnosticVerifyCommand.deleteEntireDirectory(f);
        }
        toDeletedFile.delete();
    }

    static class DiagnosticVerifySNAsSub
    extends CommandWithSubs.SubCommand {
        private Map<InetAddress, EnvParams> resultMap = new ConcurrentHashMap<InetAddress, EnvParams>();

        DiagnosticVerifySNAsSub() {
            super(DiagnosticVerifyCommand.CHECK_SNS_SUBCOMMAND_NAME, 6);
        }

        @Override
        protected String getCommandSyntax() {
            return "verify -checkMulti" + eolt + "[" + DiagnosticVerifyCommand.HOST_FLAG + " <host name of a SN in topology>]" + eolt + "[" + DiagnosticVerifyCommand.PORT_FLAG + " <registry port of a SN in topology>]" + eolt + "[" + DiagnosticVerifyCommand.SSH_USER_FLAG + " <SSH username>]" + eolt + "[" + DiagnosticVerifyCommand.USER_FLAG + " <store username>]" + eolt + "[" + DiagnosticVerifyCommand.SECURITY_FLAG + " <security-file-path>]" + eolt + "[" + DiagnosticVerifyCommand.CONFIG_DIRECTORY_FLAG + " <location of storage node target file>]";
        }

        @Override
        protected String getCommandDescription() {
            return "Determine whether each SN's configuration is consistent with other members of the cluster";
        }

        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            snHostname = null;
            snPort = -1;
            sshUser = null;
            user = null;
            securityFile = null;
            configdir = null;
            Shell.checkHelp(args, this);
            if (args.length > 1) {
                for (int i = 1; i < args.length; ++i) {
                    if (DiagnosticVerifyCommand.HOST_FLAG.equals(args[i])) {
                        snHostname = Shell.nextArg(args, i++, this);
                        continue;
                    }
                    if (DiagnosticVerifyCommand.PORT_FLAG.equals(args[i])) {
                        String sPort = Shell.nextArg(args, i++, this);
                        try {
                            snPort = Integer.valueOf(sPort);
                        }
                        catch (NumberFormatException nfe) {
                            shell.invalidArgument(DiagnosticVerifyCommand.PORT_FLAG, this);
                        }
                        if (snPort > 0) continue;
                        String info = "-port should be greater than 0";
                        throw new ShellUsageException(info, this);
                    }
                    if (DiagnosticVerifyCommand.SSH_USER_FLAG.equals(args[i])) {
                        sshUser = Shell.nextArg(args, i++, this);
                        continue;
                    }
                    if (DiagnosticVerifyCommand.USER_FLAG.equals(args[i])) {
                        user = Shell.nextArg(args, i++, this);
                        continue;
                    }
                    if (DiagnosticVerifyCommand.SECURITY_FLAG.equals(args[i])) {
                        securityFile = Shell.nextArg(args, i++, this);
                        continue;
                    }
                    if (DiagnosticVerifyCommand.CONFIG_DIRECTORY_FLAG.equals(args[i])) {
                        configdir = Shell.nextArg(args, i++, this);
                        continue;
                    }
                    shell.unknownArgument(args[i], this);
                }
            }
            if (snPort < 0) {
                if (snHostname != null && !snHostname.isEmpty()) {
                    shell.requiredArg(DiagnosticVerifyCommand.PORT_FLAG, this);
                }
            } else if (snHostname == null || snHostname.isEmpty()) {
                shell.requiredArg(DiagnosticVerifyCommand.HOST_FLAG, this);
            }
            if (configdir == null || configdir.isEmpty()) {
                configdir = DEFAULT_WORK_DIR;
            }
            this.checkMulti(shell);
            return null;
        }

        private void checkMulti(Shell shell) throws ShellUsageException {
            try {
                if (snHostname != null) {
                    DiagnosticVerifyCommand.updateSNTargetFile(shell);
                }
            }
            catch (Exception ex) {
                if (ex.getMessage() != null && ex.getMessage().contains("Problem parsing")) {
                    throw new ShellUsageException(ex.getMessage(), this);
                }
                shell.getOutput().println("Updating configuration file failed: " + ex.getMessage());
            }
            try {
                DiagnosticConfigFile configFile = new DiagnosticConfigFile(configdir);
                configFile.verify();
            }
            catch (Exception ex) {
                throw new ShellUsageException(ex.getMessage(), this);
            }
            try {
                this.resultMap.clear();
                remoteFileSet.clear();
                IPRemoteMap.clear();
                DiagnosticTaskManager diagnosticTaskManager = new DiagnosticTaskManager(shell);
                DiagnosticSSHTask SSHtask = new DiagnosticSSHTask(configdir, sshUser){

                    @Override
                    public DiagnosticSSHRunnable getSSHRunnable(SNAInfo snaInfo, SSHClient client, List<SNAInfo> taskSNList) {
                        return new ConfigGather(snaInfo, this, client, taskSNList);
                    }
                };
                EnvParamsCheck check = new EnvParamsCheck();
                diagnosticTaskManager.addTask(SSHtask);
                diagnosticTaskManager.addTask(check);
                diagnosticTaskManager.execute();
            }
            catch (Exception ex) {
                throw new ShellUsageException(ex.toString(), this);
            }
        }

        private class EnvParamsCheck
        extends DiagnosticTask {
            final String PREFIX_MESSAGE = "\nMulti-SNs compatibility check";
            final String EMPTY_STRING = "";

            private EnvParamsCheck() {
            }

            @Override
            public void doWork() throws Exception {
                String message = "";
                String fastestHost = "";
                long minLatency = Long.MAX_VALUE;
                if (remoteFileSet.size() == 0) {
                    message = "No configuration file found";
                    this.notifyCompleteSubTask("\nMulti-SNs compatibility check\n\t" + message);
                    return;
                }
                for (Map.Entry entry : DiagnosticVerifySNAsSub.this.resultMap.entrySet()) {
                    if (((EnvParams)entry.getValue()).getLatency() >= minLatency) continue;
                    minLatency = ((EnvParams)entry.getValue()).getLatency();
                    fastestHost = ((InetAddress)entry.getKey()).getHostName();
                }
                String clockSkewMsg = "Clock skew: ";
                String jdkversionMsg = "Java version: ";
                String networkMsg = "Network connection status: ";
                for (Map.Entry entry : DiagnosticVerifySNAsSub.this.resultMap.entrySet()) {
                    clockSkewMsg = minLatency != Long.MIN_VALUE ? clockSkewMsg + "\n\t\t" + (((EnvParams)entry.getValue()).getLatency() - minLatency) + "ms (" + ((InetAddress)entry.getKey()).getHostName() + " to " + fastestHost + ")" : clockSkewMsg + "\n\t\tCannot get clock skew for (" + ((InetAddress)entry.getKey()).getHostName() + " to " + fastestHost + ")";
                    jdkversionMsg = jdkversionMsg + "\n\t\t" + ((EnvParams)entry.getValue()).getJavaVersion() + " (" + ((InetAddress)entry.getKey()).getHostName() + ")";
                    Map<SNAInfo, Boolean> map = ((EnvParams)entry.getValue()).getNetworkConnectionMap();
                    for (Map.Entry<SNAInfo, Boolean> e : map.entrySet()) {
                        if (e.getValue().booleanValue()) {
                            networkMsg = networkMsg + "\n\t\t" + ((InetAddress)entry.getKey()).getHostName() + " to " + e.getKey().getHost() + ": connected";
                            continue;
                        }
                        networkMsg = networkMsg + "\n\t\t" + ((InetAddress)entry.getKey()).getHostName() + " to " + e.getKey().getHost() + ": disconnected";
                    }
                }
                ArrayList<RemoteFile> nonSecuredList = new ArrayList<RemoteFile>();
                HashMap<PrivateKey, ArrayList<RemoteFile>> keyMap = new HashMap<PrivateKey, ArrayList<RemoteFile>>();
                HashMap<RemoteFile, KVVersion> versionsBeforePreReq = new HashMap<RemoteFile, KVVersion>();
                HashMap<RemoteFile, KVVersion> versionsAfterPreReq = new HashMap<RemoteFile, KVVersion>();
                String securityMsg = "Security Policy: ";
                String kvversionMsg = "KVStore version: ";
                String overLapMsg = "Port Ranges: ";
                for (RemoteFile rFile : remoteFileSet) {
                    BootstrapParams bp = ConfigUtils.getBootstrapParams(rFile.getLocalFile());
                    if (bp.getSecurityDir() != null && !bp.getSecurityDir().isEmpty()) {
                        KeyStore.PasswordProtection pwdParam;
                        File securityDir = new File(rFile.getLocalFile().getParentFile() + File.separator + bp.getSecurityDir());
                        File securityConfigPath = new File(securityDir, "security.xml");
                        LoadParameters lp = LoadParameters.getParameters(securityConfigPath, null);
                        SecurityParams sp = new SecurityParams(lp, securityConfigPath);
                        KeyStorePasswordSource pwdSrc = KeyStorePasswordSource.create(sp);
                        String keyStoreName = sp.getConfigDir() + File.separator + sp.getKeystoreFile();
                        char[] ksPwd = null;
                        ksPwd = pwdSrc.getPassword();
                        KeyStore keyStore = this.loadStore(keyStoreName, ksPwd, "keystore", sp.getKeystoreType());
                        KeyStore.PrivateKeyEntry pkEntry = (KeyStore.PrivateKeyEntry)keyStore.getEntry("shared", pwdParam = new KeyStore.PasswordProtection(ksPwd));
                        PrivateKey privateKey = pkEntry.getPrivateKey();
                        ArrayList<RemoteFile> list = (ArrayList<RemoteFile>)keyMap.get(privateKey);
                        if (list == null) {
                            list = new ArrayList<RemoteFile>();
                            keyMap.put(privateKey, list);
                        }
                        list.add(rFile);
                    } else {
                        nonSecuredList.add(rFile);
                    }
                    if (bp.getSoftwareVersion().compareTo(KVVersion.PREREQUISITE_VERSION) < 0) {
                        versionsBeforePreReq.put(rFile, bp.getSoftwareVersion());
                        continue;
                    }
                    versionsAfterPreReq.put(rFile, bp.getSoftwareVersion());
                }
                int securityPolicyCount = 0;
                if (!nonSecuredList.isEmpty()) {
                    securityPolicyCount = 1;
                }
                securityMsg = (securityPolicyCount += keyMap.size()) > 1 ? securityMsg + "\n\t\t" + securityPolicyCount + " different security policies are found\n" : (securityPolicyCount == 1 ? securityMsg + "\n\t\tSecurity policies are consistent\n" : securityMsg + "\n\t\tNo security policy found\n");
                int securityPolicyNO = 1;
                for (Map.Entry entry : keyMap.entrySet()) {
                    for (RemoteFile rf : (List)entry.getValue()) {
                        securityMsg = securityMsg + "\n\t\t" + rf + " secured " + "(security policy " + securityPolicyNO + ")";
                    }
                    ++securityPolicyNO;
                    securityMsg = securityMsg + "\n";
                }
                for (RemoteFile rf : nonSecuredList) {
                    securityMsg = securityMsg + "\n\t\t" + rf + " non-secured";
                }
                if (versionsBeforePreReq.size() > 0 && versionsAfterPreReq.size() > 0) {
                    kvversionMsg = kvversionMsg + "\n\t\tThere are version incompatibilities between nodes in the cluster. Nodes\n\t\twith versions earlier than the required minimum of " + KVVersion.PREREQUISITE_VERSION.getNumericVersionString() + ":\n";
                    for (Map.Entry entry : versionsBeforePreReq.entrySet()) {
                        kvversionMsg = kvversionMsg + "\n\t\t" + entry.getKey() + " " + ((KVVersion)entry.getValue()).getNumericVersionString();
                    }
                    if (versionsBeforePreReq.size() > 0 && versionsAfterPreReq.size() > 0) {
                        kvversionMsg = kvversionMsg + "\n";
                        kvversionMsg = kvversionMsg + "\n\t\tNodes with compatible versions:\n";
                    }
                    for (Map.Entry entry : versionsAfterPreReq.entrySet()) {
                        kvversionMsg = kvversionMsg + "\n\t\t" + entry.getKey() + " " + ((KVVersion)entry.getValue()).getNumericVersionString();
                    }
                } else if (versionsBeforePreReq.size() > 0 || versionsAfterPreReq.size() > 0) {
                    kvversionMsg = kvversionMsg + "\n\t\tAll nodes have compatible versions:\n";
                    for (Map.Entry entry : versionsBeforePreReq.entrySet()) {
                        kvversionMsg = kvversionMsg + "\n\t\t" + entry.getKey() + " " + ((KVVersion)entry.getValue()).getNumericVersionString();
                    }
                    for (Map.Entry entry : versionsAfterPreReq.entrySet()) {
                        kvversionMsg = kvversionMsg + "\n\t\t" + entry.getKey() + " " + ((KVVersion)entry.getValue()).getNumericVersionString();
                    }
                }
                HashMap portMap = new HashMap();
                for (Map.Entry entry : IPRemoteMap.entrySet()) {
                    portMap.put(entry.getKey(), this.getAllUsedPorts((List)entry.getValue()));
                }
                boolean isOverlap = false;
                String overLapDetail = new String();
                for (Map.Entry entry : portMap.entrySet()) {
                    for (Map.Entry subEntry : ((Map)entry.getValue()).entrySet()) {
                        if (((Set)subEntry.getValue()).size() <= 1) continue;
                        isOverlap = true;
                        overLapDetail = overLapDetail + "\n\t\tHost: " + ((InetAddress)entry.getKey()).getHostName() + ", port: " + subEntry.getKey() + " is used by";
                        for (RemoteFile rFile : (Set)subEntry.getValue()) {
                            overLapDetail = overLapDetail + "\n\t\t\t" + rFile.toString() + " ";
                        }
                        overLapDetail = overLapDetail.trim() + "\n";
                    }
                }
                overLapMsg = isOverlap ? overLapMsg + "\n\t\tConflicts in port allocation:\n\n\t\t" + overLapDetail : overLapMsg + "\n\t\tNo conflicts in port ranges for SNs hosted on the same node.";
                DiagnosticVerifyCommand.deleteEntireDirectory(new File("tmp"));
                message = message + DiagnosticVerifyCommand.NEW_LINE_TAB + clockSkewMsg.trim() + "\n" + DiagnosticVerifyCommand.NEW_LINE_TAB + jdkversionMsg.trim() + "\n" + DiagnosticVerifyCommand.NEW_LINE_TAB + networkMsg.trim() + "\n" + DiagnosticVerifyCommand.NEW_LINE_TAB + securityMsg.trim() + "\n" + DiagnosticVerifyCommand.NEW_LINE_TAB + kvversionMsg.trim() + "\n" + DiagnosticVerifyCommand.NEW_LINE_TAB + overLapMsg;
                message = "\nMulti-SNs compatibility check\n\t" + message.trim();
                this.notifyCompleteSubTask(message);
            }

            private Map<Integer, Set<RemoteFile>> getAllUsedPorts(List<RemoteFile> rFileList) {
                HashMap<Integer, Set<RemoteFile>> map = new HashMap<Integer, Set<RemoteFile>>();
                for (RemoteFile rFile : rFileList) {
                    BootstrapParams bp = ConfigUtils.getBootstrapParams(rFile.getLocalFile());
                    int registryPort = bp.getRegistryPort();
                    String HAPortRange = bp.getHAPortRange();
                    int adminPort = bp.getAdminHttpPort();
                    String servicePortRange = bp.getServicePortRange();
                    int trapPort = bp.getMgmtTrapPort();
                    int pollPort = bp.getMgmtPollingPort();
                    this.addPort(registryPort, rFile, map);
                    this.addPort(HAPortRange, rFile, map);
                    if (adminPort != 0) {
                        this.addPort(adminPort, rFile, map);
                    }
                    if (servicePortRange != null && !servicePortRange.isEmpty()) {
                        this.addPort(servicePortRange, rFile, map);
                    }
                    if (trapPort != 0) {
                        this.addPort(trapPort, rFile, map);
                    }
                    if (pollPort == 0) continue;
                    this.addPort(pollPort, rFile, map);
                }
                return map;
            }

            private void addPort(int port, RemoteFile rFile, Map<Integer, Set<RemoteFile>> map) {
                Set<RemoteFile> rSet = map.get(port);
                if (rSet == null) {
                    rSet = new HashSet<RemoteFile>();
                    map.put(port, rSet);
                }
                rSet.add(rFile);
            }

            private void addPort(String rangePorts, RemoteFile rFile, Map<Integer, Set<RemoteFile>> map) {
                StringTokenizer tokenizer = new StringTokenizer(rangePorts, ",");
                int firstHAPort = Integer.parseInt(tokenizer.nextToken());
                int secondHAPort = Integer.parseInt(tokenizer.nextToken());
                for (int i = firstHAPort; i <= secondHAPort; ++i) {
                    this.addPort(i, rFile, map);
                }
            }

            private KeyStore loadStore(String storeName, char[] storePassword, String storeFlavor, String storeType) throws IllegalArgumentException {
                FileInputStream fis;
                KeyStore ks;
                if (storeType == null || storeType.isEmpty()) {
                    storeType = KeyStore.getDefaultType();
                }
                try {
                    ks = KeyStore.getInstance(storeType);
                }
                catch (KeyStoreException kse) {
                    throw new IllegalArgumentException("Unable to find a " + storeFlavor + " instance of type " + storeType, kse);
                }
                try {
                    fis = new FileInputStream(storeName);
                }
                catch (FileNotFoundException fnfe) {
                    throw new IllegalArgumentException("Unable to locate specified " + storeFlavor + " " + storeName, fnfe);
                }
                try {
                    ks.load(fis, storePassword);
                }
                catch (IOException ioe) {
                    throw new IllegalArgumentException("Error reading from " + storeFlavor + " file " + storeName, ioe);
                }
                catch (NoSuchAlgorithmException nsae) {
                    throw new IllegalArgumentException("Unable to check " + storeFlavor + " integrity: " + storeName, nsae);
                }
                catch (CertificateException ce) {
                    throw new IllegalArgumentException("Not all certificates could be loaded: " + storeName, ce);
                }
                finally {
                    try {
                        fis.close();
                    }
                    catch (IOException ioe) {}
                }
                return ks;
            }
        }

        private class ConfigGather
        extends DiagnosticSSHRunnable {
            final String EMPTY_STRING = "";
            final String HOST = "host";
            private List<SNAInfo> list;

            public ConfigGather(SNAInfo snaInfo, DiagnosticTask threadOwner, SSHClient client, List<SNAInfo> list) {
                super(snaInfo, threadOwner, client);
                this.EMPTY_STRING = "";
                this.HOST = "host";
                this.list = list;
            }

            @Override
            public String doWork() throws Exception {
                String message = "";
                String retMsg = ParametersValidator.checkHostname("host", this.snaInfo.getHost());
                if (retMsg != null) {
                    message = message + DiagnosticVerifyCommand.NEW_LINE_TAB + retMsg;
                    return message;
                }
                if (this.client == null) {
                    message = message + "Cannot connect " + this.snaInfo.getHost();
                    return message.trim();
                }
                long latency = this.client.getTimeLatency();
                JavaVersionVerifier javaVersion = this.client.getJavaVersion();
                Map<SNAInfo, Boolean> map = this.client.getNetWorkStatus(this.list);
                File saveFolder = new File("tmp", this.snaInfo.getStoreName() + "_" + this.snaInfo.getStorageNodeName() + "_" + this.snaInfo.getHost());
                DiagnosticVerifySNAsSub.this.resultMap.put(this.snaInfo.getIP(), new EnvParams(latency, javaVersion, map, saveFolder));
                List<File> fileList = this.client.getConfigFile(this.snaInfo, saveFolder);
                ArrayList<RemoteFile> rFilelist = (ArrayList<RemoteFile>)IPRemoteMap.get(this.snaInfo.getIP());
                if (rFilelist == null) {
                    rFilelist = new ArrayList<RemoteFile>();
                    IPRemoteMap.put(this.snaInfo.getIP(), rFilelist);
                }
                for (File f : fileList) {
                    RemoteFile rf = new RemoteFile(f, this.snaInfo);
                    remoteFileSet.add(rf);
                    rFilelist.add(rf);
                }
                message = "\n\tFetched configuration file from [" + this.snaInfo.getSNAInfo() + "]";
                return message.trim();
            }
        }
    }

    static class DiagnosticVerifyConfigSub
    extends CommandWithSubs.SubCommand {
        DiagnosticVerifyConfigSub() {
            super(DiagnosticVerifyCommand.CHECK_CONFIG_SUBCOMMAND_NAME, 6);
        }

        @Override
        protected String getCommandSyntax() {
            return "verify -checkLocal" + eolt + "[" + DiagnosticVerifyCommand.HOST_FLAG + " <host name of a SN in topology>]" + eolt + "[" + DiagnosticVerifyCommand.PORT_FLAG + " <registry port of a SN in topology>]" + eolt + "[" + DiagnosticVerifyCommand.SSH_USER_FLAG + " <SSH username>]" + eolt + "[" + DiagnosticVerifyCommand.USER_FLAG + " <store username>]" + eolt + "[" + DiagnosticVerifyCommand.SECURITY_FLAG + " <security-file-path>]" + eolt + "[" + DiagnosticVerifyCommand.CONFIG_DIRECTORY_FLAG + " <location of storage node target file>]";
        }

        @Override
        protected String getCommandDescription() {
            return "Verify that each SN's configuration file is valid";
        }

        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            snHostname = null;
            snPort = -1;
            sshUser = null;
            user = null;
            securityFile = null;
            configdir = null;
            Shell.checkHelp(args, this);
            if (args.length > 1) {
                for (int i = 1; i < args.length; ++i) {
                    if (DiagnosticVerifyCommand.HOST_FLAG.equals(args[i])) {
                        snHostname = Shell.nextArg(args, i++, this);
                        continue;
                    }
                    if (DiagnosticVerifyCommand.PORT_FLAG.equals(args[i])) {
                        String sPort = Shell.nextArg(args, i++, this);
                        try {
                            snPort = Integer.valueOf(sPort);
                        }
                        catch (NumberFormatException nfe) {
                            shell.invalidArgument(DiagnosticVerifyCommand.PORT_FLAG, this);
                        }
                        if (snPort > 0) continue;
                        String info = "-port should be greater than 0";
                        throw new ShellUsageException(info, this);
                    }
                    if (DiagnosticVerifyCommand.SSH_USER_FLAG.equals(args[i])) {
                        sshUser = Shell.nextArg(args, i++, this);
                        continue;
                    }
                    if (DiagnosticVerifyCommand.USER_FLAG.equals(args[i])) {
                        user = Shell.nextArg(args, i++, this);
                        continue;
                    }
                    if (DiagnosticVerifyCommand.SECURITY_FLAG.equals(args[i])) {
                        securityFile = Shell.nextArg(args, i++, this);
                        continue;
                    }
                    if (DiagnosticVerifyCommand.CONFIG_DIRECTORY_FLAG.equals(args[i])) {
                        configdir = Shell.nextArg(args, i++, this);
                        continue;
                    }
                    shell.unknownArgument(args[i], this);
                }
            }
            if (snPort < 0) {
                if (snHostname != null && !snHostname.isEmpty()) {
                    shell.requiredArg(DiagnosticVerifyCommand.PORT_FLAG, this);
                }
            } else if (snHostname == null || snHostname.isEmpty()) {
                shell.requiredArg(DiagnosticVerifyCommand.HOST_FLAG, this);
            }
            if (configdir == null || configdir.isEmpty()) {
                configdir = DEFAULT_WORK_DIR;
            }
            this.checkLocalConfig(shell);
            return null;
        }

        private void checkLocalConfig(Shell shell) throws ShellUsageException {
            try {
                if (snHostname != null) {
                    DiagnosticVerifyCommand.updateSNTargetFile(shell);
                }
            }
            catch (Exception ex) {
                if (ex.getMessage() != null && ex.getMessage().contains("Problem parsing")) {
                    throw new ShellUsageException(ex.getMessage(), this);
                }
                shell.getOutput().println("Updating configuration file failed: " + ex.getMessage());
            }
            try {
                DiagnosticConfigFile configFile = new DiagnosticConfigFile(configdir);
                configFile.verify();
            }
            catch (Exception ex) {
                throw new ShellUsageException(ex.getMessage(), this);
            }
            try {
                remoteFileSet.clear();
                IPRemoteMap.clear();
                DiagnosticTaskManager diagnosticTaskManager = new DiagnosticTaskManager(shell);
                DiagnosticSSHTask SSHtask = new DiagnosticSSHTask(configdir, sshUser){

                    @Override
                    public DiagnosticSSHRunnable getSSHRunnable(SNAInfo snaInfo, SSHClient client, List<SNAInfo> taskSNList) {
                        return new ConfigGather(snaInfo, this, client);
                    }
                };
                LocalConfigCheck localConfigCheck = new LocalConfigCheck();
                diagnosticTaskManager.addTask(SSHtask);
                diagnosticTaskManager.addTask(localConfigCheck);
                diagnosticTaskManager.execute();
                DiagnosticVerifyCommand.deleteEntireDirectory(new File("tmp"));
            }
            catch (Exception ex) {
                throw new ShellUsageException(ex.toString(), this);
            }
        }

        private class LocalConfigCheck
        extends DiagnosticTask {
            final String PREFIX_MESSAGE = "\nSN Local Configuration check\n\t";
            final String EMPTY_MESSAGE = "";

            private LocalConfigCheck() {
            }

            @Override
            public void doWork() throws Exception {
                String retMsg = null;
                String message = "";
                if (remoteFileSet.size() == 0) {
                    message = "No configuration file found";
                    this.notifyCompleteSubTask("\nSN Local Configuration check\n\t" + message.trim());
                    return;
                }
                for (RemoteFile rFile : remoteFileSet) {
                    String allMessage = null;
                    BootstrapParams bp = ConfigUtils.getBootstrapParams(rFile.getLocalFile());
                    PortConflictValidator validator = new PortConflictValidator();
                    String title = "Host: " + rFile.getSNAInfo().getHost() + ", config: " + rFile.getSNAInfo().getRootdir() + "/" + rFile.getLocalFile().getName();
                    allMessage = this.aggregateMessage(allMessage, title, 0);
                    retMsg = validator.check("registryPort", bp.getRegistryPort());
                    allMessage = this.aggregateMessage(allMessage, retMsg, 1);
                    retMsg = validator.check("haPortRange", bp.getHAPortRange());
                    allMessage = this.aggregateMessage(allMessage, retMsg, 1);
                    if (bp.getAdminHttpPort() != 0) {
                        retMsg = validator.check("adminHttpPort", bp.getAdminHttpPort());
                        allMessage = this.aggregateMessage(allMessage, retMsg, 1);
                        retMsg = ParametersValidator.checkRangePortsNumber("haPortRange", bp.getHAPortRange(), bp.getCapacity() + 1);
                        allMessage = this.aggregateMessage(allMessage, retMsg, 1);
                    } else if (bp.isHostingAdmin()) {
                        retMsg = ParametersValidator.checkRangePortsNumber("haPortRange", bp.getHAPortRange(), bp.getCapacity() + 1);
                        allMessage = this.aggregateMessage(allMessage, retMsg, 1);
                    } else {
                        retMsg = ParametersValidator.checkRangePortsNumber("haPortRange", bp.getHAPortRange(), bp.getCapacity());
                        allMessage = this.aggregateMessage(allMessage, retMsg, 1);
                    }
                    if (bp.getServicePortRange() != null && !bp.getServicePortRange().isEmpty()) {
                        retMsg = validator.check("servicePortRange", bp.getServicePortRange());
                        allMessage = this.aggregateMessage(allMessage, retMsg, 1);
                    }
                    retMsg = validator.check("mgmtTrapPort", bp.getMgmtTrapPort());
                    allMessage = this.aggregateMessage(allMessage, retMsg, 1);
                    retMsg = validator.check("mgmtPollPort", bp.getMgmtPollingPort());
                    if ((allMessage = this.aggregateMessage(allMessage, retMsg, 1)).equals(title)) {
                        allMessage = this.aggregateMessage(allMessage, "SN configuration is valid.", 1);
                    }
                    message = message + DiagnosticVerifyCommand.NEW_LINE_TAB + allMessage;
                }
                this.notifyCompleteSubTask("\nSN Local Configuration check\n\t" + message.trim());
            }

            protected String aggregateMessage(String allMessage, String addMessage, int level) {
                String TAB = "\t";
                if (addMessage != null && !addMessage.isEmpty()) {
                    if (allMessage == null || allMessage.isEmpty()) {
                        allMessage = addMessage;
                    } else {
                        allMessage = allMessage + DiagnosticVerifyCommand.NEW_LINE_TAB;
                        for (int i = 0; i < level; ++i) {
                            allMessage = allMessage + TAB;
                        }
                        allMessage = allMessage + addMessage;
                    }
                }
                return allMessage;
            }
        }

        private class ConfigGather
        extends DiagnosticSSHRunnable {
            final String EMPTY_STRING = "";
            final String HOST = "host";
            final String ROOT_DIR_FLAG = "root directory";
            final String DONT_EXIST = " does not exist";
            final String BLANKSPACE_SIGN = " ";

            public ConfigGather(SNAInfo snaInfo, DiagnosticTask threadOwner, SSHClient client) {
                super(snaInfo, threadOwner, client);
                this.EMPTY_STRING = "";
                this.HOST = "host";
                this.ROOT_DIR_FLAG = "root directory";
                this.DONT_EXIST = " does not exist";
                this.BLANKSPACE_SIGN = " ";
            }

            @Override
            public String doWork() throws Exception {
                String message = "";
                String retMsg = ParametersValidator.checkHostname("host", this.snaInfo.getHost());
                if (retMsg != null) {
                    message = message + DiagnosticVerifyCommand.NEW_LINE_TAB + retMsg;
                    return message;
                }
                if (this.client == null) {
                    message = message + "Cannot connect " + this.snaInfo.getHost();
                    return message.trim();
                }
                if (!this.client.checkFile(this.snaInfo.getRootdir())) {
                    message = message + "\n\troot directory " + this.snaInfo.getRootdir() + " does not exist";
                }
                if (!message.equals("")) {
                    return message.trim();
                }
                File saveFolder = new File("tmp", this.snaInfo.getStoreName() + "_" + this.snaInfo.getStorageNodeName() + "_" + this.snaInfo.getHost());
                List<File> fileList = this.client.getConfigFile(this.snaInfo, saveFolder);
                for (File f : fileList) {
                    remoteFileSet.add(new RemoteFile(f, this.snaInfo));
                }
                message = "\n\tFetched configuration file from [" + this.snaInfo.getSNAInfo() + "]";
                return message.trim();
            }
        }
    }
}

