/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.diagnostic;

import java.util.ArrayList;
import java.util.List;
import oracle.kv.impl.diagnostic.DiagnosticTask;
import oracle.kv.util.shell.Shell;

public class DiagnosticTaskManager {
    private String ON_PROGRESS_STATUS = "progress";
    private String DONE_STATUS = "done";
    private String BACKSPACE_SIGN = "\r";
    private String NEW_LINE_SIGN = "\n";
    private String EMPTY_STRING = "";
    private String BLANKSPACE_SIGN = " ";
    private String POINT_SIGN = ".";
    private String TOTAL_TASKS_PREFIX = "Total: ";
    private String COMPLETED_TASKS_PREFIX = "    Completed: ";
    private String STATUS_PREFIX = "    Status: ";
    private List<DiagnosticTask> taskList = new ArrayList<DiagnosticTask>();
    private Shell shell;
    private int totalTaskCount = 0;
    private int completedTaskCount = 0;
    private int maxLength = 0;
    private int pointsNumber = 0;
    private List<DiagnosticTask> runningTaskList = new ArrayList<DiagnosticTask>();
    private String showStr;

    public DiagnosticTaskManager(Shell shell) {
        this.shell = shell;
    }

    public void addTask(DiagnosticTask task) {
        this.taskList.add(task);
        this.totalTaskCount += task.getTotalSubTaskCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws Exception {
        TaskProgressMonitor monitor = new TaskProgressMonitor();
        try {
            monitor.start();
            this.shell.getOutput().println(this.EMPTY_STRING);
            for (DiagnosticTask task : this.taskList) {
                this.runningTaskList.add(task);
                task.execute();
            }
        }
        finally {
            monitor.join();
        }
    }

    public String getProgressStatus() {
        return this.showStr.trim();
    }

    private class TaskProgressMonitor
    extends Thread {
        private TaskProgressMonitor() {
        }

        @Override
        public void run() {
            while (DiagnosticTaskManager.this.completedTaskCount < DiagnosticTaskManager.this.totalTaskCount) {
                DiagnosticTaskManager.this.completedTaskCount = 0;
                DiagnosticTaskManager.this.shell.getOutput().print(DiagnosticTaskManager.this.BACKSPACE_SIGN);
                try {
                    Thread.sleep(1000L);
                    for (DiagnosticTask task : DiagnosticTaskManager.this.runningTaskList) {
                        String blankString = DiagnosticTaskManager.this.EMPTY_STRING;
                        for (int i = 0; i < DiagnosticTaskManager.this.maxLength; ++i) {
                            blankString = blankString + DiagnosticTaskManager.this.BLANKSPACE_SIGN;
                        }
                        DiagnosticTaskManager.this.shell.getOutput().print(blankString + DiagnosticTaskManager.this.BACKSPACE_SIGN);
                        DiagnosticTaskManager.this.completedTaskCount += task.getCompletedSubTaskCount();
                        String message = task.getMessageQueue().poll();
                        while (message != null) {
                            DiagnosticTaskManager.this.shell.getOutput().println(message);
                            message = task.getMessageQueue().poll();
                        }
                    }
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
                DiagnosticTaskManager.this.showStr = DiagnosticTaskManager.this.TOTAL_TASKS_PREFIX + DiagnosticTaskManager.this.totalTaskCount + DiagnosticTaskManager.this.COMPLETED_TASKS_PREFIX + DiagnosticTaskManager.this.completedTaskCount + DiagnosticTaskManager.this.STATUS_PREFIX;
                if (DiagnosticTaskManager.this.completedTaskCount < DiagnosticTaskManager.this.totalTaskCount) {
                    DiagnosticTaskManager.this.showStr = DiagnosticTaskManager.this.showStr + DiagnosticTaskManager.this.ON_PROGRESS_STATUS;
                    for (int i = 0; i <= DiagnosticTaskManager.this.pointsNumber; ++i) {
                        DiagnosticTaskManager.this.showStr = DiagnosticTaskManager.this.showStr + DiagnosticTaskManager.this.POINT_SIGN;
                    }
                    DiagnosticTaskManager.this.pointsNumber++;
                    DiagnosticTaskManager.this.pointsNumber %= 6;
                } else {
                    DiagnosticTaskManager.this.showStr = DiagnosticTaskManager.this.showStr + DiagnosticTaskManager.this.DONE_STATUS;
                }
                if (DiagnosticTaskManager.this.showStr.length() >= DiagnosticTaskManager.this.maxLength) {
                    DiagnosticTaskManager.this.maxLength = DiagnosticTaskManager.this.showStr.length();
                } else {
                    int addNumber = DiagnosticTaskManager.this.maxLength - DiagnosticTaskManager.this.showStr.length();
                    for (int i = 0; i < addNumber; ++i) {
                        DiagnosticTaskManager.this.showStr = DiagnosticTaskManager.this.showStr + DiagnosticTaskManager.this.BLANKSPACE_SIGN;
                    }
                }
                if (DiagnosticTaskManager.this.completedTaskCount == DiagnosticTaskManager.this.totalTaskCount) {
                    DiagnosticTaskManager.this.showStr = DiagnosticTaskManager.this.showStr + DiagnosticTaskManager.this.NEW_LINE_SIGN;
                }
                DiagnosticTaskManager.this.shell.getOutput().print(DiagnosticTaskManager.this.showStr);
            }
        }
    }
}

