/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.client.admin;

import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import oracle.kv.FaultException;
import oracle.kv.impl.api.KVStoreImpl;
import oracle.kv.impl.client.admin.ClientAdminServiceAPI;
import oracle.kv.impl.client.admin.DdlCheckTask;
import oracle.kv.impl.client.admin.DdlFuture;
import oracle.kv.impl.client.admin.ExecutionInfo;
import oracle.kv.impl.client.admin.ExecutionInfoImpl;
import oracle.kv.impl.client.admin.FindClientAdminService;
import oracle.kv.impl.util.KVThreadFactory;

public class DdlStatementExecutor {
    private ClientAdminServiceAPI clientAdminService;
    private final ScheduledExecutorService completionChecker;
    private final Map<Integer, ScheduledFuture<?>> scheduledFutures;
    private final Map<Integer, Set<DdlFuture>> notificationTargets;
    private final KVStoreImpl store;
    private final Logger logger;
    private final int maxCheckRetries;
    private final long checkIntervalMillis;

    public DdlStatementExecutor(KVStoreImpl store) {
        this.logger = store.getLogger();
        this.store = store;
        this.scheduledFutures = new HashMap();
        this.notificationTargets = new HashMap<Integer, Set<DdlFuture>>();
        this.checkIntervalMillis = store.getCheckIntervalMillis();
        this.maxCheckRetries = store.getMaxCheckRetries();
        this.completionChecker = new ScheduledThreadPoolExecutor(1, new KVThreadFactory("DDLChecks", this.logger));
        try {
            this.ensureClientAdminService();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized ClientAdminServiceAPI getClientAdminService() {
        this.ensureClientAdminService();
        return this.clientAdminService;
    }

    private void ensureClientAdminService() throws FaultException {
        if (this.clientAdminService != null) {
            try {
                if (this.clientAdminService.canHandleDDL()) {
                    return;
                }
            }
            catch (RemoteException e) {
                this.logger.fine("Ensuring connection, got " + e);
            }
            this.clientAdminService = null;
        }
        this.logger.info("Establishing RMI connection for admin DDL");
        FindClientAdminService finder = new FindClientAdminService(this.store.getDispatcher().getTopologyManager().getTopology(), this.logger, KVStoreImpl.getLoginManager(this.store));
        this.clientAdminService = finder.getDDLService();
        if (this.clientAdminService == null) {
            throw new FaultException("Couldn't connect to a store Admin service capable of executing an administrative table statement. Contacted nodes " + finder.getTargets(), false);
        }
    }

    synchronized void startPolling(int planId, DdlFuture ddlFuture) {
        Set<DdlFuture> targets;
        if (!this.scheduledFutures.containsKey(planId)) {
            ScheduledFuture<?> f = this.completionChecker.scheduleAtFixedRate(new DdlCheckTask(planId, this, this.maxCheckRetries, this.logger), 2000L, this.checkIntervalMillis, TimeUnit.MILLISECONDS);
            this.scheduledFutures.put(planId, f);
        }
        if ((targets = this.notificationTargets.get(planId)) == null) {
            targets = new HashSet<DdlFuture>();
            this.notificationTargets.put(planId, targets);
        }
        targets.add(ddlFuture);
    }

    void shutdownWaitersDueToError(int planId, Throwable t) {
        ExecutionInfoImpl errorInfo = new ExecutionInfoImpl(planId, false, null, null, false, false, t.getMessage(), false, null);
        this.updateWaiters(errorInfo, t, true);
    }

    void updateWaiters(ExecutionInfo newInfo) {
        this.updateWaiters(newInfo, null, false);
    }

    synchronized void updateWaiters(ExecutionInfo newInfo, Throwable t, boolean stopPolling) {
        int planId = newInfo.getPlanId();
        Set<DdlFuture> waiters = this.notificationTargets.get(planId);
        if (waiters != null) {
            for (DdlFuture waiter : waiters) {
                waiter.applyNewInfo(newInfo, t);
            }
        }
        if (stopPolling || newInfo.isTerminated()) {
            ScheduledFuture<?> taskFuture = this.scheduledFutures.get(planId);
            if (taskFuture != null) {
                this.logger.fine("Polling task for plan " + planId + " finished, info = " + newInfo);
                taskFuture.cancel(true);
                this.scheduledFutures.remove(planId);
            }
            this.notificationTargets.remove(planId);
        }
    }

    void taskFailed(int planId, RemoteException e) {
        throw new UnsupportedOperationException(e);
    }
}

