/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import com.sleepycat.persist.model.Persistent;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;
import oracle.kv.impl.api.table.ArrayValueImpl;
import oracle.kv.impl.api.table.BooleanValueImpl;
import oracle.kv.impl.api.table.ComplexValueImpl;
import oracle.kv.impl.api.table.DoubleValueImpl;
import oracle.kv.impl.api.table.EnumDefImpl;
import oracle.kv.impl.api.table.EnumValueImpl;
import oracle.kv.impl.api.table.FieldComparator;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldMapEntry;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.FloatValueImpl;
import oracle.kv.impl.api.table.IntegerValueImpl;
import oracle.kv.impl.api.table.LongValueImpl;
import oracle.kv.impl.api.table.MapValueImpl;
import oracle.kv.impl.api.table.NullValueImpl;
import oracle.kv.impl.api.table.RecordDefImpl;
import oracle.kv.impl.api.table.StringValueImpl;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.table.ArrayValue;
import oracle.kv.table.EnumDef;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FieldValue;
import oracle.kv.table.MapValue;
import oracle.kv.table.RecordDef;
import oracle.kv.table.RecordValue;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.node.JsonNodeFactory;
import org.codehaus.jackson.node.ObjectNode;

@Persistent(version=1)
class RecordValueImpl
extends ComplexValueImpl
implements RecordValue {
    private static final long serialVersionUID = 1L;
    protected final Map<String, FieldValue> valueMap;
    private static final BigDecimal floatMin = new BigDecimal(new Float(Float.MIN_VALUE).toString());
    private static final BigDecimal floatMax = new BigDecimal(new Float(Float.MAX_VALUE).toString());
    private static final BigDecimal bdNegOne = BigDecimal.ONE.negate();

    RecordValueImpl(RecordDef field) {
        super(field);
        this.valueMap = new TreeMap<String, FieldValue>(FieldComparator.instance);
    }

    RecordValueImpl(RecordDef field, Map<String, FieldValue> valueMap) {
        super(field);
        if (valueMap == null) {
            throw new IllegalArgumentException("Null valueMap passed to RecordValueImpl");
        }
        this.valueMap = valueMap;
    }

    RecordValueImpl(RecordValueImpl other) {
        super(other.getDefinition());
        this.valueMap = new TreeMap<String, FieldValue>(FieldComparator.instance);
        this.copyFields(other);
    }

    private RecordValueImpl() {
        super(null);
        this.valueMap = null;
    }

    @Override
    public FieldValue get(String fieldName) {
        return this.valueMap.get(fieldName);
    }

    @Override
    public RecordValue put(String name, int value) {
        FieldDefImpl def = this.validateNameAndType(name, FieldDef.Type.INTEGER);
        this.putField(name, def.createInteger(value));
        return this;
    }

    @Override
    public RecordValue put(String name, long value) {
        FieldDefImpl def = this.validateNameAndType(name, FieldDef.Type.LONG);
        this.putField(name, def.createLong(value));
        return this;
    }

    @Override
    public RecordValue put(String name, String value) {
        FieldDefImpl def = this.validateNameAndType(name, FieldDef.Type.STRING);
        this.putField(name, def.createString(value));
        return this;
    }

    FieldValue putComplex(TableImpl.TableField tableField, FieldDef.Type type, Object value) {
        if (!tableField.isComplex()) {
            String name = tableField.getFieldName();
            FieldDefImpl def = this.validateNameAndType(name, type);
            this.putField(name, def.createValue(type, value));
        } else {
            this.putComplex((ListIterator)tableField.iterator(), type, value);
        }
        return this;
    }

    @Override
    FieldValueImpl putComplex(ListIterator<String> fieldPath, FieldDef.Type type, Object value) {
        String fname = fieldPath.next();
        if (!fieldPath.hasNext()) {
            FieldDefImpl def = this.validateNameAndType(fname, type);
            this.putField(fname, def.createValue(type, value));
        } else {
            FieldDefImpl def = (FieldDefImpl)this.getDefinition(fname);
            if (def == null) {
                throw new IllegalArgumentException("Cannot find field named " + fname);
            }
            FieldValueImpl val = (FieldValueImpl)this.get(fname);
            if (val == null) {
                val = RecordValueImpl.createComplexValue(def);
            }
            this.putField(fname, val.putComplex(fieldPath, type, value));
        }
        return this;
    }

    @Override
    public RecordValue put(String name, double value) {
        FieldDefImpl def = this.validateNameAndType(name, FieldDef.Type.DOUBLE);
        this.putField(name, def.createDouble(value));
        return this;
    }

    @Override
    public RecordValue put(String name, float value) {
        FieldDefImpl def = this.validateNameAndType(name, FieldDef.Type.FLOAT);
        this.putField(name, def.createFloat(value));
        return this;
    }

    @Override
    public RecordValue put(String name, boolean value) {
        FieldDefImpl def = this.validateNameAndType(name, FieldDef.Type.BOOLEAN);
        this.putField(name, def.createBoolean(value));
        return this;
    }

    @Override
    public RecordValue put(String name, byte[] value) {
        FieldDefImpl def = this.validateNameAndType(name, FieldDef.Type.BINARY);
        this.putField(name, def.createBinary(value));
        return this;
    }

    @Override
    public RecordValue putFixed(String name, byte[] value) {
        FieldDefImpl def = this.validateNameAndType(name, FieldDef.Type.FIXED_BINARY);
        this.putField(name, def.createFixedBinary(value));
        return this;
    }

    @Override
    public RecordValue putEnum(String name, String value) {
        EnumDefImpl enumField = (EnumDefImpl)this.validateNameAndType(name, FieldDef.Type.ENUM);
        this.putField(name, enumField.createEnum(value));
        return this;
    }

    @Override
    public RecordValue putNull(String name) {
        FieldDef ft = this.getDefinition(name);
        if (ft == null) {
            throw new IllegalArgumentException("No such field in record " + this.getDefinition().getName() + ": " + name);
        }
        if (!this.getDefinition().isNullable(name)) {
            throw new IllegalArgumentException("Named field is not nullable: " + name);
        }
        this.putField(name, NullValueImpl.getInstance());
        return this;
    }

    @Override
    public RecordValue put(String name, FieldValue value) {
        if (value.isNull()) {
            return this.putNull(name);
        }
        this.validateNameAndType(name, value.getType());
        this.putField(name, value);
        return this;
    }

    @Override
    public RecordValueImpl putRecord(String name) {
        FieldDefImpl def = this.validateNameAndType(name, FieldDef.Type.RECORD);
        RecordValue val = def.createRecord();
        this.putField(name, val);
        return (RecordValueImpl)val;
    }

    @Override
    public RecordValue putRecordAsJson(String name, String jsonInput, boolean exact) {
        return this.putRecordAsJson(name, new ByteArrayInputStream(jsonInput.getBytes()), exact);
    }

    @Override
    public RecordValue putRecordAsJson(String name, InputStream jsonInput, boolean exact) {
        FieldDefImpl def = this.validateNameAndType(name, FieldDef.Type.RECORD);
        RecordValue record = def.createRecord();
        TableImpl.createFromJson((RecordValueImpl)record, jsonInput, exact);
        this.putField(name, record);
        return this;
    }

    @Override
    public ArrayValueImpl putArray(String name) {
        FieldDefImpl def = this.validateNameAndType(name, FieldDef.Type.ARRAY);
        ArrayValue val = def.createArray();
        this.putField(name, val);
        return (ArrayValueImpl)val;
    }

    @Override
    public RecordValue putArrayAsJson(String name, String jsonInput, boolean exact) {
        return this.putArrayAsJson(name, new ByteArrayInputStream(jsonInput.getBytes()), exact);
    }

    @Override
    public RecordValue putArrayAsJson(String name, InputStream jsonInput, boolean exact) {
        FieldDefImpl def = this.validateNameAndType(name, FieldDef.Type.ARRAY);
        ArrayValue array = def.createArray();
        TableImpl.createFromJson((ArrayValueImpl)array, jsonInput, exact);
        this.putField(name, array);
        return this;
    }

    @Override
    public MapValueImpl putMap(String name) {
        FieldDefImpl def = this.validateNameAndType(name, FieldDef.Type.MAP);
        MapValue val = def.createMap();
        this.putField(name, val);
        return (MapValueImpl)val;
    }

    @Override
    public RecordValue putMapAsJson(String name, String jsonInput, boolean exact) {
        return this.putMapAsJson(name, new ByteArrayInputStream(jsonInput.getBytes()), exact);
    }

    @Override
    public RecordValue putMapAsJson(String name, InputStream jsonInput, boolean exact) {
        FieldDefImpl def = this.validateNameAndType(name, FieldDef.Type.MAP);
        MapValue map = def.createMap();
        TableImpl.createFromJson((MapValueImpl)map, jsonInput, exact);
        this.putField(name, map);
        return this;
    }

    @Override
    public int size() {
        return this.valueMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.valueMap.isEmpty();
    }

    @Override
    public RecordDefImpl getDefinition() {
        return (RecordDefImpl)super.getDefinition();
    }

    @Override
    public FieldDef.Type getType() {
        return FieldDef.Type.RECORD;
    }

    @Override
    public boolean isRecord() {
        return true;
    }

    @Override
    public RecordValue asRecord() {
        return this;
    }

    @Override
    public RecordValueImpl clone() {
        return new RecordValueImpl(this);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RecordValueImpl)) {
            return false;
        }
        RecordValueImpl otherValue = (RecordValueImpl)other;
        if (this.size() == otherValue.size() && this.getDefinition().equals(otherValue.getDefinition())) {
            for (Map.Entry<String, FieldValue> entry : this.valueMap.entrySet()) {
                if (entry.getValue().equals(otherValue.get(entry.getKey()))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int code = this.size();
        for (Map.Entry<String, FieldValue> entry : this.valueMap.entrySet()) {
            code += entry.getKey().hashCode() + entry.getValue().hashCode();
        }
        return code;
    }

    @Override
    public int compareTo(FieldValue other) {
        if (other instanceof RecordValueImpl) {
            RecordValueImpl otherImpl = (RecordValueImpl)other;
            if (!this.getDefinition().equals(otherImpl.getDefinition())) {
                throw new IllegalArgumentException("Cannot compare RecordValues with different definitions");
            }
            return this.compare(otherImpl, this.getFieldsInternal());
        }
        throw new ClassCastException("Object is not an RecordValue");
    }

    public int compare(RecordValueImpl other, List<String> fieldList) {
        for (String fieldName : fieldList) {
            FieldValueImpl val = (FieldValueImpl)this.get(fieldName);
            FieldValueImpl otherVal = (FieldValueImpl)other.get(fieldName);
            if (val != null) {
                if (otherVal == null) {
                    return 1;
                }
                int comp = val.compareTo(otherVal);
                if (comp == 0) continue;
                return comp;
            }
            if (otherVal == null) continue;
            return -1;
        }
        return 0;
    }

    @Override
    public JsonNode toJsonNode() {
        ObjectNode node = JsonNodeFactory.instance.objectNode();
        for (String fieldName : this.getFieldsInternal()) {
            FieldValueImpl val = (FieldValueImpl)this.get(fieldName);
            if (val == null) continue;
            node.put(fieldName, val.toJsonNode());
        }
        return node;
    }

    @Override
    public void toStringBuilder(StringBuilder sb) {
        sb.append('{');
        int i = 0;
        for (String fieldName : this.getFieldsInternal()) {
            FieldValueImpl val = (FieldValueImpl)this.valueMap.get(fieldName);
            if (val == null) continue;
            if (i > 0) {
                sb.append(',');
            }
            sb.append('\"');
            sb.append(fieldName);
            sb.append('\"');
            sb.append(':');
            val.toStringBuilder(sb);
            ++i;
        }
        sb.append('}');
    }

    @Override
    public FieldValue remove(String name) {
        return this.valueMap.remove(name);
    }

    @Override
    public void copyFrom(RecordValue source) {
        this.copyFrom(source, false);
    }

    void copyFrom(RecordValue source, boolean ignoreDefinition) {
        if (!ignoreDefinition && !this.getDefinition().equals(source.getDefinition())) {
            throw new IllegalArgumentException("Definition of source record does not match this object");
        }
        for (String fieldName : this.getFieldsInternal()) {
            FieldValue val = source.get(fieldName);
            if (val == null) continue;
            this.putField(fieldName, val);
        }
    }

    @Override
    public boolean contains(String fieldName) {
        return this.valueMap.containsKey(fieldName);
    }

    public void clear() {
        this.valueMap.clear();
    }

    RecordValue putEnum(String name, int value) {
        EnumDefImpl enumField = (EnumDefImpl)this.validateNameAndType(name, FieldDef.Type.ENUM);
        this.putField(name, enumField.createEnum(value));
        return this;
    }

    public FieldValue put(String name, String value, FieldDef.Type type) {
        FieldDefImpl newField = this.validateNameAndType(name, type);
        FieldValue val = this.create(value, newField);
        this.putField(name, val);
        return val;
    }

    void copyFields(RecordValueImpl from) {
        for (Map.Entry<String, FieldValue> entry : from.valueMap.entrySet()) {
            this.putField(entry.getKey(), entry.getValue().clone());
        }
    }

    FieldDef getDefinition(String name) {
        return this.getDefinition().getField(name);
    }

    int getNumFields() {
        return this.getDefinition().getNumFields();
    }

    FieldDef getField(String fieldName) {
        return this.getDefinition().getField(fieldName);
    }

    FieldMapEntry getFieldMapEntry(String fieldName) {
        return this.getDefinition().getFieldMapEntry(fieldName, false);
    }

    @Override
    public List<String> getFields() {
        return Collections.unmodifiableList(this.getFieldsInternal());
    }

    protected List<String> getFieldsInternal() {
        return this.getDefinition().getFieldsInternal();
    }

    @Override
    Object toAvroValue(Schema schema) {
        Schema recordSchema = RecordValueImpl.getRecordSchema(schema);
        GenericData.Record record = new GenericData.Record(recordSchema);
        RecordDefImpl def = this.getDefinition();
        for (Map.Entry<String, FieldMapEntry> entry : def.getFieldMap().getFields().entrySet()) {
            String fieldName = entry.getKey();
            FieldValueImpl fv = (FieldValueImpl)this.get(fieldName);
            if (fv == null) {
                fv = entry.getValue().getDefaultValue();
            }
            if (fv.isNull()) {
                record.put(fieldName, null);
                continue;
            }
            Schema s = recordSchema.getField(fieldName).schema();
            record.put(fieldName, fv.toAvroValue(s));
        }
        return record;
    }

    @Override
    void addJsonFields(JsonParser jp, boolean isIndexKey, String currentFieldName, boolean exact) {
        int numFields = 0;
        try {
            JsonToken t = null;
            while ((t = jp.nextToken()) != JsonToken.END_OBJECT && t != null) {
                JsonToken token;
                String fieldName = jp.getCurrentName();
                if (fieldName == null) continue;
                FieldMapEntry fme = this.getFieldMapEntry(fieldName);
                if (fme == null) {
                    if (exact) {
                        throw new IllegalArgumentException("Unexpected field in JSON input: " + fieldName);
                    }
                    token = jp.nextToken();
                    if (token == JsonToken.START_OBJECT) {
                        RecordValueImpl.skipToJsonToken(jp, JsonToken.END_OBJECT);
                        continue;
                    }
                    if (token != JsonToken.START_ARRAY) continue;
                    RecordValueImpl.skipToJsonToken(jp, JsonToken.END_ARRAY);
                    continue;
                }
                token = jp.nextToken();
                if (token == JsonToken.VALUE_NULL) {
                    if (fme.isNullable()) {
                        this.putNull(fieldName);
                        ++numFields;
                        continue;
                    }
                    throw new IllegalArgumentException("Invalid null value in JSON input for field " + fieldName);
                }
                switch (fme.getField().getType()) {
                    case INTEGER: {
                        RecordValueImpl.checkNumberType(fieldName, JsonParser.NumberType.INT, jp.getNumberType(), jp);
                        this.put(fieldName, jp.getIntValue());
                        break;
                    }
                    case LONG: {
                        RecordValueImpl.checkNumberType(fieldName, JsonParser.NumberType.LONG, jp.getNumberType(), jp);
                        this.put(fieldName, jp.getLongValue());
                        break;
                    }
                    case DOUBLE: {
                        RecordValueImpl.checkNumberType(fieldName, JsonParser.NumberType.DOUBLE, jp.getNumberType(), jp);
                        this.put(fieldName, jp.getDoubleValue());
                        break;
                    }
                    case FLOAT: {
                        RecordValueImpl.checkNumberType(fieldName, JsonParser.NumberType.FLOAT, jp.getNumberType(), jp);
                        this.put(fieldName, jp.getFloatValue());
                        break;
                    }
                    case STRING: {
                        RecordValueImpl.checkType(fieldName, true, "STRING", jp);
                        this.put(fieldName, jp.getText());
                        break;
                    }
                    case BINARY: {
                        RecordValueImpl.checkType(fieldName, true, "BINARY", jp);
                        this.put(fieldName, jp.getBinaryValue());
                        break;
                    }
                    case FIXED_BINARY: {
                        RecordValueImpl.checkType(fieldName, true, "BINARY", jp);
                        this.putFixed(fieldName, jp.getBinaryValue());
                        break;
                    }
                    case BOOLEAN: {
                        RecordValueImpl.checkType(fieldName, true, "BOOLEAN", jp);
                        this.put(fieldName, jp.getBooleanValue());
                        break;
                    }
                    case ARRAY: {
                        RecordValueImpl.checkType(fieldName, false, "ARRAY", jp);
                        ArrayValueImpl array = this.putArray(fieldName);
                        array.addJsonFields(jp, isIndexKey, fieldName, exact);
                        break;
                    }
                    case MAP: {
                        RecordValueImpl.checkType(fieldName, false, "MAP", jp);
                        MapValueImpl map = this.putMap(fieldName);
                        map.addJsonFields(jp, isIndexKey, fieldName, exact);
                        break;
                    }
                    case RECORD: {
                        RecordValueImpl.checkType(fieldName, false, "RECORD", jp);
                        RecordValueImpl record = this.putRecord(fieldName);
                        record.addJsonFields(jp, isIndexKey, fieldName, exact);
                        break;
                    }
                    case ENUM: {
                        RecordValueImpl.checkType(fieldName, true, "ENUM", jp);
                        this.putEnum(fieldName, jp.getText());
                    }
                }
                ++numFields;
            }
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Failed to parse JSON input: " + ioe.getMessage(), ioe);
        }
        if (exact && this.getNumFields() != numFields) {
            throw new IllegalArgumentException("Not enough fields for value in JSON input.Found " + numFields + ", expected " + this.getNumFields());
        }
    }

    private static void checkNumberType(String fieldName, JsonParser.NumberType expected, JsonParser.NumberType actual, JsonParser jp) throws IOException {
        if (actual != expected) {
            switch (actual) {
                case INT: {
                    return;
                }
                case FLOAT: 
                case LONG: {
                    if (expected == JsonParser.NumberType.DOUBLE) {
                        return;
                    }
                    if (expected != JsonParser.NumberType.FLOAT) break;
                }
                case DOUBLE: {
                    if (expected != JsonParser.NumberType.FLOAT) break;
                    Double d = jp.getDoubleValue();
                    if (d.isNaN()) {
                        return;
                    }
                    BigDecimal bd = new BigDecimal(jp.getText());
                    if (bd.compareTo(BigDecimal.ZERO) < 0) {
                        bd = bd.multiply(bdNegOne);
                    }
                    assert (bd.compareTo(BigDecimal.ZERO) >= 0);
                    int compMin = bd.compareTo(floatMin);
                    int compMax = bd.compareTo(floatMax);
                    if (compMin < 0 || compMax > 0) break;
                    return;
                }
            }
            throw new IllegalArgumentException("Illegal value for numeric field " + fieldName + ": " + jp.getText() + ". Expected " + (Object)((Object)expected) + ", is " + (Object)((Object)actual));
        }
    }

    private static void checkType(String fieldName, boolean mustBeScalar, String type, JsonParser jp) throws IOException {
        JsonToken tok = jp.getCurrentToken();
        if (tok.isScalarValue() != mustBeScalar || tok.isNumeric()) {
            throw new IllegalArgumentException("Illegal value for field " + fieldName + ": " + jp.getText() + ". Expected " + type);
        }
    }

    static RecordValueImpl fromAvroValue(FieldDef definition, Object obj, Schema schema) {
        Schema recordSchema = RecordValueImpl.getRecordSchema(schema);
        GenericRecord r = (GenericRecord)obj;
        RecordValueImpl record = new RecordValueImpl((RecordDef)definition);
        RecordDefImpl defImpl = (RecordDefImpl)definition;
        for (Map.Entry<String, FieldMapEntry> entry : defImpl.getFieldMap().getFields().entrySet()) {
            FieldMapEntry fme = entry.getValue();
            String fieldName = entry.getKey();
            Object o = r.get(fieldName);
            if (o != null) {
                Schema fieldSchema = recordSchema.getField(fieldName).schema();
                record.put(fieldName, FieldValueImpl.fromAvroValue(fme.getField(), o, fieldSchema));
                continue;
            }
            if (fme.isNullable()) {
                record.putNull(fieldName);
                continue;
            }
            record.put(fieldName, fme.getDefaultValue());
        }
        return record;
    }

    private static Schema getRecordSchema(Schema schema) {
        return RecordValueImpl.getUnionSchema(schema, Schema.Type.RECORD);
    }

    private void putField(String name, FieldValue value) {
        this.validateIndexField(name);
        this.valueMap.put(name, value);
    }

    FieldDefImpl validateNameAndType(String name, FieldDef.Type type) {
        FieldDef ft = this.getDefinition(name);
        if (ft == null) {
            throw new IllegalArgumentException("No such field in record " + this.getDefinition().getName() + ": " + name);
        }
        if (ft.getType() != type) {
            throw new IllegalArgumentException("Incorrect type for field " + name + ", type is " + (Object)((Object)type) + ", expected " + (Object)((Object)ft.getType()));
        }
        return (FieldDefImpl)ft;
    }

    private FieldValue create(String value, FieldDef field1) {
        switch (field1.getType()) {
            case INTEGER: {
                return new IntegerValueImpl(Integer.parseInt(value));
            }
            case LONG: {
                return new LongValueImpl(Long.parseLong(value));
            }
            case STRING: {
                return new StringValueImpl(value);
            }
            case DOUBLE: {
                return new DoubleValueImpl(Double.parseDouble(value));
            }
            case FLOAT: {
                return new FloatValueImpl(Float.parseFloat(value));
            }
            case BOOLEAN: {
                return new BooleanValueImpl(value);
            }
            case ENUM: {
                return new EnumValueImpl((EnumDef)field1, value);
            }
        }
        throw new IllegalArgumentException("Type not yet implemented: " + (Object)((Object)field1.getType()));
    }

    FieldValueImpl getComplex(TableImpl.TableField tableField) {
        return this.findFieldValue(tableField.iterator(), -1);
    }

    @Override
    FieldValueImpl findFieldValue(ListIterator<String> fieldPath, int arrayIndex) {
        assert (fieldPath.hasNext());
        FieldValueImpl fv = (FieldValueImpl)this.get(fieldPath.next());
        if (fv == null || !fieldPath.hasNext()) {
            return fv;
        }
        return fv.findFieldValue(fieldPath, arrayIndex);
    }

    @Override
    FieldValueImpl findFieldValue(ListIterator<String> fieldPath, String mapKey) {
        if (!fieldPath.hasNext()) {
            throw new IllegalStateException("Bad call to RecordValueImpl.findFieldValue");
        }
        FieldValueImpl fv = (FieldValueImpl)this.get(fieldPath.next());
        if (fv == null || !fieldPath.hasNext()) {
            return fv;
        }
        return fv.findFieldValue(fieldPath, mapKey);
    }

    @Override
    int numValues() {
        int num = 0;
        for (FieldValue v : this.valueMap.values()) {
            int numEntries = ((FieldValueImpl)v).numValues();
            num += numEntries == 0 ? 1 : numEntries;
        }
        return num;
    }
}

