/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import java.util.List;
import oracle.kv.impl.api.table.FieldMap;
import oracle.kv.impl.api.table.TableChange;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.impl.api.table.TableMetadata;
import oracle.kv.impl.security.ResourceOwner;

class AddTable
extends TableChange {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String parentName;
    private final List<String> primaryKey;
    private final List<String> shardKey;
    private final FieldMap fields;
    private final boolean r2compat;
    private final int schemaId;
    private final String description;
    private final ResourceOwner owner;

    AddTable(TableImpl table, int seqNum) {
        super(seqNum);
        this.name = table.getName();
        TableImpl parent = (TableImpl)table.getParent();
        this.parentName = parent == null ? null : parent.getFullName();
        this.primaryKey = table.getPrimaryKey();
        this.shardKey = table.getShardKey();
        this.fields = table.getFieldMap();
        this.r2compat = table.isR2compatible();
        this.schemaId = table.getSchemaId();
        this.description = table.getDescription();
        this.owner = table.getOwner();
    }

    @Override
    public boolean apply(TableMetadata md) {
        md.insertTable(this.name, this.parentName, this.primaryKey, this.shardKey, this.fields, this.r2compat, this.schemaId, this.description, this.owner);
        return true;
    }
}

