/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.ops;

import com.sleepycat.je.Transaction;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.kv.Operation;
import oracle.kv.UnauthorizedException;
import oracle.kv.impl.api.ops.Delete;
import oracle.kv.impl.api.ops.DeleteIfVersion;
import oracle.kv.impl.api.ops.Execute;
import oracle.kv.impl.api.ops.Get;
import oracle.kv.impl.api.ops.IndexIterate;
import oracle.kv.impl.api.ops.IndexKeysIterate;
import oracle.kv.impl.api.ops.MultiDelete;
import oracle.kv.impl.api.ops.MultiDeleteTable;
import oracle.kv.impl.api.ops.MultiGet;
import oracle.kv.impl.api.ops.MultiGetIterate;
import oracle.kv.impl.api.ops.MultiGetKeys;
import oracle.kv.impl.api.ops.MultiGetKeysIterate;
import oracle.kv.impl.api.ops.MultiGetTable;
import oracle.kv.impl.api.ops.MultiGetTableKeys;
import oracle.kv.impl.api.ops.NOP;
import oracle.kv.impl.api.ops.OperationHandler;
import oracle.kv.impl.api.ops.Put;
import oracle.kv.impl.api.ops.PutIfAbsent;
import oracle.kv.impl.api.ops.PutIfPresent;
import oracle.kv.impl.api.ops.PutIfVersion;
import oracle.kv.impl.api.ops.Result;
import oracle.kv.impl.api.ops.StoreIterate;
import oracle.kv.impl.api.ops.StoreKeysIterate;
import oracle.kv.impl.api.ops.TableIterate;
import oracle.kv.impl.api.ops.TableKeysIterate;
import oracle.kv.impl.api.ops.TableOperationHandler;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.impl.measurement.PerfStatType;
import oracle.kv.impl.security.AccessCheckUtils;
import oracle.kv.impl.security.ExecutionContext;
import oracle.kv.impl.security.KVStorePrivilege;
import oracle.kv.impl.security.SystemPrivilege;
import oracle.kv.impl.security.TablePrivilege;
import oracle.kv.impl.topo.PartitionId;
import oracle.kv.impl.util.FastExternalizable;

public abstract class InternalOperation
implements FastExternalizable {
    static final List<KVStorePrivilege> emptyPrivilegeList = Collections.emptyList();
    private static final OpCode[] OPCODES_BY_ORDINAL;
    private final OpCode opCode;

    public static OpCode getOpCode(int ordinal) {
        if (ordinal < 0 || ordinal >= OPCODES_BY_ORDINAL.length) {
            throw new RuntimeException("unknown opcode: " + ordinal);
        }
        return OPCODES_BY_ORDINAL[ordinal];
    }

    public InternalOperation(OpCode opCode) {
        this.opCode = opCode;
    }

    InternalOperation(OpCode opCode, ObjectInput in, short serialVersion) {
        this.opCode = opCode;
    }

    public static InternalOperation readFastExternal(ObjectInput in, short serialVersion) throws IOException {
        OpCode op = InternalOperation.getOpCode(in.readUnsignedByte());
        return op.readOperation(in, serialVersion);
    }

    @Override
    public void writeFastExternal(ObjectOutput out, short serialVersion) throws IOException {
        out.writeByte(this.opCode.ordinal());
    }

    public abstract Result execute(Transaction var1, PartitionId var2, OperationHandler var3) throws UnauthorizedException;

    public OpCode getOpCode() {
        return this.opCode;
    }

    public byte[] checkLOBSuffix(byte[] lobSuffixBytes) {
        return null;
    }

    public String toString() {
        return this.opCode.name();
    }

    protected boolean isInternalRequestor() {
        ExecutionContext currentContext = ExecutionContext.getCurrent();
        if (currentContext == null) {
            return true;
        }
        return currentContext.hasPrivilege(SystemPrivilege.INTLOPER);
    }

    protected void throwTablesRequired(short serialVersion) {
        throw new UnsupportedOperationException("Attempting an operation that is not supported by the server version.  Server version is " + serialVersion + ", required version is " + 4 + ", operation is " + (Object)((Object)this.opCode));
    }

    public abstract List<? extends KVStorePrivilege> getRequiredPrivileges();

    static {
        EnumSet<OpCode> set = EnumSet.allOf(OpCode.class);
        OPCODES_BY_ORDINAL = new OpCode[set.size()];
        Iterator i$ = set.iterator();
        while (i$.hasNext()) {
            OpCode op;
            InternalOperation.OPCODES_BY_ORDINAL[op.ordinal()] = op = (OpCode)((Object)i$.next());
        }
    }

    static class TableAccessChecker
    implements Keyspace.KeyAccessChecker {
        private final PrivilegedTableAccessor tableAccessor;
        final OperationHandler operationHandler;
        private final Set<Long> accessibleTables = new HashSet<Long>();

        TableAccessChecker(OperationHandler operationHandler, PrivilegedTableAccessor tableAccessor) {
            this.operationHandler = operationHandler;
            this.tableAccessor = tableAccessor;
        }

        @Override
        public boolean allowAccess(byte[] key) {
            if (!Keyspace.isGeneralAccess(key)) {
                return true;
            }
            TableImpl possibleTable = TableOperationHandler.findTableByKeyBytes(this.operationHandler, key);
            if (possibleTable == null) {
                return false;
            }
            return this.internalCheckTableAccess(possibleTable);
        }

        boolean internalCheckTableAccess(TableImpl table) {
            ExecutionContext exeCtx = ExecutionContext.getCurrent();
            if (exeCtx == null) {
                return true;
            }
            if (this.accessibleTables.contains(table.getId())) {
                return true;
            }
            if (!AccessCheckUtils.currentUserOwnsResource(table)) {
                long pTableId;
                if (!exeCtx.hasAllPrivileges(this.tableAccessor.tableAccessPrivileges(table.getId()))) {
                    return false;
                }
                for (TableImpl parent = (TableImpl)table.getParent(); parent != null && !this.accessibleTables.contains(pTableId = parent.getId()); parent = (TableImpl)parent.getParent()) {
                    TablePrivilege.ReadTable parentReadPriv = new TablePrivilege.ReadTable(pTableId);
                    if (exeCtx.hasPrivilege(parentReadPriv) || exeCtx.hasAllPrivileges(this.tableAccessor.tableAccessPrivileges(pTableId))) continue;
                    return false;
                }
            }
            this.accessibleTables.add(table.getId());
            return true;
        }
    }

    static class Keyspace {
        private static final byte[] PRIVATE_KEY_PREFIX = new byte[]{0, 0};
        private static final byte[] AVRO_SCHEMA_KEY_PREFIX = new byte[]{0, 115, 99, 104};
        static final KeyAccessChecker privateKeyAccessChecker = new KeyAccessChecker(){

            @Override
            public boolean allowAccess(byte[] key) {
                return !Keyspace.isPrivateAccess(key);
            }
        };
        static final KeyAccessChecker schemaKeyAccessChecker = new KeyAccessChecker(){

            @Override
            public boolean allowAccess(byte[] key) {
                return !Keyspace.isSchemaAccess(key);
            }
        };

        Keyspace() {
        }

        static KeyspaceType identifyKeyspace(byte[] key) {
            if (key == null || key.length == 0) {
                throw new IllegalArgumentException("Key bytes may not be null or empty");
            }
            if (key[0] == 0) {
                if (Keyspace.isSchemaAccess(key)) {
                    return KeyspaceType.SCHEMA;
                }
                if (Keyspace.isPrivateAccess(key)) {
                    return KeyspaceType.PRIVATE;
                }
            }
            return KeyspaceType.GENERAL;
        }

        static boolean isSchemaAccess(byte[] key) {
            if (key.length < AVRO_SCHEMA_KEY_PREFIX.length) {
                return false;
            }
            for (int i = 0; i < AVRO_SCHEMA_KEY_PREFIX.length; ++i) {
                if (key[i] == AVRO_SCHEMA_KEY_PREFIX[i]) continue;
                return false;
            }
            if (key.length == AVRO_SCHEMA_KEY_PREFIX.length) {
                return true;
            }
            byte endingByte = key[AVRO_SCHEMA_KEY_PREFIX.length];
            return endingByte == -1 || endingByte == 0;
        }

        static boolean mayBeSchemaAccess(byte[] key) {
            if (key.length < AVRO_SCHEMA_KEY_PREFIX.length) {
                for (int i = 0; i < key.length; ++i) {
                    if (key[i] == AVRO_SCHEMA_KEY_PREFIX[i]) continue;
                    return false;
                }
                return true;
            }
            for (int i = 0; i < AVRO_SCHEMA_KEY_PREFIX.length; ++i) {
                if (key[i] == AVRO_SCHEMA_KEY_PREFIX[i]) continue;
                return false;
            }
            if (key.length == AVRO_SCHEMA_KEY_PREFIX.length) {
                return true;
            }
            byte endingByte = key[AVRO_SCHEMA_KEY_PREFIX.length];
            return endingByte == -1 || endingByte == 0;
        }

        static boolean isPrivateAccess(byte[] key) {
            if (key.length < PRIVATE_KEY_PREFIX.length) {
                return false;
            }
            for (int i = 0; i < PRIVATE_KEY_PREFIX.length; ++i) {
                if (key[i] == PRIVATE_KEY_PREFIX[i]) continue;
                return false;
            }
            return true;
        }

        static boolean mayBePrivateAccess(byte[] key) {
            if (key.length < PRIVATE_KEY_PREFIX.length) {
                for (int i = 0; i < key.length; ++i) {
                    if (key[i] == PRIVATE_KEY_PREFIX.length) continue;
                    return false;
                }
                return true;
            }
            for (int i = 0; i < PRIVATE_KEY_PREFIX.length; ++i) {
                if (key[i] == PRIVATE_KEY_PREFIX.length) continue;
                return false;
            }
            return true;
        }

        static boolean isGeneralAccess(byte[] key) {
            return !Keyspace.isPrivateAccess(key) && !Keyspace.isSchemaAccess(key);
        }

        static enum KeyspaceType {
            PRIVATE,
            SCHEMA,
            GENERAL;

        }

        static interface KeyAccessChecker {
            public boolean allowAccess(byte[] var1);
        }
    }

    static interface PrivilegedTableAccessor {
        public List<? extends KVStorePrivilege> tableAccessPrivileges(long var1);
    }

    public static enum OpCode {
        NOP{

            @Override
            InternalOperation readOperation(ObjectInput in, short serialVersion) throws IOException {
                return new NOP(in, serialVersion);
            }

            @Override
            public Result readResult(ObjectInput in, short serialVersion) throws IOException {
                return new Result.NOPResult(in, serialVersion);
            }

            @Override
            public boolean checkResultType(Result result) {
                return true;
            }

            @Override
            public Operation.Type getExecuteType() {
                throw new RuntimeException("Not an execute op: " + (Object)((Object)this));
            }

            @Override
            public PerfStatType getIntervalMetric() {
                return PerfStatType.NOP_INT;
            }

            @Override
            public PerfStatType getCumulativeMetric() {
                return PerfStatType.NOP_CUM;
            }
        }
        ,
        GET{

            @Override
            InternalOperation readOperation(ObjectInput in, short serialVersion) throws IOException {
                return new Get(in, serialVersion);
            }

            @Override
            public Result readResult(ObjectInput in, short serialVersion) throws IOException {
                return new Result.GetResult(this, in, serialVersion);
            }

            @Override
            public boolean checkResultType(Result result) {
                return result instanceof Result.GetResult;
            }

            @Override
            public Operation.Type getExecuteType() {
                throw new RuntimeException("Not an execute op: " + (Object)((Object)this));
            }

            @Override
            public PerfStatType getIntervalMetric() {
                return PerfStatType.GET_INT;
            }

            @Override
            public PerfStatType getCumulativeMetric() {
                return PerfStatType.GET_CUM;
            }
        }
        ,
        MULTI_GET{

            @Override
            InternalOperation readOperation(ObjectInput in, short serialVersion) throws IOException {
                return new MultiGet(in, serialVersion);
            }

            @Override
            public Result readResult(ObjectInput in, short serialVersion) throws IOException {
                return new Result.IterateResult((OpCode)this, in, serialVersion);
            }

            @Override
            public boolean checkResultType(Result result) {
                return result instanceof Result.IterateResult;
            }

            @Override
            public Operation.Type getExecuteType() {
                throw new RuntimeException("Not an execute op: " + (Object)((Object)this));
            }

            @Override
            public PerfStatType getIntervalMetric() {
                return PerfStatType.MULTI_GET_INT;
            }

            @Override
            public PerfStatType getCumulativeMetric() {
                return PerfStatType.MULTI_GET_CUM;
            }
        }
        ,
        MULTI_GET_KEYS{

            @Override
            InternalOperation readOperation(ObjectInput in, short serialVersion) throws IOException {
                return new MultiGetKeys(in, serialVersion);
            }

            @Override
            public Result readResult(ObjectInput in, short serialVersion) throws IOException {
                return new Result.KeysIterateResult((OpCode)this, in, serialVersion);
            }

            @Override
            public boolean checkResultType(Result result) {
                return result instanceof Result.KeysIterateResult;
            }

            @Override
            public Operation.Type getExecuteType() {
                throw new RuntimeException("Not an execute op: " + (Object)((Object)this));
            }

            @Override
            public PerfStatType getIntervalMetric() {
                return PerfStatType.MULTI_GET_KEYS_INT;
            }

            @Override
            public PerfStatType getCumulativeMetric() {
                return PerfStatType.MULTI_GET_KEYS_CUM;
            }
        }
        ,
        MULTI_GET_ITERATE{

            @Override
            InternalOperation readOperation(ObjectInput in, short serialVersion) throws IOException {
                return new MultiGetIterate(in, serialVersion);
            }

            @Override
            public Result readResult(ObjectInput in, short serialVersion) throws IOException {
                return new Result.IterateResult((OpCode)this, in, serialVersion);
            }

            @Override
            public boolean checkResultType(Result result) {
                return result instanceof Result.IterateResult;
            }

            @Override
            public Operation.Type getExecuteType() {
                throw new RuntimeException("Not an execute op: " + (Object)((Object)this));
            }

            @Override
            public PerfStatType getIntervalMetric() {
                return PerfStatType.MULTI_GET_ITERATOR_INT;
            }

            @Override
            public PerfStatType getCumulativeMetric() {
                return PerfStatType.MULTI_GET_ITERATOR_CUM;
            }
        }
        ,
        MULTI_GET_KEYS_ITERATE{

            @Override
            InternalOperation readOperation(ObjectInput in, short serialVersion) throws IOException {
                return new MultiGetKeysIterate(in, serialVersion);
            }

            @Override
            public Result readResult(ObjectInput in, short serialVersion) throws IOException {
                return new Result.KeysIterateResult((OpCode)this, in, serialVersion);
            }

            @Override
            public boolean checkResultType(Result result) {
                return result instanceof Result.KeysIterateResult;
            }

            @Override
            public Operation.Type getExecuteType() {
                throw new RuntimeException("Not an execute op: " + (Object)((Object)this));
            }

            @Override
            public PerfStatType getIntervalMetric() {
                return PerfStatType.MULTI_GET_KEYS_ITERATOR_INT;
            }

            @Override
            public PerfStatType getCumulativeMetric() {
                return PerfStatType.MULTI_GET_KEYS_ITERATOR_CUM;
            }
        }
        ,
        STORE_ITERATE{

            @Override
            InternalOperation readOperation(ObjectInput in, short serialVersion) throws IOException {
                return new StoreIterate(in, serialVersion);
            }

            @Override
            public Result readResult(ObjectInput in, short serialVersion) throws IOException {
                return new Result.IterateResult((OpCode)this, in, serialVersion);
            }

            @Override
            public boolean checkResultType(Result result) {
                return result instanceof Result.IterateResult;
            }

            @Override
            public Operation.Type getExecuteType() {
                throw new RuntimeException("Not an execute op: " + (Object)((Object)this));
            }

            @Override
            public PerfStatType getIntervalMetric() {
                return PerfStatType.STORE_ITERATOR_INT;
            }

            @Override
            public PerfStatType getCumulativeMetric() {
                return PerfStatType.STORE_ITERATOR_CUM;
            }
        }
        ,
        STORE_KEYS_ITERATE{

            @Override
            InternalOperation readOperation(ObjectInput in, short serialVersion) throws IOException {
                return new StoreKeysIterate(in, serialVersion);
            }

            @Override
            public Result readResult(ObjectInput in, short serialVersion) throws IOException {
                return new Result.KeysIterateResult((OpCode)this, in, serialVersion);
            }

            @Override
            public boolean checkResultType(Result result) {
                return result instanceof Result.KeysIterateResult;
            }

            @Override
            public Operation.Type getExecuteType() {
                throw new RuntimeException("Not an execute op: " + (Object)((Object)this));
            }

            @Override
            public PerfStatType getIntervalMetric() {
                return PerfStatType.STORE_KEYS_ITERATOR_INT;
            }

            @Override
            public PerfStatType getCumulativeMetric() {
                return PerfStatType.STORE_KEYS_ITERATOR_CUM;
            }
        }
        ,
        PUT{

            @Override
            InternalOperation readOperation(ObjectInput in, short serialVersion) throws IOException {
                return new Put(in, serialVersion);
            }

            @Override
            public Result readResult(ObjectInput in, short serialVersion) throws IOException {
                return new Result.PutResult((OpCode)this, in, serialVersion);
            }

            @Override
            public boolean checkResultType(Result result) {
                return result instanceof Result.PutResult;
            }

            @Override
            public Operation.Type getExecuteType() {
                return Operation.Type.PUT;
            }

            @Override
            public PerfStatType getIntervalMetric() {
                return PerfStatType.PUT_INT;
            }

            @Override
            public PerfStatType getCumulativeMetric() {
                return PerfStatType.PUT_CUM;
            }
        }
        ,
        PUT_IF_ABSENT{

            @Override
            InternalOperation readOperation(ObjectInput in, short serialVersion) throws IOException {
                return new PutIfAbsent(in, serialVersion);
            }

            @Override
            public Result readResult(ObjectInput in, short serialVersion) throws IOException {
                return new Result.PutResult((OpCode)this, in, serialVersion);
            }

            @Override
            public boolean checkResultType(Result result) {
                return result instanceof Result.PutResult;
            }

            @Override
            public Operation.Type getExecuteType() {
                return Operation.Type.PUT_IF_ABSENT;
            }

            @Override
            public PerfStatType getIntervalMetric() {
                return PerfStatType.PUT_IF_ABSENT_INT;
            }

            @Override
            public PerfStatType getCumulativeMetric() {
                return PerfStatType.PUT_IF_ABSENT_CUM;
            }
        }
        ,
        PUT_IF_PRESENT{

            @Override
            InternalOperation readOperation(ObjectInput in, short serialVersion) throws IOException {
                return new PutIfPresent(in, serialVersion);
            }

            @Override
            public Result readResult(ObjectInput in, short serialVersion) throws IOException {
                return new Result.PutResult((OpCode)this, in, serialVersion);
            }

            @Override
            public boolean checkResultType(Result result) {
                return result instanceof Result.PutResult;
            }

            @Override
            public Operation.Type getExecuteType() {
                return Operation.Type.PUT_IF_PRESENT;
            }

            @Override
            public PerfStatType getIntervalMetric() {
                return PerfStatType.PUT_IF_PRESENT_INT;
            }

            @Override
            public PerfStatType getCumulativeMetric() {
                return PerfStatType.PUT_IF_PRESENT_CUM;
            }
        }
        ,
        PUT_IF_VERSION{

            @Override
            InternalOperation readOperation(ObjectInput in, short serialVersion) throws IOException {
                return new PutIfVersion(in, serialVersion);
            }

            @Override
            public Result readResult(ObjectInput in, short serialVersion) throws IOException {
                return new Result.PutResult((OpCode)this, in, serialVersion);
            }

            @Override
            public boolean checkResultType(Result result) {
                return result instanceof Result.PutResult;
            }

            @Override
            public Operation.Type getExecuteType() {
                return Operation.Type.PUT_IF_VERSION;
            }

            @Override
            public PerfStatType getIntervalMetric() {
                return PerfStatType.PUT_IF_VERSION_INT;
            }

            @Override
            public PerfStatType getCumulativeMetric() {
                return PerfStatType.PUT_IF_VERSION_CUM;
            }
        }
        ,
        DELETE{

            @Override
            InternalOperation readOperation(ObjectInput in, short serialVersion) throws IOException {
                return new Delete(in, serialVersion);
            }

            @Override
            public Result readResult(ObjectInput in, short serialVersion) throws IOException {
                return new Result.DeleteResult((OpCode)this, in, serialVersion);
            }

            @Override
            public boolean checkResultType(Result result) {
                return result instanceof Result.DeleteResult;
            }

            @Override
            public Operation.Type getExecuteType() {
                return Operation.Type.DELETE;
            }

            @Override
            public PerfStatType getIntervalMetric() {
                return PerfStatType.DELETE_INT;
            }

            @Override
            public PerfStatType getCumulativeMetric() {
                return PerfStatType.DELETE_CUM;
            }
        }
        ,
        DELETE_IF_VERSION{

            @Override
            InternalOperation readOperation(ObjectInput in, short serialVersion) throws IOException {
                return new DeleteIfVersion(in, serialVersion);
            }

            @Override
            public Result readResult(ObjectInput in, short serialVersion) throws IOException {
                return new Result.DeleteResult((OpCode)this, in, serialVersion);
            }

            @Override
            public boolean checkResultType(Result result) {
                return result instanceof Result.DeleteResult;
            }

            @Override
            public Operation.Type getExecuteType() {
                return Operation.Type.DELETE_IF_VERSION;
            }

            @Override
            public PerfStatType getIntervalMetric() {
                return PerfStatType.DELETE_IF_VERSION_INT;
            }

            @Override
            public PerfStatType getCumulativeMetric() {
                return PerfStatType.DELETE_IF_VERSION_CUM;
            }
        }
        ,
        MULTI_DELETE{

            @Override
            InternalOperation readOperation(ObjectInput in, short serialVersion) throws IOException {
                return new MultiDelete(in, serialVersion);
            }

            @Override
            public Result readResult(ObjectInput in, short serialVersion) throws IOException {
                return new Result.MultiDeleteResult(this, in, serialVersion);
            }

            @Override
            public boolean checkResultType(Result result) {
                return result instanceof Result.MultiDeleteResult;
            }

            @Override
            public Operation.Type getExecuteType() {
                throw new RuntimeException("Not an execute op: " + (Object)((Object)this));
            }

            @Override
            public PerfStatType getIntervalMetric() {
                return PerfStatType.MULTI_DELETE_INT;
            }

            @Override
            public PerfStatType getCumulativeMetric() {
                return PerfStatType.MULTI_DELETE_CUM;
            }
        }
        ,
        EXECUTE{

            @Override
            InternalOperation readOperation(ObjectInput in, short serialVersion) throws IOException {
                return new Execute(in, serialVersion);
            }

            @Override
            public Result readResult(ObjectInput in, short serialVersion) throws IOException {
                return new Result.ExecuteResult((OpCode)this, in, serialVersion);
            }

            @Override
            public boolean checkResultType(Result result) {
                return result instanceof Result.ExecuteResult;
            }

            @Override
            public Operation.Type getExecuteType() {
                throw new RuntimeException("Not an execute op: " + (Object)((Object)this));
            }

            @Override
            public PerfStatType getIntervalMetric() {
                return PerfStatType.EXECUTE_INT;
            }

            @Override
            public PerfStatType getCumulativeMetric() {
                return PerfStatType.EXECUTE_CUM;
            }
        }
        ,
        MULTI_GET_TABLE{

            @Override
            InternalOperation readOperation(ObjectInput in, short serialVersion) throws IOException {
                return new MultiGetTable(in, serialVersion);
            }

            @Override
            public Result readResult(ObjectInput in, short serialVersion) throws IOException {
                return new Result.IterateResult((OpCode)this, in, serialVersion);
            }

            @Override
            public boolean checkResultType(Result result) {
                return result instanceof Result.IterateResult;
            }

            @Override
            public Operation.Type getExecuteType() {
                throw new RuntimeException("Not an execute op: " + (Object)((Object)this));
            }

            @Override
            public PerfStatType getIntervalMetric() {
                return PerfStatType.MULTI_GET_INT;
            }

            @Override
            public PerfStatType getCumulativeMetric() {
                return PerfStatType.MULTI_GET_CUM;
            }

            @Override
            public short requiredVersion() {
                return 4;
            }
        }
        ,
        MULTI_GET_TABLE_KEYS{

            @Override
            InternalOperation readOperation(ObjectInput in, short serialVersion) throws IOException {
                return new MultiGetTableKeys(in, serialVersion);
            }

            @Override
            public Result readResult(ObjectInput in, short serialVersion) throws IOException {
                return new Result.KeysIterateResult((OpCode)this, in, serialVersion);
            }

            @Override
            public boolean checkResultType(Result result) {
                return result instanceof Result.KeysIterateResult;
            }

            @Override
            public Operation.Type getExecuteType() {
                throw new RuntimeException("Not an execute op: " + (Object)((Object)this));
            }

            @Override
            public PerfStatType getIntervalMetric() {
                return PerfStatType.MULTI_GET_INT;
            }

            @Override
            public PerfStatType getCumulativeMetric() {
                return PerfStatType.MULTI_GET_CUM;
            }

            @Override
            public short requiredVersion() {
                return 4;
            }
        }
        ,
        TABLE_ITERATE{

            @Override
            InternalOperation readOperation(ObjectInput in, short serialVersion) throws IOException {
                return new TableIterate(in, serialVersion);
            }

            @Override
            public Result readResult(ObjectInput in, short serialVersion) throws IOException {
                return new Result.IterateResult((OpCode)this, in, serialVersion);
            }

            @Override
            public boolean checkResultType(Result result) {
                return result instanceof Result.IterateResult;
            }

            @Override
            public Operation.Type getExecuteType() {
                throw new RuntimeException("Not an execute op: " + (Object)((Object)this));
            }

            @Override
            public PerfStatType getIntervalMetric() {
                return PerfStatType.STORE_ITERATOR_INT;
            }

            @Override
            public PerfStatType getCumulativeMetric() {
                return PerfStatType.STORE_ITERATOR_CUM;
            }

            @Override
            public short requiredVersion() {
                return 4;
            }
        }
        ,
        TABLE_KEYS_ITERATE{

            @Override
            InternalOperation readOperation(ObjectInput in, short serialVersion) throws IOException {
                return new TableKeysIterate(in, serialVersion);
            }

            @Override
            public Result readResult(ObjectInput in, short serialVersion) throws IOException {
                return new Result.KeysIterateResult((OpCode)this, in, serialVersion);
            }

            @Override
            public boolean checkResultType(Result result) {
                return result instanceof Result.KeysIterateResult;
            }

            @Override
            public Operation.Type getExecuteType() {
                throw new RuntimeException("Not an execute op: " + (Object)((Object)this));
            }

            @Override
            public PerfStatType getIntervalMetric() {
                return PerfStatType.STORE_KEYS_ITERATOR_INT;
            }

            @Override
            public PerfStatType getCumulativeMetric() {
                return PerfStatType.STORE_KEYS_ITERATOR_CUM;
            }

            @Override
            public short requiredVersion() {
                return 4;
            }
        }
        ,
        INDEX_ITERATE{

            @Override
            InternalOperation readOperation(ObjectInput in, short serialVersion) throws IOException {
                return new IndexIterate(in, serialVersion);
            }

            @Override
            public Result readResult(ObjectInput in, short serialVersion) throws IOException {
                return new Result.IndexRowsIterateResult((OpCode)this, in, serialVersion);
            }

            @Override
            public boolean checkResultType(Result result) {
                return result instanceof Result.IndexRowsIterateResult;
            }

            @Override
            public Operation.Type getExecuteType() {
                throw new RuntimeException("Not an execute op: " + (Object)((Object)this));
            }

            @Override
            public PerfStatType getIntervalMetric() {
                return PerfStatType.INDEX_ITERATOR_INT;
            }

            @Override
            public PerfStatType getCumulativeMetric() {
                return PerfStatType.INDEX_ITERATOR_CUM;
            }

            @Override
            public short requiredVersion() {
                return 4;
            }
        }
        ,
        INDEX_KEYS_ITERATE{

            @Override
            InternalOperation readOperation(ObjectInput in, short serialVersion) throws IOException {
                return new IndexKeysIterate(in, serialVersion);
            }

            @Override
            public Result readResult(ObjectInput in, short serialVersion) throws IOException {
                return new Result.IndexKeysIterateResult((OpCode)this, in, serialVersion);
            }

            @Override
            public boolean checkResultType(Result result) {
                return result instanceof Result.IndexKeysIterateResult;
            }

            @Override
            public Operation.Type getExecuteType() {
                throw new RuntimeException("Not an execute op: " + (Object)((Object)this));
            }

            @Override
            public PerfStatType getIntervalMetric() {
                return PerfStatType.INDEX_KEYS_ITERATOR_INT;
            }

            @Override
            public PerfStatType getCumulativeMetric() {
                return PerfStatType.INDEX_KEYS_ITERATOR_CUM;
            }

            @Override
            public short requiredVersion() {
                return 4;
            }
        }
        ,
        MULTI_DELETE_TABLE{

            @Override
            InternalOperation readOperation(ObjectInput in, short serialVersion) throws IOException {
                return new MultiDeleteTable(in, serialVersion);
            }

            @Override
            public Result readResult(ObjectInput in, short serialVersion) throws IOException {
                return new Result.MultiDeleteResult(this, in, serialVersion);
            }

            @Override
            public boolean checkResultType(Result result) {
                return result instanceof Result.MultiDeleteResult;
            }

            @Override
            public Operation.Type getExecuteType() {
                throw new RuntimeException("Not an execute op: " + (Object)((Object)this));
            }

            @Override
            public PerfStatType getIntervalMetric() {
                return PerfStatType.MULTI_DELETE_INT;
            }

            @Override
            public PerfStatType getCumulativeMetric() {
                return PerfStatType.MULTI_DELETE_CUM;
            }

            @Override
            public short requiredVersion() {
                return 4;
            }
        };


        abstract InternalOperation readOperation(ObjectInput var1, short var2) throws IOException;

        public abstract Result readResult(ObjectInput var1, short var2) throws IOException;

        public abstract boolean checkResultType(Result var1);

        public abstract Operation.Type getExecuteType();

        public abstract PerfStatType getIntervalMetric();

        public abstract PerfStatType getCumulativeMetric();

        public short requiredVersion() {
            return 1;
        }
    }
}

