/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.webapp.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.i18n.shared.TimeZone;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.DecoratedPopupPanel;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.RadioButton;
import com.google.gwt.user.client.ui.Widget;
import java.util.Date;
import java.util.Map;
import java.util.TreeSet;
import oracle.kv.impl.admin.webapp.client.Events;
import oracle.kv.impl.admin.webapp.client.KVAdminUI;
import oracle.kv.impl.admin.webapp.client.Logs;
import oracle.kv.impl.admin.webapp.client.Monitoring;
import oracle.kv.impl.admin.webapp.shared.UpdateInfo;

public class Monitoring {
    private static final Binder binder = (Binder)GWT.create(Binder.class);
    private static final DateTimeFormat dtf = DateTimeFormat.getFormat((String)"yyyy-MM-dd HH:mm:ss.SSS z");
    private static final com.google.gwt.i18n.client.TimeZone tz = com.google.gwt.i18n.client.TimeZone.createTimeZone((int)0);
    private final KVAdminUI root;
    private Logs logDisplay;
    private Events eventDisplay;
    @UiField
    Panel container;
    @UiField
    RadioButton logButton;
    @UiField
    RadioButton eventButton;
    @UiField
    Panel display;
    @UiField
    Button downloadPopup;
    private static final String DLPATH = "/kvadminui/LogDownloadService?log=";

    Monitoring(KVAdminUI root) {
        this.root = root;
        binder.createAndBindUi((Object)this);
        this.logDisplay = new Logs(root);
        this.eventDisplay = new Events(root);
        this.logButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.eventButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.downloadPopup.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.installLogDisplay();
    }

    void display(Panel place) {
        place.clear();
        place.add((Widget)this.container);
    }

    private void installLogDisplay() {
        this.logButton.addStyleName("subtitle");
        this.eventButton.removeStyleName("subtitle");
        this.logDisplay.display(this.display);
    }

    private void installEventDisplay() {
        this.logButton.removeStyleName("subtitle");
        this.eventButton.addStyleName("subtitle");
        this.eventDisplay.display(this.display);
    }

    void applyUpdates(UpdateInfo updates) {
        this.logDisplay.applyUpdates(updates);
    }

    void popupLogDownloadList(Map<String, Long> logFiles) {
        DecoratedPopupPanel logPopup = new DecoratedPopupPanel(true);
        logPopup.setWidth("416px");
        Grid g = new Grid(logFiles.size() + 1, 2);
        g.setCellPadding(4);
        g.setWidth("400px");
        Label head1 = new Label("Log File Name");
        head1.addStyleName("subsubtitle");
        g.setWidget(0, 0, (Widget)head1);
        Label head2 = new Label("Last Modified");
        head2.addStyleName("subsubtitle");
        g.setWidget(0, 1, (Widget)head2);
        int currentRow = 1;
        TreeSet<String> filenames = new TreeSet<String>(logFiles.keySet());
        for (String f : filenames) {
            Long timestamp = logFiles.get(f);
            g.setWidget(currentRow, 0, (Widget)new Anchor(f, DLPATH + f, "dummy"));
            g.setWidget(currentRow, 1, (Widget)new Label(dtf.format(new Date(timestamp), (TimeZone)tz)));
            ++currentRow;
        }
        FlowPanel p = new FlowPanel();
        p.add((Widget)new Label("Log Files Available for Downloading"));
        p.add((Widget)g);
        logPopup.setWidget((Widget)p);
        logPopup.setPopupPosition(this.downloadPopup.getAbsoluteLeft() - 456, 160);
        logPopup.show();
    }

    static /* synthetic */ void access$000(Monitoring x0) {
        x0.installLogDisplay();
    }

    static /* synthetic */ void access$100(Monitoring x0) {
        x0.installEventDisplay();
    }
}

