/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.topo;

import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.Transaction;
import com.sleepycat.persist.EntityCursor;
import com.sleepycat.persist.EntityStore;
import com.sleepycat.persist.PrimaryIndex;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import oracle.kv.impl.admin.Admin;
import oracle.kv.impl.admin.topo.RealizedTopology;
import oracle.kv.impl.admin.topo.TopologyCandidate;
import oracle.kv.impl.api.TopologyManager;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.server.LoggerUtils;

public class TopologyStore {
    private final Admin admin;
    private long lastStartMillis;
    private final int maxTopoChanges;
    private final Logger logger;

    public TopologyStore(Admin admin) {
        this.admin = admin;
        this.logger = LoggerUtils.getLogger(this.getClass(), admin.getParams());
        this.maxTopoChanges = admin.getParams().getAdminParams().getMaxTopoChanges();
        this.lastStartMillis = 0L;
    }

    public void initCachedStartTime(Transaction txn) {
        RealizedTopology rt = this.readCurrentRealizedTopology(txn);
        this.lastStartMillis = rt == null ? 0L : rt.getStartTime();
    }

    private PrimaryIndex<String, TopologyCandidate> openCandidates() {
        return this.admin.getEStore().getPrimaryIndex(String.class, TopologyCandidate.class);
    }

    public boolean exists(Transaction txn, String candidateName) {
        PrimaryIndex<String, TopologyCandidate> candidates = this.openCandidates();
        return candidates.contains(txn, (Object)candidateName, LockMode.DEFAULT);
    }

    public void save(Transaction txn, TopologyCandidate candidate) {
        PrimaryIndex<String, TopologyCandidate> candidates = this.openCandidates();
        TopologyManager.pruneChanges(candidate.getTopology(), Integer.MAX_VALUE, this.maxTopoChanges);
        candidates.put(txn, (Object)candidate);
    }

    public TopologyCandidate get(Transaction txn, String candidateName) {
        PrimaryIndex<String, TopologyCandidate> candidates = this.openCandidates();
        return (TopologyCandidate)candidates.get(txn, (Object)candidateName, LockMode.DEFAULT);
    }

    public void delete(Transaction txn, String name) {
        PrimaryIndex<String, TopologyCandidate> candidates = this.openCandidates();
        candidates.delete(txn, (Object)name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getCandidateNames(Transaction txn) {
        PrimaryIndex<String, TopologyCandidate> candidates = this.openCandidates();
        EntityCursor nameCursor = candidates.keys(txn, CursorConfig.READ_COMMITTED);
        try {
            ArrayList<String> names = new ArrayList<String>();
            Iterator iter = nameCursor.iterator();
            while (iter.hasNext()) {
                names.add((String)iter.next());
            }
            ArrayList<String> arrayList = names;
            return arrayList;
        }
        finally {
            nameCursor.close();
        }
    }

    private static PrimaryIndex<Long, RealizedTopology> openHistory(EntityStore estore) {
        return estore.getPrimaryIndex(Long.class, RealizedTopology.class);
    }

    private PrimaryIndex<Long, RealizedTopology> openHistory() {
        return this.admin.getEStore().getPrimaryIndex(Long.class, RealizedTopology.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RealizedTopology readCurrentRealizedTopology(Transaction txn) {
        PrimaryIndex<Long, RealizedTopology> history = this.openHistory();
        EntityCursor cursor = history.entities(txn, CursorConfig.READ_COMMITTED);
        RealizedTopology lastRT = null;
        try {
            lastRT = (RealizedTopology)cursor.last();
        }
        finally {
            cursor.close();
        }
        return lastRT == null ? null : lastRT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<RealizedTopology> readLastTopos(EntityStore estore, int numToRead) {
        PrimaryIndex<Long, RealizedTopology> history = TopologyStore.openHistory(estore);
        EntityCursor cursor = history.entities(null, CursorConfig.READ_COMMITTED);
        ArrayList<RealizedTopology> latestTopos = new ArrayList<RealizedTopology>();
        RealizedTopology lastRT = null;
        try {
            int count = 0;
            lastRT = (RealizedTopology)cursor.last();
            while (lastRT != null) {
                latestTopos.add(lastRT);
                lastRT = (RealizedTopology)cursor.prev();
                if (++count < numToRead) continue;
                break;
            }
        }
        finally {
            cursor.close();
        }
        return latestTopos;
    }

    public Topology readTopology(Transaction txn) {
        RealizedTopology rt = this.readCurrentRealizedTopology(txn);
        return rt == null ? null : rt.getTopology();
    }

    public void save(Transaction txn, RealizedTopology dt) {
        PrimaryIndex<Long, RealizedTopology> history = this.openHistory();
        TopologyManager.pruneChanges(dt.getTopology(), Integer.MAX_VALUE, this.maxTopoChanges);
        history.put(txn, (Object)dt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> displayHistory(Transaction txn, boolean concise) {
        ArrayList<String> display = new ArrayList<String>();
        PrimaryIndex<Long, RealizedTopology> history = this.openHistory();
        EntityCursor cursor = history.entities(txn, CursorConfig.READ_COMMITTED);
        try {
            for (RealizedTopology dt : cursor) {
                display.add(dt.display(concise));
            }
        }
        finally {
            cursor.close();
        }
        return display;
    }

    public synchronized long validateStartTime(long proposedStartTime) {
        if (proposedStartTime > this.lastStartMillis) {
            this.lastStartMillis = proposedStartTime;
            return proposedStartTime;
        }
        ++this.lastStartMillis;
        this.logger.info("TopologyStore: proposedStartTime of " + proposedStartTime + " is less than cached time, so use topoStore lastStartTime" + " of " + this.lastStartMillis);
        return this.lastStartMillis;
    }
}

