/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan.task;

import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.KVVersion;
import oracle.kv.impl.admin.Admin;
import oracle.kv.impl.admin.AdminFaultException;
import oracle.kv.impl.admin.AdminServiceParams;
import oracle.kv.impl.admin.IllegalCommandException;
import oracle.kv.impl.admin.param.AdminParams;
import oracle.kv.impl.admin.param.Parameters;
import oracle.kv.impl.admin.param.RepNodeParams;
import oracle.kv.impl.admin.param.StorageNodeParams;
import oracle.kv.impl.admin.plan.AbstractPlan;
import oracle.kv.impl.admin.plan.task.Task;
import oracle.kv.impl.api.TopologyInfo;
import oracle.kv.impl.api.table.TableMetadata;
import oracle.kv.impl.fault.OperationFaultException;
import oracle.kv.impl.metadata.Metadata;
import oracle.kv.impl.metadata.MetadataInfo;
import oracle.kv.impl.param.ParameterMap;
import oracle.kv.impl.rep.RepNodeStatus;
import oracle.kv.impl.rep.admin.RepNodeAdminAPI;
import oracle.kv.impl.rep.admin.RepNodeAdminFaultException;
import oracle.kv.impl.security.login.LoginManager;
import oracle.kv.impl.security.metadata.SecurityMetadata;
import oracle.kv.impl.security.metadata.SecurityMetadataInfo;
import oracle.kv.impl.sna.StorageNodeAgentAPI;
import oracle.kv.impl.topo.AdminId;
import oracle.kv.impl.topo.AdminType;
import oracle.kv.impl.topo.Datacenter;
import oracle.kv.impl.topo.DatacenterType;
import oracle.kv.impl.topo.RepGroup;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.topo.RepNode;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.StorageNode;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.topo.change.TopologyChange;
import oracle.kv.impl.util.ConfigurableService;
import oracle.kv.impl.util.ServiceUtils;
import oracle.kv.impl.util.VersionUtil;
import oracle.kv.impl.util.registry.RegistryUtils;
import oracle.kv.util.Ping;

public class Utils {
    private static int SUCCEEDED = 1;
    private static int FAILED = 0;
    private static int STOP = -1;

    static Set<Metadata<? extends MetadataInfo>> getMetadataSet(Topology topo, AbstractPlan plan) {
        if (topo == null) {
            throw new IllegalStateException("Requires non-null topology to build metadata set");
        }
        HashSet<Metadata<? extends MetadataInfo>> metadataSet = new HashSet<Metadata<? extends MetadataInfo>>();
        metadataSet.add(topo);
        Metadata<SecurityMetadataInfo> md = plan.getAdmin().getMetadata(SecurityMetadata.class, Metadata.MetadataType.SECURITY);
        if (md != null) {
            metadataSet.add(md);
        }
        if ((md = plan.getAdmin().getMetadata(TableMetadata.class, Metadata.MetadataType.TABLE)) != null) {
            metadataSet.add(md);
        }
        return metadataSet;
    }

    public static boolean broadcastTopoChangesToRNs(Logger logger, Topology topo, String actionDescription, AdminParams params, AbstractPlan plan) throws InterruptedException {
        logger.log(Level.INFO, "Broadcasting topology seq# {0}, changes for {1}", new Object[]{topo.getSequenceNumber(), actionDescription});
        ArrayList<RepNodeId> retryList = new ArrayList<RepNodeId>();
        RegistryUtils registry = new RegistryUtils(topo, plan.getLoginManager());
        int nNodes = 0;
        for (RepGroup rg : topo.getRepGroupMap().getAll()) {
            for (RepNode rn : rg.getRepNodes()) {
                ++nNodes;
                RepNodeId rnId = (RepNodeId)rn.getResourceId();
                int result = Utils.sendTopoChangesToRN(logger, rnId, topo, actionDescription, registry);
                if (result < 0) {
                    return true;
                }
                if (result != 0) continue;
                retryList.add(rnId);
            }
        }
        if (retryList.isEmpty()) {
            logger.log(Level.FINE, "Successful broadcast to all nodes of topology seq# {0}, for {1}", new Object[]{topo.getSequenceNumber(), actionDescription});
            return true;
        }
        int thresholdNodes = Math.max(nNodes * params.getBroadcastTopoThreshold() / 100, 1);
        int acceptableFailures = nNodes - thresholdNodes;
        long delay = params.getBroadcastTopoRetryDelayMillis();
        int retries = 0;
        while (retryList.size() > acceptableFailures) {
            if (plan.isInterruptRequested()) {
                logger.log(Level.INFO, "{0} has been interrupted, stop attempts to broadcast topology changes for {1}", new Object[]{plan.toString(), actionDescription});
                return false;
            }
            logger.log(Level.INFO, "Failed to broadcast topology to {0} out of {1} nodes, will retry, acceptable failure threshold={2}, retries={3}", new Object[]{retryList.size(), nNodes, acceptableFailures, ++retries});
            Thread.sleep(delay);
            RegistryUtils ru = new RegistryUtils(topo, plan.getLoginManager());
            Iterator itr = retryList.iterator();
            while (itr.hasNext()) {
                int result = Utils.sendTopoChangesToRN(logger, (RepNodeId)itr.next(), topo, actionDescription, ru);
                if (result < 0) {
                    return true;
                }
                if (result <= 0) continue;
                itr.remove();
            }
        }
        logger.log(Level.INFO, "Broadcast topology {0} for {1} successful to {2} out of {3} nodes", new Object[]{topo.getSequenceNumber(), actionDescription, nNodes - retryList.size(), nNodes});
        return true;
    }

    private static int sendTopoChangesToRN(Logger logger, RepNodeId rnId, Topology topo, String actionDescription, RegistryUtils registry) {
        StorageNodeId snId = topo.get(rnId).getStorageNodeId();
        try {
            List<TopologyChange> changes;
            RepNodeAdminAPI rnAdmin = registry.getRepNodeAdmin(rnId);
            int rnTopoSeqNum = rnAdmin.getTopoSeqNum();
            if (rnTopoSeqNum == topo.getSequenceNumber()) {
                return 1;
            }
            if (rnTopoSeqNum > topo.getSequenceNumber()) {
                logger.log(Level.FINE, "{0} has a higher topology sequence number of {1} compared to this topology of {2} while {3}", new Object[]{rnId, rnTopoSeqNum, topo.getSequenceNumber(), actionDescription});
                return -1;
            }
            List<TopologyChange> list = changes = rnTopoSeqNum == 0 ? null : topo.getChanges(rnTopoSeqNum);
            if (changes != null && changes.size() > 0) {
                int actualTopoSeqNum = rnAdmin.updateMetadata(new TopologyInfo(topo, changes));
                if (rnTopoSeqNum - actualTopoSeqNum > 1) {
                    logger.log(Level.INFO, "Older topology than expected for {0} on {1}. Expected topo seq num: {2} actual: {3}", new Object[]{rnId, snId, rnTopoSeqNum, actualTopoSeqNum});
                    return 0;
                }
            } else {
                rnAdmin.updateMetadata(topo);
            }
            return 1;
        }
        catch (RepNodeAdminFaultException rnfe) {
            logger.log(Level.INFO, "Unable to update topology for {0} on {1} for {2} during broadcast: {3}", new Object[]{rnId, snId, actionDescription, rnfe});
        }
        catch (NotBoundException notbound) {
            logger.log(Level.INFO, "{0} on {1} cannot be contacted for topology update to {2} during broadcast: {3}", new Object[]{rnId, snId, actionDescription, notbound});
        }
        catch (RemoteException e) {
            logger.log(Level.INFO, "Could not update topology for {0} on {1} for {2}: {3}", new Object[]{rnId, snId, actionDescription, e});
        }
        return 0;
    }

    static void updateHelperHost(Admin admin, Topology topo, RepGroupId rgId, RepNodeId rnId, Logger logger) throws RemoteException, NotBoundException {
        RepNodeParams oldRNP = admin.getRepNodeParams(rnId);
        RepNodeParams newRNP = new RepNodeParams(oldRNP);
        String updatedHelpers = Utils.findRNHelpers(admin, rnId, topo.get(rgId));
        if (updatedHelpers.length() == 0) {
            return;
        }
        newRNP.setJEHelperHosts(updatedHelpers);
        admin.updateParams(newRNP);
        StorageNodeId snId = newRNP.getStorageNodeId();
        logger.info("Changing helperHost for " + rnId + " on " + snId + " to " + updatedHelpers);
        RegistryUtils registryUtils = new RegistryUtils(topo, admin.getLoginManager());
        StorageNodeAgentAPI sna = registryUtils.getStorageNodeAgent(snId);
        sna.newRepNodeParameters(newRNP.getMap());
    }

    private static String findRNHelpers(Admin admin, RepNodeId targetRNId, RepGroup rg) {
        StringBuilder helperHosts = new StringBuilder();
        for (RepNode rn : rg.getRepNodes()) {
            RepNodeId rid = (RepNodeId)rn.getResourceId();
            if (rid.equals(targetRNId)) continue;
            if (helperHosts.length() != 0) {
                helperHosts.append(",");
            }
            helperHosts.append(admin.getRepNodeParams(rid).getJENodeHostPort());
        }
        return helperHosts.toString();
    }

    static String findAdminHelpers(Parameters p, AdminId target) {
        StringBuilder helperHosts = new StringBuilder();
        if (p.getAdminCount() == 1) {
            helperHosts.append(p.get(target).getNodeHostPort());
        } else {
            for (AdminParams ap : p.getAdminParams()) {
                AdminId aid = ap.getAdminId();
                if (aid.equals(target)) continue;
                if (helperHosts.length() != 0) {
                    helperHosts.append(",");
                }
                helperHosts.append(ap.getNodeHostPort());
            }
        }
        return helperHosts.toString();
    }

    static void changeHAAddress(Topology topo, Parameters parameters, AdminParams adminParams, RepNodeId rnId, StorageNodeId oldNode, StorageNodeId newNode, AbstractPlan plan, Logger logger) throws InterruptedException {
        RepNode targetRN = topo.get(rnId);
        RepGroup rg = topo.get(targetRN.getRepGroupId());
        Datacenter oldDC = topo.getDatacenter(oldNode);
        Datacenter newDC = topo.getDatacenter(newNode);
        if (!oldDC.getDatacenterType().isPrimary() || !newDC.getDatacenterType().isPrimary()) {
            return;
        }
        String targetNodeHostPort = parameters.get(rnId).getJENodeHostPort();
        boolean done = false;
        String targetHelperHosts = parameters.get(rnId).getJEHelperHosts();
        long delay = adminParams.getBroadcastTopoRetryDelayMillis();
        logger.log(Level.INFO, "Change haPort for {0} to relocate from {1} to {2}", new Object[]{rnId, oldNode, newNode});
        while (!done && !plan.isInterruptRequested()) {
            boolean groupHasNoMaster = false;
            for (RepNode rn : rg.getRepNodes()) {
                RepNodeId peerId = (RepNodeId)rn.getResourceId();
                if (peerId.equals(rnId)) continue;
                try {
                    RegistryUtils registry = new RegistryUtils(topo, plan.getLoginManager());
                    RepNodeAdminAPI rnAdmin = registry.getRepNodeAdmin(peerId);
                    if (rnAdmin.updateMemberHAAddress(rnId.getGroupName(), rnId.getFullName(), targetHelperHosts, targetNodeHostPort)) {
                        done = true;
                        continue;
                    }
                    logger.log(Level.INFO, "Attempting to update HA address for {0} while relocating from {1} to {2}  but shard has no master. Wait and retry", new Object[]{rnId, oldNode, newNode});
                    groupHasNoMaster = true;
                }
                catch (RepNodeAdminFaultException e) {
                    logger.log(Level.SEVERE, "{0} experienced an exception when attempting to update HA address for {1} while relocating from {2} to {3}: {4}", new Object[]{peerId, rnId, oldNode, newNode, e});
                }
                catch (NotBoundException e) {
                    logger.log(Level.SEVERE, "{0} could not be contacted, experienced an exception when attempting to update HA address for {1} while relocating from {2} to {3}: {4}", new Object[]{peerId, rnId, oldNode, newNode, e});
                }
                catch (RemoteException e) {
                    logger.log(Level.SEVERE, "{0} could not be contacted, experienced an exception when attempting to update HA address for {1} while relocating from {2} to {3}: {4}", new Object[]{peerId, rnId, oldNode, newNode, e});
                }
            }
            if (done) break;
            if (groupHasNoMaster) {
                logger.log(Level.INFO, "No master for shard while updating HA address for {0} from {1} to {2}. Wait and retry", new Object[]{rnId, oldNode, newNode});
                Thread.sleep(delay);
                continue;
            }
            logger.log(Level.INFO, "Could not contact any member of the shard while  updating HA address for {0} from {1} to {2}. Give up.", new Object[]{rnId, oldNode, newNode});
            break;
        }
        if (!done) {
            throw new OperationFaultException("Couldn't change HA address for " + rnId + " to " + targetNodeHostPort + " while migrating " + oldNode + " to " + newNode);
        }
    }

    static void stopRN(AbstractPlan plan, StorageNodeId snId, RepNodeId rnId) throws RemoteException, NotBoundException {
        plan.getLogger().log(Level.INFO, "Stopping {0} on {1}", new Object[]{rnId, snId});
        Admin admin = plan.getAdmin();
        RepNodeParams rnp = new RepNodeParams(admin.getRepNodeParams(rnId));
        rnp.setDisabled(true);
        admin.updateParams(rnp);
        Topology topology = admin.getCurrentTopology();
        RegistryUtils registryUtils = new RegistryUtils(topology, admin.getLoginManager());
        StorageNodeAgentAPI sna = registryUtils.getStorageNodeAgent(snId);
        sna.stopRepNode(rnId, false);
        admin.getMonitor().unregisterAgent(rnId);
        admin.getMonitor().collectNow(snId);
    }

    static void startRN(AbstractPlan plan, StorageNodeId snId, RepNodeId rnId) throws RemoteException, NotBoundException {
        plan.getLogger().log(Level.INFO, "Starting {0} on {1}", new Object[]{rnId, snId});
        Admin admin = plan.getAdmin();
        Topology topology = admin.getCurrentTopology();
        RepNode rn = topology.get(rnId);
        if (rn == null) {
            throw new IllegalCommandException(rnId + " was removed from the topology and can't be started");
        }
        RepNodeParams rnp = new RepNodeParams(admin.getRepNodeParams(rnId));
        rnp.setDisabled(false);
        admin.updateParams(rnp);
        AdminServiceParams asp = admin.getParams();
        StorageNodeParams snp = admin.getStorageNodeParams(snId);
        String storeName = asp.getGlobalParams().getKVStoreName();
        StorageNodeAgentAPI sna = RegistryUtils.getStorageNodeAgent(storeName, snp.getHostname(), snp.getRegistryPort(), snId, admin.getLoginManager());
        sna.startRepNode(rnId);
        RegistryUtils.checkForStartupProblem(storeName, snp.getHostname(), snp.getRegistryPort(), rnId, snId, admin.getLoginManager());
        StorageNode sn = topology.get(snId);
        plan.getAdmin().getMonitor().registerAgent(sn.getHostname(), sn.getRegistryPort(), rnId);
    }

    public static Task.State waitForRepNodeState(AbstractPlan plan, RepNodeId rnId, ConfigurableService.ServiceStatus targetState) throws InterruptedException {
        AdminServiceParams asp = plan.getAdmin().getParams();
        AdminParams ap = asp.getAdminParams();
        long waitSeconds = ap.getWaitTimeoutUnit().toSeconds(ap.getWaitTimeout());
        String msg = "Waiting " + waitSeconds + " seconds for RepNode " + rnId + " to reach " + (Object)((Object)targetState);
        plan.getLogger().fine(msg);
        RepNodeParams rnp = plan.getAdmin().getRepNodeParams(rnId);
        if (rnp == null) {
            throw new OperationFaultException(msg + ", but that that RepNode doesn't exist in the store");
        }
        StorageNodeParams snp = plan.getAdmin().getStorageNodeParams(rnp.getStorageNodeId());
        String storename = asp.getGlobalParams().getKVStoreName();
        String hostname = snp.getHostname();
        int regPort = snp.getRegistryPort();
        StorageNodeId snId = snp.getStorageNodeId();
        LoginManager loginMgr = plan.getLoginManager();
        try {
            ConfigurableService.ServiceStatus[] target = new ConfigurableService.ServiceStatus[]{targetState};
            ServiceUtils.waitForRepNodeAdmin(storename, hostname, regPort, rnId, snId, loginMgr, waitSeconds, target);
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                throw (InterruptedException)e;
            }
            plan.getLogger().info("Timed out while " + msg);
            RegistryUtils.checkForStartupProblem(storename, hostname, regPort, rnId, snId, loginMgr);
            return Task.State.ERROR;
        }
        plan.getAdmin().getMonitor().collectNow(rnId);
        return Task.State.SUCCEEDED;
    }

    static void confirmSNStatus(Topology topology, LoginManager loginMgr, StorageNodeId snId, boolean shouldBeRunning, String infoMsg) {
        block5: {
            RegistryUtils registry = new RegistryUtils(topology, loginMgr);
            try {
                StorageNodeAgentAPI sna = registry.getStorageNodeAgent(snId);
                ConfigurableService.ServiceStatus serviceStatus = sna.ping().getServiceStatus();
                if (shouldBeRunning ? serviceStatus == ConfigurableService.ServiceStatus.RUNNING : !serviceStatus.isAlive()) {
                    return;
                }
                throw new OperationFaultException(snId + " has status " + (Object)((Object)serviceStatus) + ". " + infoMsg);
            }
            catch (NotBoundException notbound) {
                if (shouldBeRunning) {
                    throw new OperationFaultException(snId + " cannot be contacted." + infoMsg);
                }
            }
            catch (RemoteException remoteEx) {
                if (!shouldBeRunning) break block5;
                throw new OperationFaultException(snId + " cannot be contacted." + infoMsg);
            }
        }
    }

    static boolean broadcastMetadataChangesToRNs(Logger logger, Metadata<?> md, Topology topo, String actionDescription, AdminParams params, AbstractPlan plan) {
        ArrayList retryList = new ArrayList(topo.getRepGroupMap().getAll());
        int nGroups = retryList.size();
        if (nGroups < 1) {
            logger.log(Level.INFO, "{0} attempting to broadcast {1} to an empty store for {2}", new Object[]{plan.toString(), md.getType(), actionDescription});
            return true;
        }
        logger.log(Level.INFO, "Broadcasting {0} for {1}", new Object[]{md, actionDescription});
        boolean masterOnly = !md.getType().equals((Object)Metadata.MetadataType.TOPOLOGY);
        int thresholdGroups = Math.max(nGroups * params.getBroadcastMetadataThreshold() / 100, 1);
        int acceptableFailures = nGroups - thresholdGroups;
        long delay = params.getBroadcastMetadataRetryDelayMillis();
        int attempts = 0;
        while (retryList.size() > acceptableFailures) {
            RegistryUtils registry = new RegistryUtils(topo, plan.getLoginManager());
            Iterator itr = retryList.iterator();
            while (itr.hasNext()) {
                boolean success = false;
                RepGroup rg = (RepGroup)itr.next();
                for (RepNode rn : rg.getRepNodes()) {
                    if (plan.isInterruptRequested()) {
                        logger.log(Level.INFO, "{0} has been interrupted, stop attempts to broadcast {1} metadata changes for {2}", new Object[]{plan.toString(), md.getType(), actionDescription});
                        return false;
                    }
                    int result = Utils.sendMetadataChangesToRN(logger, rn, md, actionDescription, registry, masterOnly);
                    if (result == STOP) {
                        return true;
                    }
                    if (result != SUCCEEDED) continue;
                    success = true;
                    if (!masterOnly) continue;
                    break;
                }
                if (!success) continue;
                itr.remove();
            }
            ++attempts;
            if (retryList.isEmpty()) {
                logger.log(Level.INFO, "Successful broadcast to all groups of {0} metadata seq# {1}, for {2}, attempts={3}", new Object[]{md.getType(), md.getSequenceNumber(), actionDescription, attempts});
                return true;
            }
            logger.log(Level.INFO, "Broadcast {0} metadata to {1} out of {2} groups, will retry, acceptable failure threshold={3}, attempts={4}", new Object[]{md.getType(), retryList.size(), nGroups, acceptableFailures, attempts});
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException ie) {
                logger.log(Level.INFO, "{0} has been interrupted, stop attempts to broadcast {1} metadata changes for {2}", new Object[]{plan.toString(), md.getType(), actionDescription});
                return false;
            }
        }
        logger.log(Level.INFO, "Broadcast {0} metadata {1} for {2} successful to {3} out of {4} groups", new Object[]{md.getType(), md.getSequenceNumber(), actionDescription, nGroups - retryList.size(), nGroups});
        return true;
    }

    private static int sendMetadataChangesToRN(Logger logger, RepNode rn, Metadata<?> md, String actionDescription, RegistryUtils registry, boolean masterOnly) {
        StorageNodeId snId = rn.getStorageNodeId();
        RepNodeId rnId = (RepNodeId)rn.getResourceId();
        try {
            RepNodeAdminAPI rnAdmin = registry.getRepNodeAdmin(rnId);
            if (masterOnly && !rnAdmin.ping().getReplicationState().isMaster()) {
                return FAILED;
            }
            int rnSeqNum = rnAdmin.getMetadataSeqNum(md.getType());
            if (rnSeqNum < md.getSequenceNumber()) {
                Object info = md.getChangeInfo(rnSeqNum);
                if (info.isEmpty()) {
                    logger.log(Level.INFO, "Unable to send {0} changes to {1} at {2}, sending full metadata", new Object[]{md.getType(), rnId, rnSeqNum});
                    rnAdmin.updateMetadata(md);
                    return SUCCEEDED;
                }
                rnSeqNum = rnAdmin.updateMetadata((MetadataInfo)info);
            }
            if (rnSeqNum == md.getSequenceNumber()) {
                return SUCCEEDED;
            }
            if (rnSeqNum > md.getSequenceNumber()) {
                logger.log(Level.FINE, "{0} has a higher {1} metadata sequence number of {2} compared to this metadata of {3} while {4}", new Object[]{rnId, md.getType(), rnSeqNum, md.getSequenceNumber(), actionDescription});
                return STOP;
            }
            logger.log(Level.INFO, "Update of {0} metadata to {1} on {2} failed. Expected metadata seq num: {3} actual: {4} while {5}", new Object[]{md.getType(), rnId, snId, md.getSequenceNumber(), rnSeqNum, actionDescription});
        }
        catch (RepNodeAdminFaultException rnfe) {
            logger.log(Level.INFO, "Unable to update {0} metadata for {1} on {2} for {3} during broadcast: {4}", new Object[]{md.getType(), rnId, snId, actionDescription, rnfe});
        }
        catch (NotBoundException notbound) {
            logger.log(Level.INFO, "{0} on {1} cannot be contacted for {2} metadata update to {3} during broadcast: {4}", new Object[]{rnId, snId, md.getType(), actionDescription, notbound});
        }
        catch (RemoteException e) {
            logger.log(Level.INFO, "Could not update {0} metadata for {1} on {2} for {3}: {4}", new Object[]{md.getType(), rnId, snId, actionDescription, e});
        }
        return FAILED;
    }

    public static void refreshParamsOnPeers(AbstractPlan plan, RepNodeId skipRNId) throws RemoteException, NotBoundException {
        Admin admin = plan.getAdmin();
        Topology topo = admin.getCurrentTopology();
        RepGroupId rgId = topo.get(skipRNId).getRepGroupId();
        RegistryUtils registry = new RegistryUtils(topo, plan.getLoginManager());
        plan.getLogger().log(Level.INFO, "Writing new RN params to members of shard {0}", rgId);
        RemoteException remoteExSeen = null;
        NotBoundException notBoundSeen = null;
        for (RepNode peer : topo.get(rgId).getRepNodes()) {
            RepNodeId peerId = (RepNodeId)peer.getResourceId();
            if (peerId.equals(skipRNId)) continue;
            RepNodeParams peerRNP = admin.getRepNodeParams(peerId);
            try {
                StorageNodeAgentAPI sna = registry.getStorageNodeAgent(peer.getStorageNodeId());
                sna.newRepNodeParameters(peerRNP.getMap());
                RepNodeAdminAPI rnAdmin = registry.getRepNodeAdmin(peerId);
                rnAdmin.newParameters();
            }
            catch (RemoteException e) {
                remoteExSeen = e;
                plan.getLogger().info("Couldn't refresh params on " + peerId + e);
            }
            catch (NotBoundException e) {
                notBoundSeen = e;
                plan.getLogger().info("Couldn't refresh params on " + peerId + e);
            }
        }
        if (remoteExSeen != null) {
            throw remoteExSeen;
        }
        if (notBoundSeen != null) {
            throw notBoundSeen;
        }
    }

    public static void setRNPHeapCacheGC(ParameterMap policyMap, StorageNodeParams targetSNP, RepNodeParams targetRNP, Topology topo) {
        StorageNodeId targetSN = targetSNP.getStorageNodeId();
        RepNodeId targetRN = targetRNP.getRepNodeId();
        Set<RepNodeId> rnsOnSN = topo.getHostedRepNodeIds(targetSN);
        int numRNsOnSN = rnsOnSN.size();
        if (!rnsOnSN.contains(targetRN)) {
            ++numRNsOnSN;
        }
        StorageNodeParams.RNHeapAndCacheSize heapAndCache = targetSNP.calculateRNHeapAndCache(policyMap, numRNsOnSN, targetRNP.getRNCachePercent());
        targetRNP.setRNHeapAndJECache(heapAndCache);
        targetRNP.setParallelGCThreads(targetSNP.calcGCThreads());
    }

    static void verifyShardHealth(Parameters params, Topology topo, RepNodeId rnId, StorageNodeId oldSN, StorageNodeId newSN, Logger logger) {
        RepNodeId master = null;
        int numTries = 0;
        HashSet<RepNodeId> running = new HashSet<RepNodeId>();
        RepGroupId rgId = new RepGroupId(rnId.getGroupId());
        while (numTries < 3) {
            ++numTries;
            Map<RepNodeId, RepNodeStatus> status = Ping.getRepNodeStatus(topo, rgId);
            int electableGroupSize = 0;
            running.clear();
            boolean groupSizeOverrideUsed = false;
            for (Map.Entry<RepNodeId, RepNodeStatus> nodeStatus : status.entrySet()) {
                RepNodeId thisRN = nodeStatus.getKey();
                Datacenter thisDC = topo.getDatacenter(thisRN);
                if (thisDC.getDatacenterType().isSecondary()) continue;
                ++electableGroupSize;
                if (params.get(thisRN).getConfigProperties().contains("je.rep.electableGroupSizeOverride")) {
                    groupSizeOverrideUsed = true;
                }
                if (nodeStatus.getValue() == null) continue;
                if (nodeStatus.getValue().getReplicationState().isMaster()) {
                    master = thisRN;
                }
                if (thisRN.equals(rnId) || !nodeStatus.getValue().getServiceStatus().equals((Object)ConfigurableService.ServiceStatus.RUNNING)) continue;
                running.add(thisRN);
            }
            int quorum = electableGroupSize / 2 + 1;
            if (running.size() < quorum && !groupSizeOverrideUsed) {
                throw new OperationFaultException("Shard " + rgId + " will not have at least " + quorum + " electable nodes up to execute writes, so can't move " + rnId + " from " + oldSN + " to " + newSN + ". Other running nodes are " + running);
            }
            if (master != null) {
                return;
            }
            try {
                logger.info("Waiting for " + rgId + " to establish a master. Running nodes are " + running);
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {}
        }
        throw new OperationFaultException("Shard " + rgId + " can't execute writes. No master exists." + "Running nodes are " + running);
    }

    public static boolean storeHasVersion(Admin admin, KVVersion targetVersion) {
        KVVersion storeVersion;
        try {
            storeVersion = admin.getStoreVersion();
        }
        catch (AdminFaultException e) {
            throw new IllegalCommandException(String.format("Unable to confirm that all nodes in the store have the required version of %s or later", targetVersion.getNumericVersionString()), e);
        }
        return VersionUtil.compareMinorVersion(storeVersion, targetVersion) >= 0;
    }

    public static AdminType getAdminType(DatacenterType dcType) {
        switch (dcType) {
            case PRIMARY: {
                return AdminType.PRIMARY;
            }
            case SECONDARY: {
                return AdminType.SECONDARY;
            }
        }
        throw new IllegalStateException("Unknown datacenter type: " + (Object)((Object)dcType));
    }
}

