/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan.task;

import java.util.Set;
import oracle.kv.impl.admin.IllegalCommandException;
import oracle.kv.impl.admin.plan.SecurityMetadataPlan;
import oracle.kv.impl.admin.plan.task.Task;
import oracle.kv.impl.admin.plan.task.UpdateMetadata;
import oracle.kv.impl.security.RoleInstance;
import oracle.kv.impl.security.metadata.SecurityMetadata;

public class RevokeRolesFromRole
extends UpdateMetadata<SecurityMetadata> {
    private static final long serialVersionUID = 1L;
    private final String revokee;
    private final Set<String> roles;

    public RevokeRolesFromRole(SecurityMetadataPlan plan, String revokee, Set<String> roles) {
        super(plan);
        SecurityMetadata secMd = (SecurityMetadata)plan.getMetadata();
        this.revokee = revokee;
        this.roles = roles;
        if (secMd == null || secMd.getRole(revokee) == null) {
            throw new IllegalCommandException("Role with name " + revokee + " does not exist in store");
        }
    }

    @Override
    protected SecurityMetadata updateMetadata() {
        SecurityMetadata secMd = (SecurityMetadata)this.plan.getMetadata();
        if (secMd == null || secMd.getRole(this.revokee) == null) {
            return null;
        }
        RoleInstance newCopy = secMd.getRole(this.revokee).clone();
        secMd.updateRole(newCopy.getElementId(), newCopy.revokeRoles(this.roles));
        this.plan.getAdmin().saveMetadata(secMd, this.plan);
        return secMd;
    }

    @Override
    public boolean logicalCompare(Task t) {
        if (this == t) {
            return true;
        }
        if (t == null) {
            return false;
        }
        if (this.getClass() != t.getClass()) {
            return false;
        }
        RevokeRolesFromRole other = (RevokeRolesFromRole)t;
        if (!this.revokee.equalsIgnoreCase(other.revokee)) {
            return false;
        }
        return this.roles.equals(other.roles);
    }
}

