/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan.task;

import com.sleepycat.persist.model.Persistent;
import oracle.kv.impl.admin.IllegalCommandException;
import oracle.kv.impl.admin.plan.SecurityMetadataPlan;
import oracle.kv.impl.admin.plan.task.Task;
import oracle.kv.impl.admin.plan.task.UpdateMetadata;
import oracle.kv.impl.security.metadata.SecurityMetadata;

@Persistent
public class RemoveUser
extends UpdateMetadata<SecurityMetadata> {
    private static final long serialVersionUID = 1L;
    private String userName;

    public RemoveUser(SecurityMetadataPlan plan, String userName) {
        super(plan);
        SecurityMetadata secMd = (SecurityMetadata)plan.getMetadata();
        this.userName = userName;
        this.guardLastSysadminUser(secMd);
    }

    private RemoveUser() {
    }

    private void guardLastSysadminUser(SecurityMetadata secMd) {
        if (secMd == null) {
            return;
        }
        if (secMd.isLastSysadminUser(this.userName)) {
            throw new IllegalCommandException("Cannot drop the last enabled admin user " + this.userName);
        }
    }

    @Override
    protected SecurityMetadata updateMetadata() {
        SecurityMetadata secMd = (SecurityMetadata)this.plan.getMetadata();
        if (secMd != null && secMd.getUser(this.userName) != null) {
            this.guardLastSysadminUser(secMd);
            secMd.removeUser(secMd.getUser(this.userName).getElementId());
            this.plan.getAdmin().saveMetadata(secMd, this.plan);
        }
        return secMd;
    }

    @Override
    public boolean logicalCompare(Task t) {
        if (this == t) {
            return true;
        }
        if (t == null) {
            return false;
        }
        if (this.getClass() != t.getClass()) {
            return false;
        }
        RemoveUser other = (RemoveUser)t;
        return this.userName.equals(other.userName);
    }
}

