/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan.task;

import com.sleepycat.je.rep.MemberNotFoundException;
import com.sleepycat.persist.model.Persistent;
import oracle.kv.impl.admin.Admin;
import oracle.kv.impl.admin.plan.AbstractPlan;
import oracle.kv.impl.admin.plan.task.SingleJobTask;
import oracle.kv.impl.admin.plan.task.Task;
import oracle.kv.impl.topo.AdminId;

@Persistent(version=0)
public class RemoveAdminRefs
extends SingleJobTask {
    private static final long serialVersionUID = 1L;
    private AbstractPlan plan;
    private AdminId victim;

    public RemoveAdminRefs() {
    }

    public RemoveAdminRefs(AbstractPlan plan, AdminId victim) {
        this.plan = plan;
        this.victim = victim;
    }

    @Override
    public Task.State doWork() throws Exception {
        Admin admin = this.plan.getAdmin();
        try {
            admin.removeAdminFromRepGroup(this.victim);
        }
        catch (MemberNotFoundException mnfe) {
            this.plan.getLogger().info("The admin " + this.victim + " was not found in the repgroup.");
        }
        try {
            admin.removeAdminParams(this.victim);
        }
        catch (MemberNotFoundException mnfe) {
            this.plan.getLogger().info("The admin " + this.victim + " was not found.");
        }
        return Task.State.SUCCEEDED;
    }

    @Override
    public boolean continuePastError() {
        return false;
    }

    @Override
    public String toString() {
        return super.toString() + " Remove references to Admin " + this.victim;
    }
}

