/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan.task;

import com.sleepycat.persist.model.Persistent;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.logging.Logger;
import oracle.kv.impl.admin.Admin;
import oracle.kv.impl.admin.CommandServiceAPI;
import oracle.kv.impl.admin.param.AdminParams;
import oracle.kv.impl.admin.param.Parameters;
import oracle.kv.impl.admin.param.StorageNodeParams;
import oracle.kv.impl.admin.plan.SecurityMetadataPlan;
import oracle.kv.impl.admin.plan.task.SingleJobTask;
import oracle.kv.impl.admin.plan.task.Task;
import oracle.kv.impl.security.metadata.SecurityMetadata;
import oracle.kv.impl.topo.AdminId;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.util.ConfigurableService;
import oracle.kv.impl.util.ServiceUtils;

@Persistent
public class NewSecurityMDChange
extends SingleJobTask {
    private static final long serialVersionUID = 1L;
    private AdminId adminId;
    private SecurityMetadataPlan plan;

    NewSecurityMDChange() {
    }

    public NewSecurityMDChange(SecurityMetadataPlan plan, AdminId adminId) {
        this.plan = plan;
        this.adminId = adminId;
    }

    @Override
    public Task.State doWork() throws Exception {
        Admin admin = this.plan.getAdmin();
        Logger logger = this.plan.getLogger();
        Parameters parameters = admin.getCurrentParameters();
        int latestSequenceNum = ((SecurityMetadata)this.plan.getMetadata()).getSequenceNumber();
        logger.fine("Notify target " + this.adminId + "security metadata change whose seq number is " + latestSequenceNum);
        try {
            AdminParams current = parameters.get(this.adminId);
            StorageNodeId snid = current.getStorageNodeId();
            StorageNodeParams snp = parameters.get(snid);
            CommandServiceAPI cs = ServiceUtils.waitForAdmin(snp.getHostname(), snp.getRegistryPort(), this.plan.getLoginManager(), 40L, ConfigurableService.ServiceStatus.RUNNING);
            cs.newSecurityMDChange();
        }
        catch (NotBoundException notbound) {
            logger.info(this.adminId + " cannot be contacted when " + "notifying about security metadata change: " + notbound);
            throw notbound;
        }
        catch (RemoteException e) {
            logger.severe("Attempting to notify " + this.adminId + " about " + "security metadata change: " + e);
            throw e;
        }
        return Task.State.SUCCEEDED;
    }

    @Override
    public String toString() {
        return super.toString() + " cause " + this.adminId + " to apply the latest security metadata change";
    }

    @Override
    public boolean continuePastError() {
        return false;
    }

    @Override
    public boolean logicalCompare(Task t) {
        if (this == t) {
            return true;
        }
        if (t == null) {
            return false;
        }
        if (this.getClass() != t.getClass()) {
            return false;
        }
        NewSecurityMDChange other = (NewSecurityMDChange)t;
        return this.adminId.equals(other.adminId);
    }
}

