/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan;

import com.sleepycat.persist.model.Persistent;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.impl.admin.plan.ExecutionState;
import oracle.kv.impl.admin.plan.task.Task;
import oracle.kv.impl.util.FormatUtils;
import oracle.kv.impl.util.server.LoggerUtils;

@Persistent(version=1)
public class TaskRun
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String taskName;
    private long startTime;
    private long endTime;
    private Task.State state;
    private int taskNum;
    private transient ExecutionState.ExceptionTransfer transfer;
    private long cleanupStartTime;
    private long cleanupEndTime;
    private String cleanupFailure;
    private Task task;
    private Map<String, String> details;

    TaskRun(Task task, Logger logger, int taskNum) {
        this.task = task;
        this.taskName = task.getName();
        this.setState(Task.State.RUNNING, logger);
        this.startTime = System.currentTimeMillis();
        this.taskNum = taskNum;
        this.details = new HashMap<String, String>();
    }

    public TaskRun() {
    }

    void setState(Task.State newState, Logger logger) {
        if (this.state == null) {
            logger.log(Level.FINE, "TaskRun {0} starting in {1}", new Object[]{this.taskName, newState});
        } else {
            logger.log(Level.FINE, "TaskRun {0} transitioning from {1} to {2}", new Object[]{this.taskName, this.state, newState});
            if (this.state == Task.State.ERROR && newState != Task.State.ERROR) {
                throw new IllegalStateException("Illegal transition from " + (Object)((Object)this.state) + " to " + (Object)((Object)newState) + " for " + this.taskName);
            }
        }
        this.state = newState;
        this.endTime = System.currentTimeMillis();
    }

    void saveFailure(Throwable t, String problem, Logger logger) {
        this.transfer = new ExecutionState.ExceptionTransfer(t, problem);
        if (t == null) {
            logger.log(Level.SEVERE, "Task {0}/{1} ended in state {2} with {3}", new Object[]{this.taskNum, this.taskName, this.state, problem});
        } else {
            logger.log(Level.SEVERE, "Task {0}/{1} ended in state {2} with {3} {4}\n{5}", new Object[]{this.taskNum, this.taskName, this.state, t, problem, LoggerUtils.getStackTrace(t)});
        }
    }

    ExecutionState.ExceptionTransfer getTransfer() {
        return this.transfer;
    }

    String getFailureDescription() {
        ExecutionState.ExceptionTransfer et = this.getTransfer();
        if (et == null) {
            return null;
        }
        return et.getDescription() + ": " + et.getStackTrace();
    }

    public String toString() {
        String ret = this.taskName + " [" + (Object)((Object)this.state) + "]";
        String failure = this.getFailureDescription();
        if (failure != null) {
            ret = ret + " " + failure;
        }
        if (this.cleanupStartTime != 0L) {
            ret = ret + " cleanup started at " + FormatUtils.formatDateAndTime(this.cleanupStartTime);
        }
        if (this.cleanupEndTime != 0L) {
            ret = ret + " cleanup ended at " + FormatUtils.formatDateAndTime(this.cleanupEndTime);
        }
        if (this.cleanupFailure != null) {
            ret = ret + "cleanup failure:" + this.cleanupFailure;
        }
        return ret;
    }

    String getTaskName() {
        return this.taskName;
    }

    Task.State getState() {
        return this.state;
    }

    int getTaskNum() {
        return this.taskNum;
    }

    void cleanupStarted() {
        this.cleanupStartTime = System.currentTimeMillis();
    }

    void cleanupEnded() {
        this.cleanupEndTime = System.currentTimeMillis();
    }

    void saveCleanupFailure(String failureInfo) {
        this.cleanupFailure = failureInfo;
    }

    long getStartTime() {
        return this.startTime;
    }

    Task getTask() {
        return this.task;
    }

    Map<String, String> getDetails() {
        return this.details;
    }

    long getEndTime() {
        return this.endTime;
    }

    void upgradeToV3(int tnum, Task t) {
        this.taskNum = tnum;
        this.task = t;
    }

    public String displayTaskDetails(String displayPrefix) {
        return this.task.displayExecutionDetails(this.details, displayPrefix);
    }
}

