/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.kv.impl.admin.IllegalCommandException;
import oracle.kv.impl.admin.param.AdminParams;
import oracle.kv.impl.admin.param.Parameters;
import oracle.kv.impl.admin.param.RepNodeParams;
import oracle.kv.impl.admin.param.StorageNodeParams;
import oracle.kv.impl.topo.AdminId;
import oracle.kv.impl.topo.RepGroup;
import oracle.kv.impl.topo.RepNode;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.PortRange;

public class PortTracker {
    private final Map<StorageNodeId, List<HAPort>> freePorts;
    private final Parameters parameters;

    public PortTracker(Topology topology, Parameters parameters, List<StorageNodeId> targetSNs) {
        this.parameters = parameters;
        this.freePorts = new HashMap<StorageNodeId, List<HAPort>>();
        for (StorageNodeId snId : targetSNs) {
            StorageNodeParams snp = parameters.get(snId);
            ArrayList<HAPort> configured = new ArrayList<HAPort>();
            List<Integer> r = PortRange.getRange(snp.getHAPortRange());
            int firstPort = r.get(0);
            int lastPort = r.get(1);
            for (int i = firstPort; i <= lastPort; ++i) {
                configured.add(new HAPort(i));
            }
            this.freePorts.put(snId, configured);
        }
        for (RepGroup rg : topology.getRepGroupMap().getAll()) {
            for (RepNode rn : rg.getRepNodes()) {
                RepNodeParams rnp = parameters.get((RepNodeId)rn.getResourceId());
                if (rnp == null) continue;
                int inUsePort = rnp.getHAPort();
                StorageNodeId rnSN = rn.getStorageNodeId();
                if (!targetSNs.contains(rnSN)) continue;
                StorageNodeParams snp = parameters.get(rnSN);
                boolean removed = this.freePorts.get(rnSN).remove(new HAPort(inUsePort));
                assert (removed) : "Port " + inUsePort + " was used in repNode " + rn + " but was not in " + " available port list(" + snp.getHAPortRange() + ") for" + rnSN;
            }
        }
        for (AdminId aid : parameters.getAdminIds()) {
            AdminParams ap = parameters.get(aid);
            if (ap.getNodeHostPort() == null) continue;
            int inUsePort = Integer.parseInt(ap.getNodeHostPort().split(":")[1]);
            StorageNodeId apSN = ap.getStorageNodeId();
            if (!targetSNs.contains(apSN)) continue;
            StorageNodeParams snp = parameters.get(apSN);
            boolean removed = this.freePorts.get(apSN).remove(new HAPort(inUsePort));
            assert (removed) : "Port " + inUsePort + " was used in Admin " + aid + " but was not in " + " available port list(" + snp.getHAPortRange() + ") for" + apSN;
        }
    }

    public PortTracker(Topology topology, Parameters parameters, StorageNodeId target) {
        this(topology, parameters, Collections.singletonList(target));
    }

    public int getNextPort(StorageNodeId targetSNId) {
        List<HAPort> available = this.freePorts.get(targetSNId);
        if (available.size() == 0) {
            StorageNodeParams snp = this.parameters.get(targetSNId);
            throw new IllegalCommandException("Storage node " + targetSNId + " with HAPortRange of " + snp.getHAPortRange() + " does not have any available" + " HA ports left.");
        }
        int nextPort = available.get((int)0).value;
        available.remove(0);
        return nextPort;
    }

    private class HAPort {
        final int value;

        HAPort(int value) {
            this.value = value;
        }

        public int hashCode() {
            int prime = 31;
            return 31 * this.value;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof HAPort)) {
                return false;
            }
            HAPort other = (HAPort)obj;
            return this.value == other.value;
        }
    }
}

