/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan;

import com.sleepycat.bind.EntityBinding;
import com.sleepycat.bind.tuple.IntegerBinding;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import com.sleepycat.persist.EntityStore;
import com.sleepycat.persist.PrimaryIndex;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.impl.admin.Admin;
import oracle.kv.impl.admin.AdminPlanDatabase;
import oracle.kv.impl.admin.NonfatalAssertionException;
import oracle.kv.impl.admin.plan.AbstractPlan;
import oracle.kv.impl.fault.DatabaseNotReadyException;
import oracle.kv.impl.util.SerializationUtil;
import oracle.kv.impl.util.TxnUtil;

public abstract class PlanStore {
    final Admin admin;
    final Logger logger;
    static final CursorConfig CURSOR_READ_COMMITTED = new CursorConfig().setNonSticky(true).setReadCommitted(true);

    public static PlanStore getStoreByVersion(Admin admin, int schemaVersion) {
        if (schemaVersion >= 4) {
            return new PlanDatabaseStore(admin);
        }
        return new DPLPlanStore(admin);
    }

    private PlanStore(Admin admin, Logger logger) {
        this.admin = admin;
        this.logger = logger;
    }

    void logPersisting(AbstractPlan plan) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, this.getName() + ": stored plan of {0}", plan);
        }
    }

    void logFetching(int planId) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, this.getName() + ": fetching plan using id {0}", planId);
        }
    }

    public abstract void persist(Transaction var1, AbstractPlan var2);

    public abstract AbstractPlan fetch(Transaction var1, int var2);

    public abstract PlanCursor getPlanCursor(Transaction var1, Integer var2);

    public abstract String getName();

    public static abstract class PlanCursor {
        private final Cursor cursor;
        private final LockMode lockMode;
        private final Integer startKey;
        final DatabaseEntry key = new DatabaseEntry();
        final DatabaseEntry data = new DatabaseEntry();

        public PlanCursor(Cursor cursor, LockMode lockMode, Integer startKey) {
            this.cursor = cursor;
            this.lockMode = lockMode;
            this.startKey = startKey;
        }

        public AbstractPlan next() {
            OperationStatus status = this.cursor.getNext(this.key, this.data, this.lockMode);
            if (status == OperationStatus.SUCCESS) {
                return this.entryToPlan(this.data);
            }
            return null;
        }

        public AbstractPlan prev() {
            OperationStatus status = this.cursor.getPrev(this.key, this.data, this.lockMode);
            if (status == OperationStatus.SUCCESS) {
                return this.entryToPlan(this.data);
            }
            return null;
        }

        public AbstractPlan first() {
            if (this.startKey != null) {
                IntegerBinding.intToEntry((int)this.startKey, (DatabaseEntry)this.key);
                OperationStatus status = this.cursor.getSearchKeyRange(this.key, this.data, this.lockMode);
                if (status == OperationStatus.SUCCESS) {
                    return this.entryToPlan(this.data);
                }
                return null;
            }
            if (this.cursor.getFirst(this.key, this.data, this.lockMode) == OperationStatus.SUCCESS) {
                return this.entryToPlan(this.data);
            }
            return null;
        }

        public AbstractPlan last() {
            if (this.cursor.getLast(this.key, this.data, this.lockMode) == OperationStatus.SUCCESS) {
                return this.entryToPlan(this.data);
            }
            return null;
        }

        public void close() {
            TxnUtil.close(this.cursor);
        }

        abstract AbstractPlan entryToPlan(DatabaseEntry var1);
    }

    private static class PlanDatabaseStore
    extends PlanStore {
        public PlanDatabaseStore(Admin admin) {
            super(admin, admin.getLogger());
            admin.initAdminPlanDb();
        }

        @Override
        public void persist(Transaction txn, AbstractPlan plan) {
            AdminPlanDatabase planDb = this.admin.getAdminPlanDb();
            this.checkPlanDbValid(planDb);
            planDb.persistEntity(txn, plan);
            this.logPersisting(plan);
        }

        @Override
        public AbstractPlan fetch(Transaction txn, int planId) {
            AdminPlanDatabase planDb = this.admin.getAdminPlanDb();
            this.checkPlanDbValid(planDb);
            this.logFetching(planId);
            return (AbstractPlan)planDb.fetchEntity(txn, planId, LockMode.READ_COMMITTED);
        }

        @Override
        public PlanCursor getPlanCursor(Transaction txn, Integer startPlanId) {
            AdminPlanDatabase planDb = this.admin.getAdminPlanDb();
            this.checkPlanDbValid(planDb);
            Cursor cursor = planDb.openEntityDb().openCursor(txn, CURSOR_READ_COMMITTED);
            return new PlanCursor(cursor, LockMode.DEFAULT, startPlanId){

                @Override
                AbstractPlan entryToPlan(DatabaseEntry value) {
                    return SerializationUtil.getObject(value.getData(), AbstractPlan.class);
                }
            };
        }

        @Override
        public String getName() {
            return "PlanDatabaseStore";
        }

        private void checkPlanDbValid(AdminPlanDatabase planDb) {
            if (planDb == null || planDb.isClosing()) {
                if (this.admin.isClosing()) {
                    throw new NonfatalAssertionException("Admin plan database is closed in shutting down");
                }
                throw new DatabaseNotReadyException("Admin plan database is not ready");
            }
        }
    }

    private static class DPLPlanStore
    extends PlanStore {
        private DPLPlanStore(Admin admin) {
            super(admin, admin.getLogger());
        }

        @Override
        public void persist(Transaction txn, AbstractPlan plan) {
            EntityStore eStore = this.admin.getEStore();
            this.checkStoreValid(eStore);
            PrimaryIndex pi = eStore.getPrimaryIndex(Integer.class, AbstractPlan.class);
            pi.put(txn, (Object)plan);
            this.logPersisting(plan);
        }

        @Override
        public AbstractPlan fetch(Transaction txn, int planId) {
            EntityStore eStore = this.admin.getEStore();
            this.checkStoreValid(eStore);
            this.logFetching(planId);
            PrimaryIndex pi = eStore.getPrimaryIndex(Integer.class, AbstractPlan.class);
            return (AbstractPlan)pi.get(txn, (Object)new Integer(planId), LockMode.READ_COMMITTED);
        }

        @Override
        public PlanCursor getPlanCursor(Transaction txn, Integer startPlanId) {
            final EntityStore eStore = this.admin.getEStore();
            this.checkStoreValid(eStore);
            PrimaryIndex pi = eStore.getPrimaryIndex(Integer.class, AbstractPlan.class);
            Cursor cursor = pi.getDatabase().openCursor(txn, CURSOR_READ_COMMITTED);
            return new PlanCursor(cursor, LockMode.DEFAULT, startPlanId){
                private final EntityBinding<AbstractPlan> planBinding;
                {
                    super(x0, x1, x2);
                    this.planBinding = eStore.getPrimaryIndex(Integer.class, AbstractPlan.class).getEntityBinding();
                }

                @Override
                AbstractPlan entryToPlan(DatabaseEntry value) {
                    return (AbstractPlan)this.planBinding.entryToObject(this.key, this.data);
                }
            };
        }

        @Override
        public String getName() {
            return "DPLPlanStore";
        }

        private void checkStoreValid(EntityStore estore) {
            if (estore == null) {
                if (this.admin.isClosing()) {
                    throw new NonfatalAssertionException("Admin entity store is closed in shutting down");
                }
                throw new DatabaseNotReadyException("Admin entity store is not ready");
            }
        }
    }
}

