/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan;

import com.sleepycat.persist.model.Persistent;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import oracle.kv.impl.admin.plan.ChangeParamsPlan;
import oracle.kv.impl.admin.plan.Planner;
import oracle.kv.impl.param.ParameterMap;
import oracle.kv.impl.param.ParameterState;
import oracle.kv.impl.rep.RepNodeStatus;
import oracle.kv.impl.rep.admin.RepNodeAdminAPI;
import oracle.kv.impl.topo.DatacenterId;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.registry.RegistryUtils;

@Persistent
public class ChangeAllParamsPlan
extends ChangeParamsPlan {
    private static final long serialVersionUID = 1L;

    public ChangeAllParamsPlan(AtomicInteger idGenerator, String name, Planner planner, Topology topology, DatacenterId dcid, ParameterMap map) {
        super(idGenerator, name, planner, topology, topology.getRepNodeIds(dcid), map.filter(ParameterState.Scope.STORE));
    }

    @Override
    protected List<RepNodeId> sort(Set<RepNodeId> ids, Topology topology) {
        int replicaIndex = 0;
        int masterIndex = ids.size() - 1;
        RegistryUtils ru = new RegistryUtils(topology, this.getLoginManager());
        RepNodeId[] list = new RepNodeId[ids.size()];
        for (RepNodeId id : ids) {
            if (this.isReplica(id, ru)) {
                list[replicaIndex++] = id;
                continue;
            }
            list[masterIndex--] = id;
        }
        return Arrays.asList(list);
    }

    @Override
    protected void validateParams(ParameterMap map) {
    }

    private boolean isReplica(RepNodeId id, RegistryUtils ru) {
        Exception e = null;
        try {
            RepNodeAdminAPI rna = ru.getRepNodeAdmin(id);
            RepNodeStatus status = rna.ping();
            return status.getReplicationState().isReplica();
        }
        catch (RemoteException re) {
            e = re;
        }
        catch (NotBoundException nbe) {
            e = nbe;
        }
        this.planner.getLogger().warning("Could not reach node " + id + " in ChangeAllParamsPlan: " + e);
        return false;
    }

    protected ChangeAllParamsPlan() {
    }
}

