/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.client;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TimeZone;
import java.util.TreeMap;
import oracle.kv.KVVersion;
import oracle.kv.impl.admin.CommandServiceAPI;
import oracle.kv.impl.admin.Snapshot;
import oracle.kv.impl.admin.client.CommandShell;
import oracle.kv.impl.admin.client.CommandUtils;
import oracle.kv.impl.admin.client.PlanCommand;
import oracle.kv.impl.admin.criticalevent.CriticalEvent;
import oracle.kv.impl.admin.param.AdminParams;
import oracle.kv.impl.admin.param.Parameters;
import oracle.kv.impl.admin.param.RepNodeParams;
import oracle.kv.impl.admin.param.StorageNodeParams;
import oracle.kv.impl.admin.plan.Plan;
import oracle.kv.impl.api.avro.AvroDdl;
import oracle.kv.impl.api.avro.AvroSchemaMetadata;
import oracle.kv.impl.api.avro.AvroSchemaStatus;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.impl.api.table.TableMetadata;
import oracle.kv.impl.metadata.Metadata;
import oracle.kv.impl.monitor.views.PerfEvent;
import oracle.kv.impl.monitor.views.ServiceChange;
import oracle.kv.impl.param.LoadParameters;
import oracle.kv.impl.param.ParameterMap;
import oracle.kv.impl.param.ParameterState;
import oracle.kv.impl.security.metadata.KVStoreUser;
import oracle.kv.impl.sna.StorageNodeAgentAPI;
import oracle.kv.impl.sna.StorageNodeStatus;
import oracle.kv.impl.topo.AdminId;
import oracle.kv.impl.topo.Datacenter;
import oracle.kv.impl.topo.DatacenterId;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.topo.StorageNode;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.FormatUtils;
import oracle.kv.impl.util.TopologyPrinter;
import oracle.kv.impl.util.registry.RegistryUtils;
import oracle.kv.table.Index;
import oracle.kv.table.Table;
import oracle.kv.util.shell.CommandWithSubs;
import oracle.kv.util.shell.Shell;
import oracle.kv.util.shell.ShellArgumentException;
import oracle.kv.util.shell.ShellCommand;
import oracle.kv.util.shell.ShellException;
import oracle.kv.util.shell.ShellUsageException;

class ShowCommand
extends CommandWithSubs {
    private static final List<? extends CommandWithSubs.SubCommand> subs = Arrays.asList(new ShowParameters(), new ShowAdmins(), new ShowEvents(), new ShowFaults(), new ShowIndexes(), new ShowPerf(), new ShowPlans(), new ShowPools(), new ShowSchemas(), new ShowSnapshots(), new ShowTables(), new ShowTopology(), new ShowDatacenters(), new ShowUpgradeOrder(), new ShowUsers(), new ShowZones(), new ShowVersions());
    private static String[] dateFormats = new String[]{"yyyy-MM-dd HH:mm:ss.SSS", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm", "yyyy-MM-dd", "MM-dd-yyyy HH:mm:ss.SSS", "MM-dd-yyyy HH:mm:ss", "MM-dd-yyyy HH:mm", "MM-dd-yyyy", "HH:mm:ss.SSS", "HH:mm:ss", "HH:mm"};

    ShowCommand() {
        super(subs, "show", 2, 2);
    }

    @Override
    protected String getCommandOverview() {
        return "Encapsulates commands that display the state of the store and its components.";
    }

    private static String getDateFormatsUsage() {
        String usage = "<date> can be given in the following formats," + eolt + "which are interpreted in the UTC time zone." + eolt;
        for (String fs : dateFormats) {
            usage = usage + eolt + "    " + fs;
        }
        return usage;
    }

    private static Date parseTimestamp(String s, ShellCommand command) throws ShellUsageException {
        TimeZone tz = TimeZone.getTimeZone("UTC");
        Date r = null;
        for (String fs : dateFormats) {
            SimpleDateFormat f = new SimpleDateFormat(fs);
            f.setTimeZone(tz);
            f.setLenient(false);
            try {
                r = f.parse(s);
                break;
            }
            catch (ParseException pe) {
            }
        }
        if (r == null) {
            throw new ShellUsageException("Invalid date format: " + s, command);
        }
        Calendar rcal = Calendar.getInstance(tz);
        rcal.setTime(r);
        if (rcal.get(1) == 1970) {
            Calendar nowCal = Calendar.getInstance();
            nowCal.setTime(new Date());
            rcal.set(nowCal.get(1), nowCal.get(2), nowCal.get(5));
            if (rcal.after(nowCal)) {
                rcal.add(5, -1);
            }
            r = rcal.getTime();
        }
        return r;
    }

    private static final class ShowVersions
    extends CommandWithSubs.SubCommand {
        private ShowVersions() {
            super("versions", 3);
        }

        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            StringBuilder sb = new StringBuilder();
            sb.append("Client version: ");
            sb.append(KVVersion.CURRENT_VERSION.getNumericVersionString());
            sb.append(eol);
            CommandShell cmd = (CommandShell)shell;
            StorageNodeStatus status = null;
            String exceptionMessage = "";
            try {
                CommandServiceAPI cs = cmd.getAdmin();
                LoadParameters adminConfig = cs.getParams();
                int snId = adminConfig.getMap("storageNodeParams").getOrZeroInt("storageNodeId");
                String storeName = adminConfig.getMap("globalParams").get("storeName").asString();
                StorageNodeAgentAPI sna = RegistryUtils.getStorageNodeAgent(storeName, cmd.getAdminHostname(), cmd.getAdminPort(), new StorageNodeId(snId), null);
                status = sna.ping();
            }
            catch (RemoteException re) {
                exceptionMessage = re.toString();
            }
            catch (NotBoundException e) {
                exceptionMessage = e.toString();
            }
            if (status == null) {
                sb.append("Cannot reach server at host ");
                sb.append(cmd.getAdminHostname());
                sb.append(": " + eol);
                sb.append(exceptionMessage);
            } else {
                sb.append("Server version: ");
                sb.append(status.getKVVersion().getNumericVersionString());
            }
            return sb.toString();
        }

        @Override
        protected String getCommandSyntax() {
            return "show versions";
        }

        @Override
        protected String getCommandDescription() {
            return "Display client and conneted server version information. " + eolt + "If you want to get all servers version, please use " + "ping instead.";
        }
    }

    private static final class ShowUsers
    extends CommandWithSubs.SubCommand {
        static final String NAME_FLAG = "-name";
        static final String DESC_STR = "user";

        private ShowUsers() {
            super("users", 4);
        }

        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            String nameFlag = null;
            Shell.checkHelp(args, this);
            if (args.length > 1) {
                for (int i = 1; i < args.length; ++i) {
                    if (NAME_FLAG.equals(args[i])) {
                        if ((nameFlag = Shell.nextArg(args, i++, this)) != null && !nameFlag.isEmpty()) continue;
                        throw new ShellUsageException("User name could not be empty.", this);
                    }
                    shell.unknownArgument(args[i], this);
                }
            }
            CommandShell cmd = (CommandShell)shell;
            CommandServiceAPI cs = cmd.getAdmin();
            try {
                ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                PrintStream out = new PrintStream(outStream);
                Map<String, KVStoreUser.UserDescription> userDescMap = cs.getUsersDescription();
                if (userDescMap == null || userDescMap.isEmpty()) {
                    return "No users.";
                }
                if (nameFlag != null) {
                    KVStoreUser.UserDescription desc = userDescMap.get(nameFlag);
                    return desc == null ? "User with name of " + nameFlag + " not found." : "user: " + desc.details();
                }
                Collection<KVStoreUser.UserDescription> usersDesc = userDescMap.values();
                for (KVStoreUser.UserDescription desc : usersDesc) {
                    out.println("user: " + desc.brief());
                }
                return outStream.toString();
            }
            catch (RemoteException re) {
                cmd.noAdmin(re);
                return "Cannot get here";
            }
        }

        @Override
        protected String getCommandSyntax() {
            return "show users [-name <name>]";
        }

        @Override
        protected String getCommandDescription() {
            return "Lists the names of all users, or displays information about a" + eolt + "specific " + DESC_STR + ". If no " + DESC_STR + " is " + "specified, lists the names" + eolt + "of all " + DESC_STR + "s. If a " + DESC_STR + " is specified using the " + NAME_FLAG + " flag," + eolt + "then lists detailed information about the " + DESC_STR + ".";
        }
    }

    private static final class ShowIndexes
    extends CommandWithSubs.SubCommand {
        static final String CMD_TEXT = "indexes";
        static final String INDEX_FLAG = "-name";
        static final String TABLE_FLAG = "-table";

        private ShowIndexes() {
            super(CMD_TEXT, 3);
        }

        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            String tableName = null;
            String indexName = null;
            Shell.checkHelp(args, this);
            if (args.length > 1) {
                for (int i = 1; i < args.length; ++i) {
                    if (TABLE_FLAG.equals(args[i])) {
                        tableName = Shell.nextArg(args, i++, this);
                        continue;
                    }
                    if (INDEX_FLAG.equals(args[i])) {
                        indexName = Shell.nextArg(args, i++, this);
                        continue;
                    }
                    if (TABLE_FLAG.equals(args[i])) {
                        tableName = Shell.nextArg(args, i++, this);
                        continue;
                    }
                    shell.unknownArgument(args[i], this);
                }
            }
            if (indexName != null && tableName == null) {
                shell.requiredArg(TABLE_FLAG, this);
            }
            CommandShell cmd = (CommandShell)shell;
            CommandServiceAPI cs = cmd.getAdmin();
            TableMetadata meta = null;
            try {
                meta = cs.getMetadata(TableMetadata.class, Metadata.MetadataType.TABLE);
            }
            catch (RemoteException re) {
                cmd.noAdmin(re);
            }
            if (meta == null) {
                return "No table found.";
            }
            if (tableName != null) {
                TableImpl table = meta.getTable(tableName);
                if (table == null) {
                    return "Table " + tableName + " does not exist.";
                }
                if (indexName != null) {
                    Index index = table.getIndex(indexName);
                    if (index == null) {
                        return "Index " + indexName + " on table " + tableName + " does not exist.";
                    }
                    return this.getIndexInfo(index);
                }
                String ret = this.getTableIndexesInfo(table);
                if (ret == null) {
                    return "No Index found.";
                }
                return ret;
            }
            Map<String, Table> tableMap = null;
            tableMap = meta.getTables();
            if (tableMap == null || tableMap.isEmpty()) {
                return "No table found.";
            }
            return this.getAllTablesIndexesInfo(tableMap);
        }

        private String getAllTablesIndexesInfo(Map<String, Table> tableMap) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, Table> entry : tableMap.entrySet()) {
                Table table = entry.getValue();
                String ret = this.getTableIndexesInfo(table);
                if (ret == null) continue;
                if (sb.length() > 0) {
                    sb.append(eol);
                }
                sb.append(ret);
                sb.append(eol);
                if (table.getChildTables() == null || (ret = this.getAllTablesIndexesInfo(table.getChildTables())).length() <= 0) continue;
                sb.append(eol);
                sb.append(ret);
            }
            return sb.toString();
        }

        private String getTableIndexesInfo(Table table) {
            Map<String, Index> map = table.getIndexes();
            if (map == null || map.isEmpty()) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("Indexes on table ");
            sb.append(table.getFullName());
            for (Map.Entry<String, Index> entry : map.entrySet()) {
                sb.append(eol);
                sb.append(this.getIndexInfo(entry.getValue()));
            }
            return sb.toString();
        }

        private String getIndexInfo(Index index) {
            StringBuilder sb = new StringBuilder();
            sb.append("\t");
            sb.append(index.getName());
            sb.append(" (");
            boolean first = true;
            for (String s : index.getFields()) {
                if (!first) {
                    sb.append(", ");
                } else {
                    first = false;
                }
                sb.append(s);
            }
            sb.append(")");
            if (index.getDescription() != null) {
                sb.append(" -- ");
                sb.append(index.getDescription());
            }
            return sb.toString();
        }

        @Override
        protected String getCommandSyntax() {
            return "show indexes [-table <name>] [-name <name>]";
        }

        @Override
        protected String getCommandDescription() {
            return "Display index metadata. By default the indexes metadata of all tables" + eolt + "are listed.  If a specific table is named its indexes " + "metadata are" + eolt + "displayed, if a specific index of the table is named its " + "metadata is " + eolt + "displayed.";
        }
    }

    private static final class ShowTables
    extends CommandWithSubs.SubCommand {
        static final String CMD_TEXT = "tables";
        static final String TABLE_FLAG = "-name";
        static final String PARENT_FLAG = "-parent";
        static final String LEVEL_FLAG = "-level";

        private ShowTables() {
            super(CMD_TEXT, 3);
        }

        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            String tableName = null;
            String parentName = null;
            Integer maxLevel = null;
            Shell.checkHelp(args, this);
            if (args.length > 1) {
                for (int i = 1; i < args.length; ++i) {
                    if (TABLE_FLAG.equals(args[i])) {
                        tableName = Shell.nextArg(args, i++, this);
                        continue;
                    }
                    if (PARENT_FLAG.equals(args[i])) {
                        parentName = Shell.nextArg(args, i++, this);
                        continue;
                    }
                    if (LEVEL_FLAG.equals(args[i])) {
                        String sLevel = Shell.nextArg(args, i++, this);
                        try {
                            maxLevel = Integer.valueOf(sLevel);
                        }
                        catch (NumberFormatException nfe) {
                            shell.invalidArgument(sLevel, this);
                        }
                        continue;
                    }
                    shell.unknownArgument(args[i], this);
                }
            }
            CommandShell cmd = (CommandShell)shell;
            CommandServiceAPI cs = cmd.getAdmin();
            TableMetadata meta = null;
            try {
                meta = cs.getMetadata(TableMetadata.class, Metadata.MetadataType.TABLE);
            }
            catch (RemoteException re) {
                cmd.noAdmin(re);
            }
            if (meta == null) {
                return "No table found.";
            }
            if (tableName != null) {
                TableImpl table = meta.getTable(tableName);
                if (table == null) {
                    return "Table " + tableName + " does not exist.";
                }
                return table.toJsonString(true);
            }
            Map<String, Table> tableMap = null;
            boolean verbose = shell.getVerbose();
            if (parentName != null) {
                TableImpl tbParent = meta.getTable(parentName);
                if (tbParent == null) {
                    return "Table " + parentName + " does not exist.";
                }
                tableMap = tbParent.getChildTables();
            } else {
                tableMap = meta.getTables();
            }
            if (tableMap == null || tableMap.size() == 0) {
                return "No table found.";
            }
            return this.getAllTablesInfo(tableMap, maxLevel, verbose);
        }

        private String getAllTablesInfo(Map<String, Table> tableMap, Integer maxLevel, boolean verbose) {
            if (!verbose) {
                return "Tables: " + eolt + this.getTableAndChildrenName(tableMap, 0, maxLevel);
            }
            return this.getTableAndChildrenMetaInfo(tableMap, 0, maxLevel);
        }

        private String getTableAndChildrenName(Map<String, Table> tableMap, int curLevel, Integer maxLevel) {
            String INDENT = "  ";
            String indent = "";
            StringBuilder sb = new StringBuilder();
            if (curLevel > 0) {
                for (int i = 0; i < curLevel; ++i) {
                    indent = indent + "  ";
                }
            }
            for (Map.Entry<String, Table> entry : tableMap.entrySet()) {
                Map<String, Table> childTabs;
                TableImpl table = (TableImpl)entry.getValue();
                sb.append(indent);
                sb.append(table.getFullName());
                String desc = table.getDescription();
                if (desc != null && desc.length() > 0) {
                    sb.append(" -- ");
                    sb.append(desc);
                }
                sb.append(Shell.eolt);
                if (maxLevel != null && curLevel == maxLevel || (childTabs = table.getChildTables()) == null) continue;
                sb.append(this.getTableAndChildrenName(childTabs, curLevel + 1, maxLevel));
            }
            return sb.toString();
        }

        private String getTableAndChildrenMetaInfo(Map<String, Table> tableMap, int curLevel, Integer maxLevel) {
            StringBuffer sb = new StringBuffer();
            for (Map.Entry<String, Table> entry : tableMap.entrySet()) {
                TableImpl table = (TableImpl)entry.getValue();
                sb.append(table.getFullName());
                sb.append(":");
                sb.append(Shell.eol);
                sb.append(table.toJsonString(true));
                sb.append(Shell.eol);
                if (maxLevel != null && curLevel == maxLevel || table.getChildTables() == null) continue;
                sb.append(this.getTableAndChildrenMetaInfo(table.getChildTables(), curLevel++, maxLevel));
            }
            return sb.toString();
        }

        @Override
        protected String getCommandSyntax() {
            return "show tables [-name <name>] [-parent <name>] [-level <level>]";
        }

        @Override
        protected String getCommandDescription() {
            return "Display table metadata.  By default the names of all top-tables and" + eolt + "their child tables are listed.  " + "Top-level tables are those without" + eolt + "parents.  " + "The level of child tables can be limited by specifying the" + eolt + LEVEL_FLAG + " flag.  If a specific table is named " + "its detailed metadata is" + eolt + "displayed.  The table " + "name is a dot-separated name with the format" + eolt + "tableName[.childTableName]*.  Flag " + PARENT_FLAG + " is used to show all child" + eolt + "tables for the " + "given parent table.";
        }
    }

    static class ShowZones
    extends CommandWithSubs.SubCommand {
        static final String ID_FLAG = "-zn";
        static final String NAME_FLAG = "-znname";
        static final String DESC_STR = "zone";
        static final String dcFlagsDeprecation = "The -dc and -dcname flags, and the dc<ID> ID format, are deprecated" + eol + "and have been replaced by -zn, -znname, and zn<ID>." + eol + eol;

        private ShowZones() {
            super("zones", 4);
        }

        ShowZones(String name, int prefixLength) {
            super(name, prefixLength);
        }

        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            DatacenterId id = null;
            String nameFlag = null;
            boolean deprecatedDcFlag = false;
            Shell.checkHelp(args, this);
            if (args.length > 1) {
                for (int i = 1; i < args.length; ++i) {
                    if (CommandUtils.isDatacenterIdFlag(args[i])) {
                        try {
                            id = DatacenterId.parse(Shell.nextArg(args, i++, this));
                        }
                        catch (IllegalArgumentException e) {
                            throw new ShellUsageException("Invalid zone ID: " + args[i], this);
                        }
                        if (!CommandUtils.isDeprecatedDatacenterId(args[i - 1], args[i])) continue;
                        deprecatedDcFlag = true;
                        continue;
                    }
                    if (CommandUtils.isDatacenterNameFlag(args[i])) {
                        nameFlag = Shell.nextArg(args, i++, this);
                        if (!CommandUtils.isDeprecatedDatacenterName(args[i - 1])) continue;
                        deprecatedDcFlag = true;
                        continue;
                    }
                    shell.unknownArgument(args[i], this);
                }
            }
            String deprecatedDcFlagPrefix = !deprecatedDcFlag ? "" : dcFlagsDeprecation;
            CommandShell cmd = (CommandShell)shell;
            CommandServiceAPI cs = cmd.getAdmin();
            try {
                ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                PrintStream out = new PrintStream(outStream);
                Topology topo = cs.getTopology();
                Parameters params = cs.getParameters();
                TopologyPrinter.printZoneInfo(id, nameFlag, topo, out, params);
                return deprecatedDcFlagPrefix + outStream;
            }
            catch (RemoteException re) {
                cmd.noAdmin(re);
                return "Cannot get here";
            }
        }

        @Override
        protected String getCommandSyntax() {
            return "show " + this.name + " [" + ID_FLAG + " <id> | " + NAME_FLAG + " <name>]";
        }

        @Override
        protected String getCommandDescription() {
            return "Lists the names of all zones, or display information about a" + eolt + "specific " + DESC_STR + ". If no " + DESC_STR + " is " + "specified, list the names" + eolt + "of all " + DESC_STR + "s. If a specific " + DESC_STR + " is specified using" + eolt + "either the " + DESC_STR + "'s id (via the '" + ID_FLAG + "' flag), or the " + DESC_STR + "'s" + eolt + "name (via the '" + NAME_FLAG + "' flag), then list " + "information such as the" + eolt + "names of the storage " + "nodes deployed to that " + DESC_STR + ".";
        }
    }

    static final class ShowDatacenters
    extends ShowZones {
        static final String dcCommandDeprecation = "The command:" + eol + eolt + "show datacenters" + eol + eol + "is deprecated and has been replaced by:" + eol + eolt + "show zones" + eol + eol;

        ShowDatacenters() {
            super("datacenters", 4);
        }

        @Override
        protected boolean isDeprecated() {
            return true;
        }

        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            return dcCommandDeprecation + super.execute(args, shell);
        }

        @Override
        public String getCommandDescription() {
            return super.getCommandDescription() + eol + eolt + "This command is deprecated and has been replaced by:" + eol + eolt + "show zones";
        }
    }

    private static final class ShowUpgradeOrder
    extends CommandWithSubs.SubCommand {
        private ShowUpgradeOrder() {
            super("upgrade-order", 3);
        }

        @Override
        protected String getCommandSyntax() {
            return "show upgrade-order";
        }

        @Override
        protected String getCommandDescription() {
            return "Lists the Storage Nodes which need to be upgraded in an order that" + eolt + "prevents disruption to the store's " + "operation.";
        }

        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            CommandShell cmd = (CommandShell)shell;
            CommandServiceAPI cs = cmd.getAdmin();
            try {
                return cs.getUpgradeOrder(KVVersion.CURRENT_VERSION, KVVersion.PREREQUISITE_VERSION);
            }
            catch (RemoteException re) {
                cmd.noAdmin(re);
                return "Cannot get here";
            }
        }
    }

    private static final class ShowSnapshots
    extends CommandWithSubs.SubCommand {
        private ShowSnapshots() {
            super("snapshots", 3);
        }

        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            Shell.checkHelp(args, this);
            CommandShell cmd = (CommandShell)shell;
            CommandServiceAPI cs = cmd.getAdmin();
            StorageNodeId snid = null;
            for (int i = 1; i < args.length; ++i) {
                String arg = args[i];
                if ("-sn".equals(arg)) {
                    String sn = Shell.nextArg(args, i++, this);
                    try {
                        snid = StorageNodeId.parse(sn);
                    }
                    catch (IllegalArgumentException iae) {
                        shell.invalidArgument(sn, this);
                    }
                    continue;
                }
                shell.unknownArgument(arg, this);
            }
            try {
                Snapshot snapshot = new Snapshot(cs, shell.getVerbose(), shell.getOutput());
                String[] list = null;
                list = snid != null ? snapshot.listSnapshots(snid) : snapshot.listSnapshots();
                String ret = "";
                for (String ss : list) {
                    ret = ret + ss + eol;
                }
                return ret;
            }
            catch (RemoteException re) {
                cmd.noAdmin(re);
            }
            catch (IllegalArgumentException iae) {
                throw new ShellException(iae.getMessage());
            }
            return "Cannot get here";
        }

        @Override
        protected String getCommandSyntax() {
            return "show snapshots [-sn <id>]";
        }

        @Override
        protected String getCommandDescription() {
            return "Lists snapshots on the specified Storage Node. If no Storage Node" + eolt + "is specified one is chosen from " + "the store.";
        }
    }

    private static final class ShowPerf
    extends CommandWithSubs.SubCommand {
        private ShowPerf() {
            super("perf", 3);
        }

        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            CommandShell cmd = (CommandShell)shell;
            CommandServiceAPI cs = cmd.getAdmin();
            try {
                ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                PrintStream out = new PrintStream(outStream);
                Map<ResourceId, PerfEvent> perfMap = cs.getPerfMap();
                out.println(PerfEvent.HEADER);
                for (PerfEvent pe : perfMap.values()) {
                    out.println(pe.getColumnFormatted());
                }
                return outStream.toString();
            }
            catch (RemoteException re) {
                cmd.noAdmin(re);
                return "Cannot get here";
            }
        }

        @Override
        protected String getCommandSyntax() {
            return "show perf";
        }

        @Override
        protected String getCommandDescription() {
            return "Displays recent performance information for each Replication Node.";
        }
    }

    static final class ShowFaults
    extends CommandWithSubs.SubCommand {
        private ShowFaults() {
            super("faults", 3);
        }

        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            Shell.CommandHistory history = shell.getHistory();
            boolean from = false;
            int to = history.getSize();
            if (args.length > 1) {
                String arg = args[1];
                if ("-last".equals(arg)) {
                    return history.dumpLastFault();
                }
                if ("-command".equals(arg)) {
                    String faultString = Shell.nextArg(args, 1, this);
                    try {
                        int fault = Integer.parseInt(faultString);
                        int idxFault = this.toZeroBasedIndex(fault);
                        if (idxFault < 0 || idxFault >= history.getSize()) {
                            return "Index out of range: " + fault + "" + eolt + this.getBriefHelp();
                        }
                        if (history.commandFaulted(idxFault)) {
                            return history.dumpCommand(idxFault, true);
                        }
                        return "Command " + fault + " did not fault";
                    }
                    catch (IllegalArgumentException e) {
                        shell.invalidArgument(faultString, this);
                    }
                } else {
                    shell.unknownArgument(arg, this);
                }
            }
            return history.dumpFaultingCommands(0, to);
        }

        private int toZeroBasedIndex(int index) {
            return index > 0 ? index - 1 : 0;
        }

        @Override
        protected String getCommandSyntax() {
            return "show faults [-last] [-command <command index>]";
        }

        @Override
        protected String getCommandDescription() {
            return "Displays faulting commands.  By default all available faulting commands" + eolt + "are displayed.  Individual " + "fault details can be displayed using the" + eolt + "-last and -command flags.";
        }
    }

    static final class ShowPools
    extends CommandWithSubs.SubCommand {
        ShowPools() {
            super("pools", 3);
        }

        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            Shell.checkHelp(args, this);
            CommandShell cmd = (CommandShell)shell;
            CommandServiceAPI cs = cmd.getAdmin();
            String poolName = null;
            for (int i = 1; i < args.length; ++i) {
                String arg = args[i];
                if (!"-name".equals(arg)) {
                    throw new ShellUsageException("Invalid argument: " + arg, this);
                }
                poolName = Shell.nextArg(args, i++, this);
            }
            try {
                Topology topo = cs.getTopology();
                if (args.length == 1) {
                    List<String> poolNames = cs.getStorageNodePoolNames();
                    String res = "";
                    for (String pn : poolNames) {
                        res = res + pn + ": ";
                        for (StorageNodeId snid : cs.getStorageNodePoolIds(pn)) {
                            DatacenterId dcid = topo.get(snid).getDatacenterId();
                            String dcName = ((Datacenter)topo.getDatacenterMap().get(dcid)).getName();
                            res = res + snid.toString() + " zn:[id=" + dcid + " name=" + dcName + "], ";
                        }
                        res = res.substring(0, res.length() - 2);
                        res = res + eol;
                    }
                    return res;
                }
                if (cs.getStorageNodePoolNames().contains(poolName)) {
                    String res = poolName + ": ";
                    for (StorageNodeId snid : cs.getStorageNodePoolIds(poolName)) {
                        DatacenterId dcid = topo.get(snid).getDatacenterId();
                        String dcName = ((Datacenter)topo.getDatacenterMap().get(dcid)).getName();
                        res = res + snid.toString() + " zn:[id=" + dcid + " name=" + dcName + "], ";
                    }
                    res = res.substring(0, res.length() - 2);
                    res = res + eol;
                    return res;
                }
                throw new IllegalArgumentException("Not a valid pool name: " + poolName);
            }
            catch (RemoteException re) {
                cmd.noAdmin(re);
                return "Cannot get here";
            }
        }

        @Override
        protected String getCommandSyntax() {
            return "show pools [-name <name>]";
        }

        @Override
        protected String getCommandDescription() {
            return "Lists the storage node pools";
        }
    }

    private static final class ShowPlans
    extends CommandWithSubs.SubCommand {
        private static final String lastPlanNotFound = "Found no plans created by the current user.";

        private ShowPlans() {
            super("plans", 2);
        }

        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            Shell.checkHelp(args, this);
            CommandShell cmd = (CommandShell)shell;
            CommandServiceAPI cs = cmd.getAdmin();
            if (args.length == 3 && Shell.checkArg(args, "-id") || args.length == 2 && Shell.checkArg(args, "-last")) {
                return this.showSinglePlan(shell, args, cs, cmd);
            }
            int planId = 0;
            int howMany = 0;
            Date fromTime = null;
            Date toTime = null;
            for (int i = 1; i < args.length; ++i) {
                String arg = args[i];
                if ("-id".equals(arg)) {
                    try {
                        planId = Integer.parseInt(Shell.nextArg(args, i++, this));
                        continue;
                    }
                    catch (NumberFormatException e) {
                        throw new ShellUsageException("Invalid plan ID: " + args[i], this);
                    }
                }
                if ("-num".equals(arg)) {
                    try {
                        howMany = Integer.parseInt(Shell.nextArg(args, i++, this));
                        continue;
                    }
                    catch (NumberFormatException e) {
                        throw new ShellUsageException("Invalid number of plans: " + args[i], this);
                    }
                }
                if ("-from".equals(arg)) {
                    fromTime = ShowCommand.parseTimestamp(Shell.nextArg(args, i++, this), this);
                    continue;
                }
                if ("-to".equals(arg)) {
                    toTime = ShowCommand.parseTimestamp(Shell.nextArg(args, i++, this), this);
                    continue;
                }
                shell.unknownArgument(arg, this);
            }
            if (planId != 0 && (fromTime != null || toTime != null)) {
                throw new ShellUsageException("-id cannot be used in combination with -from or -to", this);
            }
            if (planId == 0 && fromTime == null && toTime == null) {
                toTime = new Date();
            }
            if ((fromTime == null || toTime == null) && howMany == 0) {
                howMany = 10;
            }
            if (fromTime != null || toTime != null) {
                try {
                    int[] range = cs.getPlanIdRange(fromTime == null ? 0L : fromTime.getTime(), toTime == null ? 0L : toTime.getTime(), howMany);
                    planId = range[0];
                    howMany = range[1];
                }
                catch (RemoteException re) {
                    cmd.noAdmin(re);
                }
            }
            String res = "";
            while (howMany > 0) {
                try {
                    TreeMap<Integer, Plan> sortedPlans = new TreeMap<Integer, Plan>(cs.getPlanRange(planId, howMany));
                    if (sortedPlans.size() == 0) break;
                    for (Integer k : sortedPlans.keySet()) {
                        Plan p = (Plan)sortedPlans.get(k);
                        res = res + String.format("%6d %-24s %s" + eol, p.getId(), p.getName(), p.getState().toString());
                        --howMany;
                        planId = k + 1;
                    }
                }
                catch (RemoteException re) {
                    cmd.noAdmin(re);
                }
            }
            return res;
        }

        @Override
        protected String getCommandSyntax() {
            return "show plans [-last] [-id <id>] [-from <date>] [-to <date>][-num <howMany>]";
        }

        @Override
        protected String getCommandDescription() {
            return "Shows details of the specified plan or lists all plans that have been" + eolt + "created along with their " + "corresponding plan IDs and status." + eolt + eolt + "With no argument: lists the ten most recent plans." + eolt + "-last: shows details of the most recent plan" + eolt + "-id <id>: shows details of the plan with the given id;" + eolt + "    if -num <n> is also given, list <n> plans," + eolt + "    starting with plan #<id>." + eolt + "-num <n>: sets the number of plans to list." + eolt + "    Defaults to 10." + eolt + "-from <date>: lists plans after <date>." + eolt + "-to <date>: lists plans before <date>." + eolt + "    Combining -from with -to describes the range" + eolt + "    between the two <dates>.  Otherwise -num applies." + eolt + eolt + ShowCommand.getDateFormatsUsage();
        }

        private String showSinglePlan(Shell shell, String[] args, CommandServiceAPI cs, CommandShell cmd) throws ShellException {
            int planId = 0;
            boolean verbose = shell.getVerbose();
            try {
                if ("-last".equals(args[1])) {
                    planId = PlanCommand.PlanSubCommand.getLastPlanId(cs);
                    if (planId == 0) {
                        return lastPlanNotFound;
                    }
                } else if ("-id".equals(args[1])) {
                    if (args.length != 3) {
                        shell.badArgCount(this);
                    }
                    try {
                        planId = Integer.parseInt(args[2]);
                    }
                    catch (IllegalArgumentException ignored) {
                        throw new ShellUsageException("Invalid plan ID: " + args[2], this);
                    }
                } else {
                    shell.unknownArgument(args[1], this);
                }
                long options = 2L;
                if (verbose) {
                    options |= 1L;
                }
                return cs.getPlanStatus(planId, options);
            }
            catch (RemoteException re) {
                cmd.noAdmin(re);
                return "Cannot get here";
            }
        }
    }

    private static final class ShowEvents
    extends CommandWithSubs.SubCommand {
        private ShowEvents() {
            super("events", 2);
        }

        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            Shell.checkHelp(args, this);
            CommandShell cmd = (CommandShell)shell;
            CommandServiceAPI cs = cmd.getAdmin();
            if (Shell.checkArg(args, "-id")) {
                return this.showSingleEvent(args, cs, cmd, shell);
            }
            try {
                Date fromTime = null;
                Date toTime = null;
                CriticalEvent.EventType et = CriticalEvent.EventType.ALL;
                for (int i = 1; i < args.length; ++i) {
                    if ("-from".equals(args[i])) {
                        if (++i >= args.length) {
                            shell.badArgCount(this);
                        }
                        if ((fromTime = ShowCommand.parseTimestamp(args[i], this)) != null) continue;
                        return "Can't parse " + args[i] + " as a timestamp.";
                    }
                    if ("-to".equals(args[i])) {
                        if (++i >= args.length) {
                            shell.badArgCount(this);
                        }
                        toTime = ShowCommand.parseTimestamp(args[i], this);
                        continue;
                    }
                    if ("-type".equals(args[i])) {
                        if (++i >= args.length) {
                            shell.badArgCount(this);
                        }
                        try {
                            String etype = args[i].toUpperCase();
                            et = Enum.valueOf(CriticalEvent.EventType.class, etype);
                            continue;
                        }
                        catch (IllegalArgumentException iae) {
                            throw new ShellUsageException("Can't parse " + args[i] + " as an EventType.", this);
                        }
                    }
                    shell.unknownArgument(args[i], this);
                }
                long from = fromTime == null ? 0L : fromTime.getTime();
                long to = toTime == null ? 0L : toTime.getTime();
                List<CriticalEvent> events = cs.getEvents(from, to, et);
                String msg = "";
                for (CriticalEvent ev : events) {
                    msg = msg + ev.toString() + eol;
                }
                return msg;
            }
            catch (RemoteException re) {
                cmd.noAdmin(re);
                return "Cannot get here";
            }
        }

        @Override
        protected String getCommandSyntax() {
            return "show events [-id <id>] | [-from <date>] [-to <date>]" + eolt + "[-type <stat|log|perf>]";
        }

        @Override
        protected String getCommandDescription() {
            return "Displays event details or list of store events.  Status events indicate" + eolt + "changes in service status.  " + "Log events correspond to records written " + eolt + "to " + "the store's log, except that only records logged at " + "\"SEVERE\" are " + eolt + "displayed; which should be " + "investigated immediately.  To view records " + eolt + "logged at \"WARNING\" or lower consult the store's log " + "file." + eolt + "Performance events are not usually " + "critical but may merit investigation." + eolt + eolt + ShowCommand.getDateFormatsUsage();
        }

        private String showSingleEvent(String[] args, CommandServiceAPI cs, CommandShell cmd, Shell shell) throws ShellException {
            if (args.length != 3) {
                shell.badArgCount(this);
            }
            if (!"-id".equals(args[1])) {
                shell.unknownArgument(args[1], this);
            }
            String eventId = args[2];
            try {
                CriticalEvent event = cs.getOneEvent(eventId);
                if (event == null) {
                    return "No event matches the id " + eventId;
                }
                return event.getDetailString();
            }
            catch (RemoteException re) {
                cmd.noAdmin(re);
                return "Cannot get here";
            }
        }
    }

    static final class ShowTopology
    extends CommandWithSubs.SubCommand {
        static final String rnFlag = "-rn";
        static final String snFlag = "-sn";
        static final String stFlag = "-store";
        static final String shFlag = "-shard";
        static final String statusFlag = "-status";
        static final String perfFlag = "-perf";
        static final String dcFlagsDeprecation = "The -dc flag is deprecated and has been replaced by -zn." + eol + eol;

        private ShowTopology() {
            super("topology", 4);
        }

        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            EnumSet<TopologyPrinter.Filter> filter = EnumSet.noneOf(TopologyPrinter.Filter.class);
            Shell.checkHelp(args, this);
            boolean hasComponents = false;
            boolean deprecatedDcFlag = false;
            if (args.length > 1) {
                for (int i = 1; i < args.length; ++i) {
                    if (CommandUtils.isDatacenterIdFlag(args[i])) {
                        filter.add(TopologyPrinter.Filter.DC);
                        hasComponents = true;
                        if (!"-dc".equals(args[i])) continue;
                        deprecatedDcFlag = true;
                        continue;
                    }
                    if (args[i].equals(rnFlag)) {
                        filter.add(TopologyPrinter.Filter.RN);
                        hasComponents = true;
                        continue;
                    }
                    if (args[i].equals(snFlag)) {
                        filter.add(TopologyPrinter.Filter.SN);
                        hasComponents = true;
                        continue;
                    }
                    if (args[i].equals(stFlag)) {
                        filter.add(TopologyPrinter.Filter.STORE);
                        hasComponents = true;
                        continue;
                    }
                    if (args[i].equals(shFlag)) {
                        filter.add(TopologyPrinter.Filter.SHARD);
                        hasComponents = true;
                        continue;
                    }
                    if (args[i].equals(statusFlag)) {
                        filter.add(TopologyPrinter.Filter.STATUS);
                        continue;
                    }
                    if (args[i].equals(perfFlag)) {
                        filter.add(TopologyPrinter.Filter.PERF);
                        continue;
                    }
                    shell.unknownArgument(args[i], this);
                }
            } else {
                filter = TopologyPrinter.all;
                hasComponents = true;
            }
            if (!hasComponents) {
                filter.addAll(TopologyPrinter.components);
            }
            String deprecatedDcFlagPrefix = !deprecatedDcFlag ? "" : dcFlagsDeprecation;
            CommandShell cmd = (CommandShell)shell;
            CommandServiceAPI cs = cmd.getAdmin();
            try {
                ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                PrintStream out = new PrintStream(outStream);
                Topology t = cs.getTopology();
                Parameters p = cs.getParameters();
                Map<ResourceId, ServiceChange> statusMap = null;
                if (filter.contains((Object)TopologyPrinter.Filter.STATUS)) {
                    statusMap = cs.getStatusMap();
                }
                Map<ResourceId, PerfEvent> perfMap = null;
                if (filter.contains((Object)TopologyPrinter.Filter.PERF)) {
                    perfMap = cs.getPerfMap();
                }
                TopologyPrinter.printTopology(t, out, p, filter, statusMap, perfMap, shell.getVerbose());
                return deprecatedDcFlagPrefix + outStream;
            }
            catch (RemoteException re) {
                cmd.noAdmin(re);
                return "Cannot get here";
            }
        }

        @Override
        protected String getCommandSyntax() {
            return "show topology [-zn] [-rn] [-sn] [-store] [-status] [-perf]";
        }

        @Override
        protected String getCommandDescription() {
            return "Displays the current, deployed topology. By default show the entire " + eolt + "topology. The optional flags restrict the " + "display to one or more of" + eolt + "Zones, " + "RepNodes, StorageNodes and Storename," + eolt + "or " + "specify service status or performance.";
        }
    }

    static final class ShowSchemas
    extends CommandWithSubs.SubCommand {
        private ShowSchemas() {
            super("schemas", 3);
        }

        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            boolean includeDisabled;
            Shell.checkHelp(args, this);
            if (args.length > 3) {
                shell.badArgCount(this);
            }
            CommandShell cmd = (CommandShell)shell;
            CommandServiceAPI cs = cmd.getAdmin();
            if (args.length == 3) {
                if ("-name".equals(args[1])) {
                    return this.showSingleSchema(args[2], cs, cmd);
                }
                shell.unknownArgument(args[1], this);
            }
            if (args.length == 2) {
                if (!"-disabled".equals(args[1])) {
                    shell.unknownArgument(args[1], this);
                }
                includeDisabled = true;
            } else {
                includeDisabled = false;
            }
            try {
                SortedMap<String, AvroDdl.SchemaSummary> map = cs.getSchemaSummaries(includeDisabled);
                if (map.isEmpty()) {
                    return "";
                }
                StringBuilder builder = new StringBuilder(map.size() * 100);
                for (AvroDdl.SchemaSummary summary : map.values()) {
                    if (builder.length() > 0) {
                        builder.append(eol);
                    }
                    builder.append(summary.getName());
                    this.formatAvroSchemaSummary(summary, builder);
                    for (AvroDdl.SchemaSummary prevVersion = summary.getPreviousVersion(); prevVersion != null; prevVersion = prevVersion.getPreviousVersion()) {
                        this.formatAvroSchemaSummary(prevVersion, builder);
                    }
                }
                return builder.toString();
            }
            catch (RemoteException re) {
                cmd.noAdmin(re);
                return "Cannot get here";
            }
        }

        @Override
        protected String getCommandSyntax() {
            return "show schemas [-disabled] | [-name <name>]";
        }

        @Override
        protected String getCommandDescription() {
            return "Displays schema details of the named schema or a list of schemas" + eolt + "registered with the store. The " + "-disabled flag enables listing of" + eolt + "disabled " + "schemas.";
        }

        private void formatAvroSchemaSummary(AvroDdl.SchemaSummary summary, StringBuilder builder) {
            builder.append(eol).append("  ID: ").append(summary.getId());
            AvroSchemaMetadata metadata = summary.getMetadata();
            if (metadata.getStatus() == AvroSchemaStatus.DISABLED) {
                builder.append(" (disabled)");
            }
            builder.append("  Modified: ").append(FormatUtils.formatDateAndTime(metadata.getTimeModified()));
            builder.append(", From: ").append(metadata.getFromMachine());
            if (!metadata.getByUser().isEmpty()) {
                builder.append(", By: ").append(metadata.getByUser());
            }
        }

        protected static int parseSchemaNameAndId(String nameAndId, boolean idRequired, CommandServiceAPI cs, ShellCommand command) throws ShellException, RemoteException {
            int offset = nameAndId.lastIndexOf(".");
            int id = 0;
            if (offset > 0 && offset < nameAndId.length() - 1) {
                String idArg = nameAndId.substring(offset + 1);
                try {
                    id = Integer.parseInt(idArg);
                    if (id <= 0) {
                        throw new ShellUsageException("Illegal schema ID: " + id, command);
                    }
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            SortedMap<String, AvroDdl.SchemaSummary> map = cs.getSchemaSummaries(true);
            if (id == 0) {
                if (idRequired) {
                    throw new ShellUsageException(nameAndId + " does not containing a trailing .ID " + "value", command);
                }
                String name = nameAndId;
                for (AvroDdl.SchemaSummary summary = (AvroDdl.SchemaSummary)map.get(name); summary != null; summary = summary.getPreviousVersion()) {
                    if (summary.getMetadata().getStatus() == AvroSchemaStatus.DISABLED) continue;
                    return summary.getId();
                }
                throw new ShellUsageException("Schema " + name + " does not exist or is disabled." + eol + "Use <schemaName>.<ID> to refer to a disabled " + "schema.", command);
            }
            String name = nameAndId.substring(0, offset);
            for (AvroDdl.SchemaSummary summary = (AvroDdl.SchemaSummary)map.get(name); summary != null; summary = summary.getPreviousVersion()) {
                if (id != summary.getId()) continue;
                return id;
            }
            throw new ShellUsageException("Schema " + name + " does not exist or does not have ID " + id, command);
        }

        private String showSingleSchema(String nameAndId, CommandServiceAPI cs, CommandShell cmd) throws ShellException {
            try {
                int id = ShowSchemas.parseSchemaNameAndId(nameAndId, false, cs, this);
                AvroDdl.SchemaDetails details = cs.getSchemaDetails(id);
                return details.getText();
            }
            catch (RemoteException re) {
                cmd.noAdmin(re);
                return "Cannot get here";
            }
        }
    }

    private static final class ShowAdmins
    extends CommandWithSubs.SubCommand {
        private ShowAdmins() {
            super("admins", 2);
        }

        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            Shell.checkHelp(args, this);
            if (args.length > 2) {
                shell.badArgCount(this);
            }
            CommandShell cmd = (CommandShell)shell;
            CommandServiceAPI cs = cmd.getAdmin();
            String currentAdminHost = cmd.getAdminHostname();
            int currentAdminPort = cmd.getAdminPort();
            try {
                List<ParameterMap> admins = cs.getAdmins();
                Topology t = cs.getTopology();
                StringBuilder sb = new StringBuilder();
                sb.append("");
                for (ParameterMap map : admins) {
                    AdminParams params = new AdminParams(map);
                    sb.append(params.getAdminId().toString());
                    sb.append(": Storage Node ");
                    sb.append(params.getStorageNodeId().toString());
                    sb.append(", HTTP port ");
                    sb.append(params.getHttpPort());
                    sb.append(" type=");
                    sb.append(params.getType().toString());
                    StorageNode sn = t.get(params.getStorageNodeId());
                    if (currentAdminHost.equals(sn.getHostname()) && currentAdminPort == sn.getRegistryPort()) {
                        sb.append(cmd.isReadOnly() ? " (connected read-only)" : " (master)");
                    }
                    sb.append(eol);
                }
                return sb.toString();
            }
            catch (RemoteException re) {
                cmd.noAdmin(re);
                return "Cannot get here";
            }
        }

        @Override
        protected String getCommandSyntax() {
            return "show admins";
        }

        @Override
        protected String getCommandDescription() {
            return "Displays basic information about deployed Admin services.";
        }
    }

    private static final class ShowParameters
    extends CommandWithSubs.SubCommand {
        private ShowParameters() {
            super("parameters", 4);
        }

        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            block31: {
                if (args.length < 2) {
                    shell.badArgCount(this);
                }
                Shell.checkHelp(args, this);
                CommandShell cmd = (CommandShell)shell;
                CommandServiceAPI cs = cmd.getAdmin();
                boolean showHidden = cmd.showHidden();
                String serviceName = null;
                boolean isPolicy = false;
                boolean isSecurity = false;
                for (int i = 1; i < args.length; ++i) {
                    String arg = args[i];
                    if ("-policy".equals(arg)) {
                        isPolicy = true;
                        continue;
                    }
                    if ("-service".equals(arg)) {
                        serviceName = Shell.nextArg(args, i++, this);
                        continue;
                    }
                    if ("-hidden".equals(arg)) {
                        showHidden = true;
                        continue;
                    }
                    if ("-security".equals(arg)) {
                        isSecurity = true;
                        continue;
                    }
                    shell.unknownArgument(arg, this);
                }
                if (isPolicy && isSecurity) {
                    throw new ShellUsageException("-policy and -security cannot be used together", this);
                }
                if (isPolicy) {
                    if (serviceName != null) {
                        throw new ShellUsageException("-policy cannot be combined with a service", this);
                    }
                    try {
                        ParameterMap map = cs.getPolicyParameters();
                        return CommandUtils.formatParams(map, showHidden, ParameterState.Info.POLICY);
                    }
                    catch (RemoteException re) {
                        cmd.noAdmin(re);
                    }
                }
                if (isSecurity) {
                    if (serviceName != null) {
                        throw new ShellUsageException("-security cannot be combined with a service", this);
                    }
                    try {
                        ParameterMap map = cs.getParameters().getGlobalParams().getGlobalSecurityPolicies();
                        return CommandUtils.formatParams(map, showHidden, null);
                    }
                    catch (RemoteException re) {
                        cmd.noAdmin(re);
                    }
                }
                if (serviceName == null) {
                    shell.requiredArg("-service|-policy", this);
                }
                RepNodeId rnid = null;
                AdminId aid = null;
                StorageNodeId snid = null;
                try {
                    rnid = RepNodeId.parse(serviceName);
                }
                catch (IllegalArgumentException ignored) {
                    try {
                        snid = StorageNodeId.parse(serviceName);
                    }
                    catch (IllegalArgumentException ignored1) {
                        try {
                            aid = AdminId.parse(serviceName);
                        }
                        catch (IllegalArgumentException ignored2) {
                            shell.invalidArgument(serviceName, this);
                        }
                    }
                }
                try {
                    Parameters p = cs.getParameters();
                    if (rnid != null) {
                        RepNodeParams rnp = p.get(rnid);
                        if (rnp == null) {
                            this.noSuchService(rnid);
                            break block31;
                        }
                        return CommandUtils.formatParams(rnp.getMap(), showHidden, ParameterState.Info.REPNODE);
                    }
                    if (snid != null) {
                        StorageNodeParams snp = p.get(snid);
                        if (snp == null) {
                            this.noSuchService(snid);
                            return "";
                        }
                        String result = CommandUtils.formatParams(snp.getMap(), showHidden, ParameterState.Info.SNA);
                        ParameterMap mountMap = snp.getMountMap();
                        if (mountMap != null && mountMap.size() > 0) {
                            result = result + "Storage directories:" + eol;
                            for (String s : mountMap.keys()) {
                                result = result + Shell.makeWhiteSpace(4) + s + eol;
                            }
                        }
                        return result;
                    }
                    if (aid == null) break block31;
                    AdminParams ap = p.get(aid);
                    if (ap == null) {
                        this.noSuchService(aid);
                        break block31;
                    }
                    return CommandUtils.formatParams(ap.getMap(), showHidden, ParameterState.Info.ADMIN);
                }
                catch (RemoteException re) {
                    cmd.noAdmin(re);
                }
            }
            return "show parameters...";
        }

        @Override
        protected String getCommandSyntax() {
            return "show parameters -policy | -security | -service <name>";
        }

        @Override
        protected String getCommandDescription() {
            return "Displays service parameters and state for the specified service." + eolt + "The service may be a RepNode, " + "StorageNode, or Admin service," + eolt + "as identified " + "by any valid string, for example" + eolt + "rg1-rn1, sn1, " + "admin2, etc.  Use the -policy flag to show global policy" + eolt + "parameters. Use the -security flag to show global " + "security parameters.";
        }

        private void noSuchService(ResourceId rid) throws ShellException {
            throw new ShellArgumentException("No such service: " + rid);
        }
    }
}

