/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin;

import com.sleepycat.je.rep.ReplicatedEnvironment;
import java.io.IOException;
import java.io.Serializable;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.KVVersion;
import oracle.kv.impl.admin.Admin;
import oracle.kv.impl.admin.CommandServiceAPI;
import oracle.kv.impl.admin.TopologyCheck;
import oracle.kv.impl.admin.TopologyCheckUtils;
import oracle.kv.impl.admin.VerifyResults;
import oracle.kv.impl.admin.param.Parameters;
import oracle.kv.impl.admin.param.StorageNodeParams;
import oracle.kv.impl.admin.topo.Rules;
import oracle.kv.impl.admin.topo.Validations;
import oracle.kv.impl.param.LoadParameters;
import oracle.kv.impl.param.ParameterMap;
import oracle.kv.impl.param.ParameterState;
import oracle.kv.impl.rep.RepNodeStatus;
import oracle.kv.impl.rep.admin.IllegalRepNodeServiceStateException;
import oracle.kv.impl.rep.admin.RepNodeAdminAPI;
import oracle.kv.impl.rep.admin.RepNodeAdminFaultException;
import oracle.kv.impl.security.login.LoginManager;
import oracle.kv.impl.sna.StorageNodeAgentAPI;
import oracle.kv.impl.sna.StorageNodeStatus;
import oracle.kv.impl.topo.AdminId;
import oracle.kv.impl.topo.Datacenter;
import oracle.kv.impl.topo.RepGroup;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.topo.RepNode;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.ConfigurableService;
import oracle.kv.impl.util.JsonUtils;
import oracle.kv.impl.util.VersionUtil;
import oracle.kv.impl.util.registry.RegistryUtils;
import oracle.kv.util.Ping;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectWriter;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;

public class VerifyConfiguration {
    private static final String eol = System.getProperty("line.separator");
    private static final Comparator<Problem> resourceComparator = new Comparator<Problem>(){

        @Override
        public int compare(Problem p1, Problem p2) {
            return p1.getResourceId().toString().compareTo(p2.getResourceId().toString());
        }
    };
    private final Admin admin;
    private final boolean listAll;
    private final boolean showProgress;
    private final boolean json;
    private final Logger logger;
    private final TopologyCheck topoChecker;
    private final ObjectNode jsonTop;
    private final List<Problem> violations;
    private final List<Problem> warnings;
    private final Repairs repairs;
    private volatile VerifyType verifyType;

    public VerifyConfiguration(Admin admin, boolean showProgress, boolean listAll, boolean json, Logger logger) {
        this.admin = admin;
        this.showProgress = showProgress;
        this.listAll = listAll;
        this.json = json;
        this.logger = logger;
        this.violations = new ArrayList<Problem>();
        this.warnings = new ArrayList<Problem>();
        this.jsonTop = JsonUtils.createObjectNode();
        this.repairs = new Repairs();
        this.topoChecker = new TopologyCheck(logger, admin.getCurrentTopology(), admin.getCurrentParameters());
    }

    public boolean verifyTopology() {
        return this.verifyTopology(this.admin.getCurrentTopology(), this.admin.getLoginManager(), this.admin.getCurrentParameters(), true);
    }

    public boolean verifyUpgrade(KVVersion targetVersion, List<StorageNodeId> snIds) {
        this.admin.getLogger().log(Level.INFO, "Verifying upgrade to target version: {0}", targetVersion.getNumericVersionString());
        this.clear();
        this.verifyType = VerifyType.UPGRADE;
        Topology topology = this.admin.getCurrentTopology();
        Ping.topologyOverviewToJson(topology, this.jsonTop);
        VerifyConfiguration.storewideLogNameToJson(this.admin, this.jsonTop);
        RegistryUtils registryUtils = new RegistryUtils(topology, this.admin.getLoginManager());
        if (snIds == null) {
            snIds = topology.getSortedStorageNodeIds();
        }
        ArrayNode jsonSNs = this.listAll ? this.jsonTop.putArray("snStatus") : null;
        for (StorageNodeId snId : snIds) {
            this.verifySNUpgrade(snId, targetVersion, registryUtils, topology, jsonSNs);
        }
        this.problemsToJson();
        VerifyResults vResults = this.getResults();
        this.logger.log(Level.INFO, "{0}", vResults.display());
        return vResults.okay();
    }

    private void clear() {
        this.violations.clear();
        this.warnings.clear();
        this.repairs.clear();
        this.jsonTop.removeAll();
        this.verifyType = null;
    }

    private static void storewideLogNameToJson(Admin admin, ObjectNode jsonTop) {
        jsonTop.put("storewideLogName", admin.getStorewideLogName());
    }

    private static String displayStorewideLogName(JsonNode jsonTop) {
        String logName = JsonUtils.getAsText(jsonTop, "storewideLogName");
        if (logName == null) {
            return "";
        }
        return "See " + logName + " for progress messages";
    }

    private void problemsToJson() {
        this.problemsToJson(this.violations, "violations");
        this.problemsToJson(this.warnings, "warnings");
    }

    private void problemsToJson(List<Problem> problems, String field) {
        Collections.sort(problems, resourceComparator);
        ArrayNode jsonProblems = this.jsonTop.putArray(field);
        for (Problem problem : problems) {
            jsonProblems.add(VerifyConfiguration.problemToJson(problem));
        }
    }

    private static ObjectNode problemToJson(Problem problem) {
        ObjectNode on = JsonUtils.createObjectNode();
        on.put("resourceId", problem.getResourceId().toString());
        on.put("description", problem.toString());
        return on;
    }

    private static String displayProblem(JsonNode node) {
        return "[" + JsonUtils.getAsText(node, "resourceId", "?") + "]\t" + JsonUtils.getAsText(node, "description", "");
    }

    private void verifySNUpgrade(StorageNodeId snId, KVVersion targetVersion, RegistryUtils registryUtils, Topology topology, ArrayNode jsonSNs) {
        StorageNodeStatus snStatus = null;
        try {
            snStatus = registryUtils.getStorageNodeAgent(snId).ping();
        }
        catch (RemoteException re) {
            this.violations.add(new RMIFailed(snId, re, "ping()", this.showProgress, this.logger));
        }
        catch (NotBoundException nbe) {
            this.violations.add(new RMIFailed(snId, nbe, this.showProgress, this.logger));
        }
        if (snStatus != null) {
            KVVersion snVersion = snStatus.getKVVersion();
            if (snVersion.compareTo(targetVersion) < 0) {
                this.warnings.add(new UpgradeNeeded(snId, snVersion, targetVersion, this.showProgress, this.logger));
            } else {
                this.verifyRNUpgrade(snVersion, topology.getHostedRepNodeIds(snId), registryUtils);
            }
        }
        if (this.listAll) {
            ObjectNode jsonSN = Ping.storageNodeToJson(topology, topology.get(snId), snStatus);
            this.logger.info("Verify upgrade: " + Ping.displayStorageNode(jsonSN));
            jsonSNs.add(jsonSN);
        }
    }

    private void verifyRNUpgrade(KVVersion snVersion, Set<RepNodeId> hostedRepNodeIds, RegistryUtils registryUtils) {
        ConfigurableService.ServiceStatus rnStatus = null;
        for (RepNodeId rnId : hostedRepNodeIds) {
            try {
                RepNodeAdminAPI rn = registryUtils.getRepNodeAdmin(rnId);
                rnStatus = rn.ping().getServiceStatus();
                KVVersion rnVersion = rn.getInfo().getSoftwareVersion();
                if (rnVersion.compareTo(snVersion) == 0) continue;
                this.warnings.add(new UpgradeNeeded(rnId, rnVersion, snVersion, this.showProgress, this.logger));
            }
            catch (RemoteException re) {
                this.violations.add(new RMIFailed(rnId, re, "ping()", this.showProgress, this.logger));
            }
            catch (NotBoundException nbe) {
                this.violations.add(new RMIFailed(rnId, nbe, this.showProgress, this.logger));
            }
            catch (RepNodeAdminFaultException rnafe) {
                if (rnafe.getFaultClassName().equals(IllegalRepNodeServiceStateException.class.getName())) {
                    this.violations.add(new StatusNotRight(rnId, ConfigurableService.ServiceStatus.RUNNING, rnStatus, this.showProgress, this.logger));
                    continue;
                }
                throw rnafe;
            }
        }
    }

    public boolean verifyPrerequisite(KVVersion targetVersion, KVVersion prerequisiteVersion, List<StorageNodeId> snIds) {
        this.admin.getLogger().log(Level.INFO, "Checking upgrade to target version: {0}, prerequisite: {1}", new Object[]{targetVersion.getNumericVersionString(), prerequisiteVersion.getNumericVersionString()});
        this.clear();
        this.verifyType = VerifyType.PREREQUISITE;
        Topology topology = this.admin.getCurrentTopology();
        Ping.topologyOverviewToJson(topology, this.jsonTop);
        VerifyConfiguration.storewideLogNameToJson(this.admin, this.jsonTop);
        RegistryUtils registryUtils = new RegistryUtils(topology, this.admin.getLoginManager());
        if (snIds == null) {
            snIds = topology.getSortedStorageNodeIds();
        }
        ArrayNode jsonSNs = this.listAll ? this.jsonTop.putArray("snStatus") : null;
        for (StorageNodeId snId : snIds) {
            this.verifySNPrerequisite(snId, targetVersion, prerequisiteVersion, registryUtils, topology, jsonSNs);
        }
        this.problemsToJson();
        VerifyResults vResults = this.getResults();
        this.logger.log(Level.INFO, "{0}", vResults.display());
        return vResults.okay();
    }

    private void verifySNPrerequisite(StorageNodeId snId, KVVersion targetVersion, KVVersion prerequisiteVersion, RegistryUtils registryUtils, Topology topology, ArrayNode jsonSNs) {
        StorageNodeStatus snStatus = null;
        try {
            StorageNodeAgentAPI sna = registryUtils.getStorageNodeAgent(snId);
            snStatus = sna.ping();
        }
        catch (RemoteException re) {
            this.violations.add(new RMIFailed(snId, re, "ping()", this.showProgress, this.logger));
        }
        catch (NotBoundException nbe) {
            this.violations.add(new RMIFailed(snId, nbe, this.showProgress, this.logger));
        }
        if (snStatus != null) {
            KVVersion snVersion = snStatus.getKVVersion();
            if (snVersion.compareTo(prerequisiteVersion) < 0) {
                this.violations.add(new UpgradeNeeded(snId, snVersion, prerequisiteVersion, this.showProgress, this.logger));
            } else if (VersionUtil.compareMinorVersion(snVersion, targetVersion) > 0) {
                this.violations.add(new BadDowngrade(snId, snVersion, prerequisiteVersion, this.showProgress, this.logger));
            }
        }
        if (this.listAll) {
            ObjectNode jsonSN = Ping.storageNodeToJson(topology, topology.get(snId), snStatus);
            this.logger.info("Verify prerequisite: " + Ping.displayStorageNode(jsonSN));
            jsonSNs.add(jsonSN);
        }
    }

    synchronized boolean verifyTopology(Topology topology, LoginManager loginMgr, Parameters currentParams, boolean topoIsDeployed) {
        this.clear();
        this.verifyType = VerifyType.TOPOLOGY;
        Ping.topologyOverviewToJson(topology, this.jsonTop);
        this.logger.info(Ping.displayTopologyOverview(this.jsonTop));
        VerifyConfiguration.storewideLogNameToJson(this.admin, this.jsonTop);
        RegistryUtils registryUtils = new RegistryUtils(topology, loginMgr);
        Rules.Results results = Rules.validate(topology, currentParams, topoIsDeployed);
        this.violations.addAll(results.getViolations());
        this.warnings.addAll(results.getWarnings());
        for (Validations.RulesProblem rp : results.getViolations()) {
            TopologyCheck.Remedy remedy = rp.getRemedy();
            if (remedy == null) continue;
            this.repairs.add(remedy);
        }
        this.checkServices(topology, currentParams, registryUtils);
        this.problemsToJson();
        VerifyResults vResults = this.getResults();
        this.logger.log(Level.INFO, "{0}", vResults.display());
        return vResults.okay();
    }

    private void checkServices(Topology topology, Parameters currentParams, RegistryUtils registryUtils) {
        final HashMap<RepNode, RepNodeInfo> rnInfoMap = new HashMap<RepNode, RepNodeInfo>();
        HashMap<RepGroupId, RepNodeStatus> masterStatusMap = new HashMap<RepGroupId, RepNodeStatus>();
        VerifyConfiguration.rnPingAndGetParams(topology, registryUtils, rnInfoMap, masterStatusMap);
        Ping.RepNodeStatusFunction rnfunc = new Ping.RepNodeStatusFunction(){

            @Override
            public RepNodeStatus get(RepNode node) {
                RepNodeInfo info = (RepNodeInfo)rnInfoMap.get(node);
                if (info.pingStatus != null) {
                    return info.pingStatus;
                }
                return null;
            }
        };
        Ping.shardOverviewToJson(topology, rnfunc, this.jsonTop);
        ArrayNode jsonZones = this.jsonTop.putArray("zoneStatus");
        for (Datacenter dc : topology.getSortedDatacenters()) {
            jsonZones.add(Ping.zoneOverviewToJson(topology, dc, rnfunc));
        }
        Map<StorageNodeId, TopologyCheckUtils.SNServices> sortedResources = TopologyCheckUtils.groupServicesBySN(topology, currentParams);
        ArrayNode jsonSNs = this.listAll ? this.jsonTop.putArray("snStatus") : null;
        for (TopologyCheckUtils.SNServices nodeInfo : sortedResources.values()) {
            AdminId adminId;
            StorageNodeId snId = nodeInfo.getStorageNodeId();
            if (this.showProgress) {
                String msg = "Verify: == checking storage node " + snId + " ==";
                this.logger.info(msg);
            }
            ObjectNode jsonSN = this.checkStorageNode(registryUtils, topology, currentParams, snId, nodeInfo);
            if (this.listAll) {
                jsonSNs.add(jsonSN);
            }
            if ((adminId = nodeInfo.getAdminId()) != null) {
                this.checkAdmin(currentParams, adminId, jsonSN);
            }
            ArrayNode jsonRNs = this.listAll ? jsonSN.putArray("rnStatus") : null;
            for (RepNodeId rnId : nodeInfo.getAllRepNodeIds()) {
                this.checkRepNode(topology, snId, rnId, currentParams, (RepNodeInfo)rnInfoMap.get(topology.get(rnId)), (RepNodeStatus)masterStatusMap.get(new RepGroupId(rnId.getGroupId())), jsonRNs);
            }
        }
    }

    private static void rnPingAndGetParams(Topology topology, RegistryUtils registryUtils, Map<RepNode, RepNodeInfo> rnInfoMap, Map<RepGroupId, RepNodeStatus> masterStatusMap) {
        for (RepGroup rg : topology.getRepGroupMap().getAll()) {
            for (RepNode rn : rg.getRepNodes()) {
                RepNodeId rnId = (RepNodeId)rn.getResourceId();
                RepNodeAdminAPI rna = null;
                RepNodeInfo rnInfo = new RepNodeInfo();
                try {
                    rna = registryUtils.getRepNodeAdmin(rnId);
                    rnInfo.pingStatus = rna.ping();
                }
                catch (RemoteException re) {
                    rnInfo.pingRemoteException = re;
                }
                catch (NotBoundException e) {
                    rnInfo.pingNotBoundException = e;
                }
                if (rnInfo.pingStatus != null) {
                    if (rnInfo.pingStatus.getReplicationState().isMaster()) {
                        masterStatusMap.put(new RepGroupId(rnId.getGroupId()), rnInfo.pingStatus);
                    }
                    if (ConfigurableService.ServiceStatus.RUNNING.equals((Object)rnInfo.pingStatus.getServiceStatus())) {
                        try {
                            rnInfo.getParamsResult = rna.getParams();
                        }
                        catch (RemoteException re) {
                            rnInfo.getParamsRemoteException = re;
                        }
                    }
                }
                rnInfoMap.put(rn, rnInfo);
            }
        }
    }

    private void checkAdmin(Parameters params, AdminId aId, ObjectNode jsonSN) {
        StorageNodeId hostSN = params.get(aId).getStorageNodeId();
        StorageNodeParams snp = params.get(hostSN);
        boolean pingProblem = false;
        CommandServiceAPI cs = null;
        ConfigurableService.ServiceStatus status = ConfigurableService.ServiceStatus.UNREACHABLE;
        ReplicatedEnvironment.State state = null;
        try {
            cs = RegistryUtils.getAdmin(snp.getHostname(), snp.getRegistryPort(), this.admin.getLoginManager());
            status = cs.ping();
            state = cs.getAdminState();
        }
        catch (RemoteException re) {
            this.violations.add(new RMIFailed(aId, re, "ping()", this.showProgress, this.logger));
            pingProblem = true;
        }
        catch (NotBoundException e) {
            this.violations.add(new RMIFailed(aId, e, this.showProgress, this.logger));
            pingProblem = true;
        }
        TopologyCheck.Remedy remedy = this.topoChecker.checkAdminLocation(this.admin, aId);
        if (remedy.canFix()) {
            this.repairs.add(remedy);
        }
        if (!pingProblem) {
            if (status.equals((Object)ConfigurableService.ServiceStatus.RUNNING)) {
                this.checkAdminParams(cs, params, aId, hostSN);
            } else {
                this.violations.add(new StatusNotRight(aId, ConfigurableService.ServiceStatus.RUNNING, status, this.showProgress, this.logger));
            }
        }
        if (this.listAll) {
            ObjectNode jsonAdmin = Ping.adminToJson(aId, status, state);
            this.logger.info("Verify: " + Ping.displayAdmin(jsonAdmin));
            jsonSN.put("adminStatus", jsonAdmin);
        }
    }

    private ObjectNode checkStorageNode(RegistryUtils regUtils, Topology topology, Parameters currentParams, StorageNodeId snId, TopologyCheckUtils.SNServices nodeInfo) {
        boolean pingProblem = false;
        StorageNodeStatus snStatus = null;
        StorageNodeAgentAPI sna = null;
        ConfigurableService.ServiceStatus status = ConfigurableService.ServiceStatus.UNREACHABLE;
        try {
            sna = regUtils.getStorageNodeAgent(snId);
            snStatus = sna.ping();
            status = snStatus.getServiceStatus();
        }
        catch (RemoteException re) {
            this.violations.add(new RMIFailed(snId, re, "ping()", this.showProgress, this.logger));
            pingProblem = true;
        }
        catch (NotBoundException e) {
            this.violations.add(new RMIFailed(snId, e, this.showProgress, this.logger));
            pingProblem = true;
        }
        ObjectNode jsonSN = null;
        if (this.listAll) {
            jsonSN = Ping.storageNodeToJson(topology, topology.get(snId), snStatus);
            this.logger.info("Verify: " + Ping.displayStorageNode(jsonSN));
        }
        if (!pingProblem) {
            if (status.equals((Object)ConfigurableService.ServiceStatus.RUNNING)) {
                this.checkSNParams(sna, snId, currentParams, nodeInfo);
            } else {
                this.violations.add(new StatusNotRight(snId, ConfigurableService.ServiceStatus.RUNNING, status, this.showProgress, this.logger));
            }
            if (!KVVersion.CURRENT_VERSION.equals(snStatus.getKVVersion())) {
                this.violations.add(new VersionDifference(snId, snStatus.getKVVersion(), this.showProgress, this.logger));
            }
        }
        return jsonSN;
    }

    private void checkRepNode(Topology topology, StorageNodeId snId, RepNodeId rnId, Parameters currentParams, RepNodeInfo rnInfo, RepNodeStatus masterStatus, ArrayNode jsonRNs) {
        ConfigurableService.ServiceStatus expected;
        boolean pingProblem = false;
        ConfigurableService.ServiceStatus status = ConfigurableService.ServiceStatus.UNREACHABLE;
        RepNodeStatus rnStatus = null;
        boolean isDisabled = currentParams.get(rnId).isDisabled();
        ConfigurableService.ServiceStatus serviceStatus = expected = isDisabled ? ConfigurableService.ServiceStatus.UNREACHABLE : ConfigurableService.ServiceStatus.RUNNING;
        if (rnInfo.pingStatus != null) {
            rnStatus = rnInfo.pingStatus;
            status = rnStatus.getServiceStatus();
        } else if (rnInfo.pingRemoteException != null) {
            RemoteException re = rnInfo.pingRemoteException;
            if (!expected.equals((Object)ConfigurableService.ServiceStatus.UNREACHABLE)) {
                this.violations.add(new RMIFailed(rnId, re, "ping()", this.showProgress, this.logger));
                pingProblem = true;
            } else {
                this.reportStoppedRN(rnId, snId);
            }
        } else {
            NotBoundException e = rnInfo.pingNotBoundException;
            if (!expected.equals((Object)ConfigurableService.ServiceStatus.UNREACHABLE)) {
                this.violations.add(new RMIFailed(rnId, e, this.showProgress, this.logger));
                pingProblem = true;
            } else {
                this.reportStoppedRN(rnId, snId);
            }
        }
        if (!pingProblem) {
            if (status.equals((Object)expected)) {
                if (status.equals((Object)ConfigurableService.ServiceStatus.RUNNING)) {
                    this.checkRNParams(rnId, topology, currentParams, rnInfo);
                }
            } else {
                this.violations.add(new StatusNotRight(rnId, expected, status, this.showProgress, this.logger));
            }
        }
        if (this.listAll) {
            ObjectNode jsonRN = Ping.repNodeToJson(topology.get(rnId), rnStatus, masterStatus, expected);
            this.logger.info("Verify: " + Ping.displayRepNode(jsonRN));
            jsonRNs.add(jsonRN);
        }
    }

    private void reportStoppedRN(RepNodeId rnId, StorageNodeId snId) {
        this.warnings.add(new ServiceStopped(rnId, snId, this.showProgress, this.logger, true));
        boolean previousRepair = this.repairs.repairExists(rnId);
        if (!previousRepair) {
            this.repairs.add(new TopologyCheck.Remedy(new TopologyCheck.RNLocationInput(TopologyCheck.TOPO_STATUS.HERE, TopologyCheck.CONFIG_STATUS.HERE), snId, rnId, TopologyCheck.REMEDY_TYPE.CREATE_RN, null));
        }
    }

    private void checkSNParams(StorageNodeAgentAPI sna, StorageNodeId snId, Parameters currentParams, TopologyCheckUtils.SNServices nodeInfo) {
        LoadParameters remoteParams;
        try {
            remoteParams = sna.getParams();
        }
        catch (RemoteException re) {
            this.violations.add(new RMIFailed(snId, re, "getParams", this.showProgress, this.logger));
            return;
        }
        if (!this.compareParams(snId, remoteParams, currentParams.get(snId).getMap())) {
            return;
        }
        ParameterMap mountMap = currentParams.get(snId).getMountMap();
        if (mountMap != null) {
            if (!this.compareParams(snId, remoteParams, mountMap)) {
                return;
            }
        } else if (remoteParams.getMap("mountPoints") != null) {
            this.violations.add(new ParamMismatch(snId, "Parameter collection mountPoints missing", this.showProgress, this.logger));
            return;
        }
        if (!this.compareParams(snId, remoteParams, currentParams.getGlobalParams().getMap())) {
            return;
        }
        this.topoChecker.saveSNRemoteParams(snId, remoteParams);
        Set<RepNodeId> rnsToCheck = this.topoChecker.getPossibleRNs(snId);
        for (RepNodeId rnId : rnsToCheck) {
            TopologyCheck.Remedy remedy = null;
            try {
                remedy = this.topoChecker.checkRNLocation(this.admin, snId, rnId, false, false);
                if (remedy.getType() == TopologyCheck.REMEDY_TYPE.OKAY) continue;
                this.logger.log(Level.INFO, "{0}", new Object[]{remedy});
                Problem p = remedy.getType() == TopologyCheck.REMEDY_TYPE.CREATE_RN ? new ServiceStopped(remedy.getRNId(), remedy.getSNId(), this.showProgress, this.logger, false) : new ParamMismatch(remedy.getRNId(), remedy.problemDescription(), this.showProgress, this.logger);
                this.violations.add(p);
                if (!remedy.canFix()) continue;
                this.repairs.add(remedy);
            }
            catch (RemoteException e) {
                this.violations.add(new RMIFailed(snId, e, "checkRNLocation", this.showProgress, this.logger));
            }
            catch (NotBoundException e) {
                this.violations.add(new RMIFailed(snId, e, this.showProgress, this.logger));
            }
        }
        ParameterMap adminMap = remoteParams.getMapByType("adminParams");
        if (adminMap != null) {
            AdminId aid = new AdminId(adminMap.getOrZeroInt("adminId"));
            if (nodeInfo.getAdminId() == null || !aid.equals(nodeInfo.getAdminId())) {
                this.violations.add(new ParamMismatch(snId, "Storage Node is managing admin " + aid + " but the admin does not know this", this.showProgress, this.logger));
            }
        } else if (nodeInfo.getAdminId() != null) {
            this.violations.add(new ParamMismatch(snId, "Storage Node is not managing an Admin but the admin believes it is", this.showProgress, this.logger));
        }
    }

    private void checkRNParams(RepNodeId rnId, Topology topology, Parameters currentParams, RepNodeInfo rnInfo) {
        if (rnInfo.getParamsResult == null) {
            RemoteException re = rnInfo.getParamsRemoteException;
            this.violations.add(new RMIFailed(rnId, re, "getParams", this.showProgress, this.logger));
            return;
        }
        LoadParameters remoteParams = rnInfo.getParamsResult;
        if (!this.compareParams(rnId, remoteParams, currentParams.get(rnId).getMap(), new ExcludeDisableFilter())) {
            return;
        }
        StorageNodeId snId = topology.get(rnId).getStorageNodeId();
        if (!this.compareParams(rnId, remoteParams, currentParams.get(snId).getMap(), new SNPFilter())) {
            return;
        }
        if (!this.compareParams(rnId, remoteParams, currentParams.getGlobalParams().getMap())) {
            return;
        }
    }

    private void checkAdminParams(CommandServiceAPI cs, Parameters currentParams, AdminId targetAdminId, StorageNodeId hostSN) {
        LoadParameters remoteParams;
        if (this.admin != null && targetAdminId.equals(this.admin.getParams().getAdminParams().getAdminId())) {
            return;
        }
        try {
            remoteParams = cs.getParams();
        }
        catch (RemoteException re) {
            this.violations.add(new RMIFailed(targetAdminId, re, "getParams", this.showProgress, this.logger));
            return;
        }
        if (!this.compareParams(targetAdminId, remoteParams, currentParams.get(targetAdminId).getMap())) {
            return;
        }
        if (!this.compareParams(targetAdminId, remoteParams, currentParams.get(hostSN).getMap(), new SNPFilter())) {
            return;
        }
        if (!this.compareParams(targetAdminId, remoteParams, currentParams.getGlobalParams().getMap())) {
            return;
        }
    }

    private boolean compareParams(ResourceId rId, LoadParameters remoteParams, ParameterMap adminCopy) {
        return this.compareParams(rId, remoteParams, adminCopy, new MapFilter());
    }

    private boolean compareParams(ResourceId rId, LoadParameters remoteParams, ParameterMap adminCopy, MapFilter filter) {
        ParameterMap remoteCopy = remoteParams.getMapByType(adminCopy.getType());
        if (remoteCopy == null) {
            this.violations.add(new ParamMismatch(rId, "Parameter collection " + adminCopy.getType() + " missing", this.showProgress, this.logger));
            return false;
        }
        if (!(remoteCopy = filter.filter(remoteCopy)).equals(adminCopy = filter.filter(adminCopy))) {
            this.violations.add(new ParamMismatch(rId, adminCopy, remoteCopy, this.showProgress, this.logger));
            return false;
        }
        return true;
    }

    private String getOutput() {
        int numWarnings;
        int numViolations;
        if (this.json) {
            ObjectWriter writer = JsonUtils.createWriter(true);
            try {
                return writer.writeValueAsString(this.jsonTop);
            }
            catch (IOException e) {
                return e.toString();
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Verify: starting verification of ").append(Ping.displayTopologyOverview(this.jsonTop)).append(eol);
        sb.append(VerifyConfiguration.displayStorewideLogName(this.jsonTop)).append(eol);
        if (this.showProgress) {
            if (this.verifyType == VerifyType.TOPOLOGY) {
                sb.append("Verify: ").append(Ping.displayShardOverview(this.jsonTop)).append(eol);
                for (JsonNode jsonZone : JsonUtils.getArray(this.jsonTop, "zoneStatus")) {
                    sb.append("Verify: ").append(Ping.displayZoneOverview(jsonZone)).append(eol);
                }
            }
            for (JsonNode jsonSN : JsonUtils.getArray(this.jsonTop, "snStatus")) {
                String snId = JsonUtils.getAsText(jsonSN, "resourceId");
                if (this.verifyType == VerifyType.TOPOLOGY) {
                    sb.append("Verify: == checking storage node ").append(snId).append(" ==").append(eol);
                }
                this.showProgressProblems(snId, sb);
                sb.append("Verify").append(this.verifyType == VerifyType.TOPOLOGY ? "" : " " + (Object)((Object)this.verifyType)).append(": ").append(Ping.displayStorageNode(jsonSN)).append(eol);
                JsonNode jsonAdmin = jsonSN.get("adminStatus");
                if (jsonAdmin != null) {
                    this.showProgressProblems(JsonUtils.getAsText(jsonAdmin, "resourceId"), sb);
                    sb.append("Verify: ").append(Ping.displayAdmin(jsonAdmin)).append(eol);
                }
                for (JsonNode jsonRN : JsonUtils.getArray(jsonSN, "rnStatus")) {
                    this.showProgressProblems(JsonUtils.getAsText(jsonRN, "resourceId"), sb);
                    sb.append("Verify: ").append(Ping.displayRepNode(jsonRN)).append(eol);
                }
            }
            sb.append(eol);
        }
        if ((numViolations = this.violations.size()) + (numWarnings = this.warnings.size()) == 0) {
            sb.append("Verification complete, no violations.");
            return sb.toString();
        }
        sb.append("Verification complete, ").append(numViolations);
        sb.append(numViolations == 1 ? " violation, " : " violations, ");
        sb.append(numWarnings);
        sb.append(numWarnings == 1 ? " note" : " notes");
        sb.append(" found.").append(eol);
        for (JsonNode jsonProblem : JsonUtils.getArray(this.jsonTop, "violations")) {
            sb.append("Verification violation: ").append(VerifyConfiguration.displayProblem(jsonProblem)).append(eol);
        }
        for (JsonNode jsonProblem : JsonUtils.getArray(this.jsonTop, "warnings")) {
            sb.append("Verification note: ").append(VerifyConfiguration.displayProblem(jsonProblem)).append(eol);
        }
        return sb.toString();
    }

    private void showProgressProblems(String resourceId, StringBuilder sb) {
        if (this.showProgress) {
            for (Problem problem : this.violations) {
                if (!resourceId.equals(problem.getResourceId().toString())) continue;
                sb.append("Verify:         ").append(problem.getResourceId()).append(": ").append(problem).append(eol);
            }
            for (Problem problem : this.warnings) {
                if (!resourceId.equals(problem.getResourceId().toString())) continue;
                sb.append("Verify:         ").append(problem.getResourceId()).append(": ").append(problem).append(eol);
            }
        }
    }

    private static void recordProgress(boolean showProgress, Logger logger, Problem problem) {
        if (showProgress) {
            String msg = "Verify:         " + problem.getResourceId() + ": " + problem;
            logger.info(msg);
        }
    }

    public VerifyResults getResults() {
        return new VerifyResults(this.getOutput(), this.violations, this.warnings);
    }

    public TopologyCheck getTopoChecker() {
        return this.topoChecker;
    }

    public List<TopologyCheck.Remedy> getRepairs() {
        return this.repairs.getRepairs();
    }

    private class Repairs {
        private final List<TopologyCheck.Remedy> creates = new ArrayList<TopologyCheck.Remedy>();
        private final List<TopologyCheck.Remedy> removes = new ArrayList<TopologyCheck.Remedy>();
        private final List<TopologyCheck.Remedy> other = new ArrayList<TopologyCheck.Remedy>();

        void clear() {
            this.creates.clear();
            this.removes.clear();
            this.other.clear();
        }

        void add(TopologyCheck.Remedy remedy) {
            switch (remedy.getType()) {
                case CREATE_RN: {
                    this.creates.add(remedy);
                    break;
                }
                case REMOVE_RN: {
                    this.removes.add(remedy);
                    break;
                }
                default: {
                    this.other.add(remedy);
                }
            }
        }

        List<TopologyCheck.Remedy> getRepairs() {
            ArrayList<TopologyCheck.Remedy> r = new ArrayList<TopologyCheck.Remedy>();
            r.addAll(this.creates);
            r.addAll(this.other);
            r.addAll(this.removes);
            return r;
        }

        boolean repairExists(RepNodeId rnId) {
            for (TopologyCheck.Remedy r : this.creates) {
                if (!r.getRNId().equals(rnId)) continue;
                return true;
            }
            for (TopologyCheck.Remedy r : this.other) {
                if (!r.getRNId().equals(rnId)) continue;
                return true;
            }
            for (TopologyCheck.Remedy r : this.removes) {
                if (!r.getRNId().equals(rnId)) continue;
                return true;
            }
            return false;
        }
    }

    public static class BadDowngrade
    implements Problem,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final ResourceId rId;
        private final String desc;

        BadDowngrade(ResourceId rId, KVVersion rVersion, KVVersion targetVersion, boolean showProgress, Logger logger) {
            this.rId = rId;
            this.desc = "Node cannot be downgraded to " + targetVersion.getNumericVersionString() + " because it is already at a newer minor version " + rVersion.getNumericVersionString();
            VerifyConfiguration.recordProgress(showProgress, logger, this);
        }

        @Override
        public ResourceId getResourceId() {
            return this.rId;
        }

        public String toString() {
            return this.desc;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.desc == null ? 0 : this.desc.hashCode());
            result = 31 * result + (this.rId == null ? 0 : this.rId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof BadDowngrade)) {
                return false;
            }
            BadDowngrade other = (BadDowngrade)obj;
            if (this.desc == null ? other.desc != null : !this.desc.equals(other.desc)) {
                return false;
            }
            return !(this.rId == null ? other.rId != null : !this.rId.equals(other.rId));
        }
    }

    public static class UpgradeNeeded
    implements Problem,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final ResourceId rId;
        private final String desc;

        UpgradeNeeded(ResourceId rId, KVVersion rVersion, KVVersion targetVersion, boolean showProgress, Logger logger) {
            this.rId = rId;
            this.desc = "Node needs to be upgraded from " + rVersion.getNumericVersionString() + " to version " + targetVersion.getNumericVersionString() + " or newer";
            VerifyConfiguration.recordProgress(showProgress, logger, this);
        }

        @Override
        public ResourceId getResourceId() {
            return this.rId;
        }

        public String toString() {
            return this.desc;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.desc == null ? 0 : this.desc.hashCode());
            result = 31 * result + (this.rId == null ? 0 : this.rId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof UpgradeNeeded)) {
                return false;
            }
            UpgradeNeeded other = (UpgradeNeeded)obj;
            if (this.desc == null ? other.desc != null : !this.desc.equals(other.desc)) {
                return false;
            }
            return !(this.rId == null ? other.rId != null : !this.rId.equals(other.rId));
        }
    }

    public static class VersionDifference
    implements Problem,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final StorageNodeId snId;
        private final String desc;

        VersionDifference(StorageNodeId snId, KVVersion snVersion, boolean showProgress, Logger logger) {
            this.snId = snId;
            this.desc = "Admin service version is " + KVVersion.CURRENT_VERSION + " but storage node version is " + snVersion;
            VerifyConfiguration.recordProgress(showProgress, logger, this);
        }

        @Override
        public ResourceId getResourceId() {
            return this.snId;
        }

        public String toString() {
            return this.desc;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.desc == null ? 0 : this.desc.hashCode());
            result = 31 * result + (this.snId == null ? 0 : this.snId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof VersionDifference)) {
                return false;
            }
            VersionDifference other = (VersionDifference)obj;
            if (this.desc == null ? other.desc != null : !this.desc.equals(other.desc)) {
                return false;
            }
            return !(this.snId == null ? other.snId != null : !this.snId.equals(other.snId));
        }
    }

    public static class ParamMismatch
    implements Problem,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final ResourceId rId;
        private final String mismatch;

        private static String getMismatchMessage(ParameterMap adminCopy, ParameterMap remoteCopy, ResourceId resourceId) {
            ParameterMap onRemoteButNotAdmin = adminCopy.diff(remoteCopy, false);
            ParameterMap onAdminButNotRemote = remoteCopy.diff(adminCopy, false);
            return "  Param on Admin but not on " + resourceId + " = " + onAdminButNotRemote.showContents(true) + eol + "  Param on " + resourceId + " but not on Admin = " + onRemoteButNotAdmin.showContents(true);
        }

        ParamMismatch(ResourceId rId, ParameterMap adminCopy, ParameterMap remoteCopy, boolean showProgress, Logger logger) {
            this(rId, ParamMismatch.getMismatchMessage(adminCopy, remoteCopy, rId), showProgress, logger);
        }

        ParamMismatch(ResourceId rId, String msg, boolean showProgress, Logger logger) {
            this.rId = rId;
            this.mismatch = msg;
            VerifyConfiguration.recordProgress(showProgress, logger, this);
        }

        @Override
        public ResourceId getResourceId() {
            return this.rId;
        }

        public String toString() {
            return "Mismatch between metadata in admin service and " + this.rId + ": " + eol + this.mismatch;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.mismatch == null ? 0 : this.mismatch.hashCode());
            result = 31 * result + (this.rId == null ? 0 : this.rId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ParamMismatch)) {
                return false;
            }
            ParamMismatch other = (ParamMismatch)obj;
            if (this.mismatch == null ? other.mismatch != null : !this.mismatch.equals(other.mismatch)) {
                return false;
            }
            return !(this.rId == null ? other.rId != null : !this.rId.equals(other.rId));
        }
    }

    public static class RMIFailed
    implements Problem,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final ResourceId rId;
        private final String desc;

        RMIFailed(ResourceId rId, RemoteException e, String methodName, boolean showProgress, Logger logger) {
            this.rId = rId;
            this.desc = methodName + " failed for " + rId + " : " + e.getMessage();
            VerifyConfiguration.recordProgress(showProgress, logger, this);
        }

        RMIFailed(ResourceId rId, NotBoundException e, boolean showProgress, Logger logger) {
            this.rId = rId;
            this.desc = "No RMI service for " + rId + ": service name=" + e.getMessage();
            VerifyConfiguration.recordProgress(showProgress, logger, this);
        }

        @Override
        public ResourceId getResourceId() {
            return this.rId;
        }

        public String toString() {
            return this.desc;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.desc == null ? 0 : this.desc.hashCode());
            result = 31 * result + (this.rId == null ? 0 : this.rId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof RMIFailed)) {
                return false;
            }
            RMIFailed other = (RMIFailed)obj;
            if (this.desc == null ? other.desc != null : !this.desc.equals(other.desc)) {
                return false;
            }
            return !(this.rId == null ? other.rId != null : !this.rId.equals(other.rId));
        }
    }

    public static class StatusNotRight
    implements Problem,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final ResourceId rId;
        private final ConfigurableService.ServiceStatus expected;
        private final ConfigurableService.ServiceStatus current;

        StatusNotRight(ResourceId rId, ConfigurableService.ServiceStatus expected, ConfigurableService.ServiceStatus current, boolean showProgress, Logger logger) {
            this.rId = rId;
            this.expected = expected;
            this.current = current;
            VerifyConfiguration.recordProgress(showProgress, logger, this);
        }

        @Override
        public ResourceId getResourceId() {
            return this.rId;
        }

        public String toString() {
            return "Expected status " + (Object)((Object)this.expected) + " but was " + (Object)((Object)this.current);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.current == null ? 0 : this.current.hashCode());
            result = 31 * result + (this.expected == null ? 0 : this.expected.hashCode());
            result = 31 * result + (this.rId == null ? 0 : this.rId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof StatusNotRight)) {
                return false;
            }
            StatusNotRight other = (StatusNotRight)obj;
            if (this.current != other.current) {
                return false;
            }
            if (this.expected != other.expected) {
                return false;
            }
            return !(this.rId == null ? other.rId != null : !this.rId.equals(other.rId));
        }
    }

    public static class ServiceStopped
    implements Problem,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final ResourceId rId;
        private final StorageNodeId snId;
        private final boolean isDisabled;

        ServiceStopped(ResourceId rId, StorageNodeId snId, boolean showProgress, Logger logger, boolean isDisabled) {
            this.rId = rId;
            this.snId = snId;
            this.isDisabled = isDisabled;
            VerifyConfiguration.recordProgress(showProgress, logger, this);
        }

        @Override
        public ResourceId getResourceId() {
            return this.rId;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.rId + " on " + this.snId);
            if (this.isDisabled) {
                sb.append(" was previously stopped and");
            }
            sb.append(" is not running. Consider restarting it with ");
            sb.append("'plan start-service'.");
            return sb.toString();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.rId == null ? 0 : this.rId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ServiceStopped)) {
                return false;
            }
            ServiceStopped other = (ServiceStopped)obj;
            return !(this.rId == null ? other.rId != null : !this.rId.equals(other.rId));
        }
    }

    public static interface Problem {
        public ResourceId getResourceId();
    }

    private class ExcludeDisableFilter
    extends MapFilter {
        private ExcludeDisableFilter() {
        }

        @Override
        ParameterMap filter(ParameterMap map) {
            HashSet<String> disableName = new HashSet<String>();
            disableName.add("disabled");
            return map.filter(disableName, false);
        }
    }

    private class SNPFilter
    extends MapFilter {
        private SNPFilter() {
        }

        @Override
        ParameterMap filter(ParameterMap map) {
            return map.filter(ParameterState.serviceParams, true);
        }
    }

    private class MapFilter {
        private MapFilter() {
        }

        ParameterMap filter(ParameterMap map) {
            return map.filter(ParameterState.skipParams, false);
        }
    }

    private static class RepNodeInfo {
        RepNodeStatus pingStatus;
        RemoteException pingRemoteException;
        NotBoundException pingNotBoundException;
        LoadParameters getParamsResult;
        RemoteException getParamsRemoteException;

        private RepNodeInfo() {
        }
    }

    static enum VerifyType {
        TOPOLOGY,
        UPGRADE,
        PREREQUISITE;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

