/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin;

import java.io.IOException;
import oracle.kv.impl.admin.DdlHandler;
import oracle.kv.impl.admin.NonfatalAssertionException;
import oracle.kv.impl.admin.plan.Plan;
import oracle.kv.impl.admin.plan.StatusReport;
import oracle.kv.impl.util.JsonUtils;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectWriter;
import org.codehaus.jackson.node.ObjectNode;

public class DdlResultsReport {
    private static int CURRENT_OUTPUT_VERSION = 2;
    public static String NOOP_STATUS_JSON = "{\n  \"version\" : \"" + CURRENT_OUTPUT_VERSION + "\",\n  \"comment\" : \"" + "Statement did not require execution" + "\"\n}";
    private static String R3_2_5_NOOP_JSON = "{\n  \"type\" : \"noop\",\n  \"comment\" : \"Statement did not require execution\"\n}";
    public static final String STATEMENT_COMPLETED = "Statement completed.";
    public static String STATEMENT_COMPLETED_JSON = "{\n  \"version\" : \"" + CURRENT_OUTPUT_VERSION + "\",\n  \"comment\" : \"" + "Statement completed." + "\"\n}";
    private final String status;
    private final String statusAsJson;
    private final String result;

    String getStatus() {
        return this.status;
    }

    String getStatusAsJson() {
        return this.statusAsJson;
    }

    DdlResultsReport(DdlHandler handler, short serialVersion) {
        this.result = handler.getResultString();
        if (serialVersion < 7) {
            if (this.result == null) {
                this.status = "Statement did not require execution";
                this.statusAsJson = R3_2_5_NOOP_JSON;
            } else {
                this.status = this.result;
                this.statusAsJson = this.make_R_3_2_5_showResult(handler);
            }
        } else if (this.result == null) {
            this.status = "Statement did not require execution";
            this.statusAsJson = NOOP_STATUS_JSON;
        } else {
            this.status = STATEMENT_COMPLETED;
            this.statusAsJson = STATEMENT_COMPLETED_JSON;
        }
    }

    DdlResultsReport(Plan p, short serialVersion) {
        StatusReport statusReport = new StatusReport(p, 1L);
        this.status = statusReport.display();
        ObjectWriter writer = JsonUtils.createWriter(true);
        ObjectNode o = JsonUtils.createObjectNode();
        if (serialVersion < 7) {
            o.put("type", "plan");
        } else {
            o.put("version", CURRENT_OUTPUT_VERSION);
        }
        JsonNode reportAsJson = statusReport.displayAsJson();
        o.put("planInfo", reportAsJson);
        try {
            this.statusAsJson = writer.writeValueAsString(o);
        }
        catch (IOException e) {
            throw new NonfatalAssertionException("Problem trying to construct JSON for " + reportAsJson + ": " + e);
        }
        this.result = null;
    }

    String getResult() {
        return this.result;
    }

    private String make_R_3_2_5_showResult(DdlHandler handler) {
        StringBuilder sb = new StringBuilder();
        sb.append("{").append("\n");
        sb.append("  \"").append("type").append("\" : \"");
        if (handler.isDescribe()) {
            sb.append("describe");
        } else if (handler.isShow()) {
            sb.append("show");
        } else assert (false) : "handler should be show or describe";
        sb.append("\",\n");
        sb.append("  \"result\" : ");
        sb.append(handler.getResultString()).append("\n").append("}");
        return sb.toString();
    }
}

