/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.hadoop.hive.table;

import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import oracle.kv.Consistency;
import oracle.kv.Direction;
import oracle.kv.ParamConstant;
import oracle.kv.hadoop.hive.table.V1V2TableUtil;
import oracle.kv.impl.util.ExternalDataSourceUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.metadata.DefaultStorageHandler;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.JobConf;

abstract class TableStorageHandlerBase<K extends WritableComparable<?>, V extends Writable>
extends DefaultStorageHandler {
    private static final Log LOG = LogFactory.getLog("oracle.kv.hadoop.hive.table.TableStorageHandlerBase");
    protected String kvStoreName = null;
    protected String[] kvHelperHosts = null;
    protected String[] kvHadoopHosts = null;
    protected String tableName = null;
    protected String primaryKeyProperty = null;
    protected String fieldRangeProperty = null;
    protected Direction direction = Direction.UNORDERED;
    protected Consistency consistency = null;
    protected long timeout = 0L;
    protected TimeUnit timeoutUnit = TimeUnit.MILLISECONDS;
    protected int maxRequests = 0;
    protected int batchSize = 0;
    protected int maxBatches = 0;
    protected String kvStoreSecurityFile = null;
    protected JobConf jobConf = new JobConf();

    protected TableStorageHandlerBase() {
    }

    public void configureInputJobProperties(TableDesc tableDesc, Map<String, String> jobProperties) {
        V1V2TableUtil.resetInputJobInfoForNewQuery();
        this.configureJobProperties(tableDesc, jobProperties);
    }

    public void configureOutputJobProperties(TableDesc tableDesc, Map<String, String> jobProperties) {
        this.configureJobProperties(tableDesc, jobProperties);
    }

    public void configureTableJobProperties(TableDesc tableDesc, Map<String, String> jobProperties) {
        this.configureJobProperties(tableDesc, jobProperties);
    }

    private void configureJobProperties(TableDesc tableDesc, Map<String, String> jobProperties) {
        Properties tableProperties = tableDesc.getProperties();
        this.kvStoreName = tableProperties.getProperty(ParamConstant.KVSTORE_NAME.getName());
        if (this.kvStoreName == null) {
            throw new IllegalArgumentException("No KV Store Name provided via the '" + ParamConstant.KVSTORE_NAME.getName() + "' property in the " + "TBLPROPERTIES clause.");
        }
        LOG.debug("kvStoreName = " + this.kvStoreName);
        jobProperties.put(ParamConstant.KVSTORE_NAME.getName(), this.kvStoreName);
        this.jobConf.set(ParamConstant.KVSTORE_NAME.getName(), this.kvStoreName);
        String kvHelperHostsStr = tableProperties.getProperty(ParamConstant.KVSTORE_NODES.getName());
        if (kvHelperHostsStr == null) {
            throw new IllegalArgumentException("No comma-separated list of hostname:port pairs (KV Helper Hosts) provided via the '" + ParamConstant.KVSTORE_NODES.getName() + "' property in the " + "TBLPROPERTIES clause.");
        }
        this.kvHelperHosts = kvHelperHostsStr.trim().split(",");
        jobProperties.put(ParamConstant.KVSTORE_NODES.getName(), kvHelperHostsStr);
        this.jobConf.set(ParamConstant.KVSTORE_NODES.getName(), kvHelperHostsStr);
        LOG.debug("kvHelperHosts = " + kvHelperHostsStr);
        String kvHadoopHostsStr = tableProperties.getProperty(ParamConstant.KVHADOOP_NODES.getName());
        if (kvHadoopHostsStr != null) {
            this.kvHadoopHosts = kvHadoopHostsStr.trim().split(",");
        } else {
            this.kvHadoopHosts = new String[this.kvHelperHosts.length];
            StringBuilder hadoopBuf = new StringBuilder();
            for (int i = 0; i < this.kvHelperHosts.length; ++i) {
                String[] hostPort = this.kvHelperHosts[i].trim().split(":");
                this.kvHadoopHosts[i] = hostPort[0];
                if (i != 0) {
                    hadoopBuf.append(",");
                }
                hadoopBuf.append(this.kvHadoopHosts[i]);
            }
            kvHadoopHostsStr = hadoopBuf.toString();
        }
        jobProperties.put(ParamConstant.KVHADOOP_NODES.getName(), kvHadoopHostsStr);
        this.jobConf.set(ParamConstant.KVHADOOP_NODES.getName(), kvHadoopHostsStr);
        LOG.debug("kvHadoopHosts = " + kvHadoopHostsStr);
        this.tableName = tableProperties.getProperty(ParamConstant.TABLE_NAME.getName());
        if (this.tableName == null) {
            throw new IllegalArgumentException("No KV Store Table Name provided via the '" + ParamConstant.TABLE_NAME.getName() + "' property in the " + "TBLPROPERTIES clause.");
        }
        jobProperties.put(ParamConstant.TABLE_NAME.getName(), this.tableName);
        this.jobConf.set(ParamConstant.TABLE_NAME.getName(), this.tableName);
        LOG.debug("tableName = " + this.tableName);
        this.primaryKeyProperty = tableProperties.getProperty(ParamConstant.PRIMARY_KEY.getName());
        if (this.primaryKeyProperty != null) {
            jobProperties.put(ParamConstant.PRIMARY_KEY.getName(), this.primaryKeyProperty);
            this.jobConf.set(ParamConstant.PRIMARY_KEY.getName(), this.primaryKeyProperty);
        }
        LOG.debug("primaryKeyProperty = " + this.primaryKeyProperty);
        this.fieldRangeProperty = tableProperties.getProperty(ParamConstant.FIELD_RANGE.getName());
        if (this.fieldRangeProperty != null) {
            jobProperties.put(ParamConstant.FIELD_RANGE.getName(), this.fieldRangeProperty);
            this.jobConf.set(ParamConstant.FIELD_RANGE.getName(), this.fieldRangeProperty);
        }
        LOG.debug("fieldRangeProperty = " + this.fieldRangeProperty);
        String consistencyStr = tableProperties.getProperty(ParamConstant.CONSISTENCY.getName());
        if (consistencyStr != null) {
            this.consistency = ExternalDataSourceUtils.parseConsistency(consistencyStr);
            jobProperties.put(ParamConstant.CONSISTENCY.getName(), consistencyStr);
            this.jobConf.set(ParamConstant.CONSISTENCY.getName(), consistencyStr);
        }
        LOG.debug("consistency = " + consistencyStr);
        String timeoutStr = tableProperties.getProperty(ParamConstant.TIMEOUT.getName());
        if (timeoutStr != null) {
            this.timeout = ExternalDataSourceUtils.parseTimeout(timeoutStr);
            this.timeoutUnit = TimeUnit.MILLISECONDS;
            jobProperties.put(ParamConstant.TIMEOUT.getName(), timeoutStr);
            this.jobConf.set(ParamConstant.TIMEOUT.getName(), timeoutStr);
        }
        LOG.debug("timeout = " + this.timeout);
        String maxRequestsStr = tableProperties.getProperty(ParamConstant.MAX_REQUESTS.getName());
        if (maxRequestsStr != null) {
            try {
                this.maxRequests = Integer.parseInt(maxRequestsStr);
                jobProperties.put(ParamConstant.MAX_REQUESTS.getName(), maxRequestsStr);
                this.jobConf.set(ParamConstant.MAX_REQUESTS.getName(), maxRequestsStr);
            }
            catch (NumberFormatException NFE) {
                LOG.warn("Invalid value for " + ParamConstant.MAX_REQUESTS.getName() + " [" + maxRequestsStr + "]: proceeding with value determined " + "by system");
            }
        }
        LOG.debug("maxRequests = " + this.maxRequests);
        String batchSizeStr = tableProperties.getProperty(ParamConstant.BATCH_SIZE.getName());
        if (batchSizeStr != null) {
            try {
                this.batchSize = Integer.parseInt(batchSizeStr);
                jobProperties.put(ParamConstant.BATCH_SIZE.getName(), batchSizeStr);
                this.jobConf.set(ParamConstant.BATCH_SIZE.getName(), batchSizeStr);
            }
            catch (NumberFormatException NFE) {
                LOG.warn("Invalid value for " + ParamConstant.BATCH_SIZE.getName() + " [" + batchSizeStr + "]: proceeding with value determined " + "by system");
            }
        }
        LOG.debug("batchSize = " + this.batchSize);
        String maxBatchesStr = tableProperties.getProperty(ParamConstant.MAX_BATCHES.getName());
        if (maxBatchesStr != null) {
            try {
                this.maxBatches = Integer.parseInt(maxBatchesStr);
                jobProperties.put(ParamConstant.MAX_BATCHES.getName(), maxBatchesStr);
                this.jobConf.set(ParamConstant.MAX_BATCHES.getName(), maxBatchesStr);
            }
            catch (NumberFormatException NFE) {
                LOG.warn("Invalid value for " + ParamConstant.MAX_BATCHES.getName() + " [" + maxBatchesStr + "]: proceeding with value determined " + "by system");
            }
        }
        LOG.debug("maxBatches = " + this.maxBatches);
        this.kvStoreSecurityFile = tableProperties.getProperty(ParamConstant.KVSTORE_SECURITY.getName());
        if (this.kvStoreSecurityFile != null) {
            jobProperties.put(ParamConstant.KVSTORE_SECURITY.getName(), this.kvStoreSecurityFile);
            this.jobConf.set(ParamConstant.KVSTORE_SECURITY.getName(), this.kvStoreSecurityFile);
        }
        LOG.debug("kvStoreSecurityFile = " + this.kvStoreSecurityFile);
        this.setConf(new Configuration((Configuration)this.jobConf));
    }
}

