/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv;

import com.sleepycat.je.utilint.PropUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import oracle.kv.FaultException;
import oracle.kv.impl.util.FastExternalizable;

public abstract class Consistency
implements FastExternalizable,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final Consistency NONE_REQUIRED = new NoneRequired();
    public static final Consistency ABSOLUTE = new Absolute();
    public static final Consistency NONE_REQUIRED_NO_MASTER = new NoneRequiredNoMaster();
    private static final SerialType[] SERIAL_TYPES_BY_ORDINAL;

    private static SerialType getSerialType(int ordinal) {
        if (ordinal < 0 || ordinal >= SERIAL_TYPES_BY_ORDINAL.length) {
            throw new RuntimeException("unknown SerialType: " + ordinal);
        }
        return SERIAL_TYPES_BY_ORDINAL[ordinal];
    }

    Consistency() {
    }

    public static Consistency readFastExternal(ObjectInput in, short serialVersion) throws IOException {
        SerialType type = Consistency.getSerialType(in.readUnsignedByte());
        return type.readConsistency(in, serialVersion);
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(200);
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeShort(7);
            this.writeFastExternal(oos, (short)7);
            oos.flush();
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new FaultException(e, false);
        }
    }

    public static Consistency fromByteArray(byte[] keyBytes) {
        ByteArrayInputStream bais = new ByteArrayInputStream(keyBytes);
        try {
            ObjectInputStream ois = new ObjectInputStream(bais);
            short serialVersion = ois.readShort();
            return Consistency.readFastExternal(ois, serialVersion);
        }
        catch (IOException e) {
            throw new FaultException(e, false);
        }
    }

    public abstract String getName();

    static {
        EnumSet<SerialType> set = EnumSet.allOf(SerialType.class);
        SERIAL_TYPES_BY_ORDINAL = new SerialType[set.size()];
        Iterator i$ = set.iterator();
        while (i$.hasNext()) {
            SerialType op;
            Consistency.SERIAL_TYPES_BY_ORDINAL[op.ordinal()] = op = (SerialType)((Object)i$.next());
        }
    }

    public static class Time
    extends Consistency {
        private static final long serialVersionUID = 1L;
        private static final String NAME = "Consistency.Time";
        private final int permissibleLag;
        private final int timeout;

        public Time(long permissibleLag, TimeUnit permissibleLagUnit, long timeout, TimeUnit timeoutUnit) {
            this.permissibleLag = PropUtil.durationToMillis(permissibleLag, permissibleLagUnit);
            this.timeout = PropUtil.durationToMillis(timeout, timeoutUnit);
        }

        Time(ObjectInput in, short serialVersion) throws IOException {
            this.permissibleLag = in.readInt();
            this.timeout = in.readInt();
        }

        @Override
        public void writeFastExternal(ObjectOutput out, short serialVersion) throws IOException {
            out.writeByte(SerialType.TIME_TYPE.ordinal());
            out.writeInt(this.permissibleLag);
            out.writeInt(this.timeout);
        }

        @Override
        public String getName() {
            return NAME;
        }

        public long getPermissibleLag(TimeUnit unit) {
            return PropUtil.millisToDuration(this.permissibleLag, unit);
        }

        public long getTimeout(TimeUnit unit) {
            return PropUtil.millisToDuration(this.timeout, unit);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.permissibleLag;
            result = 31 * result + this.timeout;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Time other = (Time)obj;
            if (this.permissibleLag != other.permissibleLag) {
                return false;
            }
            return this.timeout == other.timeout;
        }

        public String toString() {
            return this.getName() + " permissibleLag=" + this.permissibleLag;
        }
    }

    public static class Version
    extends Consistency {
        private static final long serialVersionUID = 1L;
        private static final String NAME = "Consistency.Version";
        private final oracle.kv.Version version;
        private final int timeout;

        public Version(oracle.kv.Version version, long timeout, TimeUnit timeoutUnit) {
            if (version == null) {
                throw new IllegalArgumentException("version must not be null");
            }
            this.version = version;
            this.timeout = PropUtil.durationToMillis(timeout, timeoutUnit);
        }

        Version(ObjectInput in, short serialVersion) throws IOException {
            this.version = new oracle.kv.Version(in, serialVersion);
            this.timeout = in.readInt();
        }

        @Override
        public void writeFastExternal(ObjectOutput out, short serialVersion) throws IOException {
            out.writeByte(SerialType.VERSION_TYPE.ordinal());
            this.version.writeFastExternal(out, serialVersion);
            out.writeInt(this.timeout);
        }

        @Override
        public String getName() {
            return NAME;
        }

        public oracle.kv.Version getVersion() {
            return this.version;
        }

        public long getTimeout(TimeUnit unit) {
            return PropUtil.millisToDuration(this.timeout, unit);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
            result = 31 * result + this.timeout;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Version)) {
                return false;
            }
            Version other = (Version)obj;
            if (this.version == null ? other.version != null : !this.version.equals(other.version)) {
                return false;
            }
            return this.timeout == other.timeout;
        }

        public String toString() {
            return this.getName() + " version=" + this.version;
        }
    }

    private static class NoneRequiredNoMaster
    extends Consistency {
        private static final long serialVersionUID = 1L;
        private static final String NAME = "Consistency.NoneRequiredNoMaster";

        NoneRequiredNoMaster() {
        }

        @Override
        public void writeFastExternal(ObjectOutput out, short serialVersion) throws IOException {
            out.writeByte(SerialType.NONE_REQUIRED_NO_MASTER_TYPE.ordinal());
        }

        @Override
        public String getName() {
            return NAME;
        }

        public int hashCode() {
            return 43;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            return obj instanceof NoneRequiredNoMaster;
        }

        public String toString() {
            return this.getName();
        }
    }

    private static class Absolute
    extends Consistency {
        private static final long serialVersionUID = 1L;
        private static final String NAME = "Consistency.Absolute";

        Absolute() {
        }

        @Override
        public void writeFastExternal(ObjectOutput out, short serialVersion) throws IOException {
            out.writeByte(SerialType.ABSOLUTE_TYPE.ordinal());
        }

        @Override
        public String getName() {
            return NAME;
        }

        public int hashCode() {
            return 37;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            return obj instanceof Absolute;
        }

        public String toString() {
            return this.getName();
        }
    }

    private static class NoneRequired
    extends Consistency {
        private static final long serialVersionUID = 1L;
        private static final String NAME = "Consistency.NoneRequired";

        NoneRequired() {
        }

        @Override
        public void writeFastExternal(ObjectOutput out, short serialVersion) throws IOException {
            out.writeByte(SerialType.NONE_REQUIRED_TYPE.ordinal());
        }

        @Override
        public String getName() {
            return NAME;
        }

        public int hashCode() {
            return 31;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            return obj instanceof NoneRequired;
        }

        public String toString() {
            return this.getName();
        }
    }

    private static enum SerialType {
        NONE_REQUIRED_TYPE{

            @Override
            Consistency readConsistency(ObjectInput in, short serialVersion) throws IOException {
                return NONE_REQUIRED;
            }
        }
        ,
        ABSOLUTE_TYPE{

            @Override
            Consistency readConsistency(ObjectInput in, short serialVersion) throws IOException {
                return ABSOLUTE;
            }
        }
        ,
        VERSION_TYPE{

            @Override
            Consistency readConsistency(ObjectInput in, short serialVersion) throws IOException {
                return new Version(in, serialVersion);
            }
        }
        ,
        TIME_TYPE{

            @Override
            Consistency readConsistency(ObjectInput in, short serialVersion) throws IOException {
                return new Time(in, serialVersion);
            }
        }
        ,
        NONE_REQUIRED_NO_MASTER_TYPE{

            @Override
            Consistency readConsistency(ObjectInput in, short serialVersion) throws IOException {
                return NONE_REQUIRED_NO_MASTER;
            }
        };


        abstract Consistency readConsistency(ObjectInput var1, short var2) throws IOException;
    }
}

