/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.theme;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OraclePreparedStatement;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.RenderingRule;
import oracle.mapviewer.share.ext.NSDataSet;
import oracle.mapviewer.share.ext.NSRow;
import oracle.mapviewer.share.ext.NsDpInfo;
import oracle.mapviewer.share.util.LogFactory;
import oracle.mapviewer.share.util.SharedUtils;
import oracle.mapviewer.utils.MapCSBean;
import oracle.sdovis.NsDpHandler;
import oracle.sdovis.VisContext;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.ds.DSUtil;
import oracle.sdovis.query.SDOBoxFilter;
import oracle.sdovis.query.SpatialOp;
import oracle.sdovis.style.StylingRule;
import oracle.sdovis.theme.DynGeomThemeProducer;
import oracle.sdovis.theme.PredGeomThemeDefinition;
import oracle.sdovis.util.Util;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;

public class PredGeomThemeQueryHelper {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    transient PredGeomThemeDefinition def = null;
    String baseQuery = null;
    boolean is9i = false;
    boolean isPassThrough = false;
    int mSrid = 0;
    String mTable = null;
    String mGeomColumn = null;
    String mKeyColumn = null;
    int[] bindingVaraiblesNumArray = null;
    int totalBindingVariablesNum = 0;
    boolean isSTgeometry = false;
    String dbType = "ORACLE";
    static String NSDPFilter = " AND #NSDPCOL# IN (select * from TABLE (:NSDPVLIST) )";

    public PredGeomThemeQueryHelper(PredGeomThemeDefinition def) {
        this.def = def;
        this.is9i = def.is9i();
        this.isPassThrough = def.isQueryPassThrough();
        this.mSrid = def.getSrid();
        this.mTable = def.getBaseTable();
        this.mGeomColumn = def.getGeomColumn();
        this.mKeyColumn = def.getKeyColumn();
        if (def.getTableAlias() != null) {
            this.mTable = this.mTable + " " + def.getTableAlias();
            if (this.mGeomColumn.toUpperCase().indexOf("MDSYS.") == -1) {
                this.mGeomColumn = def.getTableAlias() + "." + this.mGeomColumn;
            }
        }
        this.isSTgeometry = Util.isSTGeometryType(def.getBaseColumnType());
        if (this.isSTgeometry && def.getTableAlias() == null) {
            this.mTable = def.getBaseTable() + " " + "st_mv_table";
            if (this.mGeomColumn.toUpperCase().indexOf("MDSYS.") == -1) {
                this.mGeomColumn = "st_mv_table." + def.getGeomColumn();
            }
        }
        if (def != null && def.getDataSourceName() != null) {
            this.dbType = DSManager.getDataSourceType(def.getDataSourceName());
        }
        this.createBaseQuery();
    }

    public PredGeomThemeQueryHelper() {
    }

    public boolean isPassThrough() {
        return this.isPassThrough;
    }

    public String getGeomColumn() {
        return this.mGeomColumn;
    }

    public String getBaseQuery() {
        return this.baseQuery;
    }

    public void createBaseQuery() {
        if (this.def == null) {
            throw new IllegalArgumentException("theme definition is null.");
        }
        StylingRule[] rules = this.def.getStylingRules();
        ArrayList<String> attrs = new ArrayList<String>(8);
        if (rules != null) {
            for (int i = 0; i < rules.length; ++i) {
                RenderingRule[] rrules;
                String[] attrColumns = rules[i].getAttributeColumnsAsArray();
                if (attrColumns != null) {
                    for (int k = 0; k < attrColumns.length; ++k) {
                        String upAttr = attrColumns[k].toUpperCase();
                        if (attrs.contains(upAttr)) continue;
                        attrs.add(upAttr);
                    }
                }
                if ((rrules = rules[i].getRenderingRules()) == null) continue;
                for (int k = 0; k < rrules.length; ++k) {
                    String[] styleColumns = rrules[k].getStyleColumns();
                    if (styleColumns != null) {
                        for (int l = 0; l < styleColumns.length; ++l) {
                            String styColumn = styleColumns[l].toUpperCase();
                            if (attrs.contains(styColumn)) continue;
                            attrs.add(styColumn);
                        }
                    }
                    String substyle = rrules[k].getSubStyleName();
                    String[] subColumns = rrules[k].getSubStyleColumns();
                    if (subColumns == null) continue;
                    for (int l = 0; l < subColumns.length; ++l) {
                        String styColumn = subColumns[l].toUpperCase();
                        if (attrs.contains(styColumn)) continue;
                        attrs.add(styColumn);
                    }
                }
            }
        }
        if (this.def != null && this.def.getIdentifiableColumns() != null) {
            Field[] infoCols = this.def.getIdentifiableColumns();
            for (int k = 0; k < infoCols.length; ++k) {
                int idx = attrs.indexOf(infoCols[k].getName());
                if (idx >= 0) continue;
                attrs.add(infoCols[k].getName());
            }
        }
        String orderByClause = "";
        if (rules[0].getOrderByColumns() != null) {
            if (rules.length > 1 && !attrs.contains(rules[0].getOrderByColumns())) {
                attrs.add(rules[0].getOrderByColumns());
            }
            orderByClause = " ORDER BY " + rules[0].getOrderByColumns() + " ";
            if (rules[0].getSortOrder() != null) {
                orderByClause = orderByClause + rules[0].getSortOrder() + " ";
            }
        }
        String attrColumns = "";
        for (int i = 0; i < attrs.size(); ++i) {
            attrColumns = attrColumns + ", " + attrs.get(i);
        }
        String spatialIndexHint = "";
        if (this.def.isSpatialIndexHintEnabled() && this.def.getRtreeIndexName() != null) {
            spatialIndexHint = "/*+ index(";
            spatialIndexHint = this.def.getTableAlias() != null ? spatialIndexHint + this.def.getTableAlias() : spatialIndexHint + this.def.getBaseTable();
            spatialIndexHint = spatialIndexHint + " " + this.def.getRtreeIndexName() + ") */ ";
        }
        log.finest("Theme " + this.def.getName() + " uses index hint: " + spatialIndexHint);
        if (rules == null || rules.length < 1) {
            if (this.dbType.equalsIgnoreCase("ORACLE")) {
                this.baseQuery = "SELECT " + spatialIndexHint + this.mKeyColumn + ", " + "#GEOMCOL#" + ", null, null, null, -1," + "'rule#" + "-1'" + attrColumns + " FROM " + this.mTable;
            } else {
                String key = this.mKeyColumn;
                if (this.mKeyColumn.equalsIgnoreCase("rowid")) {
                    key = "'rowid'";
                }
                this.baseQuery = "SELECT " + key + ", " + "#GEOMCOL#" + ", '', '', '', -1," + "'rule#" + "-1'" + attrColumns + " FROM " + this.mTable;
            }
            this.baseQuery = this.baseQuery + " WHERE #SDOOP#";
            this.bindingVaraiblesNumArray = new int[1];
            this.bindingVaraiblesNumArray[0] = 0;
            this.totalBindingVariablesNum = 0;
            log.finest("base-query: " + this.baseQuery);
            return;
        }
        this.baseQuery = "";
        this.bindingVaraiblesNumArray = new int[rules.length];
        this.totalBindingVariablesNum = 0;
        for (int i = 0; i < rules.length; ++i) {
            this.bindingVaraiblesNumArray[i] = 0;
            StylingRule rule = rules[i];
            String subQuery = null;
            if (this.dbType.equalsIgnoreCase("ORACLE")) {
                subQuery = "SELECT " + spatialIndexHint + this.mKeyColumn + ", " + "#GEOMCOL#" + ", '" + rule.getFeatureStyleName() + "', " + rule.getLabelColumn() + ", '" + rule.getLabelStyleName() + "', " + rule.getLabelFunction() + ", 'rule#" + i + "'" + attrColumns + " FROM " + this.mTable;
            } else {
                String lbcol;
                String key = this.mKeyColumn;
                if (this.mKeyColumn.equalsIgnoreCase("rowid")) {
                    key = "'rowid'";
                }
                if ((lbcol = rule.getLabelColumn()) == null) {
                    lbcol = "''";
                }
                subQuery = "SELECT " + key + ", " + "#GEOMCOL#" + ", '" + rule.getFeatureStyleName() + "', " + lbcol + ", '" + rule.getLabelStyleName() + "', " + rule.getLabelFunction() + ", 'rule#" + i + "'" + attrColumns + " FROM " + this.mTable;
            }
            subQuery = subQuery + " WHERE #SDOOP# #NSDPFLTROP#";
            String cond = rules[i].getFeatureCond();
            if (cond != null) {
                subQuery = subQuery + " AND " + cond;
                this.bindingVaraiblesNumArray[i] = SharedUtils.countBindingVariables(cond);
                this.totalBindingVariablesNum += this.bindingVaraiblesNumArray[i];
            }
            if (rules.length == 1) {
                this.baseQuery = subQuery;
                continue;
            }
            if (i > 0) {
                this.baseQuery = this.baseQuery + " UNION ALL ";
            }
            this.baseQuery = this.baseQuery + subQuery;
        }
        this.baseQuery = this.baseQuery + orderByClause;
        log.finest("Theme base-query [" + this.def.getName() + "]: " + this.baseQuery);
    }

    public String buildQueryString(boolean isFullExt, SpatialOp op, VisContext vc, boolean isOracleDB) {
        String nsdpPred;
        if (this.isPassThrough) {
            isFullExt = true;
        }
        String query = this.baseQuery;
        boolean csTransform = false;
        if (isOracleDB && this.def.getSrid() > 0 && vc.getMasterSRID() > 0 && this.def.getSrid() != vc.getMasterSRID()) {
            csTransform = true;
        }
        if (MapCSBean.supported(this.def.getSrid(), vc.getMasterSRID())) {
            csTransform = false;
            log.fine("Mid-tier will carry out CS transform: " + this.def.getSrid() + " to " + vc.getMasterSRID());
        }
        boolean pinned = this.def.getCachingMode() == 2;
        String stComplement = "";
        if (this.isSTgeometry) {
            stComplement = ".geom";
        }
        if (!csTransform) {
            query = pinned ? query.replaceAll("#GEOMCOL#", "null") : query.replaceAll("#GEOMCOL#", this.mGeomColumn + stComplement);
        } else {
            String csCol = "sdo_cs.transform(" + this.mGeomColumn + "," + vc.getMasterSRID() + ")";
            query = query.replaceAll("#GEOMCOL#", csCol);
        }
        if (isFullExt || !isOracleDB) {
            query = query.replaceAll("#SDOOP#", SDOBoxFilter.TRUE4EVER);
            nsdpPred = this.buildNSDPFilter(vc);
            query = query.replaceAll("#NSDPFLTROP#", nsdpPred);
            return query;
        }
        if (op != null) {
            String spatialPred = op.getSpatialPredicate();
            query = query.replaceAll("#SDOOP#", spatialPred);
        } else {
            query = query.replaceAll("#SDOOP#", SDOBoxFilter.TRUE4EVER);
        }
        if (this.isSTgeometry && op != null) {
            query = query.replaceAll(", 'querytype=WINDOW'", "");
        }
        nsdpPred = this.buildNSDPFilter(vc);
        query = query.replaceAll("#NSDPFLTROP#", nsdpPred);
        return query;
    }

    public PreparedStatement prepare(Connection conn, String query, SpatialOp op, Object[] bindingVariables, VisContext vc) throws SQLException, IllegalArgumentException {
        StylingRule[] rules;
        if (query == null) {
            throw new IllegalArgumentException("query string is null!");
        }
        if (bindingVariables == null && this.totalBindingVariablesNum > 0 || bindingVariables != null && bindingVariables.length < this.totalBindingVariablesNum) {
            throw new IllegalArgumentException("Not enough binding variables!");
        }
        boolean bindNsdp = false;
        NsDpHandler nsdp = this.getNsdpHandler(vc);
        if (nsdp != null && query.indexOf(":NSDPVLIST") >= 0) {
            bindNsdp = true;
        }
        if (bindNsdp && nsdp.getData() == null) {
            throw new SQLException("NSDP contains no data. Theme query will not be executed for " + this.def.getName() + ".");
        }
        PreparedStatement ps = conn.prepareStatement(query);
        if (op != null && !this.isPassThrough && conn.getMetaData().getDatabaseProductName().toUpperCase().indexOf("ORACLE") > -1) {
            op.prepare(ps);
        }
        if (bindNsdp) {
            this.bindNsdpData(ps, nsdp, conn);
        }
        if ((rules = this.def.getStylingRules()) != null && rules.length > 0) {
            int varCount = 0;
            int bIdx = 0;
            for (int i = 0; i < rules.length; ++i) {
                if (op != null && !this.isPassThrough) {
                    varCount += op.getNumBindingVariables();
                }
                if (bindNsdp) {
                    ++varCount;
                }
                for (int j = 0; j < this.bindingVaraiblesNumArray[i]; ++j) {
                    DynGeomThemeProducer.setBindingVariable(conn, ps, bindingVariables[bIdx++], ++varCount);
                }
            }
        }
        return ps;
    }

    private NsDpHandler getNsdpHandler(VisContext vc) {
        if (vc == null) {
            return null;
        }
        Vector v = vc.getNsDpHandlers();
        if (v == null) {
            return null;
        }
        for (int i = 0; i < v.size(); ++i) {
            NsDpHandler handler = (NsDpHandler)v.get(i);
            NsDpInfo temp = handler.getDef();
            String themeName = temp.getTheme();
            if (themeName == null || !themeName.equalsIgnoreCase(this.def.name)) continue;
            return handler;
        }
        return null;
    }

    private String buildNSDPFilter(VisContext vc) {
        boolean hasData;
        NsDpHandler ndh = this.getNsdpHandler(vc);
        if (ndh == null) {
            return "";
        }
        NsDpInfo ndi = ndh.getDef();
        if (ndi == null) {
            return "";
        }
        boolean showUnmatched = ndi.isShowUnmatched();
        if (showUnmatched) {
            return "";
        }
        NSDataSet data = ndh.getData();
        boolean bl = hasData = data != null && data.size() > 0;
        if (!hasData) {
            log.warning("Your NSDP data set contains no data yet; no DB filtering will be done!");
            return "";
        }
        String res = NSDPFilter;
        res = res.replaceAll("#NSDPCOL#", ndi.getJoinColumnSpatial());
        return res;
    }

    private void bindNsdpData(PreparedStatement ps, NsDpHandler nsdp, Connection conn) {
        Field key;
        int type;
        NSDataSet ds = nsdp.getData();
        NSRow[] rows = ds.getRows();
        NSRow row = rows[0];
        for (int i = 0; i < rows.length && (type = (key = (row = rows[i]).getKeyAttribute()).getType()) == 0; ++i) {
        }
        ARRAY array = null;
        try {
            Object[] a;
            key = row.getKeyAttribute();
            String etype = null;
            int type2 = key.getType();
            if (type2 == 8) {
                etype = "string";
                a = new String[rows.length];
                for (int i = 0; i < rows.length; ++i) {
                    a[i] = rows[i].getKeyAttribute().getString();
                }
                Level glevel = log.getLevel();
                if (glevel == Level.FINEST) {
                    StringBuffer sb = new StringBuffer("NSDP keys begin: \n");
                    for (int i = 0; i < rows.length; ++i) {
                        sb.append(a[i]).append("\n");
                    }
                    sb.append("NSDP keys end.");
                    log.finest(sb.toString());
                }
                ArrayDescriptor ad = DSUtil.getArrayDescriptor(conn, "string", false);
                array = new ARRAY(ad, conn, (Object)a);
            } else if (type2 == 3) {
                etype = "number";
                a = new int[rows.length];
                for (int i = 0; i < rows.length; ++i) {
                    a[i] = (String)rows[i].getKeyAttribute().getInt();
                }
                ArrayDescriptor ad = DSUtil.getArrayDescriptor(conn, "number", false);
                array = new ARRAY(ad, conn, (Object)a);
            } else if (type2 == 4) {
                etype = "number";
                a = new long[rows.length];
                for (int i = 0; i < rows.length; ++i) {
                    a[i] = (String)rows[i].getKeyAttribute().getLong();
                }
                ArrayDescriptor ad = DSUtil.getArrayDescriptor(conn, "number", false);
                array = new ARRAY(ad, conn, (Object)a);
            } else if (type2 == 6) {
                etype = "number";
                a = new double[rows.length];
                for (int i = 0; i < rows.length; ++i) {
                    a[i] = (String)rows[i].getKeyAttribute().getDouble();
                }
                ArrayDescriptor ad = DSUtil.getArrayDescriptor(conn, "number", false);
                array = new ARRAY(ad, conn, (Object)a);
            } else if (type2 == 5) {
                etype = "number";
                a = new float[rows.length];
                for (int i = 0; i < rows.length; ++i) {
                    a[i] = (String)rows[i].getKeyAttribute().getFloat();
                }
                ArrayDescriptor ad = DSUtil.getArrayDescriptor(conn, "number", false);
                array = new ARRAY(ad, conn, (Object)a);
            } else if (type2 == 10) {
                etype = "date";
                a = new Date[rows.length];
                for (int i = 0; i < rows.length; ++i) {
                    long time = rows[i].getKeyAttribute().getDate();
                    a[i] = new Date(time);
                }
                ArrayDescriptor ad = DSUtil.getArrayDescriptor(conn, "date", false);
                array = new ARRAY(ad, conn, (Object)a);
            } else {
                log.info("NSDP key-column data type not supported: " + type2 + ".");
            }
            if (array == null) {
                log.info("No valid NSDP data found. Using an empty ARRAY as binding value.");
                ArrayDescriptor ad = DSUtil.getArrayDescriptor(conn, "string", false);
                array = new ARRAY(ad, conn, (Object)new String[0]);
            }
            if (array != null) {
                OraclePreparedStatement ops = (OraclePreparedStatement)ps;
                ops.setARRAYAtName("NSDPVLIST", array);
            }
        }
        catch (Exception ex) {
            log.warning("error binding NSDP data to a theme: " + ex.getMessage());
        }
    }
}

