/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.theme;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dms.instrument.PhaseEvent;
import oracle.jdbc.OracleResultSet;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.RenderingRule;
import oracle.mapviewer.share.util.LogFactory;
import oracle.mapviewer.share.util.SensorCreator;
import oracle.mapviewer.utils.MapCSBean;
import oracle.sdovis.BuiltinStyles;
import oracle.sdovis.CacheMgr2;
import oracle.sdovis.DataException;
import oracle.sdovis.Graticule;
import oracle.sdovis.HMPointFeature;
import oracle.sdovis.JSDOGeometry;
import oracle.sdovis.LocalTheme;
import oracle.sdovis.MapMaker;
import oracle.sdovis.Proj;
import oracle.sdovis.RSBundle;
import oracle.sdovis.SRS;
import oracle.sdovis.SRSCache;
import oracle.sdovis.StyledFeature;
import oracle.sdovis.StyledFeatureI;
import oracle.sdovis.Theme;
import oracle.sdovis.VisContext;
import oracle.sdovis.cache.CacheGroup;
import oracle.sdovis.ds.AbstractDBDataSource;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.ds.DSUtil;
import oracle.sdovis.ppp.CSTransformP3;
import oracle.sdovis.ppp.PPPInterface;
import oracle.sdovis.query.SDOBoxFilter;
import oracle.sdovis.query.SpatialOp;
import oracle.sdovis.style.Style;
import oracle.sdovis.style.StylingRule;
import oracle.sdovis.theme.LocalThemeDataProducer;
import oracle.sdovis.theme.PredGeomThemeDefinition;
import oracle.sdovis.theme.PredGeomThemeQueryHelper;
import oracle.sdovis.theme.ThemeDataProducer;
import oracle.sdovis.theme.ThemeUtils;
import oracle.sdovis.util.I18nUtil;
import oracle.sdovis.util.JDBCUtil;
import oracle.sdovis.util.TopThemeQueries;
import oracle.sdovis.util.Util;
import oracle.spatial.geometry.JGeometry;

public class PredGeomThemeProducer
implements ThemeDataProducer {
    private static final Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    private static final PhaseEvent predGeomSensor = SensorCreator.createPhaseEvent(SensorCreator.NounsEnum.THEMEPRODUCER, "PredGeom", "Producer", "Time spent preparing data");
    protected Theme owner;
    protected PredGeomThemeDefinition def;
    LocalThemeDataProducer features;
    Rectangle2D mDataExtent;
    private Object[] bindingParameters = null;
    private PreparedStatement stmt = null;
    private boolean aborted = false;
    private double[] queryMBR = new double[]{Double.NaN, Double.NaN, Double.NaN, Double.NaN};
    private double[] queryMBR2 = new double[]{Double.NaN, Double.NaN, Double.NaN, Double.NaN};
    private long maxFeaturesToBePrepared = -1L;
    private long loadedFeaturesInAdjustedMBR = 0L;
    private String resourceClass = null;
    private List<PPPInterface> p3List = null;
    private static final int YIELD_COUNT = 1000;

    private PredGeomThemeProducer() {
    }

    public PredGeomThemeProducer(Theme t, Object[] bindingVariables) {
        this.owner = t;
        this.def = (PredGeomThemeDefinition)t.getDefinition();
        PredGeomThemeQueryHelper queryHelper = this.def.getQueryHelper();
        if (queryHelper == null) {
            queryHelper = new PredGeomThemeQueryHelper(this.def);
            this.def.setQueryHelper(queryHelper);
        }
        this.bindingParameters = bindingVariables;
        this.resourceClass = this.def.getResourceClassName();
    }

    @Override
    public Theme getTheme() {
        return this.owner;
    }

    @Override
    public int size() {
        if (this.features != null) {
            return this.features.size();
        }
        return 0;
    }

    @Override
    public void setStyledFeatures(StyledFeatureI[] sfs) {
        this.features = new LocalThemeDataProducer(this.getTheme());
        this.features.setStyledFeatures(sfs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int prepareData(Rectangle2D queryWin, VisContext vc) throws DataException {
        long tokenP = 0L;
        try {
            tokenP = predGeomSensor.start();
            this.aborted = false;
            double xl = 0.0;
            double yl = 0.0;
            double xh = 0.0;
            double yh = 0.0;
            boolean fullextent = MapMaker.isSpecial(queryWin);
            if (fullextent) {
                xl = Double.NEGATIVE_INFINITY;
                yl = Double.NEGATIVE_INFINITY;
                xh = Double.POSITIVE_INFINITY;
                yh = Double.POSITIVE_INFINITY;
            } else {
                xl = queryWin.getMinX();
                yl = queryWin.getMinY();
                xh = queryWin.getMaxX();
                yh = queryWin.getMaxY();
            }
            List styledFeaturesVec = null;
            this.def.isHeatMapTheme = ThemeUtils.isHeatMapTheme(this.def, vc);
            if ((this.def.getSrid() == vc.getMasterSRID() || vc.getMasterSRID() == 0) && this.def.getCachingMode() == 2) {
                if (!this.pinAllFeatures()) {
                    this.def.setCachingMode(1);
                    int n = this.prepareData(queryWin, vc);
                    return n;
                }
                styledFeaturesVec = this.fetchFromInMemoryCache(queryWin, vc);
            } else {
                try {
                    styledFeaturesVec = this.loadFeaturesInWindow(xl, yl, xh, yh, vc);
                }
                catch (Exception e) {
                    String emsg = e.getMessage();
                    if (emsg != null && emsg.indexOf("ORA-01013") < 0) {
                        log.log(Level.SEVERE, "*** Exception while querying theme: " + this.def.getName(), e);
                        throw new DataException("Exception while querying theme: " + this.def.getName(), e);
                    }
                    throw new DataException("Aborted by user.", e);
                }
            }
            int n = this.setStyledFeatures(styledFeaturesVec);
            return n;
        }
        finally {
            predGeomSensor.stop(tokenP);
        }
    }

    Vector fetchFromInMemoryCache(Rectangle2D queryWin, VisContext vc) throws DataException {
        boolean applyRotation = false;
        Rectangle2D qwindow = queryWin;
        double xl = queryWin.getMinX();
        double xh = queryWin.getMaxX();
        double yl = queryWin.getMinY();
        double yh = queryWin.getMaxY();
        log.finest("Search window: " + xl + "," + yl + "," + xh + "," + yh);
        Vector<StyledFeatureI> styledFeaturesVec = new Vector<StyledFeatureI>(128, 128);
        double masterScale = vc.getCurrentScale();
        this.getTheme().setShowLabels(true);
        if (masterScale != Double.POSITIVE_INFINITY && masterScale != Double.NEGATIVE_INFINITY) {
            double scale = masterScale;
            if (this.getTheme().getScaleType() == "RATIO") {
                SRSCache sc = DSManager.getSRSCache(this.def.getDataSourceName());
                SRS srs = sc.get(this.def.getSrid());
                if (srs != null) {
                    scale = queryWin != null ? srs.getRatioScale(masterScale, new Point2D.Double(queryWin.getCenterX(), queryWin.getCenterY())) : srs.getRatioScale(masterScale, null);
                    log.finer("Ratio scale to compare: " + scale);
                } else {
                    vc.processDataError(null, log, RSBundle.getMsg("MAPVIEWER-01025"));
                    return styledFeaturesVec;
                }
            }
            if (!this.getTheme().withinRenderScaleLimits(scale)) {
                log.finer("Scale definition for theme " + this.getTheme().getName() + " is out of range.");
                return styledFeaturesVec;
            }
            if (!this.getTheme().withinLabelScaleLimits(scale)) {
                log.finer("Label Scale definition for theme " + this.getTheme().getName() + " is out of range. Labels will not be rendered.");
                this.getTheme().setShowLabels(false);
            }
            if (vc.getRotation() != 0.0) {
                double[] rmbr = Util.rotateMBR(xl, yl, xh, yh, vc.getRotation());
                if (rmbr != null) {
                    xl = Math.min(rmbr[0], xl);
                    yl = Math.min(rmbr[1], yl);
                    xh = Math.max(rmbr[2], xh);
                    yh = Math.max(rmbr[3], yh);
                    log.finest("Rotation angle: " + vc.getRotation());
                    log.finest("Search window for rotation: " + xl + "," + yl + "," + xh + "," + yh);
                    applyRotation = true;
                    qwindow = new Rectangle2D.Double(xl, yl, xh - xl, yh - yl);
                } else {
                    log.info("Rotated MBR is null. Rotation ignored.");
                }
            }
        }
        ResourceBundle resourceBundle = null;
        if (this.resourceClass != null && vc.getUserLanguage() != null) {
            resourceBundle = I18nUtil.getRB(this.resourceClass, vc.getUserLanguage());
        }
        log.finest("Max features to be prepared: " + this.maxFeaturesToBePrepared);
        Vector FeaturesVec = this.getStyledFeatures(qwindow);
        if (FeaturesVec != null) {
            Rectangle2D qwin = vc.isTileRequest() ? queryWin : vc.getQueryWindow();
            Proj proj = vc.getProjection();
            for (int i = 0; i < FeaturesVec.size() && (this.maxFeaturesToBePrepared <= 0L || (long)styledFeaturesVec.size() < this.maxFeaturesToBePrepared); ++i) {
                JGeometry geomRot;
                StyledFeatureI sf = (StyledFeatureI)FeaturesVec.get(i);
                JSDOGeometry geom = sf.getGeometry();
                if (applyRotation && ((geomRot = Util.rotateGeometry(geom, (xl + xh) / 2.0, (yl + yh) / 2.0, vc.getRotation())) == null || (geom = JSDOGeometry.recast(geomRot)) == null) || geom.getSRID() == vc.getSrs().getSRID() && (geom = vc.getSrs().shift(geom, qwin)) == null) continue;
                if (proj != null) {
                    Proj.P2 p = proj.getOpposite();
                    if (geom.pointInPolygon(p.x, p.y) || (geom = SRS.proj(geom, proj, 0)) == null) continue;
                }
                StyledFeatureI sfnew = this.getNewStyledFeatureInstance();
                sfnew.setShapeSimplified(sf.isShapeSimplified());
                sfnew.setID(sf.getID());
                sfnew.setFeatureStyleName(sf.getFeatureStyleName());
                sfnew.setDataSource(sf.getDataSource());
                sfnew.setThemeName(this.def.getName());
                String label = sf.getLabel();
                sfnew.setLabel(sf.getLabel());
                if (label != null && resourceBundle != null) {
                    sfnew.setTranslatedLabel(I18nUtil.getTranslation(label, resourceBundle));
                }
                sfnew.setLabelStyleName(sf.getLabelStyleName());
                sfnew.setRenderableAttributes(sf.getRenderableAttributes());
                sfnew.setIdentifiableAttributes(sf.getIdentifiableAttributes());
                sfnew.setRenderingRules(sf.getRenderingRules());
                sfnew.setGeometry(geom);
                styledFeaturesVec.addElement(sfnew);
            }
        }
        return styledFeaturesVec;
    }

    @Override
    public void postPreparation(VisContext vc) {
        if (this.p3List != null) {
            for (int i = 0; i < this.p3List.size(); ++i) {
                PPPInterface ppp = this.p3List.get(i);
                ppp.process(this.owner, vc, null);
            }
        }
    }

    @Override
    public StyledFeatureI getStyledFeature(int idx) {
        if (this.features != null) {
            return this.features.getStyledFeature(idx);
        }
        return null;
    }

    @Override
    public double[] getDataMBR() {
        if (this.features == null) {
            return null;
        }
        return this.features.getDataMBR();
    }

    @Override
    public StyledFeatureI[] getStyledFeatures() {
        if (this.features != null) {
            return this.features.getStyledFeatures();
        }
        return null;
    }

    @Override
    public LocalTheme getSelectedFeaturesAsTheme(Rectangle2D window, String name) {
        if (this.features != null) {
            return this.features.getSelectedFeaturesAsTheme(window, name);
        }
        return null;
    }

    @Override
    public StyledFeatureI[] getSelectedFeatures(Rectangle2D window) {
        if (this.features != null) {
            return this.features.getSelectedFeatures(window);
        }
        return null;
    }

    public Connection getDBConnection(VisContext vc) throws DataException {
        Connection conn = null;
        try {
            conn = DSUtil.getDBConnection(this.def.getDataSourceName(), vc);
            if (conn == null) {
                vc.processDataError(null, log, "Cannot obtain connection for data source: " + this.def.getDataSourceName() + ". Max connection limit reached?");
                return null;
            }
        }
        catch (Exception ex) {
            vc.processDataError(ex, log, "Exception when obtaining connection for data source: " + this.def.getDataSourceName());
            return null;
        }
        return conn;
    }

    private boolean transformQueryMBRFromMasterToNative(double[] inmbrValid, double[] inmbrValid2, double[] qmbr, double[] qmbr2, Connection conn, VisContext vc, boolean hasQueryWin2) throws DataException {
        boolean isFullExt;
        double masterScale = vc.getCurrentScale();
        boolean bl = isFullExt = !(masterScale != Double.POSITIVE_INFINITY && masterScale != Double.NEGATIVE_INFINITY || inmbrValid[0] != Double.NaN && inmbrValid[0] != Double.NEGATIVE_INFINITY && inmbrValid[0] != Double.POSITIVE_INFINITY);
        if (!isFullExt) {
            double[] outmbr = Util.convertMBR(inmbrValid, vc.getMasterSRID(), this.def.getSrid(), conn);
            if (outmbr != null) {
                for (int k = 0; k < 4; ++k) {
                    qmbr[k] = outmbr[k];
                }
                log.finest("Transformed query box:[" + qmbr[0] + "," + qmbr[1] + " " + qmbr[2] + "," + qmbr[3] + "]");
                double[] outmbr2 = null;
                if (hasQueryWin2) {
                    outmbr2 = Util.convertMBR(inmbrValid2, vc.getMasterSRID(), this.def.getSrid(), conn);
                    if (outmbr2 != null) {
                        for (int k = 0; k < 4; ++k) {
                            qmbr2[k] = outmbr2[k];
                        }
                        log.finest("Transformed query box2:[" + qmbr2[0] + "," + qmbr2[1] + " " + qmbr2[2] + "," + qmbr2[3] + "]");
                    } else {
                        log.warning("Error in converting query MBR2");
                    }
                }
                return true;
            }
            vc.processDataError(null, log, RSBundle.getMsg("MAPVIEWER-01024"));
            return false;
        }
        return true;
    }

    private void mergeReqMBRs(double[] qmbr1, double[] qmbr2, double[] mbr) {
        if (qmbr1 == null || Double.isNaN(qmbr1[0])) {
            log.finest("Error in qmbr1: request window not properly specified. ");
            return;
        }
        mbr[1] = qmbr1[1];
        mbr[3] = qmbr1[3];
        if (qmbr2 == null || Double.isNaN(qmbr2[0])) {
            mbr[0] = qmbr1[0];
            mbr[2] = qmbr1[2];
            return;
        }
        if (qmbr1[0] > qmbr2[2]) {
            mbr[0] = qmbr1[0];
            mbr[2] = qmbr1[2] + (qmbr2[2] - qmbr2[0]);
            return;
        }
        mbr[0] = qmbr1[0] - (qmbr2[2] - qmbr2[0]);
        mbr[2] = qmbr1[2];
    }

    private boolean checkThemeScale(double xi, double yi, double xf, double yf, double[] qmbr1, double[] qmbr2, Connection conn, VisContext vc, boolean hasQueryWin2) throws DataException {
        double yh;
        double xh;
        double yl;
        double xl;
        if (hasQueryWin2) {
            double[] tmpmbr = new double[4];
            this.mergeReqMBRs(qmbr1, qmbr2, tmpmbr);
            xl = tmpmbr[0];
            yl = tmpmbr[1];
            xh = tmpmbr[2];
            yh = tmpmbr[3];
        } else {
            xl = qmbr1[0];
            yl = qmbr1[1];
            xh = qmbr1[2];
            yh = qmbr1[3];
        }
        SRSCache sc = DSManager.getSRSCache(this.def.getDataSourceName());
        SRS srs = sc.get(this.def.getSrid());
        double factor = Math.abs(yh - yl) / Math.abs(yf - yi);
        double masterScale = vc.getCurrentScale();
        log.finer("[Master scale] " + masterScale + " [Theme scale factor] " + factor);
        double scale = masterScale * factor;
        if (this.getTheme().getScaleType() == "RATIO") {
            double centery;
            double centerx;
            if (vc.getMasterSRID() > 0 && this.def.getSrid() > 0 && this.def.getSrid() != vc.getMasterSRID()) {
                srs = sc.get(vc.getMasterSRID());
                centerx = (xi + xf) / 2.0;
                centery = (yi + yf) / 2.0;
                factor = 1.0;
            } else {
                centerx = (xl + xh) / 2.0;
                centery = (yl + yh) / 2.0;
            }
            if ((vc.isTileRequest() || vc.isGetFeatureInfoRequest()) && srs.isGeodetic()) {
                centerx = 0.0;
                centery = 0.0;
            }
            if (srs != null) {
                scale = Math.round(srs.getRatioScale(masterScale * factor, new Point2D.Double(centerx, centery)));
                log.finer("Ratio scale to compare: " + scale);
            } else {
                vc.processDataError(null, log, RSBundle.getMsg("MAPVIEWER-01025"));
                return false;
            }
        }
        if (!this.getTheme().withinRenderScaleLimits(scale)) {
            log.finer("Scale definition for theme " + this.getTheme().getName() + " is out of range.");
            return false;
        }
        if (!this.getTheme().withinLabelScaleLimits(scale)) {
            log.finer("Label Scale definition for theme " + this.getTheme().getName() + " is out of range. Labels will not be rendered.");
            this.getTheme().setShowLabels(false);
        }
        return true;
    }

    /*
     * Loose catch block
     */
    private List loadFeaturesInAdjustedMBR(double[] qmbr, double xi, double yi, double xf, double yf, boolean isGeodetic, Connection conn, VisContext vc, boolean isOracleDB, boolean csTransform) throws Exception {
        long t4;
        String _query;
        long t3;
        long t2;
        int cnt;
        ArrayList<StyledFeatureI> styledFeatureList;
        long t0;
        block56: {
            ResultSet rs;
            Statement stmt;
            block55: {
                boolean applyRotation;
                boolean isFullExtent;
                CacheGroup cg;
                double yh;
                double xh;
                double yl;
                double xl;
                StyledFeatureI sf;
                block53: {
                    List list;
                    block54: {
                        String themequery;
                        t0 = System.currentTimeMillis();
                        sf = null;
                        styledFeatureList = new ArrayList<StyledFeatureI>(1000);
                        xl = qmbr[0];
                        yl = qmbr[1];
                        xh = qmbr[2];
                        yh = qmbr[3];
                        stmt = null;
                        rs = null;
                        cnt = 0;
                        long t1 = 0L;
                        t2 = 0L;
                        t3 = 0L;
                        _query = null;
                        t1 = System.currentTimeMillis();
                        cg = this.getOrCreateCacheGroup(csTransform, vc);
                        isFullExtent = MapMaker.isSpecial(xl, yl, xh, yh);
                        SDOBoxFilter filterOp = new SDOBoxFilter(this.def.getDataSourceName(), this.def.getQueryHelper().getGeomColumn());
                        log.finest("[ " + this.def.getName() + " ]:  " + xl + "," + yl + "," + xh + "," + yh);
                        applyRotation = false;
                        if (isFullExtent && vc.getRotation() != 0.0) {
                            log.warning("Rotation is currently ignored for full extent.");
                        } else if (vc.getRotation() != 0.0 && !isFullExtent) {
                            if (vc.getRotation() < -360.0 || vc.getRotation() > 360.0) {
                                log.warning("Rotation value must be in between -360 to 360 degrees. ignored");
                            } else {
                                double[] rmbr = Util.rotateMBR(xl, yl, xh, yh, vc.getRotation());
                                if (rmbr != null) {
                                    xl = Math.min(rmbr[0], xl);
                                    yl = Math.min(rmbr[1], yl);
                                    xh = Math.max(rmbr[2], xh);
                                    yh = Math.max(rmbr[3], yh);
                                    log.finest("Rotation angle: " + vc.getRotation());
                                    log.finest("Search window for rotation: " + xl + "," + yl + "," + xh + "," + yh);
                                    applyRotation = true;
                                } else {
                                    log.info("Rotated MBR is null. Rotation ignored.");
                                }
                            }
                        }
                        filterOp.setFilterBox(xl, yl, xh, yh, this.def.getSrid());
                        AbstractDBDataSource ads = (AbstractDBDataSource)DSManager.get(this.def.getDataSourceName());
                        String dbVersion = ads.getDbProductVersion();
                        if (isOracleDB && this.getTheme().getDecorator().getMinimumFeatureSizePx() > 0 && (dbVersion.indexOf(" 10.2") > 0 || dbVersion.indexOf(" 10.1.0.3") > 0 || dbVersion.indexOf(" 10.1.0.4") > 0 || Util.is11gOrAfter(dbVersion))) {
                            double viewResX = vc.getDeviceWindow().getWidth();
                            double viewResY = vc.getDeviceWindow().getHeight();
                            double resx = (xh - xl) / viewResX;
                            double resy = (yh - yl) / viewResY;
                            double res = Math.min(resx, resy) * (double)this.getTheme().getDecorator().getMinimumFeatureSizePx();
                            if (isGeodetic) {
                                double earthRadius = 6378137.0;
                                res *= Math.PI * earthRadius / 180.0;
                            }
                            filterOp.setMinResoultion(res);
                        }
                        _query = themequery = this.def.getQueryHelper().buildQueryString(isFullExtent, filterOp, vc, isOracleDB);
                        log.finest("Theme query [ " + this.def.name + " ]: " + themequery);
                        stmt = this.def.getQueryHelper().prepare(conn, themequery, filterOp, this.bindingParameters, vc);
                        stmt.setFetchSize(this.owner.getFetchSize());
                        log.finer("[ " + this.def.getName() + " ] Fetch size: " + stmt.getFetchSize());
                        t2 = System.currentTimeMillis();
                        rs = stmt.executeQuery();
                        t3 = System.currentTimeMillis();
                        if (rs != null) break block53;
                        list = null;
                        if (this.getTheme().getDecorator().getWorkspaceName() == null || !isOracleDB) break block54;
                        try {
                            Util.gotoWorkspace(conn, "LIVE");
                        }
                        catch (Exception e) {
                            log.warning(e.getMessage());
                        }
                    }
                    long t42 = System.currentTimeMillis();
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                    catch (Exception e) {
                        log.warning(e.getMessage());
                    }
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (Exception e) {
                        log.warning(e.getMessage());
                    }
                    if (this.aborted) {
                        styledFeatureList.clear();
                    }
                    log.info("[ " + this.def.name + " ] sql exec time: " + (t3 - t2) + "ms, total time loading " + cnt + " features: " + (t42 - t0) + "ms.");
                    TopThemeQueries.add(t42 - t0, this.getTheme().getName(), this.getTheme().getDataSourceName(), _query, "features loaded = " + cnt);
                    return list;
                }
                ResultSetMetaData rsmeta = rs.getMetaData();
                this.mDataExtent = null;
                Proj proj = vc.getProjection();
                Hashtable rrulehash = this.buildRenderingRuleHash();
                ResourceBundle resourceBundle = null;
                if (this.resourceClass != null && vc.getUserLanguage() != null) {
                    resourceBundle = I18nUtil.getRB(this.resourceClass, vc.getUserLanguage());
                }
                Rectangle2D qwin = null;
                qwin = vc.isTileRequest() ? new Rectangle2D.Double(xl, yl, xh - xl, yh - yl) : vc.getQueryWindow();
                while (!this.aborted && rs.next() && (this.maxFeaturesToBePrepared <= 0L || this.loadedFeaturesInAdjustedMBR < this.maxFeaturesToBePrepared)) {
                    sf = this.readCurrentRow(rs, rsmeta, vc, isOracleDB, csTransform, cg, rrulehash, resourceBundle);
                    if (sf == null) continue;
                    JSDOGeometry geom = sf.getGeometry();
                    if (applyRotation) {
                        JGeometry geomRot;
                        double centerX = (xl + xh) / 2.0;
                        double centerY = (yl + yh) / 2.0;
                        if (csTransform) {
                            centerX = (xi + xf) / 2.0;
                            centerY = (yi + yf) / 2.0;
                        }
                        if ((geomRot = Util.rotateGeometry(geom, centerX, centerY, vc.getRotation())) == null) {
                            log.finer("Unable to rotate geometry. Key: " + sf.getID());
                            continue;
                        }
                        geom = JSDOGeometry.recast(geomRot);
                        if (geom == null) continue;
                    }
                    if (geom.getSRID() == vc.getSrs().getSRID() && (geom = vc.getSrs().shift(geom, qwin)) == null) continue;
                    if (proj != null) {
                        Proj.P2 p = proj.getOpposite();
                        if (geom.pointInPolygon(p.x, p.y) || (geom = SRS.proj(geom, proj, 0)) == null) continue;
                    }
                    double[] mbr = geom.getMBR();
                    this.extendMbr(mbr);
                    sf.setGeometry(geom);
                    styledFeatureList.add(sf);
                    ++this.loadedFeaturesInAdjustedMBR;
                    if (++cnt % 1000 == 0) {
                        Thread.currentThread();
                        Thread.yield();
                    }
                    if (cnt % 5000 != 0) continue;
                    log.finest("# of features loaded so far: " + cnt);
                }
                if (isFullExtent) {
                    this.loadNewFeatures(styledFeatureList);
                } else {
                    Rectangle2D.Double rc = new Rectangle2D.Double(xl, yl, xh - xl, yh - yl);
                    this.loadEditFeatures(rc, styledFeatureList);
                }
                if (proj != null && yh - yl > 45.0) {
                    Proj.P2 c = proj.getCenter();
                    Graticule gr = new Graticule(proj, c.x, c.y, 15.0, 3.0, 0);
                    JSDOGeometry[] grs = gr.get();
                    Style sty = gr.getStyle();
                    for (int i = 0; i < grs.length; ++i) {
                        sf = this.getNewStyledFeatureInstance();
                        sf.setGeometry(grs[i]);
                        sf.setFeatureStyle(sty);
                        styledFeatureList.add(sf);
                    }
                }
                if (this.getTheme().getDecorator().getWorkspaceName() == null || !isOracleDB) break block55;
                try {
                    Util.gotoWorkspace(conn, "LIVE");
                }
                catch (Exception e) {
                    log.warning(e.getMessage());
                }
            }
            t4 = System.currentTimeMillis();
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception e) {
                log.warning(e.getMessage());
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {
                log.warning(e.getMessage());
            }
            if (this.aborted) {
                styledFeatureList.clear();
            }
            break block56;
            catch (Exception se) {
                try {
                    throw se;
                }
                catch (Throwable throwable) {
                    if (this.getTheme().getDecorator().getWorkspaceName() != null && isOracleDB) {
                        try {
                            Util.gotoWorkspace(conn, "LIVE");
                        }
                        catch (Exception e) {
                            log.warning(e.getMessage());
                        }
                    }
                    long t43 = System.currentTimeMillis();
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                    catch (Exception e) {
                        log.warning(e.getMessage());
                    }
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (Exception e) {
                        log.warning(e.getMessage());
                    }
                    if (this.aborted) {
                        styledFeatureList.clear();
                    }
                    log.info("[ " + this.def.name + " ] sql exec time: " + (t3 - t2) + "ms, total time loading " + cnt + " features: " + (t43 - t0) + "ms.");
                    TopThemeQueries.add(t43 - t0, this.getTheme().getName(), this.getTheme().getDataSourceName(), _query, "features loaded = " + cnt);
                    throw throwable;
                }
            }
        }
        log.info("[ " + this.def.name + " ] sql exec time: " + (t3 - t2) + "ms, total time loading " + cnt + " features: " + (t4 - t0) + "ms.");
        TopThemeQueries.add(t4 - t0, this.getTheme().getName(), this.getTheme().getDataSourceName(), _query, "features loaded = " + cnt);
        return styledFeatureList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List loadFeaturesInWindow(double xi, double yi, double xf, double yf, VisContext vc) throws Exception {
        List styledFeaturesList = null;
        SRSCache sc = DSManager.getSRSCache(this.def.getDataSourceName());
        SRS srs = sc.get(this.def.getSrid());
        log.finest("Srid is " + this.def.getSrid());
        boolean isGeodetic = false;
        if (srs != null) {
            isGeodetic = srs.isGeodetic();
        } else if (this.def.getSrid() > 0) {
            log.warning("cannot locate an SRS object for srid: " + this.def.getSrid());
        }
        double xl = xi;
        double yl = yi;
        double xh = xf;
        double yh = yf;
        boolean csTransform = false;
        Connection conn = this.getDBConnection(vc);
        if (conn == null) {
            return null;
        }
        try {
            boolean workaround;
            boolean isOracleDB = true;
            if (conn.getMetaData().getDatabaseProductName().toUpperCase().indexOf("ORACLE") < 0) {
                isOracleDB = false;
            }
            double[] qmbr = new double[]{Double.NaN, Double.NaN, Double.NaN, Double.NaN};
            double[] qmbr2 = new double[]{Double.NaN, Double.NaN, Double.NaN, Double.NaN};
            double[] inmbr = new double[]{xl, yl, xh, yh};
            double[] inmbrValid = new double[]{Double.NaN, Double.NaN, Double.NaN, Double.NaN};
            double[] inmbrValid2 = new double[]{Double.NaN, Double.NaN, Double.NaN, Double.NaN};
            boolean hasQueryWin2 = SRS.splitQueryMBR(inmbr, inmbrValid, inmbrValid2, vc.getMasterSRID());
            if (vc.getWrapAround() && !SRS.isWrapAroundSupported(vc.getMasterSRID())) {
                vc.setWrapAround(false);
            }
            log.finest("Original query window is adjusted to: (" + inmbrValid[0] + "," + inmbrValid[1] + " " + inmbrValid[2] + "," + inmbrValid[3] + ")");
            this.setRequestMBR(inmbrValid);
            if (hasQueryWin2) {
                this.setRequestMBR2(inmbrValid2);
                log.finest("Query box2 is st to: (" + inmbrValid2[0] + "," + inmbrValid2[1] + " " + inmbrValid2[2] + "," + inmbrValid2[3] + ")");
            }
            if (vc.getMasterSRID() > 0 && this.def.getSrid() > 0 && this.def.getSrid() != vc.getMasterSRID() && isOracleDB) {
                if (!this.transformQueryMBRFromMasterToNative(inmbrValid, inmbrValid2, qmbr, qmbr2, conn, vc, hasQueryWin2)) {
                    List list = styledFeaturesList;
                    return list;
                }
                csTransform = true;
            } else {
                for (int k = 0; k < 4; ++k) {
                    qmbr[k] = inmbrValid[k];
                    qmbr2[k] = inmbrValid2[k];
                }
            }
            if (vc.getMasterSRID() > 0 && this.def.getSrid() > 0 && this.def.getSrid() != vc.getMasterSRID() && MapCSBean.supported(this.def.getSrid(), vc.getMasterSRID())) {
                HashMap<String, String> params = new HashMap<String, String>(7);
                params.put("from_srid", "" + this.def.getSrid());
                params.put("to_srid", "" + vc.getMasterSRID());
                CSTransformP3 csTransformP3 = new CSTransformP3(params);
                this.removeAllP3s();
                this.addP3(csTransformP3);
                log.finest("Added a PPP for mid-tier CS transform: " + this.def.getSrid() + " to " + vc.getMasterSRID() + ".");
            }
            this.getTheme().setShowLabels(true);
            double masterScale = vc.getCurrentScale();
            if (masterScale != Double.POSITIVE_INFINITY && masterScale != Double.NEGATIVE_INFINITY && !this.checkThemeScale(xi, yi, xf, yf, qmbr, qmbr2, conn, vc, hasQueryWin2)) {
                List list = styledFeaturesList;
                return list;
            }
            boolean bl = workaround = isGeodetic && xh - xl >= 1.8 && xh - xl < 120.0;
            if (workaround) {
                xl = Math.floor(xl);
                log.finest("ptvpxfmfxed: xl=" + xl);
            }
            if (this.getTheme().getDecorator().getWorkspaceName() != null && isOracleDB) {
                this.gotoWorkspace(conn);
            }
            log.finest("Max features to be prepared: " + this.maxFeaturesToBePrepared);
            this.loadedFeaturesInAdjustedMBR = 0L;
            styledFeaturesList = this.loadFeaturesInAdjustedMBR(qmbr, xi, yi, xf, yf, isGeodetic, conn, vc, isOracleDB, csTransform);
            this.loadedFeaturesInAdjustedMBR = styledFeaturesList.size();
            if (hasQueryWin2) {
                List styledFeaturesVec2 = null;
                styledFeaturesVec2 = this.loadFeaturesInAdjustedMBR(qmbr2, xi, yi, xf, yf, isGeodetic, conn, vc, isOracleDB, csTransform);
                for (int k = 0; k < styledFeaturesVec2.size(); ++k) {
                    styledFeaturesList.add(styledFeaturesVec2.get(k));
                }
                styledFeaturesVec2 = null;
            }
        }
        catch (Exception e) {
            log.warning(e.getMessage());
        }
        finally {
            try {
                if (conn != null) {
                    DSUtil.closeDBConnection(conn, this.def.getDataSourceName());
                }
            }
            catch (Exception e) {
                log.warning(e.getMessage());
            }
        }
        return styledFeaturesList;
    }

    void gotoWorkspace(Connection conn) throws DataException {
        try {
            if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                if (this.getTheme().getDecorator().getWorkspaceDate() != null) {
                    Util.gotoWorkspaceDate(conn, this.getTheme().getDecorator().getWorkspaceName(), this.getTheme().getDecorator().getWorkspaceDate(), this.getTheme().getDecorator().getWorkspaceDateFormat(), this.getTheme().getDecorator().getWorkspaceDateNlsParam(), this.getTheme().getDecorator().isWorkspaceDateTsWtz());
                } else if (this.getTheme().getDecorator().getWorkspaceSavedPoint() != null) {
                    Util.gotoWorkspaceSavedPoint(conn, this.getTheme().getDecorator().getWorkspaceName(), this.getTheme().getDecorator().getWorkspaceSavedPoint());
                } else {
                    Util.gotoWorkspace(conn, this.getTheme().getDecorator().getWorkspaceName());
                }
            }
        }
        catch (Exception e) {
            String err = "Cannot go to workspace " + this.getTheme().getDecorator().getWorkspaceName();
            if (this.getTheme().getDecorator().getWorkspaceDate() != null) {
                err = err + ", Date " + this.getTheme().getDecorator().getWorkspaceDate();
            } else if (this.getTheme().getDecorator().getWorkspaceSavedPoint() != null) {
                err = err + ", Saved Point " + this.getTheme().getDecorator().getWorkspaceSavedPoint();
            }
            log.log(Level.SEVERE, err, e);
            throw new DataException(err);
        }
    }

    CacheGroup getOrCreateCacheGroup(boolean transformSRid, VisContext vc) {
        CacheGroup cg;
        String cacheGroupName = this.def.getCacheGroupName();
        if (transformSRid && (cacheGroupName = this.def.getCacheGroupName(vc.getMasterSRID())) == null && this.def.cachingMode != 3) {
            if (!this.def.createCacheGroup(vc.getMasterSRID())) {
                log.severe("Could not create Cache group for SRid = " + vc.getMasterSRID());
                return null;
            }
            cacheGroupName = this.def.getCacheGroupName(vc.getMasterSRID());
        }
        if ((cg = CacheMgr2.getGroup(this.def.getCacheSubRegionName(), cacheGroupName)) == null && this.def.getCachingMode() != 3) {
            CacheMgr2.createGeomGroup(this.def.getCacheSubRegionName(), cacheGroupName, 0, false);
            cg = CacheMgr2.getGroup(this.def.getCacheSubRegionName(), cacheGroupName);
        }
        return cg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pinAll(VisContext vc) throws DataException, SQLException {
        if (!CacheMgr2.isReady()) {
            throw new DataException("Cache not available.");
        }
        PredGeomThemeDefinition predGeomThemeDefinition = this.def;
        synchronized (predGeomThemeDefinition) {
            if (this.def.getTree() != null) {
                return;
            }
            Connection conn = null;
            try {
                conn = DSUtil.getDBConnection(this.def.getDataSourceName(), vc);
            }
            catch (Exception ex) {
                log.severe("Cannot obtain connection for data source: " + this.def.getDataSourceName());
                throw new DataException(ex);
            }
            this.def.setCachingMode(1);
            boolean isOracleDB = true;
            if (conn.getMetaData().getDatabaseProductName().toUpperCase().indexOf("ORACLE") < 0) {
                isOracleDB = false;
            }
            String themeQuery = this.def.getQueryHelper().buildQueryString(true, null, vc, isOracleDB);
            log.finest("loading all: " + this.def.getName() + "...");
            try {
                this._loadAllFeatures(conn, themeQuery);
                this.def.setCachingMode(2);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "*** Exception while pinning theme: " + this.def.getName(), e);
                log.warning("*** Will use normal caching scheme for theme: " + this.def.getName());
                this.def.setCachingMode(1);
                CacheMgr2.removeGroup(this.def.getCacheSubRegionName(), this.def.getCacheGroupName());
                throw new DataException("Exception while pinning theme: " + this.def.getName(), e);
            }
            catch (OutOfMemoryError e) {
                log.log(Level.SEVERE, "*** Reached cache memory limit while pinning theme: " + this.def.getName(), e);
                log.warning("*** Will use normal caching scheme for theme: " + this.def.getName());
                this.def.setCachingMode(1);
                CacheMgr2.removeGroup(this.def.getCacheSubRegionName(), this.def.getCacheGroupName());
                System.gc();
                throw new DataException("Exception while pinning theme: " + this.def.getName(), e);
            }
            finally {
                try {
                    if (conn != null) {
                        DSUtil.closeDBConnection(conn, this.def.getDataSourceName());
                    }
                }
                catch (Exception ex) {
                    log.warning(ex.getMessage());
                }
            }
        }
    }

    @Override
    public void destroy() {
        if (this.features != null) {
            this.features.destroy();
        }
        this.features = null;
    }

    @Override
    public void abort() {
        this.aborted = true;
        try {
            if (this.stmt != null) {
                this.stmt.cancel();
            }
        }
        catch (Exception e) {
            log.warning(e.getMessage());
        }
    }

    public List fetchFeatures(SpatialOp op, VisContext vc, boolean highlight) throws Exception {
        long t0 = System.currentTimeMillis();
        ArrayList<StyledFeatureI> styledFeaturesVec = new ArrayList<StyledFeatureI>();
        StyledFeatureI sf = null;
        Connection conn = null;
        try {
            conn = DSUtil.getDBConnection(this.def.getDataSourceName(), vc);
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Cannot obtain connection for data source: " + this.def.getDataSourceName(), ex);
            return null;
        }
        boolean isOracleDB = true;
        if (conn.getMetaData().getDatabaseProductName().toUpperCase().indexOf("ORACLE") < 0) {
            isOracleDB = false;
        }
        if (this.getTheme().getDecorator().getWorkspaceName() != null && isOracleDB) {
            this.gotoWorkspace(conn);
        }
        this.stmt = null;
        ResultSet rs = null;
        int cnt = 0;
        long t1 = 0L;
        long t2 = 0L;
        long t3 = 0L;
        try {
            t1 = System.currentTimeMillis();
            boolean csTransform = isOracleDB && vc.getMasterSRID() > 0 && this.def.getSrid() > 0 && this.def.getSrid() != vc.getMasterSRID();
            String themequery = this.def.getQueryHelper().buildQueryString(false, op, vc, isOracleDB);
            log.finest("Theme SpatialOp query [ " + this.def.name + " ]: " + themequery);
            this.stmt = this.def.getQueryHelper().prepare(conn, themequery, op, this.bindingParameters, vc);
            this.stmt.setFetchSize(this.owner.getFetchSize());
            log.finer("Fetch size: " + this.stmt.getFetchSize());
            t2 = System.currentTimeMillis();
            rs = (OracleResultSet)this.stmt.executeQuery();
            t3 = System.currentTimeMillis();
            if (rs == null) {
                List list = null;
                return list;
            }
            ResultSetMetaData rsmeta = rs.getMetaData();
            this.mDataExtent = null;
            Proj proj = vc.getProjection();
            ResourceBundle resourceBundle = null;
            if (this.resourceClass != null && vc.getUserLanguage() != null) {
                resourceBundle = I18nUtil.getRB(this.resourceClass, vc.getUserLanguage());
            }
            Hashtable rrulehash = this.buildRenderingRuleHash();
            while (rs.next()) {
                JSDOGeometry geom;
                sf = this.readCurrentRow(rs, rsmeta, vc, isOracleDB, csTransform, null, rrulehash, resourceBundle);
                if (sf == null || (geom = sf.getGeometry()) == null || geom.getSRID() == vc.getSrs().getSRID() && (geom = vc.getSrs().shift(geom, vc.getQueryWindow())) == null) continue;
                if (proj != null) {
                    Proj.P2 p = proj.getOpposite();
                    if (geom.pointInPolygon(p.x, p.y) || (geom = SRS.proj(geom, proj, 0)) == null) continue;
                }
                double[] mbr = geom.getMBR();
                this.extendMbr(mbr);
                sf.setGeometry(geom);
                if (highlight) {
                    String hiliSty = this.def.getHighlightStyleName();
                    if (hiliSty == null) {
                        hiliSty = BuiltinStyles.highlightColorStyleName;
                    }
                    sf.setFeatureStyleName(hiliSty);
                }
                styledFeaturesVec.add(sf);
                if (++cnt % 1000 != 0) continue;
                Thread.currentThread();
                Thread.yield();
            }
            ArrayList<StyledFeatureI> arrayList = styledFeaturesVec;
            return arrayList;
        }
        catch (Exception se) {
            throw se;
        }
        finally {
            if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                try {
                    Util.gotoWorkspace(conn, "LIVE");
                }
                catch (Exception e) {
                    log.warning(e.getMessage());
                }
            }
            long t4 = System.currentTimeMillis();
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception e) {
                log.warning(e.getMessage());
            }
            try {
                if (this.stmt != null) {
                    this.stmt.close();
                }
            }
            catch (Exception e) {
                log.warning(e.getMessage());
            }
            try {
                if (conn != null) {
                    DSUtil.closeDBConnection(conn, this.def.getDataSourceName());
                }
            }
            catch (Exception e) {
                log.warning(e.getMessage());
            }
            log.info("[ " + this.def.name + " ] SpatialOp sql exec time: " + (t3 - t2) + "ms, total time loading " + cnt + " features: " + (t4 - t0) + "ms.");
        }
    }

    protected JSDOGeometry loadGeom(ResultSet rs, boolean unpickler, boolean isOracleDB, int nextColumnToRead) throws Exception {
        if (isOracleDB) {
            return JDBCUtil.loadGeometry(rs, nextColumnToRead, unpickler);
        }
        return JDBCUtil.loadGeometryFromJavaDB(rs, nextColumnToRead);
    }

    protected JSDOGeometry loadGeom(CacheGroup cg, ResultSet rs, String cacheKey, boolean unpickler, boolean isOracleDB, int nextColumnToRead) throws Exception {
        JSDOGeometry geom = null;
        if (this.def.getCachingMode() != 3 && cg != null && this.getTheme().getDecorator().getWorkspaceName() == null) {
            if (cacheKey != null) {
                geom = (JSDOGeometry)cg.get(cacheKey);
            }
            if (geom == null && (geom = this.loadGeom(rs, unpickler, isOracleDB, nextColumnToRead)) != null && cacheKey != null) {
                cg.put(cacheKey, geom, geom.getSize());
            }
        } else {
            geom = this.loadGeom(rs, unpickler, isOracleDB, nextColumnToRead);
        }
        return geom;
    }

    private void _loadAllFeatures(Connection conn, String query) throws Exception {
        log.finest("[" + this.def.name + " loadAll Query] " + query);
        PreparedStatement stmt = null;
        OracleResultSet rs = null;
        int cnt = 0;
        long t1 = 0L;
        long t2 = 0L;
        long t3 = 0L;
        ArrayList<StyledFeatureI> styledFeaturesVec = new ArrayList<StyledFeatureI>(1024);
        try {
            t1 = System.currentTimeMillis();
            stmt = this.def.getQueryHelper().prepare(conn, query, null, this.bindingParameters, null);
            stmt.setFetchSize(this.owner.getFetchSize());
            log.finer("Fetch size: " + stmt.getFetchSize());
            t2 = System.currentTimeMillis();
            rs = (OracleResultSet)stmt.executeQuery();
            ResultSetMetaData rsmeta = rs.getMetaData();
            t3 = System.currentTimeMillis();
            CacheGroup cg = CacheMgr2.getGroup(this.def.cacheSubRegionName, this.def.getCacheGroupName());
            if (cg == null) {
                CacheMgr2.createGeomGroup(this.def.cacheSubRegionName, this.def.getCacheGroupName(), 0, true);
            }
            Hashtable rrulehash = this.buildRenderingRuleHash();
            boolean isOracleDB = true;
            if (conn.getMetaData().getDatabaseProductName().toUpperCase().indexOf("ORACLE") < 0) {
                isOracleDB = false;
            }
            while (rs.next()) {
                StyledFeatureI sf = this.readCurrentRow((ResultSet)rs, rsmeta, null, isOracleDB, false, null, rrulehash, null);
                JSDOGeometry geom = sf.getGeometry();
                if (geom == null) continue;
                String key = sf.getID();
                cg.put(key, geom, geom.getSize());
                styledFeaturesVec.add(sf);
                if (++cnt % 1000 != 0) continue;
                Thread.currentThread();
                Thread.yield();
            }
        }
        catch (SQLException se) {
            throw se;
        }
        finally {
            long t4 = System.currentTimeMillis();
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception e) {
                log.warning(e.getMessage());
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {
                log.warning(e.getMessage());
            }
            log.info("[ " + this.def.name + ".loadAll ] sql exec time: " + (t3 - t2) + "ms, total time loading " + cnt + " features: " + (t4 - t1) + "ms.");
            TopThemeQueries.add(t4 - t1, this.getTheme().getName() + "#loadAll", this.getTheme().getDataSourceName(), query, "features loaded = " + cnt);
        }
        if (styledFeaturesVec.size() > 0) {
            this.def.buildRTree(styledFeaturesVec);
        }
    }

    private StyledFeatureI readCurrentRow(ResultSet rs, ResultSetMetaData rsmeta, VisContext vc, boolean isOracleDB, boolean csTransform, CacheGroup cg, Hashtable rrulehash, ResourceBundle resourceBundle) throws Exception {
        boolean unpickler = this.owner.getDecorator().isFastUnpickle();
        boolean simpleShapes = this.owner.getDecorator().isSimplifiedShapes();
        boolean allowNakedPoints = this.owner.getDecorator().allowNakedPoints;
        int numKeyCols = this.def.getNumKeyColumns();
        int colCnt = rsmeta.getColumnCount();
        StyledFeatureI sf = this.getNewStyledFeatureInstance();
        sf.setShapeSimplified(simpleShapes);
        int nextCol = 1;
        String key = rs.getString(nextCol);
        JSDOGeometry geom = null;
        for (int i = 1; i < numKeyCols; ++i) {
            key = key + ThemeUtils.KEY_VALUE_DELIMITER + rs.getString(++nextCol);
        }
        sf.setID(key);
        String cacheKey = key;
        if (csTransform && vc != null) {
            cacheKey = key + vc.getMasterSRID();
        }
        if (!isOracleDB && this.def.getKeyColumn().equalsIgnoreCase("rowid")) {
            cacheKey = null;
        }
        if ((geom = this.loadGeom(cg, rs, cacheKey, unpickler, isOracleDB, ++nextCol)) == null) {
            return null;
        }
        sf.setGeometry(geom);
        sf.setDataSource(this.def.getDataSourceName());
        sf.setThemeName(this.def.getName());
        sf.setFeatureStyleName(rs.getString(++nextCol));
        if (rs.getFloat(numKeyCols + 5) > 0.0f) {
            this.loadLabel(rs, sf, rsmeta, resourceBundle, ++nextCol);
        }
        sf.setAllowNakedPoints(allowNakedPoints);
        if (colCnt > numKeyCols + 6) {
            this.loadAttributeData(rs, sf, colCnt, rsmeta, numKeyCols + 6 + 1);
        }
        if (rrulehash != null) {
            int ruleIndex = Integer.parseInt(rs.getString(numKeyCols + 6).substring(5));
            sf.setRenderingRules((RenderingRule[])rrulehash.get(sf.getFeatureStyleName().toUpperCase() + "#" + ruleIndex));
        }
        return sf;
    }

    public void loadAttributeData(ResultSet rs, StyledFeatureI sf, int totalCol, ResultSetMetaData meta, int nextCol) throws SQLException, IOException {
        Vector<Field> v = new Vector<Field>(totalCol - 6 - this.def.getNumKeyColumns());
        for (int i = nextCol; i < totalCol + 1; ++i) {
            Field a = null;
            String name = meta.getColumnName(i);
            int sqlType = meta.getColumnType(i);
            a = Util.getFieldFromResultSet(sqlType, rs, i);
            a.setName(name);
            v.add(a);
        }
        Field[] iAttrs = this.def.getIdentifiableColumns();
        if (iAttrs == null) {
            sf.setRenderableAttributes(v.toArray(new Field[v.size()]));
        } else {
            Field[] myIAttrs = new Field[iAttrs.length];
            block1: for (int i = 0; i < iAttrs.length; ++i) {
                Field a = iAttrs[i];
                String name = a.getName();
                for (int c = 0; c < v.size(); ++c) {
                    Field ca = (Field)v.get(c);
                    String tn = ca.getName();
                    if (!name.equalsIgnoreCase(tn) && !name.replaceAll("[ |']", "").equalsIgnoreCase(tn.replaceAll("[ |']", ""))) continue;
                    myIAttrs[i] = ca;
                    ca.setDisplayName(a.getDisplayName());
                    if (this.columnDefinedInStylingRules(a.getName())) continue block1;
                    v.remove(c);
                    continue block1;
                }
            }
            sf.setIdentifiableAttributes(myIAttrs);
            if (v.size() > 0) {
                sf.setRenderableAttributes(v.toArray(new Field[v.size()]));
            }
        }
    }

    protected void loadLabel(ResultSet rs, StyledFeatureI sf, ResultSetMetaData meta, ResourceBundle resourceBundle, int nextCol) throws SQLException {
        String label = rs.getString(nextCol);
        if (label != null && label.length() == 0) {
            label = null;
        }
        sf.setLabel(label);
        sf.setLabelStyleName(rs.getString(nextCol + 1));
        if (label != null && resourceBundle != null) {
            sf.setTranslatedLabel(I18nUtil.getTranslation(label, resourceBundle));
        }
    }

    public void createCacheGroup(int SRid) {
        Integer id = new Integer(SRid);
        if (this.def.getSRidCache().get(id) != null) {
            log.info("Cache group for SRid " + SRid + " already exists.");
            return;
        }
        log.finer("Creating a cache group for SRID: " + SRid);
        String cacheGroupName = this.def.getBaseTable() + "_" + this.def.getGeomColumn() + "_" + SRid + "_PDT_GEOM#" + this.def.getDataSourceName();
        log.finer("Cache group: " + cacheGroupName);
        boolean pinned = this.def.getCachingMode() == 2;
        try {
            CacheMgr2.createGeomGroup(this.def.getCacheSubRegionName(), cacheGroupName, 0, pinned);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "error creating geom cache group.", e);
        }
        this.def.getSRidCache().put(id, cacheGroupName);
    }

    public int setStyledFeatures(List styledFeaturesVec) {
        this.features = new LocalThemeDataProducer(this.owner);
        this.features.setStyledFeatures(styledFeaturesVec);
        return styledFeaturesVec != null ? styledFeaturesVec.size() : 0;
    }

    protected boolean columnDefinedInStylingRules(String col) {
        StylingRule[] rules = this.def.getStylingRules();
        if (rules == null) {
            return false;
        }
        for (int i = 0; i < rules.length; ++i) {
            String[] columns = rules[i].getAttributeColumnsAsArray();
            if (columns == null) continue;
            for (int j = 0; j < columns.length; ++j) {
                if (!col.equalsIgnoreCase(columns[j])) continue;
                return true;
            }
        }
        return false;
    }

    public void setBindingParameters(Object[] bindingParams) {
        this.bindingParameters = bindingParams;
    }

    public Object[] getBindingParameters() {
        return this.bindingParameters;
    }

    @Override
    public StyledFeatureI getNewStyledFeatureInstance() {
        if (this.def.isHeatMapTheme) {
            return new HMPointFeature();
        }
        return new StyledFeature();
    }

    private void extendMbr(double[] mbr) {
        if (this.mDataExtent == null) {
            this.mDataExtent = new Rectangle2D.Double(mbr[0], mbr[1], 0.0, 0.0);
        } else {
            this.mDataExtent.add(mbr[0], mbr[1]);
        }
        if (mbr.length == 4) {
            this.mDataExtent.add(mbr[2], mbr[3]);
        } else {
            this.mDataExtent.add(mbr[3], mbr[4]);
        }
    }

    private Hashtable buildRenderingRuleHash() {
        if (this.def.getStylingRules() == null) {
            return null;
        }
        StylingRule[] srules = this.def.getStylingRules();
        if (srules.length == 0) {
            return null;
        }
        Hashtable<String, RenderingRule[]> rhash = new Hashtable<String, RenderingRule[]>();
        for (int i = 0; i < srules.length; ++i) {
            String style = srules[i].getFeatureStyleName();
            RenderingRule[] rrule = srules[i].getRenderingRules();
            if (style == null || rrule == null) continue;
            rhash.put(style.toUpperCase() + "#" + i, rrule);
        }
        if (rhash.size() == 0) {
            return null;
        }
        return rhash;
    }

    protected void loadNewFeatures(List featVector) {
    }

    protected void loadEditFeatures(Rectangle2D mbr, List featVector) {
    }

    public void addP3(PPPInterface p3) {
        if (this.p3List == null) {
            this.p3List = new ArrayList<PPPInterface>(5);
        }
        this.p3List.add(p3);
    }

    public List<PPPInterface> getP3List() {
        return this.p3List;
    }

    public void removeP3(PPPInterface p3) {
        if (this.p3List != null) {
            for (int i = 0; i < this.p3List.size(); ++i) {
                PPPInterface pi = this.p3List.get(i);
                if (pi != p3) continue;
                this.p3List.remove(i);
            }
            if (this.p3List.size() == 0) {
                this.p3List = null;
            }
        }
    }

    public void removeAllP3s() {
        if (this.p3List != null) {
            this.p3List.clear();
            this.p3List = null;
        }
    }

    protected boolean pinAllFeatures() {
        if (this.def.getTree() == null) {
            try {
                VisContext vc1 = new VisContext();
                vc1.setMasterSRID(this.def.getSrid());
                this.pinAll(vc1);
            }
            catch (Throwable e) {
                log.severe(e.getMessage());
                return false;
            }
        }
        return true;
    }

    protected Vector getStyledFeatures(Rectangle2D qwindow) {
        return this.def.searchStyledFeatures(qwindow);
    }

    public void setRequestMBR(double[] mbr) {
        for (int k = 0; k < 4; ++k) {
            this.queryMBR[k] = mbr[k];
        }
    }

    public void setRequestMBR2(double[] mbr2) {
        for (int k = 0; k < 4; ++k) {
            this.queryMBR2[k] = mbr2[k];
        }
    }

    public double[] getRequestMBR() {
        return this.queryMBR;
    }

    public double[] getRequestMBR2() {
        return this.queryMBR2;
    }

    @Override
    public long getMaxFeaturesToBePrepared() {
        return this.maxFeaturesToBePrepared;
    }

    @Override
    public void setMaxFeaturesToBePrepared(long size) {
        this.maxFeaturesToBePrepared = size;
    }
}

