/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.stylex;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.logging.Logger;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.style.StyleModel;
import oracle.mapviewer.share.stylex.CollectionStyleModel;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.StyleCache;
import oracle.sdovis.VisContext;
import oracle.sdovis.style.Style;
import oracle.sdovis.style.StyleArea;
import oracle.sdovis.style.StyleColor;
import oracle.sdovis.style.StyleException;
import oracle.sdovis.style.StyleLine;
import oracle.sdovis.style.StyleMarker;
import oracle.sdovis.style.StyleModifiers;
import oracle.sdovis.style.StyleNotApplicableException;
import oracle.sdovis.stylex.AdvancedStyle;
import oracle.sdovis.stylex.AdvancedStyleModifiers;
import oracle.sdovis.util.ConflictResolver;
import oracle.sdovis.util.Util;
import oracle.sdovis.util.XMLDOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class CollectionStyle
implements AdvancedStyle {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    private CollectionStyleModel bean = null;

    public CollectionStyle() {
        this.bean = new CollectionStyleModel();
        this.bean.setDefaultStyle(new StyleColor(Color.red));
    }

    public CollectionStyle(CollectionStyleModel model) {
        this.setModel(model);
    }

    public void setModel(CollectionStyleModel model) {
        if (!(model instanceof CollectionStyleModel)) {
            throw new IllegalArgumentException("Not a CollectionStyleModel instance.");
        }
        this.bean = model;
        this.bean.setDefaultStyle(new StyleColor(Color.red));
    }

    @Override
    public StyleModel getModel() {
        return this.bean;
    }

    @Override
    public void setModel(StyleModel model) {
        if (!(model instanceof CollectionStyleModel)) {
            throw new IllegalArgumentException("Not a CollectionStyleModel instance.");
        }
        this.bean = (CollectionStyleModel)model;
        this.bean.setDefaultStyle(new StyleColor(Color.red));
    }

    public CollectionStyle(Document doc) throws StyleException {
        this.bean = new CollectionStyleModel();
        try {
            Node elem = XMLDOMParser.getSubElement(doc, "AdvancedStyle");
            Node elemCCSS = XMLDOMParser.getSubElement(elem, "CollectionStyle");
            ArrayList nl2 = XMLDOMParser.getRealChildNodes(elemCCSS);
            if (nl2 == null || nl2.size() <= 0) {
                return;
            }
            for (int i = 0; i < nl2.size(); ++i) {
                Node e = (Node)nl2.get(i);
                if (!e.getNodeName().equalsIgnoreCase("style")) continue;
                String styleName = XMLDOMParser.getAttribute(e, "name");
                if (styleName == null || styleName.trim().length() < 1) {
                    log.info("Style name (index " + i + ") must be defined.");
                    continue;
                }
                String styleShape = XMLDOMParser.getAttribute(e, "shape");
                if (styleShape == null || styleShape.trim().length() < 1) {
                    styleShape = null;
                }
                this.bean.addStyle(styleName, null, styleShape);
            }
        }
        catch (Exception e) {
            throw new StyleException("Invalid Collection style definition.");
        }
    }

    @Override
    public String getDefinition() {
        return this.bean.toXMLString();
    }

    @Override
    public boolean resolveStyles(StyleCache sc, Hashtable dynaStyles) {
        if (this.bean == null) {
            return false;
        }
        for (int i = 0; i < this.bean.getNumberOfStyles(); ++i) {
            String styleName = this.bean.getStyleName(i);
            Style style = Util.getStyle(styleName, sc, dynaStyles);
            if (style == null) continue;
            this.bean.setStyle(styleName, style);
            style.resolveStyles(sc, dynaStyles);
        }
        return true;
    }

    @Override
    public boolean refreshResolvedStyles(StyleCache sc, Hashtable dynaStyles) {
        if (this.bean == null) {
            return false;
        }
        for (int i = 0; i < this.bean.getNumberOfStyles(); ++i) {
            String styleName = this.bean.getStyleName(i);
            Style style = Util.getStyle(styleName, sc, dynaStyles);
            if (style == null) continue;
            this.bean.setStyle(styleName, style);
            style.refreshResolvedStyles(sc, dynaStyles);
        }
        return true;
    }

    @Override
    public void apply(VisContext vc, Graphics2D g, float x, float y, StyleModifiers stymods) throws StyleNotApplicableException {
        if (this.bean == null) {
            return;
        }
        for (int i = 0; i < this.bean.getNumberOfStyles(); ++i) {
            String shape;
            Style style = (Style)this.bean.getStyle(i);
            if (style == null) continue;
            StyleModifiers smods = null;
            if (stymods != null && stymods instanceof AdvancedStyleModifiers) {
                smods = ((AdvancedStyleModifiers)stymods).getStyleModifiers(this.bean.getStyleName(i).toUpperCase());
            }
            if ((shape = this.bean.getStyleShape(i)) != null) {
                if (!shape.equalsIgnoreCase(CollectionStyleModel.POINT_SHAPE) || style instanceof AdvancedStyle) continue;
                style.apply(null, g, x, y, smods);
                continue;
            }
            if (!(style instanceof StyleMarker) && !(style instanceof StyleColor)) continue;
            style.apply(null, g, x, y, smods);
        }
    }

    @Override
    public void apply(VisContext vc, Graphics2D g, Rectangle2D rect, StyleModifiers stymods) throws StyleNotApplicableException {
        if (this.bean == null) {
            return;
        }
        double width_step = rect.getWidth() / (double)this.bean.getNumberOfStyles();
        double cur_step = 0.0;
        for (int i = 0; i < this.bean.getNumberOfStyles(); ++i) {
            Style sty = (Style)this.bean.getStyle(i);
            Rectangle2D.Double rec = new Rectangle2D.Double();
            rec.setRect(rect.getMinX() + cur_step, rect.getMinY(), width_step, rect.getHeight());
            sty.apply(null, g, rec, stymods);
            cur_step += width_step;
        }
    }

    @Override
    public void apply(VisContext vc, Graphics2D g, Shape shp, int gtype, StyleModifiers stymods) throws StyleNotApplicableException {
        if (this.bean == null) {
            return;
        }
        if (shp == null) {
            return;
        }
        block12: for (int i = 0; i < this.bean.getNumberOfStyles(); ++i) {
            String shape;
            Style style = (Style)this.bean.getStyle(i);
            if (style == null) continue;
            StyleModifiers smods = null;
            if (stymods != null && stymods instanceof AdvancedStyleModifiers) {
                smods = ((AdvancedStyleModifiers)stymods).getStyleModifiers(this.bean.getStyleName(i).toUpperCase());
            }
            if ((shape = this.bean.getStyleShape(i)) != null) {
                switch (gtype) {
                    case 1: 
                    case 5: {
                        if (!shape.equalsIgnoreCase(CollectionStyleModel.POINT_SHAPE) || style instanceof AdvancedStyle) continue block12;
                        style.apply(null, g, shp, gtype, smods);
                        break;
                    }
                    case 2: 
                    case 6: {
                        if (!shape.equalsIgnoreCase(CollectionStyleModel.LINE_SHAPE) || style instanceof AdvancedStyle) continue block12;
                        style.apply(null, g, shp, gtype, smods);
                        break;
                    }
                    case 3: 
                    case 7: {
                        if (!shape.equalsIgnoreCase(CollectionStyleModel.POLYGON_SHAPE) || style instanceof AdvancedStyle) continue block12;
                        style.apply(null, g, shp, gtype, smods);
                        break;
                    }
                    case 4: {
                        style.apply(null, g, shp, gtype, smods);
                        break;
                    }
                }
                continue;
            }
            switch (gtype) {
                case 1: 
                case 5: {
                    if (!(style instanceof StyleMarker) && !(style instanceof StyleColor)) continue block12;
                    style.apply(null, g, shp, gtype, smods);
                    continue block12;
                }
                case 2: 
                case 6: {
                    if (!(style instanceof StyleLine) && !(style instanceof StyleColor)) continue block12;
                    style.apply(null, g, shp, gtype, smods);
                    continue block12;
                }
                case 3: 
                case 7: {
                    if (!(style instanceof StyleArea) && !(style instanceof StyleColor) && !(style instanceof StyleLine)) continue block12;
                    style.apply(null, g, shp, gtype, smods);
                    continue block12;
                }
                case 4: {
                    style.apply(null, g, shp, gtype, smods);
                    continue block12;
                }
            }
        }
    }

    @Override
    public void apply(VisContext vc, Graphics2D g, Shape shp, int gtype, String label, Point2D labelPoint, ConflictResolver cr, Field[] values, StyleModifiers stymods) throws StyleNotApplicableException {
        if (this.bean == null) {
            return;
        }
        if (shp == null) {
            return;
        }
        block12: for (int i = 0; i < this.bean.getNumberOfStyles(); ++i) {
            String shape;
            Style style = (Style)this.bean.getStyle(i);
            if (style == null) continue;
            StyleModifiers smods = null;
            if (stymods != null && stymods instanceof AdvancedStyleModifiers) {
                smods = ((AdvancedStyleModifiers)stymods).getStyleModifiers(this.bean.getStyleName(i).toUpperCase());
            }
            if ((shape = this.bean.getStyleShape(i)) != null) {
                switch (gtype) {
                    case 1: 
                    case 5: {
                        if (!shape.equalsIgnoreCase(CollectionStyleModel.POINT_SHAPE)) continue block12;
                        style.apply(null, g, shp, gtype, label, labelPoint, cr, values, smods);
                        break;
                    }
                    case 2: 
                    case 6: {
                        if (!shape.equalsIgnoreCase(CollectionStyleModel.LINE_SHAPE)) continue block12;
                        style.apply(null, g, shp, gtype, label, labelPoint, cr, values, smods);
                        break;
                    }
                    case 3: 
                    case 7: {
                        if (!shape.equalsIgnoreCase(CollectionStyleModel.POLYGON_SHAPE)) continue block12;
                        style.apply(null, g, shp, gtype, label, labelPoint, cr, values, smods);
                        break;
                    }
                    case 4: {
                        style.apply(null, g, shp, gtype, label, labelPoint, cr, values, smods);
                        break;
                    }
                }
                continue;
            }
            switch (gtype) {
                case 1: 
                case 5: {
                    if (!(style instanceof StyleMarker) && !(style instanceof StyleColor) && !(style instanceof AdvancedStyle)) continue block12;
                    style.apply(null, g, shp, gtype, label, labelPoint, cr, values, smods);
                    continue block12;
                }
                case 2: 
                case 6: {
                    if (!(style instanceof StyleLine) && !(style instanceof StyleColor) && !(style instanceof AdvancedStyle)) continue block12;
                    style.apply(null, g, shp, gtype, label, labelPoint, cr, values, smods);
                    continue block12;
                }
                case 3: 
                case 7: {
                    if (!(style instanceof StyleArea) && !(style instanceof StyleColor) && !(style instanceof StyleLine) && !(style instanceof AdvancedStyle)) continue block12;
                    style.apply(null, g, shp, gtype, label, labelPoint, cr, values, smods);
                    continue block12;
                }
                case 4: {
                    style.apply(null, g, shp, gtype, label, labelPoint, cr, values, smods);
                    continue block12;
                }
            }
        }
    }

    @Override
    public void apply(VisContext vc, Graphics2D g, Shape shp, int gtype, String label, Point2D labelPoint, ConflictResolver cr, Field[] values, String[] styleColumns, StyleModifiers stymods) throws StyleNotApplicableException {
        this.apply(null, g, shp, gtype, label, labelPoint, cr, values, stymods);
    }

    @Override
    public void apply(VisContext vc, Graphics2D g, Shape shp, int gtype, String label, Point2D labelPoint, ConflictResolver cr, Field[] values, String[] styleColumns, Style subStyle, String[] substyleColumns, String changeProperty, StyleModifiers stymods) throws StyleNotApplicableException {
        this.apply(null, g, shp, gtype, label, labelPoint, cr, values, stymods);
    }

    @Override
    public int getMaxLegendWidth(Graphics2D g, int fontSize) {
        return 0;
    }

    @Override
    public Object getPropertyValue(String propertyType) {
        return null;
    }

    @Override
    public StyleModifiers convertToPixelSize(VisContext vc) {
        AdvancedStyleModifiers stymods = new AdvancedStyleModifiers();
        for (int i = 0; i < this.bean.getNumberOfStyles(); ++i) {
            StyleModifiers smods;
            Style style = (Style)this.bean.getStyle(i);
            if (style == null || (smods = style.convertToPixelSize(vc)) == null) continue;
            stymods.addStyleModifiers(this.bean.getStyleName(i).toUpperCase(), smods);
        }
        if (stymods.getStyleModifiers().size() == 0) {
            return null;
        }
        return stymods;
    }
}

