/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.raytracing;

import javax.vecmath.Matrix4d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector4d;
import oracle.sdovis.raytracing.Hit;
import oracle.sdovis.raytracing.Object3d;
import oracle.sdovis.raytracing.Ray;

public class Transform {
    Matrix4d transf;
    Object3d obj;
    Matrix4d inverse;

    public Transform(Matrix4d m, Object3d o) {
        this.transf = m;
        this.obj = o;
        this.inverse = new Matrix4d();
        this.inverse.invert(this.transf);
    }

    public Vector3d getTextureCoordinates(Hit h, Ray r) {
        return new Vector3d();
    }

    public boolean intersect(Ray r, Hit h, double tmin) {
        Vector3d newOri = r.getOrigin();
        Transform.transform3D(this.inverse, newOri);
        Vector3d newDir = r.getDirection();
        Transform.transformDirection3D(this.inverse, newDir);
        double sf1 = newDir.length();
        double sf2 = r.getDirection().length();
        double scalefactor = sf1 / sf2;
        newDir.normalize();
        Ray newRay = new Ray(newDir, newOri);
        Hit newHit = h;
        newHit.set(newHit.getT() * scalefactor, newHit.getMaterial());
        boolean success = this.obj.intersect(newRay, newHit, tmin);
        if (success) {
            h.set(newHit.getT() / scalefactor, newHit.getMaterial());
            Vector3d hnorm = newHit.getNormal();
            Matrix4d transpose = new Matrix4d();
            transpose.transpose(this.inverse);
            Transform.transform3D(transpose, hnorm);
            hnorm.normalize();
            h.set(h.getT(), h.getMaterial(), hnorm);
            return success;
        }
        return false;
    }

    public static void transform4D(Matrix4d data, Vector4d v) {
        double[] output = new double[4];
        double[] input = new double[4];
        v.get(input);
        for (int y = 0; y < 4; ++y) {
            output[y] = 0.0;
            for (int i = 0; i < 4; ++i) {
                output[y] = output[y] + data.getElement(y, i) * input[i];
            }
        }
        v.set(output);
    }

    public static void transform3D(Matrix4d data, Vector3d v) {
        Vector4d v2 = new Vector4d(v.x, v.y, v.z, 1.0);
        Transform.transform4D(data, v2);
        v.set(v2.x, v2.y, v2.z);
    }

    public static void transformDirection3D(Matrix4d data, Vector3d v) {
        Vector4d v2 = new Vector4d(v.x, v.y, v.z, 0.0);
        Transform.transform4D(data, v2);
        v.set(v2.x, v2.y, v2.z);
    }
}

