/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.cache;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

class MVHashMap
implements Serializable {
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    transient Entry[] table;
    transient int size;
    int threshold;
    final float loadFactor;
    volatile transient int modCount;
    static final Object NULL_KEY = new Object();
    private static final long serialVersionUID = 362498820763181265L;

    public MVHashMap(int initialCapacity, float loadFactor) {
        int capacity;
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal initialcapacity: " + initialCapacity);
        }
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Illegal load factor: " + loadFactor);
        }
        for (capacity = 1; capacity < initialCapacity; capacity <<= 1) {
        }
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)capacity * loadFactor);
        this.table = new Entry[capacity];
        this.init();
    }

    public MVHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public MVHashMap() {
        this.loadFactor = 0.75f;
        this.threshold = 16;
        this.table = new Entry[16];
        this.init();
    }

    void init() {
    }

    static Object maskNull(Object key) {
        return key == null ? NULL_KEY : key;
    }

    static Object unmaskNull(Object key) {
        return key == NULL_KEY ? null : key;
    }

    static int hash(Object x) {
        int h = x.hashCode();
        return h;
    }

    static boolean eq(Object x, Object y) {
        return x == y || x.equals(y);
    }

    static int indexFor(int h, int length) {
        return h & length - 1;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public Object get(Object key) {
        Object k = MVHashMap.maskNull(key);
        int hash = MVHashMap.hash(k);
        int i = MVHashMap.indexFor(hash, this.table.length);
        Entry e = this.table[i];
        while (e != null) {
            if (e.hash == hash && MVHashMap.eq(k, e.key)) {
                return e.value;
            }
            e = e.next;
        }
        return e;
    }

    public boolean containsKey(Object key) {
        Object k = MVHashMap.maskNull(key);
        int hash = MVHashMap.hash(k);
        int i = MVHashMap.indexFor(hash, this.table.length);
        Entry e = this.table[i];
        while (e != null) {
            if (e.hash == hash && MVHashMap.eq(k, e.key)) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    Entry getEntry(Object key) {
        Object k = MVHashMap.maskNull(key);
        int hash = MVHashMap.hash(k);
        int i = MVHashMap.indexFor(hash, this.table.length);
        Entry e = this.table[i];
        while (!(e == null || e.hash == hash && MVHashMap.eq(k, e.key))) {
            e = e.next;
        }
        return e;
    }

    int _put(Object key, Object value, int esize) {
        Object k = MVHashMap.maskNull(key);
        int hash = MVHashMap.hash(k);
        int i = MVHashMap.indexFor(hash, this.table.length);
        Entry e = this.table[i];
        while (e != null) {
            if (e.hash == hash && MVHashMap.eq(k, e.key)) {
                int oldSize = e.esize;
                e.value = value;
                e.esize = esize;
                e.recordAccess(this);
                return oldSize;
            }
            e = e.next;
        }
        ++this.modCount;
        this.addEntry(hash, k, value, i, esize);
        return 0;
    }

    private void putForCreate(Object key, Object value, int esize) {
        Object k = MVHashMap.maskNull(key);
        int hash = MVHashMap.hash(k);
        int i = MVHashMap.indexFor(hash, this.table.length);
        Entry e = this.table[i];
        while (e != null) {
            if (e.hash == hash && MVHashMap.eq(k, e.key)) {
                e.value = value;
                return;
            }
            e = e.next;
        }
        this.createEntry(hash, k, value, i, esize);
    }

    void resize(int newCapacity) {
        Entry[] oldTable = this.table;
        int oldCapacity = oldTable.length;
        if (this.size < this.threshold || oldCapacity > newCapacity) {
            return;
        }
        Entry[] newTable = new Entry[newCapacity];
        this.transfer(newTable);
        this.table = newTable;
        this.threshold = (int)((float)newCapacity * this.loadFactor);
    }

    void transfer(Entry[] newTable) {
        Entry[] src = this.table;
        int newCapacity = newTable.length;
        for (int j = 0; j < src.length; ++j) {
            Entry next;
            Entry e = src[j];
            if (e == null) continue;
            src[j] = null;
            do {
                next = e.next;
                int i = MVHashMap.indexFor(e.hash, newCapacity);
                e.next = newTable[i];
                newTable[i] = e;
            } while ((e = next) != null);
        }
    }

    public Object remove(Object key) {
        Entry e = this.removeEntryForKey(key);
        return e == null ? e : e.value;
    }

    Entry removeEntryForKey(Object key) {
        Entry prev;
        Object k = MVHashMap.maskNull(key);
        int hash = MVHashMap.hash(k);
        int i = MVHashMap.indexFor(hash, this.table.length);
        Entry e = prev = this.table[i];
        while (e != null) {
            Entry next = e.next;
            if (e.hash == hash && MVHashMap.eq(k, e.key)) {
                ++this.modCount;
                --this.size;
                if (prev == e) {
                    this.table[i] = next;
                } else {
                    prev.next = next;
                }
                e.recordRemoval(this);
                return e;
            }
            prev = e;
            e = next;
        }
        return e;
    }

    Entry removeMapping(Object o) {
        Entry prev;
        if (!(o instanceof Map.Entry)) {
            return null;
        }
        Map.Entry entry = (Map.Entry)o;
        Object k = MVHashMap.maskNull(entry.getKey());
        int hash = MVHashMap.hash(k);
        int i = MVHashMap.indexFor(hash, this.table.length);
        Entry e = prev = this.table[i];
        while (e != null) {
            Entry next = e.next;
            if (e.hash == hash && e.equals(entry)) {
                ++this.modCount;
                --this.size;
                if (prev == e) {
                    this.table[i] = next;
                } else {
                    prev.next = next;
                }
                e.recordRemoval(this);
                return e;
            }
            prev = e;
            e = next;
        }
        return e;
    }

    public void clear() {
        ++this.modCount;
        Entry[] tab = this.table;
        for (int i = 0; i < tab.length; ++i) {
            tab[i] = null;
        }
        this.size = 0;
    }

    public boolean containsValue(Object value) {
        if (value == null) {
            return this.containsNullValue();
        }
        Entry[] tab = this.table;
        for (int i = 0; i < tab.length; ++i) {
            Entry e = tab[i];
            while (e != null) {
                if (value.equals(e.value)) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    private boolean containsNullValue() {
        Entry[] tab = this.table;
        for (int i = 0; i < tab.length; ++i) {
            Entry e = tab[i];
            while (e != null) {
                if (e.value == null) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    void addEntry(int hash, Object key, Object value, int bucketIndex, int esize) {
        this.table[bucketIndex] = new Entry(hash, key, value, this.table[bucketIndex], esize);
        if (this.size++ >= this.threshold) {
            this.resize(2 * this.table.length);
        }
    }

    void createEntry(int hash, Object key, Object value, int bucketIndex, int esize) {
        this.table[bucketIndex] = new Entry(hash, key, value, this.table[bucketIndex], esize);
        ++this.size;
    }

    Iterator newKeyIterator() {
        return new KeyIterator();
    }

    Iterator newValueIterator() {
        return new ValueIterator();
    }

    Iterator newEntryIterator() {
        return new EntryIterator();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.table.length);
        s.writeInt(this.size);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int numBuckets = s.readInt();
        this.table = new Entry[numBuckets];
        this.init();
        int size = s.readInt();
        for (int i = 0; i < size; ++i) {
            Object key = s.readObject();
            Object value = s.readObject();
            int esize = s.readInt();
            this.putForCreate(key, value, esize);
        }
    }

    int capacity() {
        return this.table.length;
    }

    float loadFactor() {
        return this.loadFactor;
    }

    public String report(int ntab) {
        StringBuffer sb = new StringBuffer(1024);
        String tabs = "";
        for (int i = 0; i < ntab; ++i) {
            tabs = tabs + "\t";
        }
        sb.append(tabs + "   capacity: " + this.capacity() + "\n");
        sb.append(tabs + "       size: " + this.size + "\n");
        sb.append(tabs + "load factor: " + this.loadFactor() + "\n");
        int maxBucketSize = 1;
        int totalNonEmptyBuckets = 0;
        long totalMemSize = 0L;
        for (int i = 0; i < this.capacity(); ++i) {
            Entry e = this.table[i];
            if (e != null) {
                ++totalNonEmptyBuckets;
            }
            int depth = 0;
            while (e != null) {
                totalMemSize += (long)e.esize;
                ++depth;
                e = e.next;
            }
            if (depth <= maxBucketSize) continue;
            maxBucketSize = depth;
        }
        sb.append(tabs + "    # of chains: " + totalNonEmptyBuckets + "\n");
        sb.append(tabs + "max chain depth: " + maxBucketSize + "\n");
        sb.append(tabs + "avg chain depth: " + (double)this.size / (double)totalNonEmptyBuckets + "\n");
        sb.append(tabs + " empty bucket %: " + (double)(this.capacity() - totalNonEmptyBuckets) / (double)this.capacity() + "\n");
        sb.append(tabs + "total mem size : " + totalMemSize / 1024L + "KB\n");
        return sb.toString();
    }

    private class EntryIterator
    extends HashIterator {
        private EntryIterator() {
        }

        public Object next() {
            return this.nextEntry();
        }
    }

    private class KeyIterator
    extends HashIterator {
        private KeyIterator() {
        }

        public Object next() {
            return this.nextEntry().getKey();
        }
    }

    private class ValueIterator
    extends HashIterator {
        private ValueIterator() {
        }

        public Object next() {
            return this.nextEntry().value;
        }
    }

    private abstract class HashIterator
    implements Iterator {
        Entry next;
        int expectedModCount;
        int index;
        Entry current;

        HashIterator() {
            this.expectedModCount = MVHashMap.this.modCount;
            Entry[] t = MVHashMap.this.table;
            int i = t.length;
            Entry n = null;
            if (MVHashMap.this.size != 0) {
                while (i > 0 && (n = t[--i]) == null) {
                }
            }
            this.next = n;
            this.index = i;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        Entry nextEntry() {
            if (MVHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Entry e = this.next;
            if (e == null) {
                throw new NoSuchElementException();
            }
            Entry n = e.next;
            Entry[] t = MVHashMap.this.table;
            int i = this.index;
            while (n == null && i > 0) {
                n = t[--i];
            }
            this.index = i;
            this.next = n;
            this.current = e;
            return this.current;
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            if (MVHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Object k = this.current.key;
            this.current = null;
            MVHashMap.this.removeEntryForKey(k);
            this.expectedModCount = MVHashMap.this.modCount;
        }
    }

    static class Entry
    implements Map.Entry {
        int esize;
        final Object key;
        Object value;
        final int hash;
        Entry next;

        Entry(int h, Object k, Object v, Entry n, int esz) {
            this.value = v;
            this.next = n;
            this.key = k;
            this.hash = h;
            this.esize = esz;
        }

        public Object getKey() {
            return MVHashMap.unmaskNull(this.key);
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object newValue) {
            Object oldValue = this.value;
            this.value = newValue;
            return oldValue;
        }

        public void setSize(int sz) {
            this.esize = sz;
        }

        public int getSize() {
            return this.esize;
        }

        @Override
        public boolean equals(Object o) {
            Object v2;
            Object v1;
            Object k2;
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object k1 = this.getKey();
            return (k1 == (k2 = e.getKey()) || k1 != null && k1.equals(k2)) && ((v1 = this.getValue()) == (v2 = e.getValue()) || v1 != null && v1.equals(v2));
        }

        @Override
        public int hashCode() {
            return (this.key == NULL_KEY ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }

        void recordAccess(MVHashMap m) {
        }

        void recordRemoval(MVHashMap m) {
        }
    }
}

