/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.SRS;
import oracle.sdovis.SRSCommons;
import oracle.sdovis.SRSConstants;
import oracle.sdovis.SRSRowData;
import oracle.sdovis.SRSStore;
import oracle.sdovis.Spheroid;
import oracle.sdovis.util.IntHashtable;
import oracle.sdovis.util.Util;

public class SRSCache {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    protected String mDataSource;
    protected IntHashtable geodeticSrids = new IntHashtable(31);
    protected Hashtable srsList = new Hashtable(41);
    protected SRSStore srsStore = null;
    private static String LSB = "[";
    private static String RSB = "]";

    public SRSCache(String dataSrc, SRSStore store) {
        this.mDataSource = dataSrc;
        this.srsList.put(new Integer(0), new SRS());
        this.srsStore = store;
        if (this.srsStore != null) {
            this.srsStore.loadGeodeticSrids(this.geodeticSrids);
        }
    }

    public SRS get(int srid) {
        if (srid < 0) {
            return null;
        }
        SRS s = null;
        s = SRSCommons.get(srid);
        if (s != null) {
            return s;
        }
        s = (SRS)this.srsList.get(new Integer(srid));
        if (s != null) {
            return s;
        }
        if (this.srsStore == null) {
            log.warning("srsStore is null!");
            return null;
        }
        SRSRowData data = this.srsStore.getSRSRowData(srid);
        if (data == null) {
            log.warning("Cannot find SRS definition for srid " + srid + ".");
            return null;
        }
        s = this.register(srid, data, this.mDataSource);
        return s;
    }

    public SRS put(int srid, SRS srs) {
        return this.srsList.put(new Integer(srid), srs);
    }

    public void setSrsStore(SRSStore srsStore) {
        this.srsStore = srsStore;
    }

    public SRSStore getSrsStore() {
        return this.srsStore;
    }

    private SRS register(int srid, SRSRowData data, String ds) {
        if (srid == 0) {
            return null;
        }
        Integer sridI = new Integer(srid);
        if (this.srsList.get(sridI) != null) {
            return (SRS)this.srsList.get(sridI);
        }
        this.parseAndAdd(srid, data.wktext, ds);
        return (SRS)this.srsList.get(sridI);
    }

    public static boolean isValidWKT(String wkt) {
        if (wkt == null) {
            return true;
        }
        int cnt = 0;
        char c = '\u0000';
        for (int i = 0; i < wkt.length(); ++i) {
            c = wkt.charAt(i);
            if (c == '[') {
                ++cnt;
                continue;
            }
            if (c != ']') continue;
            --cnt;
        }
        return cnt == 0;
    }

    private void parseAndAdd(int srid, String wkt, String ds) {
        if (wkt == null || wkt.length() == 0) {
            if (srid == 999999) {
                SRS sr = new SRS();
                sr.set(srid, null, 1.0, 0, null);
                if (this.srsList.get(new Integer(srid)) == null) {
                    log.finer("Registering srs " + srid);
                    this.srsList.put(new Integer(srid), sr);
                }
            }
            return;
        }
        SRS sr = new SRS(ds);
        int csType = 0;
        String wkt_ = wkt.toUpperCase();
        if (wkt_.indexOf("PROJCS") >= 0) {
            csType = 2;
        } else if (wkt_.indexOf("GEOGCS") >= 0) {
            csType = 1;
            this.geodeticSrids.put(srid, (Object)"");
        } else if (wkt_.indexOf("LOCAL_CS") >= 0) {
            csType = 3;
        }
        Spheroid spheroid = SRSCache.extractSpheroidInfo(wkt_);
        int idx = wkt_.lastIndexOf("UNIT");
        int idx2 = 0;
        if (idx < 0) {
            log.severe("cannot find UNIT parameter in wkt.");
            return;
        }
        double cf = 0.0;
        String unit = null;
        try {
            while (wkt_.charAt(idx) != '[') {
                ++idx;
            }
            while (wkt_.charAt(idx) != '\"') {
                ++idx;
            }
            idx2 = ++idx;
            while (wkt_.charAt(idx2) != '\"') {
                ++idx2;
            }
            unit = wkt_.substring(idx, idx2);
            if (unit == null || unit.length() == 0) {
                log.severe("no unit name.");
                return;
            }
            idx = idx2;
            while (wkt_.charAt(idx) != ',') {
                ++idx;
            }
            idx2 = ++idx;
            while (wkt_.charAt(idx2) != ']') {
                ++idx2;
            }
            try {
                cf = Double.valueOf(wkt_.substring(idx, idx2));
            }
            catch (Exception ex) {
                log.severe("cannot parse unit conversion factor.");
                return;
            }
        }
        catch (Exception e) {
            log.severe("error parsing UNIT parameter in wkt.");
            return;
        }
        if (csType == 1) {
            Hashtable angularUnitList = SRSConstants.getAngularUnitList();
            if (angularUnitList.get(unit) == null) {
                angularUnitList.put(unit, new Double(cf));
            }
        } else {
            Hashtable distUnitList = SRSConstants.getDistanceUnitList();
            if (distUnitList.get(unit) == null) {
                distUnitList.put(unit, new Double(cf));
            }
        }
        sr.set(srid, unit, cf, csType, spheroid);
        if (this.srsList.get(new Integer(srid)) == null) {
            log.finer("Registering srs " + srid + ", isGeodetic=" + sr.isGeodetic() + ", unit=" + unit);
            this.srsList.put(new Integer(srid), sr);
        }
    }

    public static Spheroid extractSpheroidInfo(String wkt) {
        int idx = wkt.indexOf("GEOGCS");
        if (idx < 0) {
            return null;
        }
        if ((idx = wkt.indexOf("SPHEROID", idx)) < 0) {
            return null;
        }
        try {
            idx = wkt.indexOf("[", idx);
            idx = wkt.indexOf("\"", idx);
            int idx2 = wkt.indexOf("\"", idx + 1);
            String name = wkt.substring(idx + 1, idx2);
            idx = wkt.indexOf(",", idx2);
            idx2 = wkt.indexOf("]", idx);
            String sph = wkt.substring(idx + 1, idx2);
            ArrayList elem = Util.splitBy(sph, ", ");
            double semiMajor = Double.parseDouble((String)elem.get(0));
            double flattening_ = Double.parseDouble((String)elem.get(1));
            double flattening = flattening_ == 0.0 ? 0.0 : 1.0 / flattening_;
            Spheroid spheroid = new Spheroid(name, semiMajor, flattening);
            return spheroid;
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.getMessage(), e);
            return null;
        }
    }

    public boolean isGeodetic(int srid) {
        return this.geodeticSrids.get(srid) != null;
    }
}

