/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db.ssh;

import java.sql.SQLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.jdeveloper.db.adapter.ConnectionCreator;
import oracle.jdeveloper.db.adapter.DatabaseProvider;
import oracle.jdeveloper.db.ssh.SSHConnectionCreator;
import oracle.jdeveloper.db.ssh.SSHTunnel;
import oracle.jdeveloper.db.ssh.SSHTunnelException;
import oracle.jdevimpl.db.resource.DBAdapterBundle;

public final class SSHTunnelConfiguration {
    public static final String SSH_ENABLED = "SSH.Enabled";
    public static final String SSH_USER = "SSH.User";
    public static final String SSH_PASSWORD = "SSH.Password";
    public static final String SSH_HOST = "SSH.Host";
    public static final String SSH_PORT = "SSH.Port";
    public static final String SSH_KEY_FILE = "SSH.LocalFile";
    private final String m_url;
    private final String m_host;
    private final int[] m_hostOffsets;
    private final int m_port;
    private final int[] m_portOffsets;

    public SSHTunnelConfiguration(String url, String host, int[] hostOffsets, int port, int[] portOffsets) {
        this.m_url = url;
        this.m_host = host;
        this.m_hostOffsets = hostOffsets;
        this.m_port = port;
        this.m_portOffsets = portOffsets;
    }

    public String getRemoteHost() {
        return this.m_host;
    }

    public int getRemotePort() {
        return this.m_port;
    }

    public String getLocalConnectionURL(SSHTunnel tunnel) {
        StringBuilder retval = new StringBuilder(this.m_url);
        if (this.m_hostOffsets[0] > this.m_portOffsets[0]) {
            this.replaceHost(retval, tunnel);
            this.replacePort(retval, tunnel);
        } else {
            this.replacePort(retval, tunnel);
            this.replaceHost(retval, tunnel);
        }
        return retval.toString();
    }

    private void replaceHost(StringBuilder buff, SSHTunnel tunnel) {
        buff.replace(this.m_hostOffsets[0], this.m_hostOffsets[1], tunnel.getLocalHost());
    }

    private void replacePort(StringBuilder buff, SSHTunnel tunnel) {
        buff.replace(this.m_portOffsets[0], this.m_portOffsets[1], String.valueOf(tunnel.getLocalPort()));
    }

    public static int parsePort(String port) throws SSHTunnelException {
        try {
            return Integer.parseInt(port);
        }
        catch (NumberFormatException nfe) {
            throw new SSHTunnelException(DBAdapterBundle.get("SSH_INVALID_PORT"));
        }
    }

    public static SSHTunnelConfiguration createFromMatcher(String url, Matcher m, int hostGroup, int portGroup) throws SSHTunnelException {
        String host = m.group(hostGroup);
        int[] hostOffsets = new int[]{m.start(hostGroup), m.end(hostGroup)};
        String port = m.group(portGroup);
        int[] portOffsets = new int[]{m.start(portGroup), m.end(portGroup)};
        return new SSHTunnelConfiguration(url, host, hostOffsets, SSHTunnelConfiguration.parsePort(port), portOffsets);
    }

    public static SSHTunnelConfiguration parseAddressSyntax(String url) throws SSHTunnelException {
        int[] portOffsets;
        String port;
        int[] hostOffsets;
        String host;
        Pattern pattern = Pattern.compile("\\(\\s*HOST\\s*=\\s*([^\\s)]+)\\s*\\)", 2);
        Matcher matcher = pattern.matcher(url);
        if (matcher.find()) {
            host = matcher.group(1);
            hostOffsets = new int[]{matcher.start(1), matcher.end(1)};
            if (matcher.find()) {
                throw new SSHTunnelException(DBAdapterBundle.get("SSH_HOST_MULTIPLE"));
            }
        } else {
            throw new SSHTunnelException(DBAdapterBundle.get("SSH_HOST_MISSING"));
        }
        pattern = Pattern.compile("\\(\\s*PORT\\s*=\\s*([^\\s)]+)\\s*\\)", 2);
        matcher = pattern.matcher(url);
        if (matcher.find()) {
            port = matcher.group(1);
            portOffsets = new int[]{matcher.start(1), matcher.end(1)};
            if (matcher.find()) {
                throw new SSHTunnelException(DBAdapterBundle.get("SSH_PORT_MULTIPLE"));
            }
        } else {
            throw new SSHTunnelException(DBAdapterBundle.get("SSH_PORT_MISSING"));
        }
        return new SSHTunnelConfiguration(url, host, hostOffsets, SSHTunnelConfiguration.parsePort(port), portOffsets);
    }

    public static SSHTunnelConfiguration getConfiguration(DatabaseProvider pro) throws SQLException {
        ConnectionCreator cc = DatabaseProvider.getCreator(pro);
        if (cc instanceof SSHConnectionCreator) {
            return ((SSHConnectionCreator)cc).getConfiguration(pro);
        }
        throw new SSHTunnelException(DBAdapterBundle.get("SSH_NOT_SUPPORTED"));
    }

    public static final boolean requiresTunnel(DatabaseProvider pro) {
        return Boolean.parseBoolean(pro.getProperty(SSH_ENABLED));
    }
}

