/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.rest.RestArb;
import oracle.dbtools.rest.ui.IRestDialog;
import oracle.ide.Ide;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.IdeUtil;
import oracle.javatools.dialogs.MessageDialog;

public abstract class RestBaseDialog
implements IRestDialog,
ActionListener {
    private JEWTDialog _dialog;
    private JPanel _panel;
    private String _label;
    private String _helpTopicId;
    private int _width;
    private int _height;

    public RestBaseDialog(String string, String string2) {
        this._label = string;
        this._helpTopicId = string2;
    }

    @Override
    public boolean runDialog() {
        boolean bl = false;
        try {
            this.initDialog();
            bl = WizardLauncher.runDialog((JDialog)this._dialog);
        }
        catch (Exception exception) {
        }
        finally {
            this.removeListeners();
            if (this._dialog != null) {
                this._dialog.dispose();
                this._dialog.removeActionListener((ActionListener)this);
                this._dialog = null;
            }
        }
        return bl;
    }

    @Override
    public Object getObject() {
        return null;
    }

    public void removeListeners() {
    }

    protected void initDialog() {
        JPanel jPanel = this.getPanel();
        HelpSystem.getHelpSystem().registerTopic((JComponent)jPanel, this._helpTopicId);
        String string = this.getObject() == null ? RestArb.format("NEW_TITLE", this._label) : RestArb.format("EDIT_TITLE", this._label);
        this._dialog = OnePageWizardDialogFactory.createJEWTDialog((Component)jPanel, null, (String)string, (int)14);
        this._dialog.addActionListener((ActionListener)this);
        Dimension dimension = new Dimension(450, 450);
        this._dialog.setMinimumSize(dimension);
        this._dialog.setPreferredSize(dimension);
        this._dialog.setSize(dimension);
        this.checkIncreaseWidthHeight();
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this._dialog);
    }

    private void checkIncreaseWidthHeight() {
        if (this._width != 0 || this._height != 0) {
            Dimension dimension = this._dialog.getPreferredSize();
            int n = (int)dimension.getWidth() + this._width;
            int n2 = (int)dimension.getHeight() + this._height;
            this._dialog.setSize(n, n2);
            this._dialog.setPreferredSize(n, n2);
        }
    }

    protected void setIncreaseDialogSize(int n, int n2) {
        this._width = n;
        this._height = n2;
    }

    protected void setPanel(JPanel jPanel) {
        this._panel = jPanel;
    }

    protected JPanel getPanel() {
        return this._panel;
    }

    protected JEWTDialog getDialog() {
        return this._dialog;
    }

    protected void showError(String string) {
        MessageDialog.error((Component)this._dialog, (Object)string, (String)RestArb.format("ERROR_TITLE", this._label), null);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }
}

