/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.navigator;

import javax.swing.Icon;
import oracle.dbtools.rest.RestArb;
import oracle.dbtools.rest.model.RestResourceHandler;
import oracle.dbtools.rest.navigator.RestFolder;
import oracle.javatools.icons.OracleIcons;

public class RestHandlerNode
extends RestFolder {
    private static int NODE_ID = 5000;
    private RestResourceHandler _handler;
    private int _nodeId;
    private String _moduleURI;
    private String _templateURI;

    public RestHandlerNode(RestResourceHandler restResourceHandler) {
        this._handler = restResourceHandler;
        this._nodeId = ++NODE_ID;
    }

    public void setHandler(RestResourceHandler restResourceHandler) {
        this._handler = restResourceHandler;
    }

    public RestResourceHandler getHandler() {
        return this._handler;
    }

    public RestResourceHandler.HTTP_METHOD_TYPE getMethodType() {
        return this._handler != null ? this._handler.getMethodType() : RestResourceHandler.HTTP_METHOD_TYPE.GET;
    }

    public int getNodeId() {
        return this._nodeId;
    }

    public String getTemplateURI() {
        return this._templateURI;
    }

    public void setTemplateURI(String string) {
        this._templateURI = string;
    }

    public String getModuleURI() {
        return this._moduleURI;
    }

    public void setModuleURI(String string) {
        this._moduleURI = string;
    }

    @Override
    public String getShortLabel() {
        switch (this.getMethodType()) {
            case GET: {
                return RestArb.getString("GET_NODE");
            }
            case POST: {
                return RestArb.getString("POST_NODE");
            }
            case PUT: {
                return RestArb.getString("PUT_NODE");
            }
            case DELETE: {
                return RestArb.getString("DELETE_NODE");
            }
        }
        return RestArb.getString("UNKNOWN_NODE");
    }

    @Override
    public String getLongLabel() {
        return this.getShortLabel();
    }

    @Override
    public String getToolTipText() {
        return this.getShortLabel();
    }

    @Override
    public Icon getIcon() {
        switch (this.getMethodType()) {
            case GET: {
                return RestArb.getIcon("HANDLER_GET_ICON");
            }
            case POST: {
                return RestArb.getIcon("HANDLER_POST_ICON");
            }
            case PUT: {
                return RestArb.getIcon("HANDLER_PUT_ICON");
            }
            case DELETE: {
                return RestArb.getIcon("HANDLER_DELETE_ICON");
            }
        }
        return OracleIcons.getIcon((String)"unknownstatus.png");
    }

    @Override
    public void setUserObject(Object object) {
        if (object != null && object instanceof RestResourceHandler) {
            this.setHandler((RestResourceHandler)object);
        }
    }

    @Override
    public RestResourceHandler getUserObject() {
        return this.getHandler();
    }
}

