/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.install;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.namespace.NamespaceContext;
import oracle.dbtools.common.config.file.ConfigurationFiles;
import oracle.dbtools.common.install.InstallConstants;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.Files;
import oracle.dbtools.common.util.NSContext;
import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.common.util.XPaths;
import oracle.dbtools.rest.RestArb;
import oracle.dbtools.rest.install.RestInstallConstants;
import org.w3c.dom.Node;

public class InstallUtils {
    private static final String _NS = "http://java.sun.com/xml/ns/j2ee";
    private static final String _NS_PREFIX = "j";
    private static final NamespaceContext NS_CONTEXT = NSContext.namespaceContext((String[])new String[]{"j", "http://java.sun.com/xml/ns/j2ee"});
    private static final XPaths.Expression CONFIG_DIR_TEXT = XPaths.expression((String)"/j:web-app/j:context-param[j:param-name=\"config.dir\"]/j:param-value/text()", (NamespaceContext)NS_CONTEXT);
    private static final XPaths.Expression VERSION_TEXT = XPaths.expression((String)"/j:web-app/j:context-param[j:param-name=\"version\"]/j:param-value/text()", (NamespaceContext)NS_CONTEXT);
    private static final String APEX_CONFIG_XML = "apex-config.xml";
    private static final String DEFAULTS_XML = "apex-config.xml";

    public static String getLogFolder(File file) throws Exception {
        String string = file.getParent() + File.separator + "logs" + File.separator;
        if (InstallUtils.canWriteFolder(string)) {
            return string;
        }
        string = System.getProperty("user.home");
        if (InstallUtils.canWriteFolder(string)) {
            return string;
        }
        throw new Exception(RestArb.format("ERRORWRITELOGFILE", string));
    }

    public static boolean canWriteFolder(String string) {
        File file;
        return !NullOrEmpty.nullOrEmpty((CharSequence)string) && (file = new File(string)).isDirectory() && file.canWrite();
    }

    public static Map<String, String> getWEBXMLParams(File file) throws IOException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ZipFile zipFile = null;
        InputStream inputStream = null;
        try {
            zipFile = new ZipFile(file);
            ZipEntry zipEntry = zipFile.getEntry("WEB-INF/web.xml");
            if (zipEntry == null) {
                throw new IllegalStateException(RestArb.format("ERROR_FILE_NOT_FOUND", "WEB-INF/web.xml"));
            }
            inputStream = zipFile.getInputStream(zipEntry);
            hashMap.put("product.version", InstallUtils.getVersion(inputStream));
            inputStream = zipFile.getInputStream(zipEntry);
            hashMap.put("config.dir", InstallUtils.getConfigDir(inputStream));
        }
        catch (Exception exception) {
            try {
                throw new IOException(exception);
            }
            catch (Throwable throwable) {
                Closeables.close((Object[])new Object[]{inputStream, zipFile});
                throw throwable;
            }
        }
        Closeables.close((Object[])new Object[]{inputStream, zipFile});
        return hashMap;
    }

    public static String getConfigDir(InputStream inputStream) throws IOException {
        try {
            Node node = (Node)XPaths.select((InputStream)inputStream, (XPaths.Expression)CONFIG_DIR_TEXT, Node.class);
            if (node == null) {
                return null;
            }
            String string = node.getNodeValue();
            if (NullOrEmpty.nullOrEmpty((CharSequence)string)) {
                return null;
            }
            return string.trim();
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
    }

    public static String getVersion(InputStream inputStream) throws IOException {
        try {
            Node node = (Node)XPaths.select((InputStream)inputStream, (XPaths.Expression)VERSION_TEXT, Node.class);
            if (node == null) {
                return null;
            }
            String string = node.getNodeValue();
            if (NullOrEmpty.nullOrEmpty((CharSequence)string)) {
                throw new IllegalStateException(RestArb.getString("ERROR_VERSION_NUM"));
            }
            return string.trim();
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getInstallParamsFromFile(File file) throws IOException {
        String string;
        File file2;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (file != null && file.exists() && (file2 = Files.file((String)(string = file.getParentFile().getPath() + InstallConstants.INSTALL_PARAMS_XML))).exists() && file2.canRead()) {
            Properties properties = new Properties();
            InputStream inputStream = null;
            try {
                inputStream = Files.inputStream((File)file2);
                properties.load(inputStream);
            }
            finally {
                Closeables.close((Object)inputStream);
            }
            if (properties != null) {
                Enumeration<?> enumeration = properties.propertyNames();
                while (enumeration.hasMoreElements()) {
                    Object obj = enumeration.nextElement();
                    String string2 = obj.toString();
                    String string3 = properties.getProperty(string2);
                    if (NullOrEmpty.nullOrEmpty((CharSequence)string3)) continue;
                    hashMap.put(string2, string3);
                }
            }
            hashMap.put("file.parameter", string);
        }
        return hashMap;
    }

    private static boolean isMigrateV1(File file) {
        File file2 = Files.file((File)file, (String)"apex-config.xml");
        return file2.exists();
    }

    private static File getConfigDirContext(File file) {
        File file2 = Files.file((File)file, (String)"apex");
        if (file2.exists() && file2.isDirectory()) {
            return file2;
        }
        file2 = Files.file((File)file, (String)"ords");
        return file2;
    }

    public static RestInstallConstants.InstallType getInstallType(File file) throws Exception {
        File file2 = InstallUtils.getConfigDirContext(file);
        boolean bl = file2.exists();
        if (bl) {
            if (ConfigurationFiles.isConfigured((File)file2)) {
                if (ConfigurationFiles.isMigrateV2((File)file2)) {
                    return RestInstallConstants.InstallType.MIGRATE_V2;
                }
                return RestInstallConstants.InstallType.VERIFY_SCHEMA;
            }
            if (InstallUtils.isMigrateV1(file2)) {
                return RestInstallConstants.InstallType.MIGRATE_V1;
            }
            return RestInstallConstants.InstallType.REQUIRES_CONFIG;
        }
        return RestInstallConstants.InstallType.REQUIRES_CONFIG;
    }

    public static boolean isDefaultConfigFileExist(File file) throws Exception {
        File file2;
        File file3 = InstallUtils.getConfigDirContext(file);
        return file3.exists() && (file2 = Files.file((File)file3, (String)"apex-config.xml")).exists() && file2.isFile();
    }
}

