/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.autorest.wizard;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.regex.Pattern;
import oracle.dbtools.autorest.generator.AutoRestCodeGenerator;
import oracle.dbtools.autorest.model.AutoRestListTask;
import oracle.dbtools.autorest.model.RestSchemaData;
import oracle.dbtools.autorest.ui.RestSchemaSummaryPanel;
import oracle.dbtools.autorest.wizard.AbstractScriptRunnerTraversablePanel;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;

public class RestWizSchemaSummaryPanel
extends AbstractScriptRunnerTraversablePanel {
    private transient RestSchemaData restSchemaDataModel;
    private RestSchemaSummaryPanel schemaSummaryPanel;
    private GridBagLayout gridBagLayout = new GridBagLayout();

    private void jbInit(TraversableContext traversableContext) {
        this.setName("RestWizSchemaSummaryPanel");
        this.restSchemaDataModel = (RestSchemaData)traversableContext.get("KEY_REST_SCHEMA_DATA");
        this.schemaSummaryPanel = new RestSchemaSummaryPanel(this.restSchemaDataModel, this.getScriptEditorTabName(), this.createScriptPane());
        this.setLayout(this.gridBagLayout);
        this.add(this.schemaSummaryPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 23, 1, new Insets(0, 0, 10, 0), 0, 0));
    }

    public void onEntry(TraversableContext traversableContext) {
        if (this.schemaSummaryPanel == null) {
            this.jbInit(traversableContext);
        }
        this.schemaSummaryPanel.addListeners();
        this.schemaSummaryPanel.updatePanel();
        traversableContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true));
    }

    public void onExitImpl(TraversableContext traversableContext) throws TraversalException {
        this.schemaSummaryPanel.removeListeners();
        if (traversableContext.getDirection() == 1) {
            // empty if block
        }
    }

    @Override
    protected void validateData(TraversableContext traversableContext) throws TraversalException {
        RestSchemaData restSchemaData = (RestSchemaData)traversableContext.get("KEY_REST_SCHEMA_DATA");
        DBObject dBObject = (DBObject)traversableContext.get("KEY_DBOBJECT");
        if (restSchemaData.isEnabled()) {
            TableColumnsListTask tableColumnsListTask;
            try {
                tableColumnsListTask = new TableColumnsListTask(dBObject, "COMPLETE_MEMBER_LIST", "OBJECT_NAME", "MEMBER_NAME", "VISIBLE", "MEMBER_ALIAS");
            }
            catch (Throwable throwable) {
                tableColumnsListTask = null;
                throwable.printStackTrace();
            }
            if (tableColumnsListTask == null) {
                return;
            }
            RaptorTaskManager.getInstance().addTask(tableColumnsListTask);
            Pattern pattern = Pattern.compile("\\p{Alpha}([[\\p{Alnum}]#$_])*$");
        }
    }

    @Override
    protected String getTitle() {
        return "SummaryTitle";
    }

    private class TableColumnsListTask
    extends AutoRestListTask {
        String template;
        String[] resultColumns;
        DBObject dbObj;

        public TableColumnsListTask(DBObject dBObject, String string, String ... stringArray) {
            this.template = string;
            this.resultColumns = stringArray;
            this.dbObj = dBObject;
        }

        @Override
        public String getQuery() {
            String string = "query";
            if (this.dbObj != null) {
                AutoRestCodeGenerator autoRestCodeGenerator = AutoRestCodeGenerator.getInstance();
                String string2 = this.dbObj.getSchemaName();
                String string3 = this.dbObj.getObjectName();
                String string4 = this.dbObj.getDBVersion();
                string = autoRestCodeGenerator.generate(string4, this.template, "owner", string2, "object", string3);
            }
            return string;
        }

        @Override
        public DBObject getDBObject() {
            return this.dbObj;
        }

        @Override
        public String[] getResultColumnNames() {
            return this.resultColumns;
        }
    }
}

