/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.autorest.wizard;

import java.awt.Frame;
import java.sql.Connection;
import javax.swing.JDialog;
import oracle.bali.ewt.wizard.WizardDialog;
import oracle.dbtools.autorest.AutoRestArb;
import oracle.dbtools.autorest.model.RestSchemaData;
import oracle.dbtools.autorest.model.RestSchemaDataInitialiser;
import oracle.dbtools.autorest.wizard.RestWizSchemaDetailsPanel;
import oracle.dbtools.autorest.wizard.RestWizSchemaSummaryPanel;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.util.Namespace;
import oracle.ide.wizard.FSM;
import oracle.ide.wizard.FSMBuilder;
import oracle.ide.wizard.FSMInvalidException;
import oracle.ide.wizard.FSMWizard;
import oracle.ide.wizard.Step;

public class AutoRestSchemaWizard {
    public static final String STATE_DETAILS = "State.Details";
    public static final String TRANSITION_OBJECTS = "Transition.Objects";
    public static final String STATE_OBJECTS = "State.Objects";
    public static final String TRANSITION_FINISH = "Transition.Finish";
    public static final String STATE_FINISH = "State.Finish";
    public static final String KEY_REST_SCHEMA_DATA = "KEY_REST_SCHEMA_DATA";
    public static final String KEY_REST_DIALOG = "KEY_REST_DIALOG";
    private static AutoRestSchemaWizard INSTANCE;

    public static AutoRestSchemaWizard getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new AutoRestSchemaWizard();
        }
        return INSTANCE;
    }

    public RestSchemaData launchEnableRESTForSchema(Context context) {
        Connection connection;
        Namespace namespace = new Namespace();
        DBObject dBObject = (DBObject)context.getProperty("ObjectAction.DBOBJECT");
        RestSchemaData restSchemaData = new RestSchemaData();
        RestSchemaDataInitialiser restSchemaDataInitialiser = new RestSchemaDataInitialiser(restSchemaData, dBObject);
        restSchemaData.setSchemaAlias(dBObject.getSchemaName().toLowerCase());
        try {
            connection = dBObject.getConnection();
            String string = connection.getMetaData().getUserName();
            restSchemaData.setSchemaName(string);
        }
        catch (Throwable throwable) {
            restSchemaData.setSchemaName(dBObject.getSchemaName());
        }
        namespace.put(KEY_REST_SCHEMA_DATA, (Object)restSchemaData);
        namespace.put("KEY_DBOBJECT", (Object)dBObject);
        connection = AutoRestSchemaWizard.getFSMforEnableRESTForObject();
        try {
            new Thread(restSchemaDataInitialiser).start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        boolean bl = this.launchWizard((FSM)connection, namespace);
        if (bl) {
            RestSchemaData restSchemaData2 = (RestSchemaData)namespace.get(KEY_REST_SCHEMA_DATA);
            return restSchemaData2;
        }
        return null;
    }

    public boolean launchWizard(FSM fSM, Namespace namespace) {
        FSMWizard fSMWizard = new FSMWizard(fSM, namespace);
        fSMWizard.setWizardTitle(AutoRestArb.getString("WIZ_TITLE"));
        fSMWizard.setLogoImage(AutoRestArb.getImage("WIZ_LOGO_IMAGE"));
        fSMWizard.setRoadmapVisible(true);
        fSMWizard.setSize(800, 800);
        WizardDialog wizardDialog = fSMWizard.getDialog((Frame)Ide.getMainWindow());
        namespace.put("KEY_DIALOG", (Object)wizardDialog);
        boolean bl = WizardLauncher.runDialog((JDialog)wizardDialog);
        return bl;
    }

    private static FSM getFSMforEnableRESTForObject() {
        FSMBuilder fSMBuilder = new FSMBuilder();
        Step step = new Step(AutoRestArb.getString("WIZ_SCHEMA_STEP_REST_DETAILS"), RestWizSchemaDetailsPanel.class, "f1_rest_schema_details_html");
        fSMBuilder.newStartState(step, (Object)STATE_FINISH);
        fSMBuilder.addStateTrans((Object)TRANSITION_FINISH, (Object)STATE_FINISH);
        Step step2 = new Step(AutoRestArb.getString("WIZ_STEP_SUMMARY"), RestWizSchemaSummaryPanel.class, "f1_rest_schema_summary_html");
        fSMBuilder.newFinalState((Object)STATE_FINISH, step2);
        try {
            return fSMBuilder.getFSM();
        }
        catch (FSMInvalidException fSMInvalidException) {
            return null;
        }
    }
}

