/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.autorest.wizard;

import java.awt.Frame;
import javax.swing.JDialog;
import oracle.bali.ewt.wizard.WizardDialog;
import oracle.dbtools.autorest.AutoRestArb;
import oracle.dbtools.autorest.model.RestObjectData;
import oracle.dbtools.autorest.model.RestObjectDataInitialiser;
import oracle.dbtools.autorest.wizard.RestWizObjectDetailsPanel;
import oracle.dbtools.autorest.wizard.RestWizObjectSummaryPanel;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.util.Namespace;
import oracle.ide.wizard.FSM;
import oracle.ide.wizard.FSMBuilder;
import oracle.ide.wizard.FSMInvalidException;
import oracle.ide.wizard.FSMWizard;
import oracle.ide.wizard.Step;

public class AutoRestObjectWizard {
    public static final String STATE_DETAILS = "State.Details";
    public static final String TRANSITION_COLUMNS = "Transition.Members";
    public static final String STATE_MEMBERS = "State.Members";
    public static final String TRANSITION_FINISH = "Transition.Finish";
    public static final String STATE_FINISH = "State.Finish";
    public static final String KEY_REST_OBJECT_DATA = "KEY_REST_OBJECT_DATA";
    public static final String KEY_REST_DIALOG = "KEY_REST_DIALOG";
    private static AutoRestObjectWizard INSTANCE;

    public static AutoRestObjectWizard getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new AutoRestObjectWizard();
        }
        return INSTANCE;
    }

    public RestObjectData launchEnableRESTForObject(Context context) {
        Namespace namespace = new Namespace();
        DBObject dBObject = (DBObject)context.getProperty("ObjectAction.DBOBJECT");
        RestObjectData restObjectData = new RestObjectData();
        RestObjectDataInitialiser restObjectDataInitialiser = new RestObjectDataInitialiser(restObjectData, dBObject);
        restObjectData.setObjectAlias(dBObject.getObjectName().toLowerCase());
        restObjectData.setObjectName(dBObject.getObjectName());
        namespace.put(KEY_REST_OBJECT_DATA, (Object)restObjectData);
        namespace.put("KEY_DBOBJECT", (Object)dBObject);
        FSM fSM = AutoRestObjectWizard.getFSMforEnableRESTForObject();
        try {
            new Thread(restObjectDataInitialiser).start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        boolean bl = this.launchWizard(fSM, namespace);
        if (bl) {
            RestObjectData restObjectData2 = (RestObjectData)namespace.get(KEY_REST_OBJECT_DATA);
            return restObjectData2;
        }
        return null;
    }

    public boolean launchWizard(FSM fSM, Namespace namespace) {
        FSMWizard fSMWizard = new FSMWizard(fSM, namespace);
        fSMWizard.setWizardTitle(AutoRestArb.getString("WIZ_TITLE"));
        fSMWizard.setLogoImage(AutoRestArb.getImage("WIZ_LOGO_IMAGE"));
        fSMWizard.setRoadmapVisible(true);
        fSMWizard.setSize(800, 800);
        WizardDialog wizardDialog = fSMWizard.getDialog((Frame)Ide.getMainWindow());
        namespace.put("KEY_DIALOG", (Object)wizardDialog);
        boolean bl = WizardLauncher.runDialog((JDialog)wizardDialog);
        return bl;
    }

    private static FSM getFSMforEnableRESTForObject() {
        FSMBuilder fSMBuilder = new FSMBuilder();
        Step step = new Step(AutoRestArb.getString("WIZ_OBJECT_STEP_REST_DETAILS"), RestWizObjectDetailsPanel.class, "f1_rest_object_details_html");
        fSMBuilder.newStartState(step, (Object)STATE_FINISH);
        Step step2 = new Step(AutoRestArb.getString("WIZ_STEP_SUMMARY"), RestWizObjectSummaryPanel.class, "f1_rest_object_summary_html");
        fSMBuilder.newFinalState((Object)STATE_FINISH, step2);
        try {
            return fSMBuilder.getFSM();
        }
        catch (FSMInvalidException fSMInvalidException) {
            return null;
        }
    }
}

