/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.file;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.ide.Ide;
import oracle.ide.config.EnvironOptions;
import oracle.ide.config.Preferences;
import oracle.ide.file.ContentSetRoot;
import oracle.ide.file.FileSet;
import oracle.ide.file.FileSetFilter;
import oracle.ide.file.FileSetFilters;
import oracle.ide.file.FileTable;
import oracle.ide.file.Path;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Dependable;
import oracle.ide.model.DependencyConfiguration;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.TechnologyScopeConfiguration;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ide.persistence.NameSpace;
import oracle.ide.persistence.Storage;
import oracle.ide.persistence.Storages;
import oracle.ide.util.PatternFilter;
import oracle.ide.util.PatternFilters;
import oracle.javatools.assembly.AssemblyException;
import oracle.javatools.assembly.AssemblyFactory;
import oracle.javatools.assembly.ObjectFactory;
import oracle.javatools.assembly.StringFactory;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.PropertyStorage;

public class ProjectCache {
    protected static final Logger LOGGER = Logger.getLogger(ProjectCache.class.getName());
    private static final String NAMESPACE_NAME = "oracle.ide.file.ProjectCache";
    private static final String ALL_CONTENT_KEY = "all$";
    private static final String DEPENDENCY_KEY = "dep$";
    private static final String TECHNOLOGY_KEY = "tech$";
    private static final NameSpace USER_TIMESTAMPS = NameSpace.getNameSpace((String)"IdeProjectCacheTimestamps");
    private static final boolean ENABLED = Ide.isRunning() && USER_TIMESTAMPS != null && !Boolean.getBoolean("ide.project.cache.disabled");
    private static boolean verifyCache = false;
    private final AssemblyFactory fileSetFactory = new FileSetFactory();
    protected final AssemblyFactory pathFactory = new PathFactory();
    private final AssemblyFactory cachedPathFactory = new CacheEntryFactory(this.pathFactory);
    private final AssemblyFactory dependencyFactory = new CacheEntryFactory((AssemblyFactory)new DependencyFactory());
    private final AssemblyFactory technologyFactory = new CacheEntryFactory((AssemblyFactory)new TechnologyFactory());
    protected final Workspace workspace;
    protected final Storage storage;
    protected final NameSpace namespace;
    private Project lastProject;
    private String lastProjectKey;

    public static ProjectCache getInstance(Workspace workspace) {
        return new ProjectCache(workspace);
    }

    public static void invalidate(Workspace workspace) {
        ProjectCache.putUserTimestamp(workspace, System.currentTimeMillis());
    }

    public static void invalidate(Collection<Project> projects) {
        long timestamp = System.currentTimeMillis();
        for (Project project : projects) {
            ProjectCache.putUserTimestamp(project, timestamp);
        }
    }

    public static void invalidate(Project project) {
        ProjectCache.putUserTimestamp(project, System.currentTimeMillis());
    }

    private static long getUserTimestamp(String key) {
        byte[] record;
        if (USER_TIMESTAMPS != null && (record = USER_TIMESTAMPS.getRecord(key)) != null) {
            try {
                return Long.parseLong(new String(record, "UTF-8"), 36);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return -1L;
    }

    private static void putUserTimestamp(String key, long timestamp) {
        if (USER_TIMESTAMPS != null) {
            try {
                USER_TIMESTAMPS.putRecord(key, Long.toString(timestamp, 36).getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
    }

    protected static long getUserTimestamp(Workspace workspace) {
        return ProjectCache.getUserTimestamp(workspace.getURL().toString());
    }

    private static void putUserTimestamp(Workspace workspace, long timestamp) {
        ProjectCache.putUserTimestamp(workspace.getURL().toString(), timestamp);
    }

    protected static long getUserTimestamp(Project project) {
        return ProjectCache.getUserTimestamp(project.getURL().toString());
    }

    private static void putUserTimestamp(Project project, long timestamp) {
        ProjectCache.putUserTimestamp(project.getURL().toString(), timestamp);
    }

    protected ProjectCache(Workspace workspace) {
        this.workspace = workspace;
        if (workspace != null) {
            this.storage = Storages.getApplicationStorage((Workspace)workspace);
            this.storage.open();
            this.namespace = this.storage.getNameSpace(NAMESPACE_NAME);
        } else {
            this.storage = null;
            this.namespace = null;
        }
    }

    public void close() {
        if (this.namespace != null) {
            this.namespace.close();
        }
        if (this.storage != null) {
            this.storage.close();
        }
    }

    public Path getContentPath(Project project) {
        if (project == null) {
            return Path.getInstance();
        }
        Path path = this.getPath(project, ALL_CONTENT_KEY);
        if (path == null) {
            ContentSet content = ProjectContent.getInstance((PropertyStorage)this.loadProject(project)).getAllContents();
            path = ContentSetRoot.asPath(ContentSetRoot.getContentSetRoots(project, content));
            this.putPath(project, ALL_CONTENT_KEY, path);
        }
        return path;
    }

    public Path getContentPath(Project project, String contentSetKey) {
        if (project == null) {
            return Path.getInstance();
        }
        Path path = this.getPath(project, contentSetKey);
        if (path == null) {
            ContentSet content = ProjectContent.getInstance((PropertyStorage)this.loadProject(project)).getContentSet(contentSetKey);
            path = ContentSetRoot.asPath(ContentSetRoot.getContentSetRoots(project, content));
            this.putPath(project, contentSetKey, path);
        }
        return path;
    }

    public Collection<Project> getDirectDependencies(Project project) {
        byte[] record;
        if (project == null) {
            return Collections.emptyList();
        }
        Collection<Project> dependencies = null;
        if (ProjectCache.isEnabled() && this.namespace != null && (record = this.namespace.getRecord(this.getProjectKey(project, DEPENDENCY_KEY))) != null) {
            try {
                CacheEntry cachedDependencies = (CacheEntry)this.dependencyFactory.assemble(record);
                if (this.isValid(project, cachedDependencies)) {
                    dependencies = (Collection)cachedDependencies.getEntry();
                }
            }
            catch (AssemblyException cachedDependencies) {
                // empty catch block
            }
        }
        if (dependencies == null) {
            dependencies = new ArrayList();
            DependencyConfiguration config = DependencyConfiguration.getInstance((Project)this.loadProject(project));
            List dependables = config.getDependencyList();
            if (dependables != null) {
                for (Dependable dependency : dependables) {
                    Element source = dependency.getSource();
                    if (!(source instanceof Project)) continue;
                    dependencies.add((Project)source);
                }
            }
            if (ProjectCache.isEnabled() && this.namespace != null) {
                try {
                    CacheEntry entry = new CacheEntry(dependencies, project.getTimestamp(), ProjectCache.getUserTimestamp(this.workspace), ProjectCache.getUserTimestamp(project));
                    byte[] record2 = this.dependencyFactory.disassemble(entry);
                    this.namespace.putRecord(this.getProjectKey(project, DEPENDENCY_KEY), record2);
                }
                catch (AssemblyException assemblyException) {
                    // empty catch block
                }
            }
        }
        return dependencies;
    }

    public Collection<Project> getTransitiveDependencies(Project project) throws InterruptedException {
        IdentityHashMap<Project, Project> dependencies = new IdentityHashMap<Project, Project>();
        IdentityHashMap<Project, Project> alreadySeen = new IdentityHashMap<Project, Project>();
        this.getDependenciesImpl(project, dependencies, alreadySeen);
        return dependencies.keySet();
    }

    public Collection<Project> getDownstreamDependencies(Project project) throws InterruptedException {
        if (this.workspace == null) {
            return Collections.emptySet();
        }
        ArrayList<Project> downstream = new ArrayList<Project>();
        block0: for (Project p : this.workspace.projects()) {
            ProjectCache.checkInterrupt();
            for (Project d : this.getDirectDependencies(p)) {
                ProjectCache.checkInterrupt();
                if (d != project || p == project) continue;
                downstream.add(p);
                continue block0;
            }
        }
        return downstream;
    }

    public String[] getTechnologyScopeKeys(Project project) {
        byte[] record;
        if (project == null) {
            return new String[0];
        }
        String[] technologyKeys = null;
        if (ProjectCache.isEnabled() && this.namespace != null && (record = this.namespace.getRecord(this.getProjectKey(project, TECHNOLOGY_KEY))) != null) {
            try {
                CacheEntry cachedTechnologyKeys = (CacheEntry)this.technologyFactory.assemble(record);
                if (this.isValid(project, cachedTechnologyKeys)) {
                    technologyKeys = (String[])cachedTechnologyKeys.getEntry();
                }
            }
            catch (AssemblyException cachedTechnologyKeys) {
                // empty catch block
            }
        }
        if (technologyKeys == null) {
            technologyKeys = TechnologyScopeConfiguration.getInstance((PropertyStorage)this.loadProject(project)).getTechnologyScope().getTechnologyKeys();
            if (ProjectCache.isEnabled() && this.namespace != null) {
                try {
                    CacheEntry<String[]> entry = new CacheEntry<String[]>(technologyKeys, project.getTimestamp(), ProjectCache.getUserTimestamp(this.workspace), ProjectCache.getUserTimestamp(project));
                    byte[] record2 = this.technologyFactory.disassemble(entry);
                    this.namespace.putRecord(this.getProjectKey(project, TECHNOLOGY_KEY), record2);
                }
                catch (AssemblyException assemblyException) {
                    // empty catch block
                }
            }
        }
        return technologyKeys;
    }

    private void getDependenciesImpl(Project project, Map<Project, Project> dependencies, Map<Project, Project> alreadySeen) throws InterruptedException {
        alreadySeen.put(project, project);
        for (Project dependency : this.getDirectDependencies(project)) {
            ProjectCache.checkInterrupt();
            if (alreadySeen.containsKey(dependency)) continue;
            dependencies.put(dependency, dependency);
            this.getDependenciesImpl(dependency, dependencies, alreadySeen);
        }
    }

    protected Path getPath(Project project, String key) {
        byte[] record;
        Path path = null;
        if (ProjectCache.isEnabled() && this.namespace != null && (record = this.namespace.getRecord(this.getProjectKey(project, key))) != null) {
            try {
                CacheEntry cachedPath = (CacheEntry)this.cachedPathFactory.assemble(record);
                if (this.isValid(project, cachedPath)) {
                    path = (Path)cachedPath.getEntry();
                }
            }
            catch (AssemblyException e) {
                LOGGER.log(Level.FINE, "Unable to get path from cache for " + key, e);
            }
        }
        return path;
    }

    protected void putPath(Project project, String key, Path path) {
        if (ProjectCache.isEnabled() && this.namespace != null) {
            try {
                CacheEntry<Path> entry = new CacheEntry<Path>(path, project.getTimestamp(), ProjectCache.getUserTimestamp(this.workspace), ProjectCache.getUserTimestamp(project));
                byte[] record = this.cachedPathFactory.disassemble(entry);
                if (record != null) {
                    this.namespace.putRecord(this.getProjectKey(project, key), record);
                }
            }
            catch (AssemblyException e) {
                LOGGER.log(Level.FINE, "Unable to put path into cache for " + key, e);
            }
        }
    }

    protected Project loadProject(Project project) {
        if (ProjectCache.isEnabled() && LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Cache miss for " + URLFileSystem.getPlatformPathName((URL)project.getURL()) + ", loading project.");
        }
        return project;
    }

    protected Logger getLogger() {
        return LOGGER;
    }

    protected String getProjectKey(Project project, String key) {
        return key + this.getBaseProjectKey(project);
    }

    private String getBaseProjectKey(Project project) {
        if (project != this.lastProject) {
            this.lastProjectKey = this.storage.getRelativePath(project.getURL());
            this.lastProject = project;
        }
        return this.lastProjectKey;
    }

    protected boolean isValid(Project project, CacheEntry entry) {
        if (FileTable.VERIFY_FILE_TABLES) {
            return false;
        }
        if ((ProjectCache.isVerifyCache() || project.isLoaded()) && entry.getProjectTimestamp() != project.getTimestamp()) {
            return false;
        }
        return entry.getUserProjectTimestamp() == ProjectCache.getUserTimestamp(project) && entry.getUserWorkspaceTimestamp() == ProjectCache.getUserTimestamp(this.workspace);
    }

    protected static boolean isEnabled() {
        return ENABLED;
    }

    private static synchronized boolean isVerifyCache() {
        return verifyCache;
    }

    private static void checkInterrupt() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    static {
        if (ProjectCache.isEnabled()) {
            EnvironOptions envOptions = EnvironOptions.getInstance((PropertyStorage)Preferences.getPreferences());
            verifyCache = envOptions != null && envOptions.getVerifyCachedFileData();
            envOptions.addChangeListener(new ChangeListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void stateChanged(ChangeEvent e) {
                    Class<ProjectCache> clazz = ProjectCache.class;
                    synchronized (ProjectCache.class) {
                        EnvironOptions envOptions = EnvironOptions.getInstance((PropertyStorage)Preferences.getPreferences());
                        verifyCache = envOptions != null && envOptions.getVerifyCachedFileData();
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                }
            });
        }
    }

    protected static final class CacheEntry<E> {
        private final E entry;
        private final long projectTimestamp;
        private final long userProjectTimestamp;
        private final long userWorkspaceTimestamp;

        public CacheEntry(E entry, long projectTimestamp, long userWorkspaceTimestamp, long userProjectTimestamp) {
            this.entry = entry;
            this.projectTimestamp = projectTimestamp;
            this.userWorkspaceTimestamp = userWorkspaceTimestamp;
            this.userProjectTimestamp = userProjectTimestamp;
        }

        public E getEntry() {
            return this.entry;
        }

        public long getProjectTimestamp() {
            return this.projectTimestamp;
        }

        public long getUserWorkspaceTimestamp() {
            return this.userWorkspaceTimestamp;
        }

        public long getUserProjectTimestamp() {
            return this.userProjectTimestamp;
        }
    }

    protected final class CacheEntryFactory<E>
    extends ObjectFactory {
        private final AssemblyFactory factory;

        public CacheEntryFactory(AssemblyFactory factory) {
            this.factory = factory;
        }

        public byte getObjectCode() {
            return -107;
        }

        public Object assembleImpl(DataInput input) throws IOException, AssemblyException {
            long projectTimestamp = input.readLong();
            long userWorkspaceTimestamp = input.readLong();
            long userProjectTimestamp = input.readLong();
            Object entry = this.factory.assemble(input);
            return new CacheEntry<Object>(entry, projectTimestamp, userWorkspaceTimestamp, userProjectTimestamp);
        }

        public void disassembleImpl(Object object, DataOutput output) throws IOException, ClassCastException, AssemblyException {
            CacheEntry entry = (CacheEntry)object;
            output.writeLong(entry.getProjectTimestamp());
            output.writeLong(entry.getUserWorkspaceTimestamp());
            output.writeLong(entry.getUserProjectTimestamp());
            this.factory.disassemble(entry.getEntry(), output);
        }
    }

    private final class TechnologyFactory
    extends ObjectFactory {
        private TechnologyFactory() {
        }

        public byte getObjectCode() {
            return -110;
        }

        public Object assembleImpl(DataInput input) throws IOException, AssemblyException {
            int size = input.readInt();
            String[] technologyKeys = new String[size];
            for (int i = 0; i < size; ++i) {
                technologyKeys[i] = (String)StringFactory.STRING_FACTORY.assemble(input);
            }
            return technologyKeys;
        }

        public void disassembleImpl(Object object, DataOutput output) throws IOException, ClassCastException, AssemblyException {
            String[] technologyKeys = (String[])object;
            output.writeInt(technologyKeys.length);
            for (String key : technologyKeys) {
                StringFactory.STRING_FACTORY.disassemble((Object)key, output);
            }
        }
    }

    private final class DependencyFactory
    extends ObjectFactory {
        private DependencyFactory() {
        }

        public byte getObjectCode() {
            return -109;
        }

        public Object assembleImpl(DataInput input) throws IOException, AssemblyException {
            int size = input.readInt();
            ArrayList<Project> dependencies = new ArrayList<Project>(size);
            for (int i = 0; i < size; ++i) {
                String relativePath = (String)StringFactory.STRING_FACTORY.assemble(input);
                URL url = ProjectCache.this.storage.getURL(relativePath);
                try {
                    Node node = NodeFactory.findOrCreate((URL)url);
                    if (!(node instanceof Project)) continue;
                    dependencies.add((Project)node);
                    continue;
                }
                catch (IllegalAccessException illegalAccessException) {
                    continue;
                }
                catch (InstantiationException instantiationException) {
                    // empty catch block
                }
            }
            return dependencies;
        }

        public void disassembleImpl(Object object, DataOutput output) throws IOException, ClassCastException, AssemblyException {
            Collection dependencies = (Collection)object;
            output.writeInt(dependencies.size());
            for (Project project : dependencies) {
                URL url = project.getURL();
                String relativePath = ProjectCache.this.storage.getRelativePath(url);
                StringFactory.STRING_FACTORY.disassemble((Object)relativePath, output);
            }
        }
    }

    private final class PathFactory
    extends ObjectFactory {
        private PathFactory() {
        }

        public byte getObjectCode() {
            return -104;
        }

        public Object assembleImpl(DataInput input) throws IOException, AssemblyException {
            int size = input.readInt();
            ArrayList<FileSet> list = new ArrayList<FileSet>(size);
            for (int i = 0; i < size; ++i) {
                list.add((FileSet)ProjectCache.this.fileSetFactory.assemble(input));
            }
            return Path.getInstance(list);
        }

        public void disassembleImpl(Object object, DataOutput output) throws IOException, ClassCastException, AssemblyException {
            Path path = (Path)object;
            output.writeInt(path.size());
            for (FileSet fileSet : path) {
                ProjectCache.this.fileSetFactory.disassemble((Object)fileSet, output);
            }
        }
    }

    private final class FileSetFactory
    extends ObjectFactory {
        private FileSetFactory() {
        }

        public byte getObjectCode() {
            return -103;
        }

        public Object assembleImpl(DataInput input) throws IOException, AssemblyException {
            String relativePath = (String)StringFactory.STRING_FACTORY.assemble(input);
            URL root = ProjectCache.this.storage.getURL(relativePath);
            boolean isAcceptAllFilter = input.readBoolean();
            if (isAcceptAllFilter) {
                return FileSet.getInstance(root);
            }
            String id = (String)StringFactory.STRING_FACTORY.assemble(input);
            int length = id.length();
            if (length == 0) {
                return FileSet.getInstance(root);
            }
            int start = 0;
            ArrayList<PatternFilter> filters = new ArrayList<PatternFilter>();
            for (int i = 1; i < length; ++i) {
                char c = id.charAt(i);
                if (c != '+' && c != '-') continue;
                filters.add(PatternFilter.fromStr((String)id.substring(start, i)));
                start = i;
            }
            filters.add(PatternFilter.fromStr((String)id.substring(start, length)));
            PatternFilters pf = PatternFilters.getInstance((HashStructure)HashStructure.newInstance());
            pf.setFilters(filters.toArray(new PatternFilter[filters.size()]));
            return FileSet.getInstance(root, FileSetFilters.getFileSetFilter(pf));
        }

        public void disassembleImpl(Object object, DataOutput output) throws IOException, ClassCastException, AssemblyException {
            FileSet fileSet = (FileSet)object;
            String relativePath = ProjectCache.this.storage.getRelativePath(fileSet.getRoot());
            StringFactory.STRING_FACTORY.disassemble((Object)relativePath, output);
            FileSetFilter filter = fileSet.getFilter();
            if (FileSetFilters.isAcceptAllFilter(filter)) {
                output.writeBoolean(true);
            } else {
                output.writeBoolean(false);
                String id = filter.getUniqueIdentifier();
                StringFactory.STRING_FACTORY.disassemble((Object)id, output);
            }
        }
    }
}

