/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.file;

import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.WeakHashMap;
import oracle.ide.file.FileSetFilter;
import oracle.ide.file.FileSetFilters;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLKey;
import oracle.javatools.annotations.NotNull;
import oracle.javatools.util.NullArgumentException;

public class FileSet {
    private static WeakHashMap<FileSet, WeakReference<FileSet>> pool = new WeakHashMap();
    private final URLKey root;
    private final FileSetFilter filter;

    public static FileSet getInstance(@NotNull URL root) {
        if (root == null) {
            throw new NullArgumentException("null root URL");
        }
        return FileSet.getInstance(root, FileSetFilters.getAcceptAllFilter());
    }

    public static FileSet getInstance(@NotNull URL root, @NotNull FileSetFilter filter) {
        if (root == null) {
            throw new NullArgumentException("null root URL");
        }
        if (filter == null) {
            throw new NullArgumentException("null filter");
        }
        return new FileSet(FileSet.getNormalizedUrl(root), filter);
    }

    private static URL getNormalizedUrl(URL url) {
        if (!URLFileSystem.isDirectoryPath((URL)url)) {
            if (FileSet.isJarFileUrl(url)) {
                if (JarUtil.isJarURL((URL)url)) {
                    return URLFactory.newJarURL((URL)JarUtil.getJarFileURL((URL)url), (String)JarUtil.getJarEntry((URL)url));
                }
                return URLFactory.newJarURL((URL)url, null);
            }
            return URLFactory.replacePathPart((URL)url, (String)(url.getPath() + "/"));
        }
        return url;
    }

    private static boolean isJarFileUrl(URL url) {
        String suffix = URLFileSystem.getSuffix((URL)url).toLowerCase();
        return ".jar".equals(suffix) || ".zip".equals(suffix);
    }

    protected FileSet(URL root, FileSetFilter filter) {
        this(URLKey.getInstance((URL)root), filter);
    }

    private FileSet(URLKey root, FileSetFilter filter) {
        this.root = root;
        this.filter = filter;
    }

    public URL getRoot() {
        return this.root.toURL();
    }

    public FileSetFilter getFilter() {
        return this.filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileSet intern() {
        WeakHashMap<FileSet, WeakReference<FileSet>> weakHashMap = pool;
        synchronized (weakHashMap) {
            FileSet interned;
            WeakReference<FileSet> ref = pool.get(this);
            FileSet fileSet = interned = ref == null ? null : (FileSet)ref.get();
            if (interned == null) {
                URLKey internedRoot = this.root.intern();
                interned = internedRoot == this.root ? this : new FileSet(internedRoot, this.filter);
                pool.put(interned, new WeakReference<FileSet>(interned));
            }
            return interned;
        }
    }

    public boolean contains(URL url) {
        String path = URLFileSystem.toRelativeSpec((URL)url, (URL)this.root.toURL(), (boolean)true);
        if (path != null) {
            return URLFileSystem.isDirectoryPath((URL)url) ? this.filter.acceptDirectory(path) : this.filter.acceptFile(path);
        }
        return false;
    }

    public String getRelativePath(URL url) {
        String path = URLFileSystem.toRelativeSpec((URL)url, (URL)this.root.toURL(), (boolean)true);
        if (path != null) {
            if (URLFileSystem.isDirectoryPath((URL)url)) {
                return this.filter.acceptDirectory(path) ? path : null;
            }
            return this.filter.acceptFile(path) ? path : null;
        }
        return null;
    }

    public int hashCode() {
        int hashCode = 31 * this.root.hashCode() + this.filter.hashCode();
        return hashCode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileSet)) {
            return false;
        }
        FileSet other = (FileSet)o;
        return this.root.equals((Object)other.root) && this.filter.equals(other.filter);
    }

    public String toString() {
        return String.format("%s[%s]", URLFileSystem.getPlatformPathName((URL)this.root.toURL()), this.filter.toString());
    }
}

