/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.docking.DockStation;
import oracle.ide.keyboard.KeyUtil;
import oracle.ide.util.DefaultStructuredPropertyAccess;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.StructuredPropertyAccess;
import oracle.ideimpl.MainWindowImpl;
import oracle.ideimpl.controls.dockLayout.DockInsertionPoint;
import oracle.ideimpl.controls.dockLayout.DockLayout;
import oracle.ideimpl.controls.dockLayout.DockLayoutConstraint;
import oracle.ideimpl.controls.dockLayout.DockLayoutInfo;
import oracle.ideimpl.controls.dockLayout.DockLayoutInfoLeaf;
import oracle.ideimpl.controls.dockLayout.DockLayoutPanel;
import oracle.ideimpl.editor.DesktopDropZone;
import oracle.ideimpl.editor.EditorCriteriaImpl;
import oracle.ideimpl.editor.EditorManagerImpl;
import oracle.ideimpl.editor.EditorPathImpl;
import oracle.ideimpl.editor.TabGroup;
import oracle.ideimpl.editor.TabGroupState;
import oracle.ideimpl.editor.TabGroupXMLLayoutPersistence;
import oracle.ideimpl.editor.TransferableEditorTab;
import oracle.ideimpl.layout.LayoutsImpl;
import oracle.ideimpl.util.DropFileUtil;
import oracle.ideimpl.window.MaximizedWindowInfo;
import oracle.javatools.ui.themes.Themes;

final class Desktop
extends JLayeredPane
implements MaximizedWindowInfo,
DropTargetListener {
    private int _currentTabGroupPos = -1;
    private final DockLayoutPanel _dockLayoutPanel;
    private final JPanel _background = new JPanel();
    private DesktopDropZone _desktopDropZone;
    private static final Integer LAYER_BACKGROUND = JLayeredPane.DEFAULT_LAYER;
    private static final Integer LAYER_DOCKPANEL = JLayeredPane.DEFAULT_LAYER + 1;
    private final DesktopFocusTraversalPolicy _focusTraversalPolicy;
    private static final String LAYOUT_ROOT_KEY = "editorPositions";
    private TabGroup _maximizedTabGroup;

    public Desktop() {
        this._background.setName("desktopBackground");
        if (Themes.isThemed()) {
            this._background.setOpaque(false);
        }
        this.add((Component)this._background, LAYER_BACKGROUND);
        this._dockLayoutPanel = new DockLayoutPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                this.paintDivider(g, this._layout.getVertDividers(this), true);
            }
        };
        this._dockLayoutPanel.setName("dockLayoutPanel");
        this._dockLayoutPanel.setPaintingDividers(false);
        this._dockLayoutPanel.setVisible(false);
        this.add((Component)this._dockLayoutPanel, LAYER_DOCKPANEL);
        new DropTarget(this._background, 2, this);
        KeyUtil.removeCtrlTabFromTraversalKeys(this);
        this.setFocusCycleRoot(true);
        FocusTraversalPolicy defaultFocusTraversalPolicy = this.getFocusTraversalPolicy();
        this._focusTraversalPolicy = new DesktopFocusTraversalPolicy(defaultFocusTraversalPolicy);
        this.setFocusTraversalPolicy(this._focusTraversalPolicy);
    }

    void freezeFocusChanges(boolean freeze) {
        this._focusTraversalPolicy.setFocusChangeFrozen(freeze);
        if (!this._focusTraversalPolicy.isFocusChangeFrozen() && this.getTabGroupCount() == 0 && !Ide.isStarting()) {
            IdeUtil.tryToRestoreFocus(null);
        }
    }

    void dump(String indent) {
        System.out.println(indent + "Desktop");
        int tabGroupCount = this.getTabGroupCount();
        for (int i = 0; i < tabGroupCount; ++i) {
            TabGroup tabGroup = this.getTabGroup(i);
            boolean active = i == this._currentTabGroupPos;
            tabGroup.dump("  ", active);
        }
    }

    void setDropPanesVisible(boolean visible) {
        if (visible) {
            if (this._desktopDropZone == null) {
                this._desktopDropZone = new DesktopDropZone(this._dockLayoutPanel);
                this.add((Component)this._desktopDropZone, JLayeredPane.DRAG_LAYER);
            }
        } else if (this._desktopDropZone != null) {
            this.remove(this._desktopDropZone);
            this._desktopDropZone = null;
            this.repaint();
        }
    }

    @Override
    public void addNotify() {
        if (Themes.isThemed()) {
            this._background.setOpaque(false);
        } else {
            Color color = UIManager.getColor("Desktop.background");
            this._background.setBackground(color);
        }
        super.addNotify();
    }

    @Override
    public void doLayout() {
        Dimension size = this.getSize();
        this.maximizeComponents(LAYER_BACKGROUND, size);
        this.maximizeComponents(LAYER_DOCKPANEL, size);
    }

    private void maximizeComponents(Integer layer, Dimension size) {
        Component[] componentsInLayer = this.getComponentsInLayer(layer);
        for (int i = 0; i < componentsInLayer.length; ++i) {
            Component component = componentsInLayer[i];
            component.setBounds(0, 0, size.width, size.height);
        }
    }

    JComponent getDesktopBackground() {
        return this._background;
    }

    public int getVisibleTabGroupCount() {
        int count = 0;
        int i = this.getTabGroupCount();
        while (--i >= 0) {
            TabGroup tabGroup = this.getTabGroup(i);
            if (!tabGroup.isVisible()) continue;
            ++count;
        }
        return count;
    }

    public int getTabGroupCount() {
        return this._dockLayoutPanel.getComponentCount();
    }

    public TabGroup getTabGroup(int i) {
        return (TabGroup)this._dockLayoutPanel.getComponent(i);
    }

    private int indexOf(TabGroup tabGroup) {
        int tabGroupCount = this.getTabGroupCount();
        for (int i = 0; i < tabGroupCount; ++i) {
            if (tabGroup != this.getTabGroup(i)) continue;
            return i;
        }
        return -1;
    }

    boolean getCurrentEditorPath(EditorPathImpl editorPath) {
        boolean ret = false;
        editorPath._tabGroupPos = this.getCurrentTabGroupPos();
        if (editorPath._tabGroupPos != -1) {
            TabGroup tabGroup = this.getTabGroup(editorPath._tabGroupPos);
            ret = tabGroup.getCurrentEditorPath(editorPath);
        }
        return ret;
    }

    public int getCurrentTabGroupPos() {
        return this._currentTabGroupPos;
    }

    private boolean isTabPosInvalid(int currentTabGroupPos) {
        return currentTabGroupPos < -1 || currentTabGroupPos == -1 && this.getTabGroupCount() != 0;
    }

    private void validatePos() {
        if (this.isTabPosInvalid(this._currentTabGroupPos)) {
            this._currentTabGroupPos = this.getTabGroupCount() > 0 ? 0 : -1;
        }
    }

    private void setCurrentTabGroupPos(int currentTabGroupPos) {
        if (this.isTabPosInvalid(currentTabGroupPos)) {
            return;
        }
        if (this._currentTabGroupPos != currentTabGroupPos) {
            this._currentTabGroupPos = currentTabGroupPos;
            TabGroup tabGroup = this._currentTabGroupPos != -1 ? this.getTabGroup(currentTabGroupPos) : null;
            this.whenCurrentEditorChanges(tabGroup);
        }
        this.validatePos();
    }

    void maximizeTabGroup(TabGroup tabGroup) {
        this._maximizedTabGroup = tabGroup;
        MainWindowImpl mainWindow = (MainWindowImpl)Ide.getMainWindow();
        mainWindow.maximize(this);
    }

    void restoreTabGroups() {
        MainWindowImpl mainWindow = (MainWindowImpl)Ide.getMainWindow();
        mainWindow.restore();
    }

    boolean isTabGroupMaximized(TabGroup tabGroup) {
        return tabGroup == this._maximizedTabGroup && tabGroup.isVisible();
    }

    public int addTabGroup(TabGroup tabGroup, DockLayoutConstraint constraint) {
        int ret = this._dockLayoutPanel.getComponentCount();
        this._dockLayoutPanel.add((Component)tabGroup, constraint);
        if (this.getTabGroupCount() == 1) {
            this.setCurrentTabGroupPos(0);
        }
        this.whenTabGroupAdded();
        return ret;
    }

    private void whenTabGroupAdded() {
        if (!Themes.isThemed()) {
            this._background.setOpaque(false);
        }
        this._dockLayoutPanel.setVisible(true);
        this._dockLayoutPanel.revalidate();
    }

    public void removeTabGroup(TabGroup tabGroup) {
        int tabGroupPos = this.indexOf(tabGroup);
        this._removeTabGroup(tabGroup);
        MainWindowImpl mainWindow = (MainWindowImpl)Ide.getMainWindow();
        if (mainWindow.getMaximizedWindowType() == 2 && this.getVisibleTabGroupCount() <= 0) {
            this.restoreTabGroups();
        }
        if (this._currentTabGroupPos >= tabGroupPos) {
            --this._currentTabGroupPos;
        }
        if (this.getTabGroupCount() == 0) {
            DockStation dockStation = DockStation.getDockStation();
            dockStation.activateAnyDockable();
        } else if (this._currentTabGroupPos < 0) {
            this._currentTabGroupPos = 0;
        }
        this.validatePos();
    }

    private void _removeTabGroup(TabGroup tabGroup) {
        this._dockLayoutPanel.remove(tabGroup);
        if (this.getTabGroupCount() == 0) {
            if (!Themes.isThemed()) {
                this._background.setOpaque(true);
            }
            this._dockLayoutPanel.setVisible(false);
        }
    }

    final void saveLayout(StructuredPropertyAccess access) {
        TabGroupXMLLayoutPersistence xmlDockLayoutPersistence = new TabGroupXMLLayoutPersistence();
        this._dockLayoutPanel.saveLayout(xmlDockLayoutPersistence, access);
    }

    final void loadLayout(StructuredPropertyAccess access) {
        if (access != null) {
            TabGroupXMLLayoutPersistence xmlDockLayoutPersistence = new TabGroupXMLLayoutPersistence();
            this._dockLayoutPanel.loadLayout(xmlDockLayoutPersistence, access);
            if (this.getTabGroupCount() > 0) {
                this.setCurrentTabGroupPos(0);
                this.whenTabGroupAdded();
            }
        }
    }

    public void saveLayout() {
        DefaultStructuredPropertyAccess editorPositions = new DefaultStructuredPropertyAccess(LAYOUT_ROOT_KEY);
        this.saveLayout(editorPositions);
        LayoutsImpl.getInstance().setLayoutInfo(editorPositions);
    }

    public void loadLayout() {
        if (!Ide.getIdeArgs().hasArg("-noreopen")) {
            StructuredPropertyAccess layoutInfo = LayoutsImpl.getInstance().getLayoutInfo(LAYOUT_ROOT_KEY);
            this.loadLayout(layoutInfo);
        }
    }

    @Override
    public JComponent getMaximizeComponent() {
        return this;
    }

    @Override
    public void maximize() {
        for (int i = 0; i < this.getTabGroupCount(); ++i) {
            TabGroup tg = this.getTabGroup(i);
            if (tg == this._maximizedTabGroup) continue;
            tg.setVisible(false);
        }
        this._maximizedTabGroup.focusCurrentEditor();
    }

    @Override
    public void restore() {
        for (int i = 0; i < this.getTabGroupCount(); ++i) {
            TabGroup tg = this.getTabGroup(i);
            tg.setVisible(true);
        }
        MainWindowImpl mainWindow = (MainWindowImpl)Ide.getMainWindow();
        mainWindow.setDesktop(this);
        this._maximizedTabGroup.focusCurrentEditor();
        this._maximizedTabGroup = null;
    }

    @Override
    public int getWindowType() {
        return 2;
    }

    private static void handleDropTargetDragEvent(DropTargetDragEvent dtde) {
        if (DropFileUtil.canDrop(dtde)) {
            dtde.acceptDrag(2);
        } else {
            dtde.rejectDrag();
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        Desktop.handleDropTargetDragEvent(dtde);
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        Desktop.handleDropTargetDragEvent(dtde);
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
        Desktop.handleDropTargetDragEvent(dtde);
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        DropFileUtil.dropEditorFile(dtde);
    }

    void dropTab(DropTargetDropEvent dtde) {
        Transferable transferable = dtde.getTransferable();
        DockLayout dockLayout = (DockLayout)this._dockLayoutPanel.getLayout();
        dockLayout.lockOptimize();
        Component dropPanel = dtde.getDropTargetContext().getComponent();
        Point location = SwingUtilities.convertPoint(dropPanel, dtde.getLocation(), this._dockLayoutPanel);
        DockInsertionPoint dockInsertionAt = this._dockLayoutPanel.getDockInsertionAt(location);
        if (dockInsertionAt != null) {
            try {
                TransferableEditorTab transferableEditorTab = (TransferableEditorTab)transferable.getTransferData(TransferableEditorTab.contextFlavor);
                Context context = transferableEditorTab.getContext();
                EditorCriteriaImpl editorCriteria = new EditorCriteriaImpl(context);
                EditorPathImpl editorPath = new EditorPathImpl();
                EditorManagerImpl editorManager = EditorManagerImpl.getInstance();
                if (editorManager.searchEditor(editorPath, editorCriteria)) {
                    TabGroup tabGroupSource = editorPath.getTabGroup();
                    JComponent centerReferenceComponent = dockInsertionAt.getCenterReferenceComponent();
                    if (centerReferenceComponent == null) {
                        boolean isValidDock;
                        boolean isReferingSelf;
                        DockLayoutConstraint constraint = dockInsertionAt.createConstraint();
                        Object reference = constraint.getReference();
                        if (reference instanceof DockLayoutInfo) {
                            DockLayoutInfo dockLayoutInfo = (DockLayoutInfo)reference;
                            isReferingSelf = dockLayoutInfo.isReferring(tabGroupSource);
                        } else {
                            isReferingSelf = reference == tabGroupSource;
                        }
                        boolean bl = isValidDock = !isReferingSelf || tabGroupSource.getTabGroupStateCount() > 1;
                        if (isValidDock) {
                            TabGroupState tabGroupState = editorPath.getTabGroupState();
                            TabGroup tabGroupTarget = new TabGroup();
                            tabGroupSource.detachTabGroupState(editorPath._tabGroupStatePos);
                            editorPath._tabGroupStatePos = tabGroupTarget.addTabGroupState(tabGroupState, -1);
                            this.addTabGroup(tabGroupTarget, constraint);
                            editorPath._tabGroupPos = this.indexOf(tabGroupTarget);
                            editorManager.focusEditor(editorPath);
                        }
                    } else {
                        TabGroup tabGroupTarget = (TabGroup)centerReferenceComponent;
                        int tabGroupSourceCount = tabGroupSource.getTabGroupStateCount();
                        if (tabGroupSource != tabGroupTarget || tabGroupSourceCount > 1 && tabGroupSourceCount - 1 > editorPath._tabGroupStatePos) {
                            TabGroupState tabGroupState = editorPath.getTabGroupState();
                            tabGroupSource.detachTabGroupState(editorPath._tabGroupStatePos);
                            editorPath._tabGroupPos = this.indexOf(tabGroupTarget);
                            editorPath._tabGroupStatePos = tabGroupTarget.addTabGroupState(tabGroupState, -1);
                            editorManager.focusEditor(editorPath);
                        }
                    }
                    int tabGroupStateCount = tabGroupSource.getTabGroupStateCount();
                    if (tabGroupStateCount == 0) {
                        this.removeTabGroup(tabGroupSource);
                    }
                }
            }
            catch (UnsupportedFlavorException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        dockLayout.unlockOptimize();
    }

    void detachEditor(EditorPathImpl editorPath) {
        TabGroup tabGroupSource = editorPath.getTabGroup();
        DockLayoutInfoLeaf dockLayoutInfo = this._dockLayoutPanel.getLayoutInfo(tabGroupSource);
        Dimension prefSize = dockLayoutInfo.getSize(2);
        DockLayoutConstraint constraint = new DockLayoutConstraint(tabGroupSource, 1, 1, prefSize);
        TabGroupState tabGroupState = editorPath.getTabGroupState();
        TabGroup tabGroupTarget = new TabGroup();
        tabGroupSource.detachTabGroupState(editorPath._tabGroupStatePos);
        editorPath._tabGroupStatePos = tabGroupTarget.addTabGroupState(tabGroupState, -1);
        this.addTabGroup(tabGroupTarget, constraint);
        editorPath._tabGroupPos = this.indexOf(tabGroupTarget);
        tabGroupTarget.activateEditor(editorPath);
        tabGroupTarget.focusCurrentEditor();
        int tabGroupStateCount = tabGroupSource.getTabGroupStateCount();
        if (tabGroupStateCount == 0) {
            this.removeTabGroup(tabGroupSource);
        }
    }

    void reattachEditors() {
        this.setCurrentTabGroupPos(0);
        TabGroup tabGroupTarget = this.getTabGroup(0);
        int tabGroupCount = this.getTabGroupCount();
        for (int tabGroupPos = 1; tabGroupPos < tabGroupCount; ++tabGroupPos) {
            TabGroup tabGroupSource = this.getTabGroup(1);
            int tabGroupStateCount = tabGroupSource.getTabGroupStateCount();
            for (int tabGroupStatePos = 0; tabGroupStatePos < tabGroupStateCount; ++tabGroupStatePos) {
                TabGroupState tabGroupState = tabGroupSource.getTabGroupState(0);
                tabGroupSource.detachTabGroupState(0);
                tabGroupTarget.addTabGroupState(tabGroupState, -1);
            }
            this.removeTabGroup(tabGroupSource);
        }
    }

    void whenCurrentEditorChanges(TabGroup tabGroup) {
        TabGroup currentTabGroup;
        int currentTabGroupPos = this.getCurrentTabGroupPos();
        TabGroup tabGroup2 = currentTabGroup = currentTabGroupPos == -1 ? null : this.getTabGroup(currentTabGroupPos);
        if (currentTabGroup == tabGroup) {
            EditorManagerImpl editorManager = EditorManagerImpl.getInstance();
            editorManager.whenCurrentEditorChanges();
        }
    }

    public void whenEditorActivated(TabGroup tabGroup) {
        TabGroup currentTabGroup;
        int currentTabGroupPos = this.getCurrentTabGroupPos();
        TabGroup tabGroup2 = currentTabGroup = currentTabGroupPos == -1 ? null : this.getTabGroup(currentTabGroupPos);
        if (tabGroup != currentTabGroup) {
            int tabGroupPos = this.indexOf(tabGroup);
            this.setCurrentTabGroupPos(tabGroupPos);
        }
    }

    public boolean activateEditor(EditorPathImpl editorPath) {
        boolean ret = false;
        this.setCurrentTabGroupPos(editorPath._tabGroupPos);
        TabGroup tabGroup = editorPath.getTabGroup();
        if (tabGroup != null) {
            ret = tabGroup.activateEditor(editorPath);
        }
        return ret;
    }

    public void ensureCurrentTabVisble(EditorPathImpl editorPath) {
        TabGroup tabGroup = editorPath.getTabGroup();
        if (tabGroup != null) {
            tabGroup.ensureTabVisible();
        }
    }

    private final class DesktopFocusTraversalPolicy
    extends FocusTraversalPolicy {
        private int _focusChangeFrozen;
        private FocusTraversalPolicy _defaultPolicy;

        public DesktopFocusTraversalPolicy(FocusTraversalPolicy defaultPolicy) {
            this._defaultPolicy = defaultPolicy;
        }

        @Override
        public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
            if (this.isFocusChangeFrozen()) {
                return Desktop.this._background;
            }
            return this._defaultPolicy.getComponentAfter(focusCycleRoot, aComponent);
        }

        @Override
        public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
            if (this.isFocusChangeFrozen()) {
                return Desktop.this._background;
            }
            return this._defaultPolicy.getComponentBefore(focusCycleRoot, aComponent);
        }

        @Override
        public Component getFirstComponent(Container focusCycleRoot) {
            if (this.isFocusChangeFrozen()) {
                return Desktop.this._background;
            }
            return this._defaultPolicy.getFirstComponent(focusCycleRoot);
        }

        @Override
        public Component getLastComponent(Container focusCycleRoot) {
            if (this.isFocusChangeFrozen()) {
                return Desktop.this._background;
            }
            return this._defaultPolicy.getLastComponent(focusCycleRoot);
        }

        @Override
        public Component getDefaultComponent(Container focusCycleRoot) {
            if (this.isFocusChangeFrozen()) {
                return Desktop.this._background;
            }
            return this._defaultPolicy.getDefaultComponent(focusCycleRoot);
        }

        public boolean isFocusChangeFrozen() {
            return this._focusChangeFrozen > 0;
        }

        public void setFocusChangeFrozen(boolean focusChangeFrozen) {
            this._focusChangeFrozen = focusChangeFrozen ? ++this._focusChangeFrozen : --this._focusChangeFrozen;
        }
    }
}

