/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl;

import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.AddinManager;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.IdeActions;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ideimpl.resource.IdeImplMenuArb;
import oracle.ideri.util.Product;
import oracle.javatools.util.PlatformUtils;
import org.openide.filesystems.FileUtil;
import org.openide.util.actions.Presenter;

public final class IdeMenus {
    private static final Menubar menuMgr = Ide.getMenubar();

    public static JMenu findJMenu(String menuID) {
        String string = menuID = menuID != null ? menuID.trim() : null;
        if (menuID == null || menuID.length() == 0) {
            return null;
        }
        return MenuManager.getJMenu(menuID);
    }

    public static JMenu findOrCreateJMenu(String menuID) {
        JMenu menu = IdeMenus.findJMenu(menuID);
        if (menu != null) {
            return menu;
        }
        if (menuID.equals("File")) {
            menu = IdeMenus.createFileMenu();
        } else if (menuID.equals("Edit")) {
            menu = IdeMenus.createEditMenu();
        } else if (menuID.equals("Search")) {
            menu = IdeMenus.createSearchMenu();
        } else if (menuID.equals("View")) {
            menu = IdeMenus.createViewMenu();
        } else if (menuID.equals("Navigate")) {
            menu = IdeMenus.createNavigateMenu();
        } else if (menuID.equals("Tools")) {
            menu = IdeMenus.createToolsMenu();
        } else if (menuID.equals("Help")) {
            menu = IdeMenus.createHelpMenu();
        }
        if (menu != null) {
            MenuManager.putJMenu(menuID, menu);
            menuMgr.add(menu);
        }
        return menu;
    }

    public static JMenuItem createMenuItem(int cmdID, String cmdStr, String label, String actionCategory, Integer labelMnemonic, ArrayResourceBundle bundle, int iconKey, Object data, boolean enabled, float weight) {
        String cmd = AddinManager.getAddinManager().getCommand(cmdID, cmdStr);
        IdeAction action = IdeAction.get(cmdID, cmd, label, actionCategory, labelMnemonic, bundle, iconKey, data, enabled);
        return Ide.getMenubar().createMenuItem(action, weight);
    }

    public static JMenuItem createMenuItem(Controller controller, int cmdID, String cmdStr, String label, String actionCategory, Integer labelMnemonic, ArrayResourceBundle bundle, int iconKey, Object data, boolean enabled, float weight) {
        String cmd = AddinManager.getAddinManager().getCommand(cmdID, cmdStr);
        IdeAction action = IdeAction.get(cmdID, cmd, label, actionCategory, labelMnemonic, bundle, iconKey, data, enabled);
        action.addController(controller);
        return Ide.getMenubar().createMenuItem(action, weight);
    }

    public static JMenuItem createMenuItem(IdeAction action, float weight) {
        return menuMgr.createMenuItem(action, weight);
    }

    public static JMenu loadFileMenu() {
        JMenu fileMenu = IdeMenus.findJMenu("File");
        if (fileMenu == null && (fileMenu = IdeMenus.findOrCreateJMenu("File")) != null) {
            menuMgr.add(IdeMenus.createExitMenuItem(), fileMenu, MenuConstants.SECTION_FILE_EXIT);
        }
        menuMgr.add(IdeMenus.createOpenMenuItem(), fileMenu, 1.0f);
        JMenu reopenMenu = IdeMenus.createReopenMenu();
        MenuManager.putJMenu("FileReopen", reopenMenu);
        menuMgr.add(reopenMenu, fileMenu, 1.0f);
        menuMgr.add(IdeMenus.createCloseMenuItem(), fileMenu, MenuConstants.SECTION_FILE_CLOSE);
        menuMgr.add(IdeMenus.createCloseAllMenuItem(), fileMenu, MenuConstants.SECTION_FILE_CLOSE);
        menuMgr.add(IdeMenus.createSaveMenuItem(), fileMenu, MenuConstants.SECTION_FILE_SAVE);
        menuMgr.add(IdeMenus.createSaveAsMenuItem(), fileMenu, MenuConstants.SECTION_FILE_SAVE);
        menuMgr.add(IdeMenus.createSaveAllMenuItem(), fileMenu, MenuConstants.SECTION_FILE_SAVE);
        menuMgr.add(IdeMenus.createRenameMenuItem(), fileMenu, MenuConstants.SECTION_FILE_SAVE);
        menuMgr.add(IdeMenus.createReloadAllMenuItem(), fileMenu, MenuConstants.SECTION_FILE_SAVE);
        return fileMenu;
    }

    private static JMenu createFileMenu() {
        return menuMgr.createMenu(IdeArb.getString(22), 1.0f, MenuConstants.SECTION_FILE_ADDINS);
    }

    private static JMenuItem createOpenMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getFileOpenAction(), MenuConstants.WEIGHT_FILE_OPEN);
    }

    private static JMenu createReopenMenu() {
        return menuMgr.createSubMenu(StringUtils.stripMnemonic((String)IdeArb.getString(55)), StringUtils.getMnemonicKeyCode((String)IdeArb.getString(55)), MenuConstants.WEIGHT_FILE_REOPEN);
    }

    private static JMenuItem createCloseMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getFileCloseAction(), MenuConstants.WEIGHT_FILE_CLOSE);
    }

    private static JMenuItem createCloseAllMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getFileCloseAllAction(), MenuConstants.WEIGHT_FILE_CLOSE_ALL);
    }

    private static JMenuItem createSaveMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getFileSaveAction(), MenuConstants.WEIGHT_FILE_SAVE);
    }

    private static JMenuItem createSaveAsMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getFileSaveAsAction(), MenuConstants.WEIGHT_FILE_SAVE_AS);
    }

    private static JMenuItem createSaveAllMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getFileSaveAllAction(), MenuConstants.WEIGHT_FILE_SAVE_ALL);
    }

    private static JMenuItem createRenameMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getFileRenameAction(), MenuConstants.WEIGHT_FILE_RENAME);
    }

    private static JMenuItem createRemoveFromDiskMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getFileRemoveFromDiskAction(), MenuConstants.WEIGHT_FILE_ERASE);
    }

    private static JMenuItem createExitMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getFileExitAction(), MenuConstants.WEIGHT_FILE_EXIT);
    }

    private static JMenuItem createReloadAllMenuItem() {
        JMenuItem mi = IdeMenus.createMenuItem(IdeActions.getFileReloadNodesAction(), MenuConstants.WEIGHT_FILE_RELOAD);
        boolean visible = !Ide.getEnvironOptions().getAutoReloadExtMod();
        mi.setVisible(visible);
        return mi;
    }

    public static JMenu loadEditMenu() {
        JMenu editMenu = IdeMenus.findOrCreateJMenu("Edit");
        menuMgr.add(IdeMenus.createUndoMenuItem(), editMenu, 1.0f);
        menuMgr.add(IdeMenus.createRedoMenuItem(), editMenu, 1.0f);
        menuMgr.add(IdeMenus.createCutMenuItem(), editMenu, MenuConstants.SECTION_EDIT_CUT_COPY_PASTE);
        menuMgr.add(IdeMenus.createCopyMenuItem(), editMenu, MenuConstants.SECTION_EDIT_CUT_COPY_PASTE);
        menuMgr.add(IdeMenus.createCopyPathMenuItem(), editMenu, MenuConstants.SECTION_EDIT_CUT_COPY_PASTE);
        menuMgr.add(IdeMenus.createPasteMenuItem(), editMenu, MenuConstants.SECTION_EDIT_CUT_COPY_PASTE);
        menuMgr.add(IdeMenus.createExtendedPasteMenuItem(), editMenu, MenuConstants.SECTION_EDIT_CUT_COPY_PASTE);
        menuMgr.add(IdeMenus.createDeleteMenuItem(), editMenu, MenuConstants.SECTION_EDIT_CUT_COPY_PASTE);
        menuMgr.add(IdeMenus.createSelectAllMenuItem(), editMenu, MenuConstants.SECTION_EDIT_SELECT_ALL);
        menuMgr.add(IdeMenus.createPropertiesMenuItem(), editMenu, MenuConstants.SECTION_EDIT_PROPERTIES);
        menuMgr.add(IdeMenus.createDuplicateSelectionMenuItem(), editMenu, MenuConstants.SECTION_EDIT_CUT_COPY_PASTE);
        menuMgr.add(IdeMenus.createSelectWrapMenuItem(), editMenu, MenuConstants.SECTION_EDIT_SELECT_ALL);
        return editMenu;
    }

    private static JMenu createEditMenu() {
        return menuMgr.createMenu(IdeArb.getString(79), MenuConstants.WEIGHT_EDIT_MENU, MenuConstants.SECTION_EDIT_ADDINS);
    }

    private static JMenuItem createUndoMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getEditUndoAction(), 1.0f);
    }

    private static JMenuItem createRedoMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getEditRedoAction(), MenuConstants.WEIGHT_EDIT_REDO);
    }

    private static JMenuItem createCutMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getEditCutAction(), MenuConstants.WEIGHT_EDIT_CUT);
    }

    private static JMenuItem createCopyMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getEditCopyAction(), MenuConstants.WEIGHT_EDIT_COPY);
    }

    private static JMenuItem createCopyPathMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getEditCopyPathAction(), MenuConstants.WEIGHT_EDIT_COPY_PATH);
    }

    private static JMenuItem createPasteMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getEditPasteAction(), MenuConstants.WEIGHT_EDIT_PASTE);
    }

    private static JMenuItem createExtendedPasteMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getEditExtendedPasteAction(), MenuConstants.WEIGHT_EDIT_EXTENDED_PASTE);
    }

    private static JMenuItem createDuplicateSelectionMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getEditDuplicateSelectionAction(), MenuConstants.WEIGHT_EDIT_DUPLICATE_SELECTION);
    }

    private static JMenuItem createDeleteMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getEditDeleteAction(), MenuConstants.WEIGHT_EDIT_DELETE);
    }

    private static JMenuItem createSelectWrapMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getEditSelectWrapAction(), MenuConstants.WEIGHT_EDIT_SELECT_BLOCK);
    }

    private static JMenuItem createSelectAllMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getEditSelectAllAction(), MenuConstants.WEIGHT_EDIT_SELECT_ALL);
    }

    private static JMenuItem createPropertiesMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getEditPropertiesAction(), MenuConstants.WEIGHT_EDIT_PROPERTIES);
    }

    public static void loadSearchMenu() {
        if (Product.isRaptor()) {
            JMenu searchMenu = IdeMenus.findOrCreateJMenu("Edit");
            menuMgr.add(IdeMenus.createFindMenuItem(), searchMenu, MenuConstants.SECTION_EDIT_FIND);
            menuMgr.add(IdeMenus.createSearchAgainMenuItem(), searchMenu, MenuConstants.SECTION_EDIT_FIND);
            menuMgr.add(IdeMenus.createSearchBackwardMenuItem(), searchMenu, MenuConstants.SECTION_EDIT_FIND);
            menuMgr.add(IdeMenus.createReplaceMenuItem(), searchMenu, MenuConstants.SECTION_EDIT_FIND);
        } else {
            JMenu searchMenu = IdeMenus.findOrCreateJMenu("Search");
            menuMgr.add(IdeMenus.createFindMenuItem(), searchMenu, 1.0f);
            menuMgr.add(IdeMenus.createSearchAgainMenuItem(), searchMenu, 1.0f);
            menuMgr.add(IdeMenus.createSearchBackwardMenuItem(), searchMenu, 1.0f);
            menuMgr.add(IdeMenus.createReplaceMenuItem(), searchMenu, 1.0f);
        }
        IdeActions.getSearchIncrementalFindForwardAction();
        IdeActions.getSearchIncrementalFindBackwardAction();
    }

    private static JMenu createSearchMenu() {
        return menuMgr.createMenu(IdeArb.getString(108), MenuConstants.WEIGHT_SEARCH_MENU, MenuConstants.SECTION_SEARCH_ADDINS);
    }

    private static JMenuItem createFindMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getSearchFindAction(), 1.0f);
    }

    private static JMenuItem createSearchAgainMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getSearchFindNextAction(), MenuConstants.WEIGHT_SEARCH_FIND_NEXT);
    }

    private static JMenuItem createSearchBackwardMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getSearchFindPreviousAction(), MenuConstants.WEIGHT_SEARCH_FIND_PREVIOUS);
    }

    private static JMenuItem createReplaceMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getSearchReplaceAction(), MenuConstants.WEIGHT_SEARCH_REPLACE);
    }

    public static JMenu loadViewMenu() {
        JMenu viewMenu = IdeMenus.findOrCreateJMenu("View");
        JMenu toolbarsMenu = IdeMenus.createToolbarsSubMenu();
        menuMgr.add(IdeMenus.createMainToolbarMenuItem(), toolbarsMenu, 1.0f);
        menuMgr.add(IdeMenus.createNbAction("/Actions/Window/org-netbeans-core-windows-actions-ToolbarsListAction.instance"), toolbarsMenu, 1.0f);
        menuMgr.add(IdeMenus.createNbAction("/Actions/View/com-oracle-jdeveloper-nbwindowsystem-editor-EditorsAction.instance"), viewMenu, 1.0f);
        menuMgr.add(IdeMenus.createStatusBarMenuItem(), viewMenu, MenuConstants.SECTION_VIEW_TOOLBAR);
        menuMgr.add(toolbarsMenu, viewMenu, MenuConstants.SECTION_VIEW_TOOLBAR);
        menuMgr.add(IdeMenus.createRefreshMenuItem(), viewMenu, MenuConstants.SECTION_VIEW_REFRESH);
        if (!PlatformUtils.isMac()) {
            menuMgr.add(IdeMenus.createFullScreeMenuItem(), viewMenu, Float.MAX_VALUE);
        }
        return viewMenu;
    }

    private static JMenu createViewMenu() {
        JMenu viewMenu = menuMgr.createMenu(IdeArb.getString(151), MenuConstants.WEIGHT_VIEW_MENU, MenuConstants.SECTION_VIEW_ADDINS);
        menuMgr.sortSectionByName(viewMenu, MenuConstants.SECTION_VIEW_ADDINS);
        return viewMenu;
    }

    private static JMenu createToolbarsSubMenu() {
        JMenu viewToolbarsSubMenu = menuMgr.createSubMenu(StringUtils.stripMnemonic((String)IdeImplMenuArb.getString(0)), Integer.valueOf(IdeImplMenuArb.getMnemonic(1)), MenuConstants.WEIGHT_VIEW_TOOLBARS, MenuConstants.SECTION_VIEW_TOOLBARS_SUBMENU_OTHERS);
        MenuManager.putJMenu("ViewToolbars", viewToolbarsSubMenu);
        menuMgr.sortSectionByName(viewToolbarsSubMenu, MenuConstants.SECTION_VIEW_TOOLBARS_SUBMENU_OTHERS);
        menuMgr.resolveMnemonicsForMenuItemsInSection(viewToolbarsSubMenu, 1.0f);
        menuMgr.resolveMnemonicsForMenuItemsInSection(viewToolbarsSubMenu, MenuConstants.SECTION_VIEW_TOOLBARS_SUBMENU_OTHERS);
        return viewToolbarsSubMenu;
    }

    private static JMenuItem createMainToolbarMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getViewMainToolbarAction(), MenuConstants.WEIGHT_VIEW_TOOLBARS_MAIN);
    }

    private static JMenuItem createStatusBarMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getViewStatusBarAction(), MenuConstants.WEIGHT_VIEW_STATUS_BAR);
    }

    private static JMenuItem createRefreshMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getViewRefreshAction(), MenuConstants.WEIGHT_VIEW_REFRESH);
    }

    private static JMenuItem createFullScreeMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getFullScreenAction(), Float.MAX_VALUE);
    }

    public static JMenu loadNavigateMenu() {
        JMenu navigateMenu = IdeMenus.findOrCreateJMenu("Navigate");
        menuMgr.add(IdeMenus.createNextMsgMenuItem(), navigateMenu, MenuConstants.SECTION_NAVIGATE_GOTO_MESSAGE);
        menuMgr.add(IdeMenus.createPrevMsgMenuItem(), navigateMenu, MenuConstants.SECTION_NAVIGATE_GOTO_MESSAGE);
        menuMgr.add(IdeMenus.createGotoLineNumberMenuItem(), navigateMenu, MenuConstants.SECTION_NAVIGATE_GOTO_ELEMENT);
        return navigateMenu;
    }

    private static JMenu createNavigateMenu() {
        return menuMgr.createMenu(IdeArb.getString(147), MenuConstants.WEIGHT_NAVIGATE_MENU, MenuConstants.SECTION_NAVIGATE_ADDINS);
    }

    private static JMenuItem createNextMsgMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getNavigateGoToNextMessageAction(), MenuConstants.WEIGHT_NAVIGATE_GO_TO_NEXT_MESSAGE);
    }

    private static JMenuItem createPrevMsgMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getNavigateGoToPreviousMessageAction(), MenuConstants.WEIGHT_NAVIGATE_GO_TO_PREVIOUS_MESSAGE);
    }

    private static JMenuItem createGotoLineNumberMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getNavigateGoToLineAction(), MenuConstants.WEIGHT_NAVIGATE_GO_TO_LINE);
    }

    public static JMenu loadToolsMenu() {
        JMenu toolsMenu = IdeMenus.findOrCreateJMenu("Tools");
        menuMgr.sortSectionByName(toolsMenu, MenuConstants.SECTION_TOOLS_ADDINS);
        JMenuItem preferencesMenuItem = IdeMenus.createPreferencesMenuItem();
        if (!PlatformUtils.isMac()) {
            menuMgr.add(preferencesMenuItem, toolsMenu, Float.MAX_VALUE);
        }
        return toolsMenu;
    }

    private static JMenu createToolsMenu() {
        return menuMgr.createMenu(IdeArb.getString(180), MenuConstants.WEIGHT_TOOLS_MENU, MenuConstants.SECTION_TOOLS_ADDINS);
    }

    private static JMenuItem createPreferencesMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getToolsPreferencesAction(), MenuConstants.WEIGHT_TOOLS_PREFERENCES);
    }

    public static JMenu loadHelpMenu() {
        JMenu helpMenu = IdeMenus.findOrCreateJMenu("Help");
        menuMgr.add(IdeMenus.createAboutMenuItem(), helpMenu, MenuConstants.SECTION_HELP_ABOUT);
        return helpMenu;
    }

    private static JMenu createHelpMenu() {
        return menuMgr.createMenu(IdeArb.getString(421), MenuConstants.WEIGHT_HELP_MENU, MenuConstants.SECTION_HELP_ADDINS);
    }

    private static JMenuItem createAboutMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getHelpAboutAction(), 1.0f);
    }

    private static JMenuItem createNbAction(String path) {
        Action nbAction = (Action)FileUtil.getConfigObject((String)path, Action.class);
        if (nbAction instanceof Presenter.Menu) {
            Presenter.Menu presenter = (Presenter.Menu)nbAction;
            JMenuItem menuItem = presenter.getMenuPresenter();
            return menuItem;
        }
        return null;
    }
}

