/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.xml;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.ide.util.MetaClass;
import oracle.ide.marshal.xml.Object2Dom;
import oracle.ide.model.Node;
import oracle.ide.model.NodeInfo;
import oracle.ide.model.Recognizer;
import oracle.ide.model.RecognizerException;
import oracle.ide.model.RecognizersHook;
import oracle.ide.model.XMLDataNode;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.ModelUtil;
import oracle.ide.xml.NodeInfoLoader;
import oracle.ide.xml.StartElementPacket;
import oracle.ide.xml.XMLUtil;

public final class XMLRecognizer
extends Recognizer {
    private static final XMLRecognizer _instance = new XMLRecognizer();
    private static final HashMap _xmlExtensions = new HashMap();
    private static final HashMap _nsElemToClass = new HashMap();
    private static final HashMap _xsiToClass = new HashMap();
    private static final HashMap _doctypeToClass = new HashMap();
    private static final HashMap _rootElementToClass = new HashMap();
    private static final HashMap _classToNodeInfo = new HashMap();

    private XMLRecognizer() {
    }

    public static XMLRecognizer getInstance() {
        return _instance;
    }

    public static void treatExtensionAsXML(String extension) {
        XMLRecognizer.treatExtensionAsXML(extension, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void treatExtensionAsXML(String extension, NodeInfoLoader loader) {
        XMLRecognizer.mapExtensionToXML(extension);
        if (ModelUtil.hasLength((String)extension)) {
            File fileExt = XMLRecognizer.sanitizeExtension(extension);
            HashMap hashMap = _xmlExtensions;
            synchronized (hashMap) {
                _xmlExtensions.put(fileExt, loader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mapNamespaceElemToClass(String namespaceURI, String localElemName, Class cls) {
        if (cls != null && ModelUtil.hasLength((String)namespaceURI)) {
            HashMap hashMap = _nsElemToClass;
            synchronized (hashMap) {
                _nsElemToClass.put(new NSElem(namespaceURI, localElemName), cls);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mapSchemaInstanceToClass(String schemaLocationURI, String rootElemLocalName, Class nodeType) {
        if (nodeType != null && ModelUtil.hasLength((String)schemaLocationURI)) {
            HashMap hashMap = _xsiToClass;
            synchronized (hashMap) {
                _xsiToClass.put(new NSElem(schemaLocationURI, rootElemLocalName), nodeType);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mapDoctypeToClass(String publicId, String systemId, Class cls) {
        if (cls != null && (publicId != null || systemId != null)) {
            Doctype doctype = new Doctype(publicId, systemId);
            HashMap hashMap = _doctypeToClass;
            synchronized (hashMap) {
                _doctypeToClass.put(doctype, cls);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mapRootElementToClass(String rootElem, Class cls) {
        if (cls != null && ModelUtil.hasLength((String)rootElem)) {
            HashMap hashMap = _rootElementToClass;
            synchronized (hashMap) {
                _rootElementToClass.put(rootElem, cls);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerNodeInfo(NodeInfo info) {
        if (info != null) {
            Class dataClass = info.getDataClass();
            String rootElem = info.getXMLRootElement();
            String namespaceURI = info.getXMLNamespaceURI();
            if (ModelUtil.hasLength((String)namespaceURI)) {
                XMLRecognizer.mapNamespaceElemToClass(namespaceURI, rootElem, dataClass);
                Object2Dom.registerNamespaceElem((Class)dataClass, (String)namespaceURI, (String)rootElem);
            }
            XMLRecognizer.mapRootElementToClass(info.getXMLRootElement(), dataClass);
            HashMap hashMap = _classToNodeInfo;
            synchronized (hashMap) {
                _classToNodeInfo.put(dataClass, info);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NodeInfo findNodeInfo(Class dataClass) {
        if (dataClass == null) {
            return null;
        }
        HashMap hashMap = _classToNodeInfo;
        synchronized (hashMap) {
            return (NodeInfo)_classToNodeInfo.get(dataClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetaClass recognizeAsMeta(URL url) {
        StartElementPacket rootElem = null;
        try {
            rootElem = XMLUtil.getXMLRootElement((URL)url);
        }
        catch (FileNotFoundException ex) {
            return null;
        }
        if (rootElem != null) {
            RecognizersHook hook;
            Map<String, MetaClass<Node>> rootElementMappings;
            MetaClass<Node> cls;
            Object dataClass;
            String schemaLocationURI;
            Class clazz;
            Object dataClass2;
            Map<Object, Object> mappings;
            RecognizersHook hook2;
            XMLRecognizer.ensureNodeInfosLoaded(XMLRecognizer.sanitizeExtension(URLFileSystem.getSuffix((URL)url)));
            if (ModelUtil.hasLength((String)rootElem.namespaceURI)) {
                Object nsElem;
                String value;
                if (rootElem.attributes != null && ModelUtil.hasLength((String)(value = rootElem.attributes.getValue("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation")))) {
                    StringTokenizer stok = new StringTokenizer(value);
                    while (stok.hasMoreTokens()) {
                        String xmlns = stok.nextToken();
                        if (!rootElem.namespaceURI.equals(xmlns)) continue;
                        if (!stok.hasMoreTokens()) break;
                        String schemaLocationURI2 = stok.nextToken();
                        nsElem = new NSElem(schemaLocationURI2, rootElem.localName);
                        RecognizersHook hook3 = RecognizersHook.getHook();
                        Map<NSElem, MetaClass<Node>> mappings2 = hook3.schemaMappings();
                        MetaClass<Node> type = mappings2.get(nsElem);
                        if (type != null) {
                            return type;
                        }
                        HashMap hashMap = _xsiToClass;
                        synchronized (hashMap) {
                            Object dataClass3 = _xsiToClass.get(nsElem);
                            if (dataClass3 != null) {
                                Class clazz2 = (Class)dataClass3;
                                return MetaClass.newMetaClass((Class)clazz2);
                            }
                        }
                    }
                }
                NSElem nsElem2 = new NSElem(rootElem.namespaceURI, rootElem.localName);
                hook2 = RecognizersHook.getHook();
                mappings = hook2.namespaceMappings();
                MetaClass<Node> nodeType = mappings.get(nsElem2);
                if (nodeType != null) {
                    return nodeType;
                }
                nsElem = _nsElemToClass;
                synchronized (nsElem) {
                    dataClass2 = _nsElemToClass.get(nsElem2);
                    if (dataClass2 != null) {
                        clazz = (Class)dataClass2;
                        return MetaClass.newMetaClass((Class)clazz);
                    }
                }
            }
            MetaClass<?> nodeType = this.tryToRecognizeByNoNamespaceRule(url, rootElem);
            if (nodeType != null) {
                return nodeType;
            }
            if (rootElem.attributes != null && ModelUtil.hasLength((String)(schemaLocationURI = rootElem.attributes.getValue("http://www.w3.org/2001/XMLSchema-instance", "noNamespaceSchemaLocation")))) {
                mappings = _xsiToClass;
                synchronized (mappings) {
                    NSElem nsElem = new NSElem(schemaLocationURI, rootElem.localName);
                    dataClass = _xsiToClass.get(nsElem);
                    if (dataClass != null) {
                        Class clazz3 = (Class)dataClass;
                        return MetaClass.newMetaClass((Class)clazz3);
                    }
                }
            }
            if (rootElem.publicId != null || rootElem.systemId != null) {
                Doctype doctype = new Doctype(rootElem.publicId, rootElem.systemId);
                hook2 = RecognizersHook.getHook();
                mappings = hook2.docTypeMappings();
                MetaClass type = (MetaClass)mappings.get(doctype);
                if (type != null) {
                    return type;
                }
                dataClass = _doctypeToClass;
                synchronized (dataClass) {
                    dataClass2 = _doctypeToClass.get(doctype);
                    if (dataClass2 != null) {
                        clazz = (Class)dataClass2;
                        return MetaClass.newMetaClass((Class)clazz);
                    }
                }
            }
            if ((cls = (rootElementMappings = (hook = RecognizersHook.getHook()).rootElementMappings()).get(rootElem.localName)) != null) {
                return cls;
            }
            HashMap hashMap = _rootElementToClass;
            synchronized (hashMap) {
                dataClass = _rootElementToClass.get(rootElem.localName);
                if (dataClass != null) {
                    Class clazz4 = (Class)dataClass;
                    return MetaClass.newMetaClass((Class)clazz4);
                }
            }
        }
        return null;
    }

    private MetaClass<?> tryToRecognizeByNoNamespaceRule(URL url, StartElementPacket rootElem) {
        RecognizersHook hook = RecognizersHook.getHook();
        Map<String, List<NoNamespaceRule>> mappings = hook.noNamespaceMappings();
        if (mappings.isEmpty()) {
            return null;
        }
        List<NoNamespaceRule> rules = mappings.get(rootElem.localName);
        if (rules == null || rules.isEmpty()) {
            return null;
        }
        String fileName = URLFileSystem.getFileName((URL)url);
        for (NoNamespaceRule rule : rules) {
            if (rule.excludeFiles.contains(fileName) || !rule.includeFiles.isEmpty() && !rule.includeFiles.contains(fileName)) continue;
            return rule.nodeType;
        }
        return null;
    }

    @Override
    public Node create(URL url, Class nodeType) throws IllegalAccessException, InstantiationException {
        if (url != null && nodeType != null) {
            NodeInfo nodeInfo = XMLRecognizer.findNodeInfo(nodeType);
            if (nodeInfo != null) {
                Class nodeInfoNodeClass = nodeInfo.getNodeClass();
                XMLDataNode node = (XMLDataNode)super.create(url, nodeInfoNodeClass);
                node.setNodeInfo(nodeInfo);
                return node;
            }
            return super.create(url, nodeType);
        }
        return null;
    }

    @Override
    public URL validate(URL newURL, URL oldURL) throws RecognizerException {
        String extension = URLFileSystem.getSuffix((URL)newURL);
        if (XMLRecognizer.isXmlExtension(extension)) {
            return newURL;
        }
        if (this.recognize(oldURL) != null) {
            String oldExtension = URLFileSystem.getSuffix((URL)oldURL);
            try {
                String newPath = newURL.getPath() + oldExtension;
                return URLFactory.replacePathPart((URL)newURL, (String)newPath);
            }
            catch (Exception e) {
                throw new RecognizerException("Internal exception: Unable to build new URL: " + e.getLocalizedMessage());
            }
        }
        throw new RecognizerException("Internal exception: Old URL not recognized.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ensureNodeInfosLoaded(File fileExt) {
        HashMap hashMap = _xmlExtensions;
        synchronized (hashMap) {
            Object loader = _xmlExtensions.get(fileExt);
            if (loader != null) {
                ((NodeInfoLoader)loader).loadNodeInfos();
                _xmlExtensions.put(fileExt, null);
            }
        }
    }

    static {
        XMLRecognizer.treatExtensionAsXML(".xml");
    }

    public static class NoNamespaceRule {
        final String elementName;
        final List<String> excludeFiles;
        final List<String> includeFiles;
        final MetaClass<?> nodeType;

        public NoNamespaceRule(String elementName, String[] excludeFiles, String[] includeFiles, MetaClass<?> nodeType) {
            this.elementName = elementName;
            this.excludeFiles = NoNamespaceRule.trim(excludeFiles);
            this.includeFiles = NoNamespaceRule.trim(includeFiles);
            this.nodeType = nodeType;
        }

        private static List<String> trim(String[] strings) {
            ArrayList<String> trimmed = new ArrayList<String>();
            for (String s : strings) {
                if (s == null) continue;
                trimmed.add(s.trim());
            }
            return Collections.unmodifiableList(trimmed);
        }
    }

    public static final class Doctype {
        final String publicId;
        final String systemId;
        private Integer _hashCode;

        public Doctype(String publicId, String systemId) {
            this.publicId = publicId;
            this.systemId = systemId;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Doctype)) {
                return false;
            }
            Doctype other = (Doctype)o;
            if (this.publicId == null || other.publicId == null) {
                return ModelUtil.areEqual((Object)this.systemId, (Object)other.systemId);
            }
            return this.publicId.equals(other.publicId);
        }

        public int hashCode() {
            if (this._hashCode == null) {
                int hashCode = this.publicId != null ? this.publicId.hashCode() : (this.systemId != null ? this.systemId.hashCode() : 0);
                this._hashCode = hashCode;
            }
            return this._hashCode;
        }
    }

    public static final class NSElem {
        final String namespaceURI;
        final String localElemName;
        private Integer _hashCode;

        public NSElem(String namespaceURI, String localElemName) {
            this.namespaceURI = namespaceURI;
            this.localElemName = localElemName;
        }

        public boolean equals(Object o) {
            if (!(o instanceof NSElem)) {
                return false;
            }
            NSElem other = (NSElem)o;
            return ModelUtil.areEqual((Object)this.namespaceURI, (Object)other.namespaceURI) && ModelUtil.areEqual((Object)this.localElemName, (Object)other.localElemName);
        }

        public int hashCode() {
            if (this._hashCode == null) {
                int hcUri = this.namespaceURI != null ? this.namespaceURI.hashCode() : 0;
                int hcElem = this.localElemName != null ? this.localElemName.hashCode() : 0;
                this._hashCode = hcUri ^ hcElem;
            }
            return this._hashCode;
        }
    }
}

