/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.view;

import java.text.MessageFormat;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controls.Toolbar;
import oracle.ide.docking.DockableWindow;
import oracle.ide.model.Node;
import oracle.ide.model.Observer;
import oracle.ide.model.UpdateMessage;
import oracle.ide.resource.IdeArb;
import oracle.ide.view.ActiveViewEvent;
import oracle.ide.view.ActiveViewListener;
import oracle.ide.view.Pinnable;
import oracle.ide.view.View;
import oracle.ide.view.ViewEvent;
import oracle.ide.view.ViewListener;
import oracle.ide.view.ViewSelectionEvent;
import oracle.ide.view.ViewSelectionListener;
import oracle.javatools.icons.OracleIcons;

public abstract class AbstractPinnable
extends DockableWindow
implements ViewSelectionListener,
Pinnable,
Observer {
    public static final String TOOLBAR_ITEM = "Toolbar.item";
    public static final String TOOLBAR_ITEM_COUNT = "Toolbar.count";
    private View pinnedView;
    private int pinState = 0;
    private ViewMonitor viewMonitor = new ViewMonitor();
    protected Toolbar toolbar;
    protected boolean isToolbarVisible;
    protected Node _node;
    protected boolean forceUpdate;

    protected AbstractPinnable(String viewId) {
        super(viewId);
        this.viewMonitor.start();
    }

    protected AbstractPinnable(IdeMainWindow mw, String viewId) {
        this(viewId);
    }

    @Override
    public Toolbar getToolbar() {
        return this.toolbar;
    }

    @Override
    public void setToolbarVisible(boolean visible) {
        this.isToolbarVisible = visible;
    }

    public void setContext(Context context) {
        View view;
        View view2 = view = context != null ? context.getView() : null;
        if (!this.isViewSupported(view) && view instanceof AbstractPinnable && (view = ((AbstractPinnable)view).getPinnedView()) == null) {
            view = Ide.getMainWindow().getLastActiveView();
        }
        ActiveViewEvent e = new ActiveViewEvent(Ide.getMainWindow(), this.getPinnedView(), view);
        this.activeViewChanged(e);
    }

    protected boolean isSingleton() {
        return false;
    }

    @Override
    public void stateChange(int newState) {
        switch (newState) {
            case 1: {
                super.stateChange(newState);
                if (this.getPinnedView() == null && this.getPinState() == 0) {
                    this.setPinState(0);
                    break;
                }
                if (this.getPinnedView() != null) {
                    this.getPinnedView().addViewSelectionListener(this);
                }
                this.restorePinTarget();
                this.setPinState(this.getPinState());
                break;
            }
            case 2: {
                super.stateChange(newState);
                if (this.getPinnedView() == null) break;
                this.getPinnedView().removeViewSelectionListener(this);
                this.persistPinTarget();
                break;
            }
            case 3: {
                if (!this.isSingleton()) {
                    this.viewMonitor.stop();
                }
                super.stateChange(newState);
            }
        }
    }

    protected synchronized void activeViewChanged(ActiveViewEvent e) {
        View newView = e.getNewView();
        if (!this.isViewSupported(newView)) {
            return;
        }
        if (this.getPinState() != 0) {
            return;
        }
        this.setPinnedView(newView);
    }

    @Override
    public synchronized void viewSelectionChanged(ViewSelectionEvent e) {
        if (this.getPinState() == 2) {
            return;
        }
        this.viewSelectionChangedImpl(e.getView());
    }

    private void viewSelectionChangedImpl(View view) {
        Context context = view.getContext();
        this.viewSelectionChanged(context);
    }

    @Override
    public synchronized int getPinState() {
        return this.pinState;
    }

    @Override
    public synchronized void setPinState(int newState) {
        this.pinState = newState;
        switch (newState) {
            case 0: {
                View view = this.getPinnedView();
                View lastSupportedView = this.viewMonitor.getLastSupportedView();
                if (view == null || view != lastSupportedView) {
                    IdeMainWindow mainWindow = Ide.getMainWindow();
                    ActiveViewEvent e = new ActiveViewEvent(mainWindow, view, lastSupportedView);
                    if (view != null && lastSupportedView == null) {
                        this.viewMonitor.start();
                    }
                    this.activeViewChanged(e);
                    if (lastSupportedView == this.viewMonitor.getLastSupportedView()) break;
                    this.viewSelectionChangedImpl(view);
                    break;
                }
                this.viewSelectionChangedImpl(view);
                break;
            }
            case 1: {
                View view = this.getPinnedView();
                if (view != null) {
                    this.viewSelectionChangedImpl(view);
                    break;
                }
                this.clear();
                break;
            }
            case 2: {
                this.updateTitle(this.getTitleName());
            }
        }
    }

    protected abstract boolean isViewSupported(View var1);

    protected void persistPinTarget() {
    }

    protected void restorePinTarget() {
    }

    protected void viewSelectionChanged(Context context) {
        Node doc;
        Node node = doc = context != null ? context.getNode() : null;
        if (doc != this._node) {
            if (this._node != null) {
                this._node.detach(this);
            }
            this._node = doc;
            if (this._node != null) {
                this._node.attach(this);
            }
        }
    }

    @Override
    public void update(Object subject, UpdateMessage msg) {
        int id;
        int n = id = msg != null ? msg.getMessageID() : -1;
        if (id == UpdateMessage.OBJECT_CLOSED) {
            this.objectClosed(subject, msg);
        } else if (id == UpdateMessage.OBJECT_RENAMED) {
            this.objectRenamed(subject, msg);
        }
    }

    protected void objectClosed(Object subject, UpdateMessage msg) {
        this.setPinnedView(null);
        this.clear();
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                AbstractPinnable.this.setPinState(AbstractPinnable.this.getPinState());
            }
        };
        SwingUtilities.invokeLater(runner);
    }

    protected void objectRenamed(Object subject, UpdateMessage msg) {
        this.setPinnedView(null);
        this.clear();
        this.setPinState(this.getPinState());
    }

    protected void clear() {
        if (this._node != null) {
            this._node.detach(this);
            this._node = null;
        }
    }

    protected synchronized View getPinnedView() {
        return this.pinnedView;
    }

    protected synchronized void setPinnedView(View view) {
        if (view != null && view == this.pinnedView) {
            if (!this.forceUpdate) {
                return;
            }
            this.forceUpdate = false;
        }
        if (this.pinnedView != null) {
            this.pinnedView.removeViewSelectionListener(this);
        }
        this.pinnedView = view;
        if (this.pinnedView == null) {
            if (this.getPinState() != 2) {
                this.clear();
            }
        } else {
            this.pinnedView.addViewSelectionListener(this);
            this.viewSelectionChangedImpl(this.pinnedView);
        }
    }

    public boolean isPinned() {
        return this.getPinState() != 0;
    }

    @Override
    public String getTitleName() {
        if (this.isPinned()) {
            return MessageFormat.format(IdeArb.getString(531), this.getTitleNameImpl());
        }
        return this.getTitleNameImpl();
    }

    protected String getTitleNameImpl() {
        return "";
    }

    @Override
    public Icon getTabIcon() {
        if (this.isPinned()) {
            return OracleIcons.getIcon((String)"pin.png");
        }
        return this.getTabIconImpl();
    }

    protected Icon getTabIconImpl() {
        return OracleIcons.getIcon((String)"pin.png");
    }

    private final class ViewMonitor
    implements ActiveViewListener,
    ViewListener {
        private View lastSupportedView;

        private ViewMonitor() {
        }

        public View getLastSupportedView() {
            return this.lastSupportedView;
        }

        public void start() {
            IdeMainWindow mainWin = Ide.getMainWindow();
            this.lastSupportedView = AbstractPinnable.this.isViewSupported(mainWin.getLastActiveView()) ? mainWin.getLastActiveView() : null;
            mainWin.addActiveViewListener(this);
        }

        public void stop() {
            Ide.getMainWindow().removeActiveViewListener(this);
            if (this.lastSupportedView != null) {
                this.lastSupportedView.removeViewListener(this);
            }
            this.lastSupportedView = null;
        }

        @Override
        public void activeViewChanged(ActiveViewEvent e) {
            View newView = e.getNewView();
            if (AbstractPinnable.this.isViewSupported(newView)) {
                if (this.lastSupportedView != null) {
                    this.lastSupportedView.removeViewListener(this);
                }
                this.lastSupportedView = newView;
                if (this.lastSupportedView != null) {
                    this.lastSupportedView.addViewListener(this);
                }
                AbstractPinnable.this.activeViewChanged(e);
            }
        }

        @Override
        public void viewActivated(ViewEvent e) {
        }

        @Override
        public void viewDeactivated(ViewEvent e) {
        }

        @Override
        public void viewClosed(ViewEvent e) {
            View view = e.getView();
            if (view == this.lastSupportedView) {
                if (this.lastSupportedView != null) {
                    this.lastSupportedView.removeViewListener(this);
                }
                this.lastSupportedView = null;
            }
            if (view == AbstractPinnable.this.getPinnedView()) {
                AbstractPinnable.this.setPinnedView(null);
                AbstractPinnable.this.setPinState(AbstractPinnable.this.getPinState());
            }
        }
    }
}

