/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.test;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLStreamHandlerFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectVersion;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.model.WorkspaceMigrator;
import oracle.ide.model.Workspaces;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;
import oracle.ide.net.URLPath;
import oracle.ide.test.Bundle;
import oracle.ide.test.BundleContext;
import oracle.ide.test.internal.TipURLFileSystemHelper;
import oracle.ide.test.internal.TipURLStreamHandlerFactory;
import oracle.ide.util.Assert;
import oracle.javatools.util.UnexpectedExceptionError;

public class IdeFixture {
    private static IdeFixture fixture;
    private boolean started;
    private Throwable startException;
    private String productId;
    private URL installationDirectory;
    private URL workDirectoryPendingSet;
    private URL workDirectory;
    private URL dataDirectory;
    private URL testClassDirectory;
    private Map<String, String> shroudedExtensions = new HashMap<String, String>();
    private Map<String, String> unshroudedExtensions = new HashMap<String, String>();
    private Class testClass;
    private String testName;
    private Map<String, Node> nodes = new HashMap<String, Node>();
    private boolean verbose;
    private static Method resolve;

    protected IdeFixture(String productId) {
        this.productId = productId;
        this.output("created fixture for product " + productId);
    }

    public static IdeFixture getIdeFixture() {
        if (fixture == null) {
            fixture = new IdeFixture("oracle.ide");
        }
        return fixture;
    }

    /*
     * Unable to fully structure code
     */
    public void start(Class testClass, String testName) {
        if (testClass == null) {
            throw new IllegalArgumentException("testClass null");
        }
        if (testName == null) {
            throw new IllegalArgumentException("testName null");
        }
        this.testClass = testClass;
        System.out.println("IdeFixture " + this + " started for product " + this.productId + " with testClass " + testClass);
        this.testClassDirectory = null;
        this.testName = testName;
        if (!this.started) {
            this.started = true;
            try {
                URLFileSystem.addURLStreamHandlerFactory((String)"tip", (URLStreamHandlerFactory)new TipURLStreamHandlerFactory());
                URLFileSystem.registerHelper((String)"tip", (URLFileSystemHelper)new TipURLFileSystemHelper());
                registry = ExtensionRegistry.getExtensionRegistry();
                extensions = new ArrayList<String>(registry.getDisabledExtensions());
                if (extensions.isEmpty()) ** GOTO lbl58
                Collections.sort(extensions);
                System.out.println("FIXTURE: disabled extensions:");
                var5_8 = extensions.iterator();
                while (var5_8.hasNext()) {
                    id = (String)var5_8.next();
                    builder = new StringBuilder(" ");
                    builder.append(id);
                    builder.append(": ");
                    i = 24 - id.length();
                    while (i-- > 0) {
                        builder.append(' ');
                    }
                    builder.append(registry.getNotLoadedReason(id));
                    System.out.println(builder.toString());
                }
            }
            catch (Throwable e) {
                this.startException = e;
                throw new StartFailedException(this.startException, true);
            }
        } else {
            if (this.startException != null) {
                throw new StartFailedException(this.startException, false);
            }
            this.setActive(null, null);
            workspaces = Ide.getWorkspaces();
            for (Node node : this.nodes.values()) {
                try {
                    node.close();
                }
                catch (IOException id) {
                    // empty catch block
                }
                if (node instanceof Workspace) {
                    workspaces.remove(node);
                    UpdateMessage.fireChildRemoved(workspaces, node);
                }
                NodeFactory.uncache(node.getURL());
            }
            this.nodes.clear();
        }
lbl58:
        // 3 sources

        this.workDirectory = null;
        workspaces = Ide.getWorkspaces();
        if (workspaces != null) {
            i = workspaces.getChildren();
            while (i.hasNext()) {
                child = i.next();
                if (!(child instanceof Workspace)) continue;
                workspace = (Workspace)child;
                url = workspace.getURL();
                if (!URLFileSystem.isBaseURLFor((URL)this.getWorkDirectory(), (URL)url)) continue;
                workspaces.remove(workspace);
                UpdateMessage.fireChildRemoved(workspaces, workspace);
                NodeFactory.uncache(workspace.getURL());
            }
        }
        this.verbose("Deleting contents of " + URLFileSystem.getPlatformPathName((URL)this.getWorkDirectory()));
        IdeFixture.deleteChildren(this.getWorkDirectory());
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                }
            });
        }
        catch (InterruptedException e) {
            throw new UnexpectedExceptionError((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new UnexpectedExceptionError((Throwable)e);
        }
        this.output("started test " + testName + " in " + testClass.getName());
        this.output("work directory " + URLFileSystem.getPlatformPathName((URL)this.getWorkDirectory()));
        this.output("test data directory " + URLFileSystem.getPlatformPathName((URL)this.getTestDataDirectory()));
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public String getProductId() {
        return this.productId;
    }

    public URL getInstallationDirectory() {
        if (this.installationDirectory == null) {
            String ideHome = System.getProperty("ide.home");
            String built = System.getProperty("BUILT");
            if (ideHome != null) {
                this.installationDirectory = URLFactory.newDirURL((String)ideHome);
            } else if (built != null) {
                this.installationDirectory = URLFactory.newDirURL((String)(built + "/jdeveloper/jdev"));
            } else {
                String classPath = System.getProperty("java.class.path");
                StringTokenizer i = new StringTokenizer(classPath, File.pathSeparator);
                String FIXTURE_SUFFIX = "/built/ideimpl/junit-classes".replace('/', File.separatorChar);
                while (i.hasMoreTokens()) {
                    String path = i.nextToken();
                    if (!path.endsWith(FIXTURE_SUFFIX)) continue;
                    URL oracle = URLFactory.newDirURL((String)path.substring(0, path.length() - FIXTURE_SUFFIX.length()));
                    this.installationDirectory = URLFactory.newDirURL((URL)oracle, (String)"jdeveloper/jdev");
                    break;
                }
            }
        }
        if (this.installationDirectory == null) {
            throw new IllegalArgumentException("Failed to find the home directory");
        }
        return this.installationDirectory;
    }

    public URL getWorkDirectory() {
        if (this.workDirectory == null) {
            if (this.workDirectoryPendingSet != null) {
                this.workDirectory = this.workDirectoryPendingSet;
                this.workDirectoryPendingSet = null;
            } else {
                String tmp = System.getProperty("unit.tests.tmp.dir");
                this.workDirectory = tmp != null ? URLFactory.newDirURL((String)tmp) : URLFactory.newDirURL((String)System.getProperty("java.io.tmpdir"));
                this.workDirectory = URLFactory.newDirURL((URL)this.workDirectory, (String)(this.getTestClass().getName() + '_' + this.getTestName()));
                URLFileSystem.mkdirs((URL)this.workDirectory);
            }
        }
        return this.workDirectory;
    }

    public void setWorkDirectory(URL workDirectory) {
        this.workDirectoryPendingSet = workDirectory;
    }

    public URL getDataDirectory() {
        if (this.dataDirectory == null) {
            String path = System.getProperty("fixture.data.dir");
            if (path == null) {
                path = System.getProperty("unit.tests.ref.dir");
            }
            if (path == null) {
                return null;
            }
            this.dataDirectory = URLFactory.newDirURL((URL)this.getInstallationDirectory(), (String)path);
        }
        return this.dataDirectory;
    }

    public void setDataDirectory(URL dataDirectory) {
        this.dataDirectory = dataDirectory;
    }

    public String unshroudExtension(String shroudedExtension) {
        String extension;
        if ("".equals(shroudedExtension)) {
            return shroudedExtension;
        }
        if (shroudedExtension.charAt(0) != '.') {
            shroudedExtension = '.' + shroudedExtension;
        }
        if ((extension = this.shroudedExtensions.get(shroudedExtension)) == null) {
            extension = shroudedExtension;
        }
        return extension;
    }

    public String shroudExtension(String unshroudedExtension) {
        String extension;
        if ("".equals(unshroudedExtension)) {
            return unshroudedExtension;
        }
        if (unshroudedExtension.charAt(0) != '.') {
            unshroudedExtension = '.' + unshroudedExtension;
        }
        if ((extension = this.unshroudedExtensions.get(unshroudedExtension)) == null) {
            extension = unshroudedExtension;
        }
        return extension;
    }

    public void addShroudedExtension(String shroudedExtension, String unshroudedExtension) {
        if (shroudedExtension.charAt(0) != '.') {
            shroudedExtension = '.' + shroudedExtension;
        }
        if (unshroudedExtension.charAt(0) != '.') {
            unshroudedExtension = '.' + unshroudedExtension;
        }
        this.shroudedExtensions.put(shroudedExtension, unshroudedExtension);
        this.unshroudedExtensions.put(unshroudedExtension, shroudedExtension);
    }

    public void removeShroudedExtension(String shroudedExtension) {
        if (shroudedExtension.charAt(0) != '.') {
            shroudedExtension = '.' + shroudedExtension;
        }
        String unshroudedExtension = this.shroudedExtensions.remove(shroudedExtension);
        this.unshroudedExtensions.remove(unshroudedExtension);
    }

    public Class getTestClass() {
        return this.testClass;
    }

    public URL getTestClassDirectory() {
        if (this.testClassDirectory == null) {
            this.testClassDirectory = URLFileSystem.getParent((URL)this.resolve(this.testClass.getResource(this.getTestClass().getSimpleName() + ".class")));
        }
        return this.testClassDirectory;
    }

    public String getTestName() {
        return this.testName;
    }

    public URL getLocalTestDataDirectory() {
        String className = this.getTestClass().getName();
        int dot = className.lastIndexOf(46);
        if (dot > 0) {
            className = className.substring(dot + 1);
        }
        return URLFactory.newDirURL((URL)this.getTestClassDirectory(), (String)("data-files/" + className + "_" + this.getTestName()));
    }

    public URL getLocalTestClassDataDirectory() {
        String className = this.getTestClass().getName();
        int dot = className.lastIndexOf(46);
        if (dot > 0) {
            className = className.substring(dot + 1);
        }
        return URLFactory.newDirURL((URL)this.getTestClassDirectory(), (String)("data-files/" + className));
    }

    public URL getTestDataDirectory() {
        URL base = this.getDataDirectory();
        if (base == null) {
            return null;
        }
        base = this.resolve(base);
        String path = this.getTestClass().getName().replace('.', '/') + '/' + this.getTestName();
        return URLFactory.newDirURL((URL)base, (String)path);
    }

    private URL resolve(URL url) {
        if (url != null && url.getProtocol().startsWith("bundle")) {
            try {
                if (resolve == null) {
                    BundleContext c = BundleContext.getSystemBundleContext(null);
                    String n = "org.eclipse.core.runtime.FileLocator";
                    Class<?> fileLocator = null;
                    for (Bundle b : c.getBundles()) {
                        if (!b.getSymbolicName().equals("org.eclipse.equinox.common")) continue;
                        fileLocator = b.loadClass("org.eclipse.core.runtime.FileLocator");
                        break;
                    }
                    resolve = fileLocator.getMethod("resolve", URL.class);
                }
                return (URL)resolve.invoke(null, url);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println("Not converting " + url + " due to previous error");
            }
        }
        return url;
    }

    public Node getNode(URL url) {
        String path = URLFileSystem.toRelativeSpec((URL)url, (URL)this.getWorkDirectory(), (boolean)true);
        return this.nodes.get(path);
    }

    public Node getNode(String path) {
        return this.nodes.get(path);
    }

    protected void addNode(String path, Node node) {
        String name;
        if (this.nodes.containsKey(path) && this.nodes.get(path) != node) {
            this.nodes.put(path, null);
            throw new IllegalArgumentException("multiple nodes at path " + path);
        }
        this.nodes.put(path, node);
        int slash = path.lastIndexOf(47);
        if (slash > 0 && !this.nodes.containsKey(name = path.substring(slash + 1))) {
            this.nodes.put(name, node);
        }
    }

    public Workspace createWorkspace() {
        return this.createWorkspace(null);
    }

    public Workspace createWorkspace(String path) {
        if (path == null) {
            path = "workspace.jws";
        }
        if (this.getNode(path) != null) {
            throw new IllegalArgumentException("node " + this.getNode(path) + " at " + path + " already created");
        }
        URL file = URLFactory.newURL((URL)this.getWorkDirectory(), (String)path);
        URLFileSystem.mkdirs((URL)URLFileSystem.getParent((URL)file));
        try {
            this.output("Creating workspace " + URLFileSystem.getPlatformPathName((URL)file));
            Workspace workspace = (Workspace)NodeFactory.findOrCreate(Workspace.class, file);
            this.addNode(path, workspace);
            ProjectVersion.initializeVersions(workspace, WorkspaceMigrator.MIGRATOR_NAME);
            workspace.save();
            Workspaces workspaces = Ide.getWorkspaces();
            workspaces.add(workspace);
            UpdateMessage.fireChildAdded(workspaces, workspace);
            return workspace;
        }
        catch (Exception e) {
            throw new UnexpectedExceptionError((Throwable)e);
        }
    }

    public void addProjectToWorkspace(Project project, Workspace workspace) {
        if (workspace == null) {
            workspace = this.createWorkspace(null);
        }
        workspace.add(project);
        UpdateMessage.fireChildAdded(workspace, project);
    }

    public Project createProject(String path) {
        if (path == null) {
            path = "project.jpr";
        }
        Project project = this.createProjectNoSave(path);
        try {
            project.save();
        }
        catch (IOException e) {
            throw new UnexpectedExceptionError((Throwable)e);
        }
        return project;
    }

    protected Project createProjectNoSave(String path) {
        Project project;
        if (path == null) {
            path = "project.jpr";
        }
        if (this.getNode(path) != null) {
            throw new IllegalArgumentException("node " + this.getNode(path) + " at " + path + " already created");
        }
        URL file = URLFactory.newURL((URL)this.getWorkDirectory(), (String)path);
        URL directory = URLFileSystem.getParent((URL)file);
        this.verbose("Creating directory " + URLFileSystem.getPlatformPathName((URL)directory));
        URLFileSystem.mkdirs((URL)directory);
        try {
            this.output("Creating project " + URLFileSystem.getPlatformPathName((URL)file));
            project = this.createProject(file);
            this.addNode(path, project);
        }
        catch (Exception e) {
            throw new UnexpectedExceptionError((Throwable)e);
        }
        return project;
    }

    protected Project createProject(URL file) throws IllegalAccessException, InstantiationException, IOException {
        return (Project)NodeFactory.findOrCreate(Project.class, file);
    }

    public URL createDirectory(String path) {
        URL url = URLFactory.newDirURL((URL)this.getWorkDirectory(), (String)path);
        URLFileSystem.mkdirs((URL)url);
        return url;
    }

    public URL getDataUrl(String path) {
        URL resource;
        ArrayList<URL> tried = new ArrayList<URL>();
        if (!"".equals(path) && (resource = this.getDataUrl(this.getTestClassDirectory(), path, tried)) != null) {
            return resource;
        }
        resource = this.getDataUrl(this.getLocalTestDataDirectory(), path, tried);
        if (resource != null) {
            return resource;
        }
        resource = this.getDataUrl(this.getLocalTestClassDataDirectory(), path, tried);
        if (resource != null) {
            return resource;
        }
        resource = this.getDataUrl(this.getTestDataDirectory(), path, tried);
        if (resource != null) {
            return resource;
        }
        resource = this.getDataUrl(this.getDataDirectory(), path, tried);
        if (resource != null) {
            return resource;
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("data path \"");
        buffer.append(path);
        buffer.append("\" not found; tried:");
        for (URL url : tried) {
            buffer.append('\n');
            buffer.append(URLFileSystem.getPlatformPathName((URL)url));
        }
        Assert.fail((String)buffer.toString());
        return null;
    }

    private URL getDataUrl(URL root, String path, List<URL> tried) {
        if (root == null) {
            return null;
        }
        URL resolvedRoot = this.resolveUrl(root);
        if (resolvedRoot != null) {
            URL shroudedUrl;
            URL dir;
            URL url = URLFactory.newURL((URL)resolvedRoot, (String)path);
            if (URLFileSystem.exists((URL)url)) {
                return url;
            }
            if (!URLFileSystem.isDirectoryPath((URL)url) && URLFileSystem.exists((URL)(dir = URLFactory.newDirURL((URL)resolvedRoot, (String)path)))) {
                return dir;
            }
            String unshroudedExtension = URLFileSystem.getSuffix((URL)url);
            String shroudedExtension = this.shroudExtension(unshroudedExtension);
            if (!shroudedExtension.equals(unshroudedExtension) && URLFileSystem.exists((URL)(shroudedUrl = URLFileSystem.convertSuffix((URL)url, (String)unshroudedExtension, (String)shroudedExtension)))) {
                return shroudedUrl;
            }
            tried.add(url);
        } else {
            tried.add(root);
        }
        return null;
    }

    protected URL resolveUrl(URL directory) {
        if (directory == null) {
            return directory;
        }
        if (URLFileSystem.exists((URL)directory)) {
            return directory;
        }
        if (URLFileSystem.isDirectoryPath((URL)directory)) {
            directory = URLFactory.newURL((URL)URLFileSystem.getParent((URL)directory), (String)URLFileSystem.getFileName((URL)directory));
        } else {
            URL dir = URLFactory.newDirURL((URL)directory, (String)"");
            if (URLFileSystem.exists((URL)dir)) {
                return dir;
            }
        }
        URL zip = URLFileSystem.convertSuffix((URL)directory, (String)"", (String)".zip");
        if (URLFileSystem.exists((URL)zip)) {
            return URLFactory.newJarURL((URL)zip, (String)"");
        }
        URL jar = URLFileSystem.convertSuffix((URL)directory, (String)"", (String)".jar");
        if (URLFileSystem.exists((URL)jar)) {
            return URLFactory.newJarURL((URL)jar, (String)"");
        }
        URL tip = URLFileSystem.convertSuffix((URL)directory, (String)"", (String)".tip");
        if (URLFileSystem.exists((URL)tip)) {
            return TipURLFileSystemHelper.newTipUrl(tip, "");
        }
        return null;
    }

    public Reader getDataReader(String path) throws IOException {
        return new InputStreamReader(URLFileSystem.openInputStream((URL)this.getDataUrl(path)));
    }

    public String getDataText(String path) {
        try {
            URL url = this.getDataUrl(path);
            if (url == null) {
                throw new IllegalArgumentException("contents \"" + path + "\" not found relative to " + this.testClass.getName());
            }
            int length = (int)URLFileSystem.getLength((URL)url);
            BufferedReader reader = new BufferedReader(new InputStreamReader(URLFileSystem.openInputStream((URL)url)));
            StringWriter writer = new StringWriter(length);
            char[] buffer = new char[4096];
            int size = reader.read(buffer);
            while (size >= 0) {
                writer.write(buffer, 0, size);
                size = reader.read(buffer);
            }
            return writer.toString();
        }
        catch (IOException e) {
            throw new UnexpectedExceptionError((Throwable)e);
        }
    }

    public Node createFile(String path) {
        Node node;
        if (this.getNode(path) != null) {
            throw new IllegalArgumentException("node " + this.getNode(path) + " at " + path + " already created");
        }
        URL file = URLFactory.newURL((URL)this.getWorkDirectory(), (String)path);
        URLFileSystem.mkdirs((URL)URLFileSystem.getParent((URL)file));
        try {
            this.verbose("Creating file " + URLFileSystem.getPlatformPathName((URL)file));
            node = NodeFactory.findOrCreate(file);
            this.addNode(path, node);
        }
        catch (Exception e) {
            throw new UnexpectedExceptionError((Throwable)e);
        }
        return node;
    }

    public Node createFile(String path, String contents) {
        Node node;
        URL file = URLFactory.newURL((URL)this.getWorkDirectory(), (String)path);
        URLFileSystem.mkdirs((URL)URLFileSystem.getParent((URL)file));
        try {
            this.verbose("Creating file " + URLFileSystem.getPlatformPathName((URL)file));
            OutputStreamWriter writer = new OutputStreamWriter(URLFileSystem.openOutputStream((URL)file));
            writer.write(contents);
            ((Writer)writer).close();
            node = NodeFactory.findOrCreate(file);
            this.addNode(path, node);
        }
        catch (Exception e) {
            throw new UnexpectedExceptionError((Throwable)e);
        }
        return node;
    }

    public Node createFileRelative(String path, String contentsPath) {
        return this.createFile(path, this.getDataUrl(contentsPath));
    }

    public Node createFile(String path, URL contentsURL) {
        Node node;
        URL file = URLFactory.newURL((URL)this.getWorkDirectory(), (String)path);
        URLFileSystem.mkdirs((URL)URLFileSystem.getParent((URL)file));
        try {
            this.verbose("Copying " + URLFileSystem.getPlatformPathName((URL)contentsURL) + " to " + URLFileSystem.getPlatformPathName((URL)file));
            URLFileSystem.copy((URL)contentsURL, (URL)file);
            node = NodeFactory.findOrCreate(file);
            this.addNode(path, node);
        }
        catch (Exception e) {
            throw new UnexpectedExceptionError((Throwable)e);
        }
        return node;
    }

    public URL createFiles(String path, URL contentsURL) {
        if (contentsURL == null) {
            throw new IllegalArgumentException("contentsURL null");
        }
        URL root = URLFactory.newDirURL((URL)this.getWorkDirectory(), (String)path);
        this.copyFiles(contentsURL, root, new String[]{""}, null);
        return root;
    }

    public URL createFilesRelative(String path, String contentsPath) {
        return this.createFiles(path, this.getDataUrl(contentsPath));
    }

    protected void copyFiles(URL source, URL target, String[] indexes, URLPath roots) {
        URL[] urls;
        this.verbose("Creating directory " + URLFileSystem.getPlatformPathName((URL)target));
        URLFileSystem.mkdirs((URL)target);
        source = this.unlockArchiveUrl(source);
        for (URL sourceChild : urls = this.getChildren(source)) {
            URL targetChild;
            String childName = URLFileSystem.getFileName((URL)sourceChild);
            if (URLFileSystem.isDirectory((URL)sourceChild)) {
                String[] childIndexes = new String[indexes.length];
                for (int j = 0; j < indexes.length; ++j) {
                    String index = indexes[j];
                    if (index.equals("")) {
                        childIndexes[j] = childName;
                        continue;
                    }
                    if (index.endsWith("..")) {
                        if (index.equals("..")) {
                            childIndexes[j] = "";
                            continue;
                        }
                        childIndexes[j] = index.substring(0, index.length() - 3);
                        continue;
                    }
                    childIndexes[j] = index + "/" + childName;
                }
                targetChild = URLFactory.newDirURL((URL)target, (String)childName);
                if (roots != null) {
                    this.copyFiles(sourceChild, targetChild, childIndexes, null);
                    roots.add(targetChild);
                    continue;
                }
                this.copyFiles(sourceChild, targetChild, childIndexes, null);
                continue;
            }
            try {
                int dot2 = childName.lastIndexOf(46);
                if (dot2 > childName.lastIndexOf(47)) {
                    String extension = this.unshroudExtension(childName.substring(dot2));
                    childName = childName.substring(0, dot2) + extension;
                }
                targetChild = URLFactory.newURL((URL)target, (String)childName);
                this.verbose("Copying " + URLFileSystem.getPlatformPathName((URL)sourceChild) + " to " + URLFileSystem.getPlatformPathName((URL)targetChild));
                URLFileSystem.copy((URL)sourceChild, (URL)targetChild);
                Node node = NodeFactory.findOrCreate(targetChild);
                for (String path : indexes) {
                    if (path.equals("")) {
                        this.addNode(childName, node);
                        continue;
                    }
                    if (path.endsWith("..")) continue;
                    this.addNode(path + "/" + childName, node);
                }
            }
            catch (IOException e) {
                throw new UnexpectedExceptionError((Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new UnexpectedExceptionError((Throwable)e);
            }
            catch (InstantiationException e) {
                throw new UnexpectedExceptionError((Throwable)e);
            }
        }
    }

    protected URL[] getChildren(URL directory) {
        URL[] children = URLFileSystem.list((URL)directory);
        Arrays.sort(children, new Comparator<URL>(){

            @Override
            public int compare(URL url1, URL url2) {
                return URLFileSystem.getFileName((URL)url1).compareTo(URLFileSystem.getFileName((URL)url2));
            }
        });
        return children;
    }

    protected URL unlockArchiveUrl(URL url) {
        URL unlockedUrl;
        String suffix = URLFileSystem.getSuffix((URL)url);
        if ("file".equals(url.getProtocol())) {
            unlockedUrl = ".jar".equals(suffix) || ".zip".equals(suffix) ? URLFactory.newJarURL((URL)url, (String)"") : (".tip".equals(suffix) ? URLFactory.newURL((String)"tip", (String)(url.toString() + "!/")) : url);
        } else if (".jar".equals(suffix) || ".zip".equals(suffix)) {
            URL fileUrl = URLFactory.newURL((URL)this.getWorkDirectory(), (String)URLFileSystem.getFileName((URL)url));
            try {
                URLFileSystem.copy((URL)url, (URL)fileUrl);
            }
            catch (IOException e) {
                throw new UnexpectedExceptionError("Copying " + url + " to " + fileUrl + " failed: " + e, (Throwable)e);
            }
            unlockedUrl = URLFactory.newJarURL((URL)fileUrl, (String)"");
        } else if (".tip".equals(suffix)) {
            URL fileUrl = URLFactory.newURL((URL)this.getWorkDirectory(), (String)URLFileSystem.getFileName((URL)url));
            try {
                URLFileSystem.copy((URL)url, (URL)fileUrl);
            }
            catch (IOException e) {
                throw new UnexpectedExceptionError("Copying " + url + " to " + fileUrl + " failed: " + e, (Throwable)e);
            }
            unlockedUrl = URLFactory.newURL((String)"tip", (String)(fileUrl.toString() + "!/"));
        } else {
            unlockedUrl = url;
        }
        return unlockedUrl;
    }

    public Context createContext() {
        return new Context(null, Ide.getActiveWorkspace(), Ide.getActiveProject(), null);
    }

    public Context createContext(Workspace workspace, Project project, Node node, Element[] selection) {
        assert (selection != null && selection.length > 0);
        Context context = new Context(null, workspace, project, node);
        context.setSelection(selection);
        return context;
    }

    public Context createContext(Workspace workspace, Project project, Node node) {
        assert (node != null);
        return new Context(null, workspace, project, node);
    }

    public void setActive(Workspace workspace, Project project) {
        if (workspace != null) {
            workspace.setActiveProject(project);
        }
        Ide.setActiveWorkspace(workspace);
        Ide.setActiveProject(project);
    }

    public static void deleteChildren(URL url) {
        URL[] urls = URLFileSystem.list((URL)url);
        if (urls != null) {
            for (URL childUrl : urls) {
                IdeFixture.delete(childUrl);
            }
        }
    }

    public static void delete(URL url) {
        IdeFixture.deleteChildren(url);
        URLFileSystem.delete((URL)url);
    }

    public boolean saveAll() {
        boolean success = true;
        Iterator<Node> i = NodeFactory.getCachedNodes();
        while (i.hasNext()) {
            Node node = i.next();
            if (!node.isOpen() || !node.isDirty()) continue;
            URL url = node.getURL();
            if (node.isReadOnly()) {
                URLFileSystem.setReadOnly((URL)url, (boolean)false);
            }
            try {
                node.save();
            }
            catch (Exception e) {
                String failedPath = URLFileSystem.getPlatformPathName((URL)url);
                System.err.println("Failed to save " + failedPath);
                success = false;
            }
        }
        return success;
    }

    public boolean dropNodes() {
        Workspaces workspaces = Ide.getWorkspaces();
        boolean success = false;
        for (Node node : this.nodes.values()) {
            if (node.isOpen() && node.isDirty()) {
                URL url = node.getURL();
                if (node.isReadOnly()) {
                    URLFileSystem.setReadOnly((URL)url, (boolean)false);
                }
                try {
                    node.save();
                }
                catch (Exception e) {
                    String failedPath = URLFileSystem.getPlatformPathName((URL)url);
                    System.err.println("Failed to save " + failedPath);
                    success = false;
                }
            }
            try {
                node.close();
            }
            catch (IOException e) {
                System.err.println("Exception closing " + URLFileSystem.getPlatformPathName((URL)node.getURL()) + ":");
                e.printStackTrace();
                success = false;
            }
            if (node instanceof Workspace) {
                workspaces.remove(node);
                UpdateMessage.fireChildRemoved(workspaces, node);
            }
            NodeFactory.uncache(node.getURL());
        }
        this.nodes.clear();
        return success;
    }

    public void assertEquals(URL expectedURL, String actualPath) {
        if (expectedURL == null) {
            throw new IllegalArgumentException("expectedURL null");
        }
        URL actualURL = URLFactory.newURL((URL)this.getWorkDirectory(), (String)actualPath);
        this.assertEquals(this.unlockArchiveUrl(expectedURL), actualURL);
    }

    public void assertEqualsFromResource(String expectedPath, String actualPath) {
        this.assertEquals(this.getDataUrl(expectedPath), actualPath);
    }

    public void assertEquals(URL expectedRootURL, URL actualRootURL) {
        if (expectedRootURL == null) {
            throw new IllegalArgumentException("expectedURL null");
        }
        if (actualRootURL == null) {
            throw new IllegalArgumentException("actualURL null");
        }
        LinkedHashMap<String, URL> expectedMap = new LinkedHashMap<String, URL>();
        this.scan("", expectedRootURL, expectedMap, true);
        LinkedHashMap<String, URL> actualMap = new LinkedHashMap<String, URL>();
        this.scan("", actualRootURL, actualMap, false);
        this.compare(expectedMap, actualMap);
    }

    private void scan(String path, URL url, Map<String, URL> map, boolean unshroud) {
        URL[] uRLArray = this.getChildren(url);
        int n = uRLArray.length;
        for (int i = 0; i < n; ++i) {
            String shrouded;
            URL child;
            URL adjustedChild = child = uRLArray[i];
            if (unshroud && (shrouded = URLFileSystem.getSuffix((URL)child)).length() > 0) {
                adjustedChild = URLFileSystem.convertSuffix((URL)child, (String)shrouded, (String)this.unshroudExtension(shrouded));
            }
            String childName = URLFileSystem.getFileName((URL)adjustedChild);
            String childPath = path.equals("") ? childName : path + "/" + childName;
            map.put(childPath, child);
            if (!URLFileSystem.isDirectory((URL)child)) continue;
            this.scan(childPath, child, map, unshroud);
        }
    }

    private void compare(Map<String, URL> expectedMap, Map<String, URL> actualMap) {
        for (Map.Entry<String, URL> entry : expectedMap.entrySet()) {
            String path = entry.getKey();
            URL expectedURL = entry.getValue();
            URL actualURL = actualMap.remove(path);
            if (URLFileSystem.isDirectory((URL)expectedURL)) {
                Assert.check((actualURL != null ? 1 : 0) != 0);
                Assert.check((boolean)URLFileSystem.isDirectory((URL)actualURL));
                continue;
            }
            Assert.check((actualURL != null ? 1 : 0) != 0);
            Assert.check((!URLFileSystem.isDirectory((URL)actualURL) ? 1 : 0) != 0);
            try {
                BufferedReader expected = new BufferedReader(new InputStreamReader(URLFileSystem.openInputStream((URL)expectedURL)));
                BufferedReader actual = new BufferedReader(new InputStreamReader(URLFileSystem.openInputStream((URL)actualURL)));
                IdeFixture.assertEquals(expected, expectedURL, actual, actualURL);
                expected.close();
                actual.close();
            }
            catch (IOException e) {
                throw new UnexpectedExceptionError((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void assertEquals(Reader expected, URL expectedFile, Reader actual, URL actualFile) {
        PrintWriter ew = null;
        if (expectedFile == null) {
            try {
                expectedFile = URLFileSystem.createTempFile((String)"expected", (String)".txt", null);
                ew = new PrintWriter(URLFileSystem.openOutputStream((URL)expectedFile));
            }
            catch (IOException e) {
                expectedFile = null;
            }
        }
        PrintWriter aw = null;
        if (actualFile == null) {
            try {
                actualFile = URLFileSystem.createTempFile((String)"actual", (String)".txt", null);
                aw = new PrintWriter(URLFileSystem.openOutputStream((URL)actualFile));
            }
            catch (IOException e) {
                actualFile = null;
            }
        }
        BufferedReader er = new BufferedReader(expected);
        BufferedReader ar = new BufferedReader(actual);
        try {
            int i = 1;
            while (true) {
                String a = ar.readLine();
                String e = er.readLine();
                if (a == null && e == null) {
                    break;
                }
                if (aw != null && a != null) {
                    aw.println(a);
                }
                if (ew != null && e != null) {
                    ew.println(e);
                }
                if (e == null ? a != null : !e.equals(a)) {
                    IdeFixture.fail(i, e, a, expectedFile, actualFile);
                }
                ++i;
            }
        }
        catch (IOException e) {
            Assert.fail((String)("exception reading " + er + " or " + ar + ": " + e.getMessage()));
        }
        finally {
            if (ew != null) {
                try {
                    while ((e = er.readLine()) != null) {
                        ew.println(e);
                    }
                }
                catch (IOException e) {}
                ew.close();
            }
            if (aw != null) {
                try {
                    String a;
                    while ((a = ar.readLine()) != null) {
                        aw.println(a);
                    }
                }
                catch (IOException iOException) {}
                aw.close();
            }
            try {
                ar.close();
                er.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static void fail(int line, String expected, String actual, URL expectedFile, URL actualFile) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("comparison failed at line ");
        buffer.append(line);
        buffer.append(":\n");
        buffer.append("expected: ");
        if (expected != null) {
            buffer.append('\"');
            buffer.append(expected);
            buffer.append('\"');
        } else {
            buffer.append("<eol>");
        }
        buffer.append("\n");
        if (expectedFile != null) {
            buffer.append("in ");
            buffer.append(URLFileSystem.getPlatformPathName((URL)expectedFile));
            buffer.append("\n");
        }
        buffer.append("actual:   ");
        if (actual != null) {
            buffer.append('\"');
            buffer.append(actual);
            buffer.append('\"');
        } else {
            buffer.append("<eol>");
        }
        if (actualFile != null) {
            buffer.append("\n");
            buffer.append("in ");
            buffer.append(URLFileSystem.getPlatformPathName((URL)actualFile));
        }
        Assert.fail((String)buffer.toString());
    }

    protected void verbose(String message) {
        if (this.isVerbose()) {
            this.output(message);
        }
    }

    protected void output(String message) {
        System.out.println("FIXTURE: " + message);
    }

    protected void errors(String message) {
        System.err.println("FIXTURE ERROR: " + message);
    }

    private class StartFailedException
    extends Error {
        public StartFailedException(Throwable cause, boolean firstTime) {
            super(firstTime ? "IDE fixture startup failed" : "IDE fixture startup failed when attempted for previous test", cause);
        }
    }
}

