/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.net;

import java.awt.Component;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.net.URL;
import javax.swing.BoxLayout;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionListener;
import oracle.ide.net.FileTable;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFilter;
import oracle.ide.net.URLNode;

final class FileView
extends JPanel
implements KeyListener {
    private final FileTable _fileTable;
    private final JScrollPane _fileScrollPane;
    private URLChooser _urlChooser;

    public FileView(URLChooser urlChooser) {
        this._urlChooser = urlChooser;
        this._fileTable = new FileTable(this._urlChooser);
        this._fileScrollPane = new JScrollPane((Component)((Object)this._fileTable));
        this.setSelectionMode(2);
        this.setLayout(new BoxLayout(this, 1));
        this.add(this._fileScrollPane);
    }

    public void clearSelection() {
        this._fileTable.clearSelection();
    }

    public URLNode getNodeAt(Point p) {
        return this._fileTable.getNodeAt(p);
    }

    public URLNode getSelectedNode() {
        return this._fileTable.getSelectedNode();
    }

    public URL getSelectedURL() {
        URLNode node = this.getSelectedNode();
        return node != null ? node.getURL() : null;
    }

    public Object[] getSelectedValues() {
        return this._fileTable.getSelectedValues();
    }

    public void resetSelection() {
        this._fileTable.resetSelection();
    }

    public void setDetailsView(boolean detailsView) {
        this._fileTable.setDetailsView(detailsView);
        this._fileTable.updateColumnHeader();
    }

    public boolean isDetailsView() {
        return this._fileTable.isDetailsView();
    }

    public void setKeyboardEnabled(boolean enabled) {
        if (enabled) {
            this._fileTable.removeKeyListener(this);
        } else {
            this._fileTable.addKeyListener(this);
        }
    }

    public void setSelectionMode(int selectionMode) {
        this._fileTable.setSelectionMode(selectionMode);
    }

    public void setSelectionModel(ListSelectionModel model) {
        if (model != null) {
            DefaultListSelectionModel newModel = new DefaultListSelectionModel();
            newModel.setSelectionMode(model.getSelectionMode());
            newModel.setAnchorSelectionIndex(model.getAnchorSelectionIndex());
            newModel.setLeadSelectionIndex(model.getLeadSelectionIndex());
            this._fileTable.setSelectionModel(newModel);
        }
    }

    public void updateList(URLNode node, URLFilter filter) {
        this._fileTable.updateList(node, filter);
    }

    public void clearList(boolean forceRepaint) {
        this._fileTable.clearList();
        if (forceRepaint) {
            this.paint(this.getGraphics());
        }
    }

    public void updateSelectedFile(String filename) {
        this._fileTable.updateSelectedFile(filename);
    }

    public void addViewMouseListener(MouseListener l) {
        this._fileTable.addMouseListener(l);
    }

    public void removeViewMouseListener(MouseListener l) {
        this._fileTable.removeMouseListener(l);
    }

    public void addViewListSelectionListener(ListSelectionListener l) {
        this._fileTable.getSelectionModel().addListSelectionListener(l);
    }

    public void removeViewListSelectionListener(ListSelectionListener l) {
        this._fileTable.getSelectionModel().removeListSelectionListener(l);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        Toolkit.getDefaultToolkit().beep();
        e.consume();
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

