/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import oracle.ide.model.HSAdapterDelegateMediator;
import oracle.ide.model.HashStructureNode;
import oracle.ide.model.panels.ReadOnlyComponent;

public final class HSAdapterDelegateComponent {
    private final JPanel _container = new JPanel(new BorderLayout(0, 0));
    private final ReadOnlyComponent _readOnlyComponent;

    public HSAdapterDelegateComponent(JComponent comp) {
        this._container.add((Component)comp, "Center");
        this._readOnlyComponent = new ReadOnlyComponent(this._container);
        this._readOnlyComponent.setState(ReadOnlyComponent.State.READ_WRITE);
    }

    public JComponent getComponent() {
        return this._readOnlyComponent.getReadOnlyComponent();
    }

    public void configureComponent(String propertyDataKey, Scope scope, HashStructureNode node) {
        if (HSAdapterDelegateComponent.propertiesAreDelegated(propertyDataKey, scope, node)) {
            Component component;
            HSAdapterDelegateMediator mediator = HSAdapterDelegateMediator.getMediator();
            this._readOnlyComponent.setMessage(mediator.getDisabledText(propertyDataKey, scope.key()));
            Icon icon = mediator.getDisabledIcon(propertyDataKey, scope.key());
            if (icon != null) {
                this._readOnlyComponent.setIcon(icon);
            }
            if ((component = mediator.getPreview(propertyDataKey, scope.key(), node)) != null) {
                this._readOnlyComponent.setPreviewComponent(component);
                this._readOnlyComponent.setState(ReadOnlyComponent.State.READ_ONLY_EX);
            } else {
                this._readOnlyComponent.setState(ReadOnlyComponent.State.READ_ONLY);
            }
        } else {
            this._container.setBorder(null);
            this._readOnlyComponent.setState(ReadOnlyComponent.State.READ_WRITE);
        }
    }

    static boolean propertiesAreDelegated(String propertyDataKey, Scope scope, HashStructureNode node) {
        if (propertyDataKey != null && scope != null) {
            HSAdapterDelegateMediator mediator = HSAdapterDelegateMediator.getMediator();
            boolean isDelegated = mediator.isDisabled(propertyDataKey, scope.key()) && mediator.needsDelegation(node, node.getProperties());
            return isDelegated;
        }
        return false;
    }

    public static enum Scope {
        PROJECT,
        WORKSPACE;


        String key() {
            switch (this) {
                case PROJECT: {
                    return "jpr:project";
                }
                case WORKSPACE: {
                    return "jws:workspace";
                }
            }
            throw new IllegalStateException("unknown Scope");
        }
    }
}

