/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.awt.GraphicsEnvironment;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectChangeEvent;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.SingletonProvider;
import oracle.ide.model.TechnologyScopeDetector;
import oracle.ide.model.Workspace;
import oracle.ide.model.panels.ProgressBarTechnologyScanner;
import oracle.ide.net.URLFileSystem;

public class TechnologyScopeManager {
    private Scanner m_scanner = null;
    private TechnologyScopeDetector m_detector = null;
    private static TechnologyScopeManager s_instance = new TechnologyScopeManager();
    public static final Set<String> EMPTY_SET = new HashSet<String>();
    public static final Scanner SAME_THREAD_SCANNER = new Scanner(){

        @Override
        public Collection<String> scanForNewTechnologies(Collection<URL> roots, Project project) throws InterruptedException {
            HashSet<URL> contents = new HashSet<URL>();
            ContentSet contentSet = ProjectContent.getInstance(project).getAllContents();
            for (URL root : roots) {
                if (!URLFileSystem.isDirectory((URL)root)) continue;
                this.getAllURLs(root, contents, contentSet);
            }
            HashSet<String> allNewTechs = new HashSet<String>();
            for (URL url : contents) {
                Collection<String> newTechs = TechnologyScopeManager.getTechnologyScopeManager().getDetector().detectTechnologyScopeIdsOfURL(project, url);
                allNewTechs.addAll(newTechs);
            }
            return allNewTechs;
        }

        private void getAllURLs(URL rootURL, Collection<URL> urls, ContentSet cs) {
            URL[] moreUrls = URLFileSystem.list((URL)rootURL);
            if (moreUrls != null) {
                for (URL url : moreUrls) {
                    if (URLFileSystem.isHidden((URL)url)) continue;
                    if (URLFileSystem.isDirectory((URL)url)) {
                        this.getAllURLs(url, urls, cs);
                        continue;
                    }
                    if (!cs.canHaveMember(url)) continue;
                    urls.add(url);
                }
            }
        }

        @Override
        public boolean canScan(ProjectChangeEvent pce) {
            return true;
        }
    };

    private TechnologyScopeManager() {
    }

    public static TechnologyScopeManager getTechnologyScopeManager() {
        return s_instance;
    }

    private synchronized void initFinder() {
        this.m_detector = SingletonProvider.find(TechnologyScopeDetector.class);
        if (this.m_detector == null) {
            this.m_detector = new NullDetector();
        }
    }

    private synchronized void initScanner() {
        this.m_scanner = GraphicsEnvironment.isHeadless() ? SAME_THREAD_SCANNER : new ProgressBarTechnologyScanner();
    }

    public TechnologyScopeDetector getDetector() {
        if (this.m_detector == null) {
            this.initFinder();
        }
        return this.m_detector;
    }

    public Scanner getScanner() {
        if (this.m_scanner == null) {
            this.initScanner();
        }
        return this.m_scanner;
    }

    public static class NullDetector
    implements TechnologyScopeDetector {
        @Override
        public Collection<String> detectTechnologyScopeIds(Workspace workspace, Project project) throws InterruptedException {
            return EMPTY_SET;
        }

        @Override
        public Collection<String> detectTechnologyScopeIdsOfURL(Project project, URL url) throws InterruptedException {
            return EMPTY_SET;
        }

        @Override
        public Collection<String> detectTechnologyScopeIdsOfProjectChanges(Workspace workspace, Project project) {
            return EMPTY_SET;
        }

        @Override
        public Map<Project, ConcurrentLinkedQueue<URL>> technologyScopesOfProjectBatch(Workspace workspace, Collection<Project> project) {
            return Collections.emptyMap();
        }
    }

    public static interface Scanner {
        public boolean canScan(ProjectChangeEvent var1);

        public Collection<String> scanForNewTechnologies(Collection<URL> var1, Project var2) throws InterruptedException;
    }
}

