/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import oracle.ide.model.ExpiredTextBuffer;
import oracle.ide.model.FacadeTextBufferListeners;
import oracle.javatools.buffer.GuardedTextBuffer;
import oracle.javatools.buffer.ReadWriteLock;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferDecorator;
import oracle.javatools.buffer.TextBufferListener;

public interface FacadeTextBuffer
extends TextBuffer {
    public void dispose(boolean var1);

    public void throwIfExpired();

    public static class Guarded
    extends GuardedTextBuffer
    implements FacadeTextBuffer {
        private FacadeTextBufferListeners realBufferListeners;
        private ReadWriteLock lock;

        Guarded(TextBuffer realBuffer, FacadeTextBufferListeners realBufferListeners, ReadWriteLock lock) {
            super(realBuffer, false);
            this.realBufferListeners = realBufferListeners;
            this.lock = lock;
        }

        @Override
        public void dispose(boolean autoClosed) {
            this.setTextBuffer((TextBuffer)new ExpiredTextBuffer(this.lock, autoClosed));
        }

        @Override
        public void throwIfExpired() {
            if (this.getTextBuffer() instanceof ExpiredTextBuffer) {
                throw ((ExpiredTextBuffer)this.getTextBuffer()).newExpiredTextBufferException();
            }
        }

        public void addTextBufferListener(TextBufferListener listener) {
            this.realBufferListeners.addIfAbsent(listener);
        }

        public void removeTextBufferListener(TextBufferListener listener) {
            this.realBufferListeners.remove(listener);
        }
    }

    public static class Basic
    extends TextBufferDecorator
    implements FacadeTextBuffer {
        private FacadeTextBufferListeners realBufferListeners;
        private ReadWriteLock lock;

        Basic(TextBuffer realBuffer, FacadeTextBufferListeners realBufferListeners, ReadWriteLock lock) {
            super(realBuffer, false);
            this.realBufferListeners = realBufferListeners;
            this.lock = lock;
        }

        @Override
        public void dispose(boolean autoClosed) {
            this.setTextBuffer((TextBuffer)new ExpiredTextBuffer(this.lock, autoClosed));
        }

        @Override
        public void throwIfExpired() {
            if (this.getTextBuffer() instanceof ExpiredTextBuffer) {
                throw ((ExpiredTextBuffer)this.getTextBuffer()).newExpiredTextBufferException();
            }
        }

        public void addTextBufferListener(TextBufferListener listener) {
            this.realBufferListeners.addIfAbsent(listener);
        }

        public void removeTextBufferListener(TextBufferListener listener) {
            this.realBufferListeners.remove(listener);
        }
    }
}

