/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.log.LogManager;
import oracle.ide.model.Dependable;
import oracle.ide.model.DependableFactory;
import oracle.ide.model.Element;
import oracle.ide.model.Project;
import oracle.ide.resource.IdeArb;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.data.StructureChangeListener;
import oracle.javatools.util.ModelUtil;

public class DependencyConfiguration
extends HashStructureAdapter {
    public static final String DATA_KEY = DependencyConfiguration.class.getName();
    private static final Logger _extensionLogger = Logger.getLogger(DATA_KEY);
    private final Project _project;
    public static final String DEPENDENCY_LIST = "dependencyList";

    private DependencyConfiguration(HashStructure hash, Project project) {
        super(hash);
        this._project = project;
    }

    public static DependencyConfiguration getInstance(Project project) {
        return new DependencyConfiguration(DependencyConfiguration.findOrCreate((PropertyStorage)project, (String)DATA_KEY), project);
    }

    public static DependencyConfiguration getInstance(PropertyStorage project) {
        return new DependencyConfiguration(DependencyConfiguration.findOrCreate((PropertyStorage)project, (String)DATA_KEY), null);
    }

    private ListStructure getDependenciesListStructure() {
        return this._hash.getListStructure(DEPENDENCY_LIST);
    }

    public void attachDependencyChangeListener(StructureChangeListener listener) {
        this._hash.getOrCreateListStructure(DEPENDENCY_LIST).addStructureChangeListener(listener);
    }

    public void detachDependencyChangeListener(StructureChangeListener listener) {
        if (this.getDependenciesListStructure() != null) {
            this.getDependenciesListStructure().removeStructureChangeListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getDependencyList() {
        ListStructure depList = this.getDependenciesListStructure();
        if (depList != null) {
            ArrayList<Dependable> dependencies = new ArrayList<Dependable>();
            Object object = depList.iteratorLock();
            synchronized (object) {
                for (HashStructure hash : depList) {
                    try {
                        Dependable dependable = DependableFactory.getInstance().toDependable(hash, this._project);
                        if (dependable != null && dependable.getSource() != null && dependable.getSource() != this._project) {
                            dependencies.add(dependable);
                            continue;
                        }
                        String msg = IdeArb.format(496, this._project != null ? this._project.getShortLabel() : null);
                        LogManager lgm = LogManager.getLogManager();
                        if (lgm != null) {
                            lgm.getMsgPage().log(msg);
                            continue;
                        }
                        Logger l = Logger.getLogger(((Object)((Object)this)).getClass().getName());
                        l.log(Level.WARNING, msg);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            return dependencies;
        }
        return null;
    }

    public void setDependencyList(List dependencies) {
        ArrayList<HashStructure> depList = new ArrayList<HashStructure>();
        if (dependencies != null) {
            for (Object dep : dependencies) {
                try {
                    HashStructure depHash = DependableFactory.getInstance().toHashStructure((Dependable)dep, this._project);
                    if (depHash == null) continue;
                    depList.add(depHash);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        ListStructure deps = this.getDependencyListStructure();
        deps.mirror(depList);
    }

    private ListStructure getDependencyListStructure() {
        return this._hash.getOrCreateListStructure(DEPENDENCY_LIST);
    }

    public void addDependency(Dependable dependable) throws IllegalStateException {
        if (dependable != null) {
            ListStructure list = this.getDependencyListStructure();
            try {
                HashStructure hash = DependableFactory.getInstance().toHashStructure(dependable, this._project);
                if (!list.contains((Object)hash)) {
                    this.checkExistingMutuallyExclusiveDependency(dependable);
                    list.add((Object)hash);
                }
            }
            catch (IllegalStateException e) {
                throw e;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void removeDependency(Dependable dependable) {
        ListStructure dependencyList;
        if (dependable != null && (dependencyList = this.getDependencyListStructure()) != null) {
            try {
                HashStructure hash = DependableFactory.getInstance().toHashStructure(dependable, this._project);
                Iterator iter = dependencyList.iterator();
                while (iter.hasNext()) {
                    Object next = iter.next();
                    if (next == null || !next.equals(hash)) continue;
                    iter.remove();
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static final Logger getLogger() {
        return _extensionLogger;
    }

    public Iterator getDependencies() {
        List list = this.getDependencyList();
        if (list != null) {
            return list.iterator();
        }
        return Collections.EMPTY_LIST.iterator();
    }

    public List getAllDependenciesList() {
        ArrayList all = new ArrayList();
        ArrayList<Project> seenSources = new ArrayList<Project>();
        if (this._project != null) {
            seenSources.add(this._project);
        } else {
            new Exception("*** Warning: Project not specified to DependencyConfiguration.  Cycles will not be detected properly.").printStackTrace();
        }
        this.collectDependencies(this.getDependencies(), all, seenSources);
        return all;
    }

    private void collectDependencies(Iterator deps, List output, List seenSources) {
        while (deps.hasNext()) {
            Dependable dependable = (Dependable)deps.next();
            if (DependencyConfiguration.wasSourceSeen(dependable.getSource(), seenSources)) continue;
            seenSources.add(dependable.getSource());
            this.collectDependencies(dependable.getDependencies(), output, seenSources);
            output.add(dependable);
        }
    }

    private static boolean wasSourceSeen(Element element, List seenSources) {
        for (int i = 0; i < seenSources.size(); ++i) {
            Element source = (Element)seenSources.get(i);
            if (source != element) continue;
            return true;
        }
        return false;
    }

    private void checkExistingMutuallyExclusiveDependency(Dependable dependable) throws IllegalStateException {
        URL sourceUrl;
        boolean isOutputPathDependency = false;
        if (dependable.getSource() instanceof Project) {
            sourceUrl = ((Project)dependable.getSource()).getURL();
            isOutputPathDependency = true;
        } else if (dependable.getSourceOwner() instanceof Project) {
            sourceUrl = ((Project)dependable.getSourceOwner()).getURL();
        } else {
            return;
        }
        Iterator deps = this.getDependencies();
        while (deps.hasNext()) {
            URL depURL = null;
            Dependable next = (Dependable)deps.next();
            if (isOutputPathDependency) {
                if (next.getSourceOwner() instanceof Project) {
                    depURL = ((Project)next.getSourceOwner()).getURL();
                }
            } else if (next.getSource() instanceof Project) {
                depURL = ((Project)next.getSource()).getURL();
            }
            if (!ModelUtil.areEqual((Object)sourceUrl, depURL)) continue;
            throw new IllegalStateException(IdeArb.format(512, dependable.toString(), next.toString()));
        }
    }
}

