/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.ide.model.Node;
import oracle.ide.model.UpdateMessage;

public abstract class DefaultContainer
extends Node
implements Folder {
    protected final ArrayList _children = new ArrayList();

    public DefaultContainer() {
    }

    public DefaultContainer(URL url) {
        super(url);
    }

    @Override
    public boolean mayHaveChildren() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator getChildren() {
        try {
            this.open();
            ArrayList arrayList = this._children;
            synchronized (arrayList) {
                return new ArrayList(this._children).iterator();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean canAdd(Element element) {
        return element != null;
    }

    @Override
    public boolean add(Element element) {
        return this.add(element, false);
    }

    @Override
    public boolean canRemove(Element element) {
        return element != null;
    }

    @Override
    public boolean remove(Element element) {
        return this.remove(element, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsChild(Element child) {
        ArrayList arrayList = this._children;
        synchronized (arrayList) {
            return this._children.contains(child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        ArrayList arrayList = this._children;
        synchronized (arrayList) {
            return this._children.size();
        }
    }

    @Override
    public void removeAll() {
        this.removeAll(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(Element element, boolean notify) {
        boolean addOk = false;
        ArrayList arrayList = this._children;
        synchronized (arrayList) {
            if (element != null && !this._children.contains(element)) {
                addOk = this._children.add(element);
            }
        }
        if (addOk) {
            this.markDirty(true);
            if (notify) {
                UpdateMessage.fireChildAdded(this, element);
            }
        }
        return addOk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Element element, boolean notify) {
        boolean removeOk = false;
        ArrayList arrayList = this._children;
        synchronized (arrayList) {
            if (element != null && this._children.contains(element)) {
                removeOk = this._children.remove(element);
            }
        }
        if (removeOk) {
            this.markDirty(true);
            if (notify) {
                UpdateMessage.fireChildRemoved(this, element);
            }
        }
        return removeOk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll(boolean notify) {
        ArrayList children = null;
        ArrayList arrayList = this._children;
        synchronized (arrayList) {
            if (notify && !this._children.isEmpty()) {
                children = new ArrayList(this._children);
            }
            this._children.clear();
        }
        if (children != null) {
            UpdateMessage.fireChildrenRemoved(this, children);
        }
        this.markDirty(true);
    }
}

